/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.open.client;

import com.baiwang.bop.client.BopException;
import com.baiwang.fasterxml.jackson.databind.ObjectMapper;
import com.baiwang.logging.Log;
import com.baiwang.logging.LogFactory;
import com.baiwang.open.client.IBWClient;
import com.baiwang.open.entity.AbstractRequest;
import com.baiwang.open.exception.BWOpenException;
import com.baiwang.open.utils.BopUtils;
import com.baiwang.open.utils.CommonWebUtils;
import com.baiwang.open.utils.JacksonUtil;
import com.baiwang.open.utils.OperationControl;
import com.baiwang.open.utils.StrUtils;
import com.baiwang.open.utils.WebUtils;
import java.util.Date;
import java.util.HashMap;
import java.util.UUID;

public class BWRestClient
extends IBWClient {
    private static final Log logger = LogFactory.getLog(BWRestClient.class);
    private static final String sdkVersion = BWRestClient.class.getPackage().getImplementationVersion();
    private static final String APP_KEY = "appKey";
    private static final String FORMAT = "format";
    private static final String METHOD = "method";
    private static final String TIMESTAMP = "timestamp";
    private static final String VERSION = "version";
    private static final String SIGN = "sign";
    private static final String TOKEN = "token";
    private static final String TYPE = "type";
    private static final String REQUEST_ID = "requestId";
    private static final String ASYNC_REQUEST_ID = "asynRequestId";
    private static final String SDK_VERSION = "sdkVersion";
    private final String serverUrl;
    private final String appKey;
    private final String appSecret;
    private static final ObjectMapper MAPPER = JacksonUtil.getMapper();

    public BWRestClient(String serverUrl, String appKey, String appSecret) {
        this.appKey = appKey;
        this.appSecret = appSecret;
        this.serverUrl = serverUrl;
    }

    @Override
    <T> T execute(AbstractRequest request, String token, String requestId, Class<T> respClazz) throws BWOpenException {
        if (requestId == null) {
            requestId = UUID.randomUUID().toString();
        }
        if (StrUtils.isEmpty(this.serverUrl)) {
            throw new BopException("\u767e\u671b\u5f00\u653e\u5e73\u53f0\u5730\u5740\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (StrUtils.isEmpty(this.appKey)) {
            throw new BopException("\u767e\u671b\u5f00\u653e\u5e73\u53f0appKey\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        if (StrUtils.isEmpty(this.appSecret)) {
            throw new BopException("\u767e\u671b\u5f00\u653e\u5e73\u53f0appSecret\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        String method = request.getMethod();
        String requestJson = JacksonUtil.beanToString(request);
        String requestUrl = this.appendSystemParamsToUrl(this.serverUrl, method, token, "sync", null, requestId, requestJson);
        String responseJson = null;
        long begin = System.currentTimeMillis();
        try {
            responseJson = WebUtils.isHttps(this.serverUrl) ? WebUtils.doPostHttps(requestUrl, requestJson) : WebUtils.doPost(requestUrl, requestJson);
            BopUtils.tryParseException(MAPPER, responseJson);
            T t = MAPPER.readValue(responseJson, respClazz);
            return t;
        }
        catch (BWOpenException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            long end = System.currentTimeMillis();
            long duration = end - begin;
            logger.warn("[BOP_LOG]" + requestId + " >> \u8bf7\u6c42URL\uff1a" + requestUrl + ", \u8bf7\u6c42\u62a5\u6587\uff1a" + OperationControl.ignoreRequestLog(method, requestJson) + " >> \u54cd\u5e94\u62a5\u6587:" + OperationControl.ignoreResponseLog(method, responseJson) + " | \u8017\u65f6\uff1a" + duration + "ms!");
        }
    }

    @Override
    <T> T execute(AbstractRequest request, String token, Class<T> respClazz) throws BWOpenException {
        return this.execute(request, token, null, respClazz);
    }

    @Override
    public void setProxy(String proxyHost, int proxyPort) {
        WebUtils.setProxy(proxyHost, proxyPort);
    }

    @Override
    public void setAuthorization(String userName, String passWord) {
        WebUtils.setAuthorization(userName, passWord);
    }

    private String appendSystemParamsToUrl(String url, String method, String token, String type, String asyncRequestId, String requestId, String body) {
        Long time = new Date().getTime();
        StringBuilder requestUrl = new StringBuilder(url);
        requestUrl = CommonWebUtils.adaptUrl(url, requestUrl);
        requestUrl.append(METHOD).append("=").append(method).append("&").append(VERSION).append("=").append("6.0").append("&").append(APP_KEY).append("=").append(this.appKey).append("&").append(FORMAT).append("=").append("json").append("&").append(TIMESTAMP).append("=").append(time).append("&").append(TOKEN).append("=").append(token).append("&").append(TYPE).append("=").append(type);
        if (asyncRequestId != null) {
            requestUrl.append("&").append(ASYNC_REQUEST_ID).append("=").append(asyncRequestId);
        }
        if (requestId != null) {
            requestUrl.append("&").append(REQUEST_ID).append("=").append(requestId);
        }
        try {
            HashMap<String, String> textParams = new HashMap<String, String>();
            textParams.put(METHOD, method);
            textParams.put(VERSION, "6.0");
            textParams.put(APP_KEY, this.appKey);
            textParams.put(FORMAT, "json");
            textParams.put(TIMESTAMP, time.toString());
            textParams.put(TOKEN, token);
            textParams.put(TYPE, type);
            if (requestId != null) {
                textParams.put(REQUEST_ID, requestId);
            }
            if (asyncRequestId != null) {
                textParams.put(ASYNC_REQUEST_ID, asyncRequestId);
            }
            if (null != sdkVersion) {
                requestUrl.append("&").append(SDK_VERSION).append("=").append(sdkVersion);
                textParams.put(SDK_VERSION, sdkVersion);
            }
            requestUrl.append("&").append(SIGN).append("=").append(BopUtils.signTopRequest(textParams, this.appSecret, body));
        }
        catch (Exception e) {
            throw new BWOpenException(e);
        }
        return requestUrl.toString();
    }
}

