/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.open.client.login;

import com.baiwang.fasterxml.jackson.databind.ObjectMapper;
import com.baiwang.logging.Log;
import com.baiwang.logging.LogFactory;
import com.baiwang.open.client.login.BasicLoginConfig;
import com.baiwang.open.client.login.BopLoginClient;
import com.baiwang.open.client.login.BopLoginResponse;
import com.baiwang.open.exception.BWOpenException;
import com.baiwang.open.utils.CommonWebUtils;
import com.baiwang.open.utils.JacksonUtil;
import com.baiwang.open.utils.StrUtils;
import com.baiwang.open.utils.WebUtils;
import java.io.IOException;
import java.util.UUID;

public abstract class BasicLoginClient
implements BopLoginClient {
    private static final Log logger = LogFactory.getLog(BasicLoginClient.class);
    protected BasicLoginConfig config;
    protected final ObjectMapper MAPPER = JacksonUtil.getMapper();

    public BasicLoginClient(BasicLoginConfig config) {
        this.config = config;
    }

    @Override
    public BopLoginResponse login() throws BWOpenException {
        return this.login(null);
    }

    @Override
    public BopLoginResponse login(String requestId) throws BWOpenException {
        return this.executeLogin(requestId);
    }

    @Override
    public BopLoginResponse refreshToken(String refreshValue) throws BWOpenException {
        return this.refreshToken(refreshValue, null);
    }

    @Override
    public BopLoginResponse refreshToken(String refreshValue, String requestId) throws BWOpenException {
        throw new BWOpenException("\u5f53\u524d\u8ba4\u8bc1\u65b9\u5f0f\u6682\u4e0d\u652f\u6301\u5237\u65b0token");
    }

    protected BopLoginResponse executeLogin(String requestId) {
        try {
            requestId = StrUtils.isEmpty(requestId) ? UUID.randomUUID().toString() : requestId;
            String loginUrl = this.spliceLoginUrlSafe();
            loginUrl = loginUrl + "&requestId=" + requestId;
            String requestBody = JacksonUtil.beanToString(this.config.getRequestBody());
            logger.warn(String.format("[BOP_LOG]%s >> \u8bf7\u6c42url\uff1a%s ;requestBody:%s", requestId, loginUrl, requestBody));
            String response = WebUtils.isHttps(loginUrl) ? WebUtils.doPostHttps(loginUrl, requestBody) : WebUtils.doPost(loginUrl, requestBody);
            logger.warn(String.format("[BOP_LOG] %s >> \u8fd4\u56de\u4fe1\u606f\uff1a%s", requestId, response));
            return this.MAPPER.readValue(response, BopLoginResponse.class);
        }
        catch (Exception e) {
            throw new BWOpenException(e);
        }
    }

    protected String spliceLoginUrl() throws IOException {
        String url = CommonWebUtils.adaptUrl(this.config.getUrl(), new StringBuilder(this.config.getUrl())).toString();
        return url + WebUtils.buildQuery(this.config.getTextParams(), "UTF-8");
    }

    protected String spliceLoginUrlSafe() throws IOException {
        String url = CommonWebUtils.adaptUrl(this.config.getUrl(), new StringBuilder(this.config.getUrl())).toString();
        return url + WebUtils.buildQuery(this.config.getTextParams(), "UTF-8");
    }
}

