/*
 * Decompiled with CFR 0.152.
 */
package com.baiwang.open.utils;

import com.baiwang.fasterxml.jackson.databind.ObjectMapper;
import com.baiwang.open.entity.AbstractResponse;
import com.baiwang.open.exception.BWOpenException;
import com.baiwang.open.utils.Encrypt;
import com.baiwang.open.utils.StrUtils;
import com.baiwang.open.utils.WebUtils;
import java.io.IOException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Map;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public abstract class BopUtils {
    private BopUtils() {
    }

    public static String signTopRequest(Map<String, String> params, String secret, String body) throws IOException {
        ArrayList<String> keys = new ArrayList<String>(params.keySet());
        Collections.sort(keys);
        StringBuilder query = new StringBuilder();
        query.append(secret);
        for (String key : keys) {
            String value = params.get(key);
            if (StrUtils.isEmpty(key) || StrUtils.isEmpty(value)) continue;
            query.append(key).append(value);
        }
        body.replaceAll("\n", "");
        body.replaceAll("\t", "");
        body.replaceAll("\r", "");
        query.append(body);
        query.append(secret);
        MessageDigest md5 = null;
        try {
            md5 = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException ignored) {
            throw new BWOpenException(ignored);
        }
        byte[] bytes = md5.digest(query.toString().getBytes("UTF-8"));
        StringBuilder sign = new StringBuilder();
        for (byte b : bytes) {
            String hex = Integer.toHexString(b & 0xFF);
            if (hex.length() == 1) {
                sign.append("0");
            }
            sign.append(hex.toUpperCase());
        }
        return sign.toString();
    }

    public static boolean verifyTopResponse(String topParams, String topSession, String topSign, String appKey, String appSecret) throws IOException {
        StringBuilder result = new StringBuilder();
        MessageDigest md5 = BopUtils.getMd5MessageDigest();
        result.append(appKey).append(topParams).append(topSession).append(appSecret);
        byte[] bytes = md5.digest(result.toString().getBytes("UTF-8"));
        BASE64Encoder encoder = new BASE64Encoder();
        return encoder.encode(bytes).equals(topSign);
    }

    private static MessageDigest getMd5MessageDigest() throws IOException {
        try {
            return MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw new IOException(e.getMessage());
        }
    }

    public static Map<String, String> decodeTopParams(String params) throws IOException {
        return BopUtils.decodeTopParams(params, "UTF-8");
    }

    public static Map<String, String> decodeTopParams(String params, String charset) throws IOException {
        if (StrUtils.isEmpty(params)) {
            return null;
        }
        BASE64Decoder decoder = new BASE64Decoder();
        byte[] buffer = decoder.decodeBuffer(params);
        String decodedParams = new String(buffer, charset);
        return WebUtils.splitUrlQuery(decodedParams);
    }

    public static String getUuidPasswd(String passwd, String uuid) {
        if (!StrUtils.isEmpty(uuid)) {
            return Encrypt.md5AndSha(passwd + uuid);
        }
        return Encrypt.md5AndSha(passwd);
    }

    public static void tryParseException(ObjectMapper mapper, String responseJson) throws IOException {
        AbstractResponse abstractResponse = mapper.readValue(responseJson, AbstractResponse.class);
        if (abstractResponse.getErrorResponse() != null) {
            throw new BWOpenException(abstractResponse);
        }
    }
}

