/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.openapi.sdk.api.message.task;

import com.dianping.openapi.sdk.api.message.entity.HeartBeat;
import com.dianping.openapi.sdk.api.message.entity.WsContext;
import java.io.IOException;
import java.util.Date;
import java.util.Timer;
import java.util.TimerTask;

public class HeartBeatTask {
    private Timer timer = new Timer("Timer-heartbeat", true);
    private final long MAX_PONG_TIME = 5000L;
    private WsContext wsContext;
    private int interval;
    private volatile boolean closeFlag;

    public HeartBeatTask(final WsContext wsContext, int interval) {
        this.wsContext = wsContext;
        this.interval = interval;
        wsContext.setHeartBeat(new HeartBeat());
        this.timer.schedule(new TimerTask(){

            @Override
            public void run() {
                HeartBeat heartBeat = wsContext.getHeartBeat();
                if (heartBeat.getCount() == 0 || HeartBeatTask.this.checkHeartBeat(heartBeat)) {
                    try {
                        wsContext.getSession().getAsyncRemote().sendPing(null);
                        heartBeat.setCount(heartBeat.getCount() + 1);
                        heartBeat.setLastPing(new Date());
                        return;
                    }
                    catch (Exception e) {
                        wsContext.getRunLogger().error("ws heartbeat error.", e);
                    }
                }
                try {
                    wsContext.getSession().close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                wsContext.getWsClient().reconnect();
                wsContext.setHeartBeat(new HeartBeat());
            }
        }, 5000L, (long)(this.interval * 1000));
        this.closeFlag = false;
        wsContext.getRunLogger().info("ws heartbeat start.");
    }

    public void close() {
        this.timer.cancel();
        this.closeFlag = true;
        this.wsContext.getRunLogger().info("ws heartbeat close.");
    }

    public boolean isClose() {
        return this.closeFlag;
    }

    private boolean checkHeartBeat(HeartBeat heartBeat) {
        if (heartBeat == null || heartBeat.getLastPing() == null || heartBeat.getLastPong() == null) {
            return false;
        }
        if (heartBeat.getLastPing().getTime() > heartBeat.getLastPong().getTime()) {
            return false;
        }
        return heartBeat.getLastPong().getTime() - heartBeat.getLastPing().getTime() < 5000L;
    }
}

