/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.openapi.sdk.executor;

import com.dianping.openapi.sdk.api.base.API;
import com.dianping.openapi.sdk.api.base.request.BaseOAuthRequest;
import com.dianping.openapi.sdk.executor.AbstractExecutor;
import com.dianping.openapi.sdk.executor.ExecutionContext;
import com.dianping.openapi.sdk.executor.Executor;
import com.dianping.openapi.sdk.httpclient.OpenAPIHttpClient;
import com.dianping.openapi.sdk.utils.TimeUtil;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class TokenExecutor
extends AbstractExecutor
implements Executor {
    private BaseOAuthRequest baseOAuthRequest;

    public TokenExecutor(OpenAPIHttpClient httpClient, BaseOAuthRequest baseOAuthRequest) {
        this.httpClient = httpClient;
        this.baseOAuthRequest = baseOAuthRequest;
    }

    @Override
    protected void prepare(ExecutionContext context) {
        HashMap executeParams = Maps.newHashMap();
        executeParams.put("app_key", this.baseOAuthRequest.getApp_key());
        API api = context.getApi();
        Map<String, Object> params = api.getAPIParams().toParams();
        for (String key : params.keySet()) {
            Object value = params.get(key);
            String newValue = value.toString();
            if (value instanceof Date) {
                Date tmp = (Date)value;
                newValue = TimeUtil.formatTime(tmp);
            }
            executeParams.put(key, newValue);
        }
        context.setParams(executeParams);
        context.setUrl(api.getHttpUrl());
    }
}

