/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.openapi.sdk.msgclient;

import com.dianping.openapi.sdk.api.message.MessageHandler;
import com.dianping.openapi.sdk.api.message.WsClientEndPoint;
import com.dianping.openapi.sdk.api.message.entity.App;
import com.dianping.openapi.sdk.api.message.entity.ConnectConfig;
import com.dianping.openapi.sdk.api.message.entity.WsContext;
import com.dianping.openapi.sdk.api.message.log.DefaultRunLogger;
import com.dianping.openapi.sdk.api.message.log.RunLogger;
import com.dianping.openapi.sdk.api.message.task.HeartBeatTask;
import com.dianping.openapi.sdk.exception.BootstrapException;
import com.dianping.openapi.sdk.exception.MaxReconnectException;
import com.dianping.openapi.sdk.utils.MessageUtils;
import java.net.URI;
import javax.websocket.Session;
import org.apache.commons.lang.StringUtils;
import org.glassfish.tyrus.client.ClientManager;

public class OpenMsgWsClient {
    private WsContext wsContext;
    private ConnectConfig connectConfig;
    private HeartBeatTask heartBeatTask;
    private volatile long maxSleepTime = 120000L;
    private volatile int maxReconnectNum = 30;
    private final int MIN_HEARTBEAT_INTERVAL = 5;
    private int maxWorkThread = 2;
    private int heartbeatInterval = 5;

    public OpenMsgWsClient(String appKey, String appSecret) {
        this(appKey, appSecret, "ALL");
    }

    public OpenMsgWsClient(String appKey, String appSecret, String type) {
        if (StringUtils.isEmpty((String)appKey)) {
            appKey = "app_key";
        }
        if (StringUtils.isEmpty((String)appSecret)) {
            appSecret = "app_secret";
        }
        if (StringUtils.isEmpty((String)type)) {
            type = "ALL";
        }
        this.connectConfig = new ConnectConfig();
        this.connectConfig.setApp(new App(appKey, appSecret));
        this.connectConfig.setType(type);
        this.connectConfig.setConnectId(MessageUtils.createClientId());
        this.wsContext = new WsContext();
        this.wsContext.setWsClient(this);
    }

    public void setMaxWorkThread(int maxWorkThread) {
        this.maxWorkThread = maxWorkThread;
    }

    public void setMaxReconnectNum(Integer maxReconnectNum) {
        this.maxReconnectNum = maxReconnectNum;
    }

    public void setMaxSleepTime(long maxSleepTime) {
        this.maxSleepTime = maxSleepTime;
    }

    public void setMessageHandler(MessageHandler messageHandler) {
        this.wsContext.setMessageHandler(messageHandler);
    }

    public void setRunLogger(RunLogger runLogger) {
        this.wsContext.setRunLogger(runLogger);
    }

    public void setHeartbeatInterval(int second) {
        this.heartbeatInterval = Math.max(second, 5);
    }

    public void connect(String wsAddress) {
        try {
            if (this.wsContext.getRunLogger() == null) {
                this.wsContext.setRunLogger(new DefaultRunLogger());
            }
            this.connectConfig.setWsAddress(wsAddress);
            this.wsConnect(wsAddress);
            this.heartBeatTask = new HeartBeatTask(this.wsContext, this.heartbeatInterval);
            this.wsContext.getRunLogger().info("dianping.ws.sdk bootstrap success.");
        }
        catch (Exception e) {
            this.wsContext.getRunLogger().error("dianping.ws.sdk bootstrap error.", new BootstrapException(e));
        }
    }

    public void reconnect() {
        if (this.connectConfig.getWsAddress() == null) {
            return;
        }
        long sleepTime = 0L;
        int reconnectCount = 0;
        while (true) {
            try {
                Thread.sleep(sleepTime);
                sleepTime = Math.min(sleepTime + 10000L, this.maxSleepTime);
                this.wsConnect(this.connectConfig.getWsAddress());
                if (this.heartBeatTask == null || this.heartBeatTask.isClose()) {
                    this.heartBeatTask = new HeartBeatTask(this.wsContext, this.heartbeatInterval);
                }
                this.wsContext.getRunLogger().info("ws reconnect success.");
            }
            catch (Exception e) {
                this.wsContext.getRunLogger().error("ws reconnect error.", e);
                if (reconnectCount == this.maxReconnectNum) {
                    this.wsContext.getRunLogger().error("ws reconnect beyond max num.", new MaxReconnectException());
                    this.close();
                    break;
                }
                ++reconnectCount;
                continue;
            }
            break;
        }
    }

    public void close() {
        if (this.heartBeatTask != null) {
            this.heartBeatTask.close();
        }
        try {
            if (this.wsContext.getSession() != null) {
                this.wsContext.getSession().close();
            }
        }
        catch (Exception e) {
            this.wsContext.setSession(null);
        }
        this.wsContext.getRunLogger().info("dianping.ws.sdk stop.");
    }

    private void wsConnect(String wsAddress) throws Exception {
        ClientManager clientManager = ClientManager.createClient();
        clientManager.getProperties().put("org.glassfish.tyrus.client.workerThreadPoolConfig", this.maxWorkThread);
        URI connectURI = new URI(MessageUtils.buildHandshakeURL(this.connectConfig, wsAddress));
        Session session = clientManager.connectToServer((Object)new WsClientEndPoint(this.wsContext), connectURI);
        this.wsContext.setSession(session);
    }
}

