/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.java;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class FormatAnnotationsStep {
    private static final List<String> defaultTypeAnnotations = Arrays.asList("A", "ACCBottom", "Acceleration", "ACCTop", "AinferBottom", "AlwaysSafe", "Angle", "AnnoWithStringArg", "Area", "ArrayLen", "ArrayLenRange", "ArrayWithoutPackage", "AwtAlphaCompositingRule", "AwtColorSpace", "AwtCursorType", "AwtFlowLayout", "B", "BinaryName", "BinaryNameInUnnamedPackage", "BinaryNameOrPrimitiveType", "BinaryNameWithoutPackage", "BoolVal", "Bottom", "BottomQualifier", "BottomThis", "BottomVal", "C", "CalledMethods", "CalledMethodsBottom", "CalledMethodsPredicate", "CalledMethodsTop", "CanonicalName", "CanonicalNameAndBinaryName", "CanonicalNameOrEmpty", "CanonicalNameOrPrimitiveType", "CCBottom", "CCTop", "cd", "ClassBound", "ClassGetName", "ClassGetSimpleName", "ClassVal", "ClassValBottom", "CompilerMessageKey", "CompilerMessageKeyBottom", "Constant", "Critical", "Current", "D", "DefaultType", "degrees", "Det", "DotSeparatedIdentifiers", "DotSeparatedIdentifiersOrPrimitiveType", "DoubleVal", "E", "Encrypted", "EnhancedRegex", "EnumVal", "Even", "F", "FBCBottom", "FEBottom", "FEBot", "Fenum", "FenumBottom", "FenumTop", "FETop", "FieldDescriptor", "FieldDescriptorForPrimitive", "FieldDescriptorForPrimitiveOrArrayInUnnamedPackage", "FieldDescriptorWithoutPackage", "FlowExp", "Force", "Format", "FormatBottom", "FqBinaryName", "Frequency", "FullyQualifiedName", "g", "GTENegativeOne", "GuardedBy", "GuardedByBottom", "GuardedByUnknown", "GuardSatisfied", "h", "H1Bot", "H1Invalid", "H1Poly", "H1S1", "H1S2", "H1Top", "H2Bot", "H2Poly", "H2S1", "H2S2", "H2Top", "Hz", "I18nFormat", "I18nFormatBottom", "I18nFormatFor", "I18nInvalidFormat", "I18nUnknownFormat", "Identifier", "IdentifierOrArray", "IdentifierOrPrimitiveType", "ImplicitAnno", "IndexFor", "IndexOrHigh", "IndexOrLow", "Initialized", "InitializedFields", "InitializedFieldsBottom", "InitializedFieldsPredicate", "InternalForm", "Interned", "InternedDistinct", "IntRange", "IntVal", "InvalidFormat", "K", "KeyFor", "KeyForBottom", "KeyForType", "kg", "kHz", "km", "km2", "km3", "kmPERh", "kN", "LbTop", "LB_TOP", "LeakedToResult", "Length", "LengthOf", "LessThan", "LessThanBottom", "LessThanUnknown", "LocalizableKey", "LocalizableKeyBottom", "Localized", "LowerBoundBottom", "LowerBoundUnknown", "LTEqLengthOf", "LTLengthOf", "LTOMLengthOf", "Luminance", "m", "m2", "m3", "Mass", "MatchesRegex", "MaybeAliased", "MaybeDerivedFromConstant", "MaybePresent", "MaybeThis", "MethodDescriptor", "MethodVal", "MethodValBottom", "min", "MinLen", "mm", "mm2", "mm3", "mol", "MonotonicNonNull", "MonotonicNonNullType", "MonotonicOdd", "mPERs", "mPERs2", "MustCall", "MustCallAlias", "MustCallUnknown", "N", "NegativeIndexFor", "NewObject", "NonConstant", "NonDet", "NonLeaked", "NonNegative", "NonNull", "NonNullType", "NonRaw", "NotCalledMethods", "NotNull", "NotQualifier", "NTDBottom", "NTDMiddle", "NTDSide", "NTDTop", "Nullable", "NullableType", "Odd", "OptionalBottom", "OrderNonDet", "Parent", "PatternA", "PatternAB", "PatternAC", "PatternB", "PatternBC", "PatternBottomFull", "PatternBottomPartial", "PatternC", "PatternUnknown", "Poly", "PolyAll", "PolyConstant", "PolyDet", "PolyEncrypted", "PolyFenum", "PolyIndex", "PolyInitializedFields", "PolyInterned", "PolyKeyFor", "PolyLength", "PolyLowerBound", "PolyMustCall", "PolyNull", "PolyNullType", "PolyPresent", "PolyRaw", "PolyReflection", "PolyRegex", "PolySameLen", "PolySignature", "PolySigned", "PolyTainted", "PolyTestAccumulation", "PolyTypeDeclDefault", "PolyUI", "PolyUnit", "PolyUpperBound", "PolyValue", "PolyVariableNameDefault", "Positive", "Present", "PrimitiveType", "PropertyKey", "PropertyKeyBottom", "PurityUnqualified", "Qualifier", "radians", "Raw", "ReflectBottom", "Regex", "RegexBottom", "RegexNNGroups", "ReportUnqualified", "s", "SameLen", "SameLenBottom", "SameLenUnknown", "SearchIndexBottom", "SearchIndexFor", "SearchIndexUnknown", "Sibling1", "Sibling2", "SiblingWithFields", "SignatureBottom", "Signed", "SignednessBottom", "SignednessGlb", "SignedPositive", "SignedPositiveFromUnsigned", "Speed", "StringVal", "SubQual", "Substance", "SubstringIndexBottom", "SubstringIndexFor", "SubstringIndexUnknown", "SuperQual", "SwingBoxOrientation", "SwingCompassDirection", "SwingElementOrientation", "SwingHorizontalOrientation", "SwingSplitPaneOrientation", "SwingTextOrientation", "SwingTitleJustification", "SwingTitlePosition", "SwingVerticalOrientation", "t", "Tainted", "Temperature", "TestAccumulation", "TestAccumulationBottom", "TestAccumulationPredicate", "This", "Time", "Top", "TypeDeclDefaultBottom", "TypeDeclDefaultMiddle", "TypeDeclDefaultTop", "UbTop", "UB_TOP", "UI", "UnderInitialization", "Unique", "UnitsBottom", "UnknownClass", "UnknownCompilerMessageKey", "UnknownFormat", "UnknownInitialization", "UnknownInterned", "UnknownKeyFor", "UnknownLocalizableKey", "UnknownLocalized", "UnknownMethod", "UnknownPropertyKey", "UnknownRegex", "UnknownSignedness", "UnknownThis", "UnknownUnits", "UnknownVal", "Unsigned", "Untainted", "UpperBoundBottom", "UpperBoundLiteral", "UpperBoundUnknown", "Value", "VariableNameDefaultBottom", "VariableNameDefaultMiddle", "VariableNameDefaultTop", "Volume", "WholeProgramInferenceBottom");
    static final String NAME = "No line break between type annotation and type";

    public static FormatterStep create() {
        return FormatAnnotationsStep.create(Collections.emptyList(), Collections.emptyList());
    }

    public static FormatterStep create(List<String> addedTypeAnnotations, List<String> removedTypeAnnotations) {
        return FormatterStep.create(NAME, new State(addedTypeAnnotations, removedTypeAnnotations), State::toFormatter);
    }

    private FormatAnnotationsStep() {
    }

    static /* synthetic */ List access$000() {
        return defaultTypeAnnotations;
    }

    private static final class State
    implements Serializable {
        private static final long serialVersionUID = 1L;
        private final Set<String> typeAnnotations = new HashSet<String>(FormatAnnotationsStep.access$000());
        private static final String annoNoArgRegex = "@(?:[A-Za-z_][A-Za-z0-9_.]*\\.)?([A-Za-z_][A-Za-z0-9_]*)";
        private static final Pattern annoNoArgPattern = Pattern.compile("@(?:[A-Za-z_][A-Za-z0-9_.]*\\.)?([A-Za-z_][A-Za-z0-9_]*)");
        private static final String annoArgRegex = "(?:\\(\\)|\\(\"[^\"]*\"\\)|\\([^\")][^)]*\\))?";
        private static final String annoRegex = "@(?:[A-Za-z_][A-Za-z0-9_.]*\\.)?([A-Za-z_][A-Za-z0-9_]*)(?:\\(\\)|\\(\"[^\"]*\"\\)|\\([^\")][^)]*\\))?";
        private static final String trailingAnnoRegex = "@(?:[A-Za-z_][A-Za-z0-9_.]*\\.)?([A-Za-z_][A-Za-z0-9_]*)(?:\\(\\)|\\(\"[^\"]*\"\\)|\\([^\")][^)]*\\))?$";
        private static final Pattern trailingAnnoPattern = Pattern.compile("@(?:[A-Za-z_][A-Za-z0-9_.]*\\.)?([A-Za-z_][A-Za-z0-9_]*)(?:\\(\\)|\\(\"[^\"]*\"\\)|\\([^\")][^)]*\\))?$");
        private static final Pattern withinCommentPattern = Pattern.compile("//|/\\*(?!.*/*/)|^[ \t]*\\*[ \t]");
        private static final Pattern startsWithCommentPattern = Pattern.compile("^[ \t]*(//|/\\*$|/\\*|void\\b)");

        State(List<String> addedTypeAnnotations, List<String> removedTypeAnnotations) {
            this.typeAnnotations.addAll(addedTypeAnnotations);
            this.typeAnnotations.removeAll(removedTypeAnnotations);
        }

        FormatterFunc toFormatter() {
            return unixStr -> this.fixupTypeAnnotations(unixStr);
        }

        String fixupTypeAnnotations(String unixStr) {
            CharSequence[] lines = unixStr.split("((?<=\n))");
            for (int i = 0; i < lines.length - 1; ++i) {
                CharSequence nextLine;
                String line = lines[i];
                if (!this.endsWithTypeAnnotation(line) || startsWithCommentPattern.matcher(nextLine = lines[i + 1]).find()) continue;
                lines[i] = "";
                lines[i + 1] = line.replaceAll("\\s+$", "") + " " + ((String)nextLine).replaceAll("^\\s+", "");
            }
            return String.join((CharSequence)"", lines);
        }

        boolean endsWithTypeAnnotation(String unixLine) {
            String line = unixLine.replaceAll("\\s+$", "");
            Matcher m = trailingAnnoPattern.matcher(line);
            if (!m.find()) {
                return false;
            }
            String preceding = line.substring(0, m.start());
            String basename = m.group(1);
            if (withinCommentPattern.matcher(preceding).find()) {
                return false;
            }
            return this.typeAnnotations.contains(basename);
        }
    }
}

