/*
 * Decompiled with CFR 0.152.
 */
package com.diffplug.spotless.npm;

import com.diffplug.spotless.FormatterFunc;
import com.diffplug.spotless.FormatterStep;
import com.diffplug.spotless.Provisioner;
import com.diffplug.spotless.ThrowingEx;
import com.diffplug.spotless.npm.NpmConfig;
import com.diffplug.spotless.npm.NpmFormatterStepStateBase;
import com.diffplug.spotless.npm.NpmResourceHelper;
import com.diffplug.spotless.npm.PrettierFormatterStep;
import com.diffplug.spotless.npm.SimpleJsonWriter;
import com.diffplug.spotless.npm.TsFmtRestService;
import com.diffplug.spotless.npm.TypedTsFmtConfigFile;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class TsFmtFormatterStep {
    private static final Logger logger = Logger.getLogger(TsFmtFormatterStep.class.getName());
    public static final String NAME = "tsfmt-format";

    public static FormatterStep create(Map<String, String> versions, Provisioner provisioner, File buildDir, @Nullable File npm, @Nullable TypedTsFmtConfigFile configFile, @Nullable Map<String, Object> inlineTsFmtSettings) {
        Objects.requireNonNull(provisioner);
        Objects.requireNonNull(buildDir);
        return FormatterStep.createLazy(NAME, () -> new State(NAME, versions, buildDir, npm, configFile, inlineTsFmtSettings), State::createFormatterFunc);
    }

    public static Map<String, String> defaultDevDependencies() {
        return TsFmtFormatterStep.defaultDevDependenciesWithTsFmt("7.2.2");
    }

    public static Map<String, String> defaultDevDependenciesWithTsFmt(String typescriptFormatter) {
        TreeMap<String, String> defaults = new TreeMap<String, String>();
        defaults.put("typescript-formatter", typescriptFormatter);
        defaults.put("typescript", "3.9.5");
        defaults.put("tslint", "6.1.2");
        return defaults;
    }

    public static class State
    extends NpmFormatterStepStateBase
    implements Serializable {
        private static final long serialVersionUID = -3789035117345809383L;
        private final TreeMap<String, Object> inlineTsFmtSettings;
        private final File buildDir;
        @Nullable
        private final TypedTsFmtConfigFile configFile;

        public State(String stepName, Map<String, String> versions, File buildDir, @Nullable File npm, @Nullable TypedTsFmtConfigFile configFile, @Nullable Map<String, Object> inlineTsFmtSettings) throws IOException {
            super(stepName, new NpmConfig(State.replaceDevDependencies(NpmResourceHelper.readUtf8StringFromClasspath(TsFmtFormatterStep.class, "/com/diffplug/spotless/npm/tsfmt-package.json"), new TreeMap<String, String>(versions)), "typescript-formatter", NpmResourceHelper.readUtf8StringFromClasspath(PrettierFormatterStep.class, "/com/diffplug/spotless/npm/tsfmt-serve.js")), buildDir, npm);
            this.buildDir = Objects.requireNonNull(buildDir);
            this.configFile = configFile;
            this.inlineTsFmtSettings = inlineTsFmtSettings == null ? new TreeMap() : new TreeMap<String, Object>(inlineTsFmtSettings);
        }

        @Override
        @Nonnull
        public FormatterFunc createFormatterFunc() {
            try {
                Map<String, Object> tsFmtOptions = this.unifyOptions();
                NpmFormatterStepStateBase.ServerProcessInfo tsfmtRestServer = this.npmRunServer();
                TsFmtRestService restService = new TsFmtRestService(tsfmtRestServer.getBaseUrl());
                return FormatterFunc.Closeable.ofDangerous(() -> this.endServer(restService, tsfmtRestServer), input -> restService.format(input, tsFmtOptions));
            }
            catch (Exception e) {
                throw ThrowingEx.asRuntime(e);
            }
        }

        private Map<String, Object> unifyOptions() {
            HashMap<String, Object> unified = new HashMap<String, Object>();
            if (!this.inlineTsFmtSettings.isEmpty()) {
                File targetFile = new File(this.buildDir, "inline-tsfmt.json");
                SimpleJsonWriter.of(this.inlineTsFmtSettings).toJsonFile(targetFile);
                unified.put("tsfmt", true);
                unified.put("tsfmtFile", targetFile.getAbsolutePath());
            } else if (this.configFile != null) {
                unified.put(this.configFile.configFileEnabledOptionName(), Boolean.TRUE);
                unified.put(this.configFile.configFileOptionName(), this.configFile.absolutePath());
            }
            return unified;
        }

        private void endServer(TsFmtRestService restService, NpmFormatterStepStateBase.ServerProcessInfo restServer) throws Exception {
            try {
                restService.shutdown();
            }
            catch (Throwable t) {
                logger.log(Level.INFO, "Failed to request shutdown of rest service via api. Trying via process.", t);
            }
            restServer.close();
        }
    }
}

