/*
 * Decompiled with CFR 0.152.
 */
package com.doudian.open.core;

import com.doudian.open.api.token.AccessTokenData;
import com.doudian.open.api.token.AccessTokenResponse;
import com.doudian.open.api.token.RefreshTokenResponse;

public class AccessToken {
    private Long errNo;
    private String message;
    private AccessTokenData data;
    private String logId;

    public static AccessToken wrap(AccessTokenResponse response) {
        AccessToken accessToken = new AccessToken();
        accessToken.errNo = response.getErrNo();
        accessToken.message = response.getMessage();
        accessToken.data = (AccessTokenData)response.getData();
        accessToken.logId = response.getLogId();
        return accessToken;
    }

    public static AccessToken wrap(RefreshTokenResponse response) {
        AccessToken accessToken = new AccessToken();
        accessToken.errNo = response.getErrNo();
        accessToken.message = response.getMessage();
        accessToken.data = (AccessTokenData)response.getData();
        accessToken.logId = response.getLogId();
        return accessToken;
    }

    public static AccessToken wrap(String accessTokenStr, String refreshTokenStr) {
        AccessToken accessToken = new AccessToken();
        AccessTokenData tokenData = new AccessTokenData();
        tokenData.setAccessToken(accessTokenStr);
        tokenData.setRefreshToken(refreshTokenStr);
        accessToken.data = tokenData;
        return accessToken;
    }

    public boolean isSuccess() {
        return this.errNo != null && this.errNo == 0L;
    }

    public String getAccessToken() {
        if (this.data != null) {
            return this.data.getAccessToken();
        }
        return null;
    }

    public Long getExpireIn() {
        if (this.data != null) {
            return this.data.getExpiresIn();
        }
        return null;
    }

    public String getScope() {
        if (this.data != null) {
            return this.data.getScope();
        }
        return null;
    }

    public String getShopId() {
        if (this.data != null) {
            return this.data.getShopId();
        }
        return null;
    }

    public String getShopName() {
        if (this.data != null) {
            return this.data.getShopName();
        }
        return null;
    }

    public String getRefreshToken() {
        if (this.data != null) {
            return this.data.getRefreshToken();
        }
        return null;
    }

    public String getAuthorityId() {
        if (this.data != null) {
            return this.data.getAuthorityId();
        }
        return null;
    }

    public String getMessage() {
        return this.message;
    }

    public Long getErrNo() {
        return this.errNo;
    }

    public String getLogId() {
        return this.logId;
    }

    public void setLogId(String logId) {
        this.logId = logId;
    }
}

