/*
 * Decompiled with CFR 0.152.
 */
package com.doudian.open.core.http;

import com.doudian.open.core.http.HttpClient;
import com.doudian.open.core.http.HttpRequest;
import com.doudian.open.core.http.HttpResponse;
import com.doudian.open.exception.DoudianOpException;
import com.doudian.open.utils.Logger;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.nio.charset.StandardCharsets;
import java.util.Map;

public class DefaultHttpClient
implements HttpClient {
    private static final Logger LOG = Logger.getLogger(DefaultHttpClient.class);
    private static HttpClient DEFAULT_CLIENT = new DefaultHttpClient();

    public static HttpClient getDefaultClient() {
        return DEFAULT_CLIENT;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public HttpResponse get(HttpRequest httpRequest) {
        HttpResponse httpResponse;
        block10: {
            HttpResponse resp = new HttpResponse();
            HttpURLConnection connection = this.createConnection(httpRequest);
            InputStream inputStream = null;
            try {
                inputStream = connection.getInputStream();
                String body = this.readBodyFromInputStream(inputStream);
                resp.setBody(body);
                httpResponse = resp;
                if (inputStream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (inputStream != null) {
                        try {
                            inputStream.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    throw new DoudianOpException(DoudianOpException.Code.HTTP_REQUEST_ERROR, e);
                }
            }
            try {
                inputStream.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return httpResponse;
    }

    @Override
    public HttpResponse post(HttpRequest httpRequest) {
        HttpResponse resp = new HttpResponse();
        InputStream inputStream = null;
        OutputStream outputStream = null;
        long now = System.currentTimeMillis();
        try {
            HttpURLConnection connection = this.createConnection(httpRequest);
            connection.setDoOutput(true);
            connection.setDoInput(true);
            connection.setUseCaches(false);
            connection.setRequestMethod("POST");
            if (httpRequest.getBody() != null && httpRequest.getBody().length() > 0) {
                outputStream = connection.getOutputStream();
                outputStream.write(httpRequest.getBody().getBytes(StandardCharsets.UTF_8));
                outputStream.flush();
            }
            int statusCode = connection.getResponseCode();
            resp.setStatusCode(statusCode);
            try {
                inputStream = connection.getInputStream();
                String body = this.readBodyFromInputStream(inputStream);
                resp.setBody(body);
            }
            catch (Exception e) {
                try {
                    inputStream = connection.getErrorStream();
                    String body = this.readBodyFromInputStream(inputStream);
                    resp.setBody(body);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (connection.getHeaderFields() != null) {
                resp.addHeaders(connection.getHeaderFields());
            }
            HttpResponse httpResponse = resp;
            return httpResponse;
        }
        catch (Exception e) {
            throw new DoudianOpException(DoudianOpException.Code.HTTP_REQUEST_ERROR, e);
        }
        finally {
            if (outputStream != null) {
                try {
                    outputStream.close();
                }
                catch (Exception exception) {}
            }
            if (inputStream != null) {
                try {
                    inputStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }

    private HttpURLConnection createConnection(HttpRequest httpRequest) throws Exception {
        URL url = new URL(httpRequest.getUrl());
        URLConnection connection = url.openConnection();
        connection.setConnectTimeout(httpRequest.getConnectTimeout());
        connection.setReadTimeout(httpRequest.getReadTimeout());
        connection.setRequestProperty("accept", "*/*");
        connection.setRequestProperty("Content-Type", "application/json;charset=UTF-8");
        if (httpRequest.getHeaderMap() != null && httpRequest.getHeaderMap().size() > 0) {
            for (Map.Entry<String, String> entry : httpRequest.getHeaderMap().entrySet()) {
                connection.setRequestProperty(entry.getKey(), entry.getValue());
            }
        }
        return (HttpURLConnection)connection;
    }

    private String readBodyFromInputStream(InputStream inputStream) throws Exception {
        BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream, StandardCharsets.UTF_8));
        StringBuilder sb = new StringBuilder();
        char[] buffer = new char[8192];
        int len = 0;
        while ((len = bufferedReader.read(buffer, 0, buffer.length)) > 0) {
            sb.append(buffer, 0, len);
        }
        return sb.toString();
    }
}

