/*
 * Decompiled with CFR 0.152.
 */
package com.drew.metadata.webp;

import com.drew.imaging.riff.RiffHandler;
import com.drew.lang.ByteArrayReader;
import com.drew.lang.annotations.NotNull;
import com.drew.metadata.Metadata;
import com.drew.metadata.exif.ExifReader;
import com.drew.metadata.icc.IccReader;
import com.drew.metadata.webp.WebpDirectory;
import com.drew.metadata.xmp.XmpReader;
import java.io.IOException;

public class WebpRiffHandler
implements RiffHandler {
    @NotNull
    private final Metadata _metadata;

    public WebpRiffHandler(@NotNull Metadata metadata) {
        this._metadata = metadata;
    }

    public boolean shouldAcceptRiffIdentifier(@NotNull String identifier) {
        return identifier.equals("WEBP");
    }

    public boolean shouldAcceptChunk(@NotNull String fourCC) {
        return fourCC.equals("VP8X") || fourCC.equals("EXIF") || fourCC.equals("ICCP") || fourCC.equals("XMP ");
    }

    public void processChunk(@NotNull String fourCC, @NotNull byte[] payload) {
        if (fourCC.equals("EXIF")) {
            new ExifReader().extract(new ByteArrayReader(payload), this._metadata);
        } else if (fourCC.equals("ICCP")) {
            new IccReader().extract(new ByteArrayReader(payload), this._metadata);
        } else if (fourCC.equals("XMP ")) {
            new XmpReader().extract(payload, this._metadata);
        } else if (fourCC.equals("VP8X") && payload.length == 10) {
            ByteArrayReader reader = new ByteArrayReader(payload);
            reader.setMotorolaByteOrder(false);
            try {
                boolean isAnimation = reader.getBit(1);
                boolean hasAlpha = reader.getBit(4);
                int widthMinusOne = reader.getInt24(4);
                int heightMinusOne = reader.getInt24(7);
                WebpDirectory directory = new WebpDirectory();
                directory.setInt(2, widthMinusOne + 1);
                directory.setInt(1, heightMinusOne + 1);
                directory.setBoolean(3, hasAlpha);
                directory.setBoolean(4, isAnimation);
                this._metadata.addDirectory(directory);
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

