/*
 * Decompiled with CFR 0.152.
 */
package com.easy.base.component;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.easy.base.component.BaseServiceImpl;
import com.easy.base.constant.BeanConstant;
import com.easy.base.entity.RowMap;
import com.easy.base.entity.ServiceResponse;
import com.easy.base.entity.ServiceSession;
import com.easy.base.util.TypeUtils;
import com.easy.base.util.UniqueID;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.CriteriaDefinition;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StringUtils;

public abstract class BaseCompomentServiceImpl<X, Y>
extends BaseServiceImpl<Y> {
    private String collectionName;
    private String keyfieldName;

    public String getCollectionName() {
        return this.collectionName;
    }

    public void setCollectionName(String collectionName) {
        this.collectionName = collectionName;
    }

    public String getKeyfieldName() {
        return this.keyfieldName;
    }

    public void setKeyfieldName(String keyfieldName) {
        this.keyfieldName = keyfieldName;
    }

    public BaseCompomentServiceImpl(String collectionName, String keyfieldName) {
        this.setCollectionName(collectionName);
        this.setKeyfieldName(keyfieldName);
    }

    protected abstract X getTemplate();

    protected abstract long onCount(ServiceSession var1, X var2, Query var3, String var4);

    protected abstract <T> List<T> onFind(ServiceSession var1, X var2, Query var3, Class<T> var4, String var5);

    protected abstract void onUpsert(ServiceSession var1, X var2, Query var3, Update var4, String var5);

    protected abstract void onInsert(ServiceSession var1, X var2, JSONObject var3, String var4);

    protected abstract void onRemove(ServiceSession var1, X var2, Query var3, String var4);

    protected void onBeforeQuery(ServiceSession session, Criteria criteria) {
    }

    protected void onAfterQuery(List<RowMap> dataList) {
        for (RowMap dataMap : dataList) {
            this.onRowAfterQuery(dataMap);
        }
    }

    protected void onDifferentWarning(ServiceSession session, JSONObject params) throws Exception {
        if (params != null && params.containsKey((Object)"ent_id")) {
            long paramsEntID = params.getLongValue("ent_id");
            if (session.getEnt_id() != paramsEntID) {
                throw new Exception(String.format("\u8bf7\u6c42\u53c2\u6570\u7684\u4f01\u4e1aID\u3010%1$d\u3011\u548c\u767b\u5f55\u4f01\u4e1aID\u3010%2$d\u3011\u4e0d\u4e00\u81f4\uff01", paramsEntID, session.getEnt_id()));
            }
        }
    }

    protected void onQueryForEntID(ServiceSession session, JSONObject params) throws Exception {
        this.onDifferentWarning(session, params);
        params.put("ent_id", (Object)session.getEnt_id());
    }

    protected void onRowAfterQuery(RowMap dataMap) {
        if (dataMap.containsKey(this.getKeyfieldName())) {
            dataMap.put(this.getKeyfieldName(), TypeUtils.castToString(dataMap.get(this.getKeyfieldName())));
        }
    }

    protected Criteria onParseParamsOne(Criteria criteria, String keyName, Object keyValue) {
        if (criteria == null) {
            criteria = Criteria.where((String)keyName).is(keyValue);
        } else {
            criteria.and(keyName).is(keyValue);
        }
        return criteria;
    }

    public ServiceResponse onQuery(ServiceSession session, JSONObject paramsObject) {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)paramsObject)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        X template = this.getTemplate();
        HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
        keyMap.put("fields", 1);
        keyMap.put("order_field", 1);
        keyMap.put("order_direction", 1);
        keyMap.put("page_no", 1);
        keyMap.put("page_size", 1);
        if (paramsObject.containsKey((Object)"ent_id")) {
            try {
                this.onQueryForEntID(session, paramsObject);
            }
            catch (Exception e) {
                return ServiceResponse.buildFailure(session, "10000", e.getMessage(), new Object[0]);
            }
        }
        if (paramsObject.containsKey((Object)this.getKeyfieldName())) {
            paramsObject.put(this.getKeyfieldName(), (Object)TypeUtils.castToLong(paramsObject.get((Object)this.getKeyfieldName())));
        }
        Set keySet = paramsObject.keySet();
        Criteria criteria = null;
        for (String keyName : keySet) {
            if (keyMap.containsKey(keyName)) continue;
            criteria = this.onParseParamsOne(criteria, keyName, paramsObject.get((Object)keyName));
        }
        this.onBeforeQuery(session, criteria);
        Query query = null;
        query = criteria != null ? new Query(criteria) : new Query();
        long rowCount = this.onCount(session, template, query, this.getCollectionName());
        JSONObject response = new JSONObject();
        response.put("total_results", (Object)rowCount);
        if (rowCount > 0L) {
            Integer pageno = BeanConstant.QueryPage.DEFAULT_PAGENO;
            Integer pageSize = BeanConstant.QueryPage.DEFAULT_PAGESIZE;
            if (paramsObject.containsKey((Object)"page_no")) {
                pageno = paramsObject.getInteger("page_no") - 1;
            }
            if (paramsObject.containsKey((Object)"page_size")) {
                pageSize = paramsObject.getInteger("page_size");
            }
            if (pageno < 0) {
                pageno = 0;
            }
            query.with((Pageable)new PageRequest(pageno.intValue(), pageSize.intValue()));
            List<RowMap> dataList = this.onFind(session, template, query, RowMap.class, this.getCollectionName());
            this.onAfterQuery(dataList);
            response.put(this.getCollectionName(), dataList);
        } else {
            response.put(this.getCollectionName(), new ArrayList());
        }
        return ServiceResponse.buildSuccess(response);
    }

    protected void onBeforeUpdate(ServiceSession session, Criteria criteria, Update update) {
    }

    protected void doUpdate(ServiceSession session, X template, Query query, Update update) {
        this.onUpsert(session, template, query, update, this.getCollectionName());
    }

    protected void onRowUpdateForEntID(ServiceSession session, JSONObject params) throws Exception {
        this.onDifferentWarning(session, params);
        params.put("ent_id", (Object)session.getEnt_id());
    }

    protected void onAfterRowUpdate(X template, Query query, JSONObject params) {
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse onUpdate(ServiceSession session, JSONObject paramsObject) {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)paramsObject)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        X template = this.getTemplate();
        if (paramsObject.containsKey((Object)this.getCollectionName())) {
            Object dataObject = paramsObject.get((Object)this.getCollectionName());
            if (dataObject != null && dataObject instanceof List) {
                JSONArray paramsArray = paramsObject.getJSONArray(this.getCollectionName());
                for (int i = 0; i < paramsArray.size(); ++i) {
                    JSONObject params = paramsArray.getJSONObject(i);
                    if (params.containsKey((Object)"ent_id")) {
                        try {
                            this.onRowUpdateForEntID(session, params);
                        }
                        catch (Exception e) {
                            return ServiceResponse.buildFailure(session, "10000", e.getMessage(), new Object[0]);
                        }
                    }
                    if (params.containsKey((Object)this.getKeyfieldName())) {
                        if (StringUtils.isEmpty((Object)params.get((Object)this.getKeyfieldName()))) {
                            params.put(this.getKeyfieldName(), (Object)UniqueID.getUniqueID(true));
                        } else {
                            params.put(this.getKeyfieldName(), (Object)TypeUtils.castToLong(params.get((Object)this.getKeyfieldName())));
                        }
                    } else {
                        return ServiceResponse.buildFailure(session, "50000", "\u8bf7\u6c42\u6761\u4ef6\u7f3a\u5185\u90e8ID\u5173\u952e\u5b57{0}", this.getKeyfieldName());
                    }
                    HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
                    keyMap.put(this.getKeyfieldName(), 1);
                    Criteria criteria = Criteria.where((String)this.getKeyfieldName()).is(params.get((Object)this.getKeyfieldName()));
                    if (params.containsKey((Object)"ent_id") && !"ent_id".equals(this.getKeyfieldName())) {
                        criteria.and("ent_id").is(params.get((Object)"ent_id"));
                        keyMap.put("ent_id", 1);
                    }
                    Update update = new Update();
                    Set keySet = params.keySet();
                    for (String keyName : keySet) {
                        if (keyMap.containsKey(keyName)) continue;
                        this.onAssistMap(update, (Map<String, Object>)params, keyName);
                    }
                    this.onBeforeUpdate(session, criteria, update);
                    Query query = new Query((CriteriaDefinition)criteria);
                    System.out.println(query.toString());
                    this.doUpdate(session, template, query, update);
                    this.onAfterRowUpdate(template, query, params);
                }
            }
        } else {
            HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
            keyMap.put(this.getKeyfieldName(), 1);
            if (paramsObject.containsKey((Object)"ent_id")) {
                try {
                    this.onRowUpdateForEntID(session, paramsObject);
                }
                catch (Exception e) {
                    return ServiceResponse.buildFailure(session, "10000", e.getMessage(), new Object[0]);
                }
                keyMap.put("ent_id", 1);
            }
            if (paramsObject.containsKey((Object)this.getKeyfieldName())) {
                if (StringUtils.isEmpty((Object)paramsObject.get((Object)this.getKeyfieldName()))) {
                    paramsObject.put(this.getKeyfieldName(), (Object)UniqueID.getUniqueID(true));
                } else {
                    paramsObject.put(this.getKeyfieldName(), (Object)TypeUtils.castToLong(paramsObject.get((Object)this.getKeyfieldName())));
                }
            } else {
                return ServiceResponse.buildFailure(session, "50000", "\u8bf7\u6c42\u6761\u4ef6\u7f3a\u5185\u90e8ID\u5173\u952e\u5b57{0}", this.getKeyfieldName());
            }
            Criteria criteria = Criteria.where((String)this.getKeyfieldName()).is(paramsObject.get((Object)this.getKeyfieldName()));
            if (paramsObject.containsKey((Object)"ent_id") && !"ent_id".equals(this.getKeyfieldName())) {
                criteria.and("ent_id").is(paramsObject.get((Object)"ent_id"));
                keyMap.put("ent_id", 1);
            }
            Update update = new Update();
            Set keySet = paramsObject.keySet();
            for (String keyName : keySet) {
                if (keyMap.containsKey(keyName)) continue;
                this.onAssistMap(update, (Map<String, Object>)paramsObject, keyName);
            }
            this.onBeforeUpdate(session, criteria, update);
            Query query = new Query((CriteriaDefinition)criteria);
            this.doUpdate(session, template, query, update);
            this.onAfterRowUpdate(template, query, paramsObject);
        }
        JSONObject response = new JSONObject();
        return ServiceResponse.buildSuccess(response);
    }

    protected void onBeforeInsert(ServiceSession session, JSONObject dataRow) {
    }

    protected void doInsert(ServiceSession session, X template, JSONObject dataRow) {
        this.onInsert(session, template, dataRow, this.getCollectionName());
    }

    protected void onAfterRowInsert(X template, JSONObject dataRow) {
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse onInsert(ServiceSession session, JSONObject paramsObject) {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)paramsObject)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        X template = this.getTemplate();
        if (paramsObject.containsKey((Object)this.getCollectionName())) {
            Object dataObject = paramsObject.get((Object)this.getCollectionName());
            if (dataObject != null && dataObject instanceof List) {
                JSONArray paramsArray = paramsObject.getJSONArray(this.getCollectionName());
                for (int i = 0; i < paramsArray.size(); ++i) {
                    JSONObject params = paramsArray.getJSONObject(i);
                    if (!params.containsKey((Object)"ent_id")) {
                        params.put("ent_id", (Object)session.getEnt_id());
                    }
                    if (params.containsKey((Object)this.getKeyfieldName())) {
                        if (StringUtils.isEmpty((Object)params.get((Object)this.getKeyfieldName()))) {
                            params.put(this.getKeyfieldName(), (Object)UniqueID.getUniqueID(true));
                        } else {
                            params.put(this.getKeyfieldName(), (Object)TypeUtils.castToLong(params.get((Object)this.getKeyfieldName())));
                        }
                    } else {
                        return ServiceResponse.buildFailure(session, "50000", "\u8bf7\u6c42\u6761\u4ef6\u7f3a\u5185\u90e8ID\u5173\u952e\u5b57{0}", this.getKeyfieldName());
                    }
                    JSONObject dataRow = new JSONObject();
                    Set keySet = params.keySet();
                    for (String keyName : keySet) {
                        this.onAssistMap(dataRow, (Map<String, Object>)params, keyName, keyName);
                    }
                    this.onBeforeInsert(session, dataRow);
                    this.doInsert(session, template, dataRow);
                    this.onAfterRowInsert(template, dataRow);
                }
            }
        } else {
            if (!paramsObject.containsKey((Object)"ent_id")) {
                paramsObject.put("ent_id", (Object)session.getEnt_id());
            }
            if (paramsObject.containsKey((Object)this.getKeyfieldName())) {
                if (StringUtils.isEmpty((Object)paramsObject.get((Object)this.getKeyfieldName()))) {
                    paramsObject.put(this.getKeyfieldName(), (Object)UniqueID.getUniqueID(true));
                } else {
                    paramsObject.put(this.getKeyfieldName(), (Object)TypeUtils.castToLong(paramsObject.get((Object)this.getKeyfieldName())));
                }
            } else {
                return ServiceResponse.buildFailure(session, "50000", "\u8bf7\u6c42\u6761\u4ef6\u7f3a\u5185\u90e8ID\u5173\u952e\u5b57{0}", this.getKeyfieldName());
            }
            JSONObject dataRow = new JSONObject();
            Set keySet = paramsObject.keySet();
            for (String keyName : keySet) {
                this.onAssistMap(dataRow, (Map<String, Object>)paramsObject, keyName, keyName);
            }
            this.onBeforeInsert(session, dataRow);
            this.doInsert(session, template, dataRow);
            this.onAfterRowInsert(template, dataRow);
        }
        JSONObject response = new JSONObject();
        return ServiceResponse.buildSuccess(response);
    }

    protected void onBeforeDelete(ServiceSession session, Criteria criteria) {
    }

    protected void doDelete(ServiceSession session, X template, Query query) {
        this.onRemove(session, template, query, this.getCollectionName());
    }

    protected void onDeleteForEntID(ServiceSession session, JSONObject params) throws Exception {
        this.onDifferentWarning(session, params);
        params.put("ent_id", (Object)session.getEnt_id());
    }

    @Transactional(propagation=Propagation.REQUIRED)
    public ServiceResponse onDelete(ServiceSession session, JSONObject paramsObject) {
        if (session == null) {
            return ServiceResponse.buildFailure(session, "50001");
        }
        if (StringUtils.isEmpty((Object)paramsObject)) {
            return ServiceResponse.buildFailure(session, "50003");
        }
        X template = this.getTemplate();
        if (paramsObject.containsKey((Object)this.getCollectionName())) {
            Object dataObject = paramsObject.get((Object)this.getCollectionName());
            if (dataObject != null && dataObject instanceof List) {
                JSONArray paramsArray = paramsObject.getJSONArray(this.getCollectionName());
                for (int i = 0; i < paramsArray.size(); ++i) {
                    HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
                    keyMap.put("fields", 1);
                    keyMap.put("order_field", 1);
                    keyMap.put("order_direction", 1);
                    keyMap.put("page_no", 1);
                    keyMap.put("page_size", 1);
                    JSONObject params = paramsArray.getJSONObject(i);
                    if (params.containsKey((Object)"ent_id")) {
                        try {
                            this.onDeleteForEntID(session, paramsObject);
                        }
                        catch (Exception e) {
                            return ServiceResponse.buildFailure(session, "10000", e.getMessage(), new Object[0]);
                        }
                    }
                    if (params.containsKey((Object)this.getKeyfieldName())) {
                        params.put(this.getKeyfieldName(), (Object)TypeUtils.castToLong(params.get((Object)this.getKeyfieldName())));
                    }
                    Set keySet = params.keySet();
                    Criteria criteria = null;
                    for (String keyName : keySet) {
                        if (keyMap.containsKey(keyName)) continue;
                        criteria = this.onParseParamsOne(criteria, keyName, params.get((Object)keyName));
                    }
                    if (criteria == null) continue;
                    this.onBeforeDelete(session, criteria);
                    Query query = new Query(criteria);
                    this.doDelete(session, template, query);
                }
            }
        } else {
            HashMap<String, Integer> keyMap = new HashMap<String, Integer>();
            keyMap.put("fields", 1);
            keyMap.put("order_field", 1);
            keyMap.put("order_direction", 1);
            keyMap.put("page_no", 1);
            keyMap.put("page_size", 1);
            if (paramsObject.containsKey((Object)"ent_id")) {
                try {
                    this.onDeleteForEntID(session, paramsObject);
                }
                catch (Exception e) {
                    return ServiceResponse.buildFailure(session, "10000", e.getMessage(), new Object[0]);
                }
            }
            if (paramsObject.containsKey((Object)this.getKeyfieldName())) {
                paramsObject.put(this.getKeyfieldName(), (Object)TypeUtils.castToLong(paramsObject.get((Object)this.getKeyfieldName())));
            }
            Set keySet = paramsObject.keySet();
            Criteria criteria = null;
            for (String keyName : keySet) {
                if (keyMap.containsKey(keyName)) continue;
                criteria = this.onParseParamsOne(criteria, keyName, paramsObject.get((Object)keyName));
            }
            if (criteria != null) {
                this.onBeforeDelete(session, criteria);
                Query query = new Query(criteria);
                this.doDelete(session, template, query);
            }
        }
        JSONObject response = new JSONObject();
        return ServiceResponse.buildSuccess(response);
    }
}

