/*
 * Decompiled with CFR 0.152.
 */
package com.easy.base.config;

import com.easy.base.component.EasyDataSource;
import com.easy.base.storage.template.FMybatisTemplate;
import com.easy.base.util.MessageSourceHelper;
import com.easy.base.util.ServiceMethodReflect;
import com.easy.base.util.UniqueID;
import javax.sql.DataSource;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSessionFactory;
import org.mybatis.spring.SqlSessionFactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Primary;
import org.springframework.context.support.ResourceBundleMessageSource;
import org.springframework.core.io.DefaultResourceLoader;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.springframework.jdbc.core.JdbcTemplate;

public class BaseConfiger {
    @Autowired
    @Qualifier(value="sqlSessionFactory")
    SqlSessionFactoryBean sqlSessionFactory;
    @Autowired
    protected ResourceLoader resourceLoader = new DefaultResourceLoader();

    @Bean(name={"UniqueID"})
    UniqueID onUniqueIDTemplate() throws Exception {
        UniqueID instance = new UniqueID();
        instance.setHostId("120");
        return instance;
    }

    @Bean(name={"datasource"})
    @Qualifier(value="datasource")
    @ConfigurationProperties(prefix="spring.datasource")
    @Primary
    public EasyDataSource onDruidDataSource() {
        EasyDataSource service = new EasyDataSource();
        return service;
    }

    @Bean(name={"JdbcTemplate"})
    public JdbcTemplate onJdbcTemplate(@Qualifier(value="datasource") DataSource dataSource) {
        return new JdbcTemplate(dataSource);
    }

    @Autowired
    @Bean(name={"sqlSessionFactory"})
    public SqlSessionFactoryBean onSqlSessionFactoryBean(@Qualifier(value="datasource") DataSource datasource) {
        SqlSessionFactoryBean service = new SqlSessionFactoryBean();
        Resource resource = this.resourceLoader.getResource("classpath:mybatis-config.xml");
        service.setConfigLocation(resource);
        service.setDataSource(datasource);
        return service;
    }

    @Bean(name={"StorageOperation"})
    public FMybatisTemplate onFMybatisTemplate(@Qualifier(value="sqlSessionFactory") SqlSessionFactory sqlSessionFactory) {
        return new FMybatisTemplate(sqlSessionFactory, ExecutorType.BATCH);
    }

    @Bean(name={"ServiceMethodReflect"})
    public ServiceMethodReflect onServiceMethodReflect() {
        return new ServiceMethodReflect();
    }

    @Bean(name={"messageSource"})
    public ResourceBundleMessageSource onResourceBundleMessageSource() {
        ResourceBundleMessageSource messageSource = new ResourceBundleMessageSource();
        messageSource.setBasenames(new String[]{"message"});
        messageSource.setDefaultEncoding("UTF-8");
        return messageSource;
    }

    @Bean(name={"messageSourceHelper"})
    public MessageSourceHelper onMessageSourceHelper() {
        MessageSourceHelper messageSourceHelper = new MessageSourceHelper();
        messageSourceHelper.setMessageSource(this.onResourceBundleMessageSource());
        return messageSourceHelper;
    }
}

