/*
 * Decompiled with CFR 0.152.
 */
package com.easy.base.controller;

import com.alibaba.fastjson.JSON;
import com.easy.base.entity.ServiceResponse;
import com.easy.base.entity.ServiceSession;
import com.easy.base.util.ServiceMethodReflect;
import com.easy.base.util.Utils;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class BaseController {
    private static final Logger LOGGER = LoggerFactory.getLogger(BaseController.class);
    @Autowired
    HttpServletRequest request;
    @Autowired
    HttpServletResponse response;
    @Autowired
    ServiceMethodReflect rcm;

    public String onRestService(String method, String session, String ent_id, String user_id, String user_name, String locale, String param) {
        LOGGER.info(String.format("---->method=%1$s session=%2$s param=%3$s ent_id=%4$s user_id=%5$s user_name=%6$s locale=%7$s", method + "", session + "", param + "", ent_id + "", user_id + "", user_name + "", locale + ""));
        try {
            Object retdata;
            if (StringUtils.isEmpty((CharSequence)session) && !StringUtils.isEmpty((CharSequence)ent_id)) {
                ServiceSession ss = new ServiceSession();
                if (!StringUtils.isEmpty((CharSequence)ent_id)) {
                    ss.setEnt_id(Long.parseLong(ent_id));
                }
                if (!StringUtils.isEmpty((CharSequence)user_id)) {
                    ss.setUser_id(Long.parseLong(user_id));
                }
                ss.setUser_name(user_name);
                ss.setLocale(locale);
                session = JSON.toJSONString((Object)ss);
            }
            if ((retdata = this.rcm.executeClassMethod(method, session, param)) == null) {
                return "";
            }
            if (retdata instanceof String) {
                return (String)retdata;
            }
            return JSON.toJSONString((Object)Utils.toNormalJSONObject(retdata));
        }
        catch (Exception ex) {
            return JSON.toJSONString((Object)ServiceResponse.buildFailure(null, "10000", Utils.getLastExceptionMessage(ex), new Object[0]));
        }
    }
}

