/*
 * Decompiled with CFR 0.152.
 */
package com.easy.base.storage.strategy;

import com.easy.base.entity.ServiceSession;
import com.easy.base.storage.strategy.SqlSessionTemplate;
import java.util.HashMap;
import org.apache.ibatis.session.ExecutorType;
import org.apache.ibatis.session.SqlSession;
import org.apache.ibatis.session.SqlSessionFactory;
import org.apache.log4j.LogManager;
import org.apache.log4j.Logger;
import org.springframework.dao.support.PersistenceExceptionTranslator;

public class MySqlSessionTemplate
extends SqlSessionTemplate {
    private static final Logger logger = LogManager.getLogger(MySqlSessionTemplate.class);

    public MySqlSessionTemplate(SqlSessionFactory sqlSessionFactory) {
        super(sqlSessionFactory);
    }

    public MySqlSessionTemplate(SqlSessionFactory sqlSessionFactory, ExecutorType executorType, PersistenceExceptionTranslator exceptionTranslator) {
        super(sqlSessionFactory, executorType, exceptionTranslator);
    }

    public MySqlSessionTemplate(SqlSessionFactory sqlSessionFactory, ExecutorType executorType) {
        super(sqlSessionFactory, executorType);
    }

    public void onSetContext(ServiceSession session) {
        this.setEntID(session.getEnt_id());
        this.setShopCode(session.getShop_code());
        this.setUserCode(session.getUser_code());
        this.setDisableContext(session.isDisableContext());
    }

    @Override
    public void enableContext(SqlSession sqlSession, Long entID, String shopCode, String userCode) {
        String statement = "mybatis.sql.setcontext";
        HashMap<String, Object> parameterMap = new HashMap<String, Object>();
        parameterMap.put("entID", entID);
        parameterMap.put("shopcode", shopCode);
        parameterMap.put("usercode", userCode);
        System.out.println(String.format("--->debugMode current entID:%1$s shopCode:%2$s userCode:%3$s", entID, shopCode, userCode));
        if (!logger.isDebugEnabled()) {
            sqlSession.selectOne(statement, parameterMap);
        }
    }

    @Override
    public void disableContext(SqlSession sqlSession) {
        String statement = "mybatis.sql.clearcontext";
        System.out.println("--->debugMode disable context");
        if (!logger.isDebugEnabled()) {
            sqlSession.selectOne(statement);
        }
    }
}

