/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.amp.auth.base;

import com.alibaba.fastjson.JSONObject;
import com.efuture.amp.auth.base.AuthBaseService;
import com.efuture.amp.auth.base.AuthStorageUtils;
import com.efuture.omd.common.entity.AbstractEntityBean;
import com.efuture.omd.common.entity.OperationLogBean;
import com.efuture.omd.common.exception.AlreadyExistException;
import com.efuture.omd.common.exception.ServiceException;
import com.efuture.omd.common.language.MessageSourceHelper;
import com.efuture.omd.common.util.SpringBeanFactory;
import com.efuture.omd.common.util.UniqueID;
import com.efuture.omd.common.util.Utils;
import com.efuture.omd.storage.FStorageOperations;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.util.StringUtils;

public class AuthBasicComponent
extends AuthBaseService {
    public FStorageOperations getStorageOperations() {
        return (FStorageOperations)SpringBeanFactory.getBean((String)"StorageOperation");
    }

    protected void onAddValid(FStorageOperations storage, AbstractEntityBean bean, String id, String ... uniques) throws Exception {
        bean.validateBean(new String[0]);
        if (storage != null) {
            for (int i = 0; uniques != null && i < uniques.length; ++i) {
                String[] uks = uniques[i].split(",");
                if (uks.length <= 0) continue;
                String code = null;
                Field fld = null;
                Criteria criteria = Criteria.where((String)"ent_id").is((Object)bean.getEnt_id());
                for (String k : uks) {
                    code = k.trim();
                    fld = bean.fetchDeclaredField(code);
                    Object obj = fld.get(bean);
                    if (StringUtils.isEmpty((Object)obj)) continue;
                    criteria = criteria.and(code).is(obj);
                }
                Query query = new Query(criteria);
                this.printDebug((Object)String.format("Bean:[%1$s] Operate:[doAdd(%2$s) valid dup] MongoSyntax:[%3$s]", this.getClass().getCanonicalName(), bean.fetchAnnotationTableName(), query));
                Object existbean = storage.selectOne(query, bean.getClass());
                if (existbean == null) continue;
                throw new AlreadyExistException("10001", "{0} {1} [{2}] already exists", new Object[]{MessageSourceHelper.getMessage((String)bean.fetchAnnotationTableName(), (String)bean.getLang(), (Object[])new Object[0]), code, fld.get(bean)});
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long doAdd(AbstractEntityBean bean, String id, String ... uniques) throws Exception {
        FStorageOperations storage = null;
        try {
            Field idfld = bean.fetchDeclaredField(id);
            if (idfld.getLong(bean) <= 0L) {
                idfld.set(bean, UniqueID.getUniqueID());
            }
            storage = this.getStorageOperations();
            this.onAddValid(storage, bean, id, uniques);
            this.printDebug((Object)String.format("Bean:[%1$s] Operate:[doAdd(%2$s)] MongoSyntax:[%3$s->%4$20d]", this.getClass().getCanonicalName(), bean.fetchAnnotationTableName(), bean.getEnt_id(), idfld.getLong(bean)));
            storage.insert((Object)bean);
            long l = idfld.getLong(bean);
            return l;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    protected void onOriginalUpdateValid(AbstractEntityBean original, AbstractEntityBean bean, Set<String> keys, String id, String ... uniques) throws Exception {
        if ("2".equalsIgnoreCase(original.getStatus()) && (keys != null && !keys.contains("status") || "2".equalsIgnoreCase(bean.getStatus()))) {
            Field idfld = bean.fetchDeclaredField(id);
            throw new ServiceException("10002", "{0} {1} [{2}] already publish,can not update", new Object[]{MessageSourceHelper.getMessage((String)bean.fetchAnnotationTableName(), (String)bean.getLang(), (Object[])new Object[0]), id, idfld.get(bean)});
        }
    }

    protected AbstractEntityBean onUpdateValid(FStorageOperations storage, AbstractEntityBean bean, Set<String> keys, String id, String ... uniques) throws Exception {
        ArrayList<String> vk = new ArrayList<String>();
        vk.add("ent_id");
        vk.add(id);
        if (keys != null) {
            for (String k : keys) {
                vk.add(k);
            }
        }
        bean.validateBeanForSpecified(vk.toArray(new String[vk.size()]));
        AbstractEntityBean original = null;
        if (storage != null) {
            Field idfld = bean.fetchDeclaredField(id);
            Criteria criteria = Criteria.where((String)"ent_id").is((Object)bean.getEnt_id()).and(id).is(idfld.get(bean));
            Query query = new Query(criteria);
            original = (AbstractEntityBean)storage.selectOne(query, bean.getClass());
            if (original != null) {
                this.onOriginalUpdateValid(original, bean, keys, id, uniques);
            }
            for (int i = 0; uniques != null && i < uniques.length; ++i) {
                String code;
                String[] uks = uniques[i].split(",");
                if (uks.length <= 0 || !keys.contains(code = uks[uks.length - 1].trim())) continue;
                Field fld = null;
                criteria = Criteria.where((String)"ent_id").is((Object)bean.getEnt_id());
                for (String k : uks) {
                    code = k.trim();
                    fld = bean.fetchDeclaredField(code);
                    Object obj = null;
                    obj = !keys.contains(code) && original != null ? fld.get(original) : fld.get(bean);
                    if (StringUtils.isEmpty((Object)obj)) continue;
                    criteria = criteria.and(code).is(obj);
                }
                criteria = criteria.and(id).ne(bean.fetchDeclaredField(id).get(bean));
                query = new Query(criteria);
                this.printDebug((Object)String.format("Bean:[%1$s] Operate:[doUpdate(%2$s) valid dup] MongoSyntax:[%3$s]", this.getClass().getCanonicalName(), bean.fetchAnnotationTableName(), query));
                Object existbean = storage.selectOne(query, bean.getClass());
                if (existbean == null) continue;
                throw new AlreadyExistException("10001", "{0} {1} [{2}] already exists", new Object[]{MessageSourceHelper.getMessage((String)bean.fetchAnnotationTableName(), (String)bean.getLang(), (Object[])new Object[0]), code, fld.get(bean)});
            }
        }
        return original;
    }

    public long doUpdate(AbstractEntityBean bean, Set<String> keys, String id, String ... uniques) throws Exception {
        AbstractEntityBean original = this.execUpdate(bean, keys, id, uniques);
        if (original != null) {
            Field fld = bean.fetchDeclaredField(id);
            return fld.getLong(original);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractEntityBean execUpdate(AbstractEntityBean bean, Set<String> keys, String id, String ... uniques) throws Exception {
        FStorageOperations storage = null;
        try {
            if (keys == null) {
                keys = new HashSet<String>();
                StringBuffer sb = new StringBuffer();
                bean.fetchAllDeclaredField(sb);
                String[] ss = sb.toString().split(",");
                for (int i = 0; i < ss.length; ++i) {
                    keys.add(ss[i]);
                }
            } else {
                if (!(keys instanceof HashSet)) {
                    keys = new HashSet<String>(keys);
                }
                if (!keys.contains("timestamp")) {
                    keys.add("timestamp");
                }
                if (!keys.contains("modifier_id")) {
                    keys.add("modifier_id");
                }
                if (!keys.contains("modifier")) {
                    keys.add("modifier");
                }
            }
            storage = this.getStorageOperations();
            AbstractEntityBean original = this.onUpdateValid(storage, bean, keys, id, uniques);
            Field fld = bean.fetchDeclaredField(id);
            Query query = new Query(Criteria.where((String)"ent_id").is((Object)bean.getEnt_id()).and(id).is(fld.get(bean)));
            Update upt = AuthStorageUtils.createUpdateFormBean((Object)bean, keys);
            this.printDebug((Object)String.format("Bean:[%1$s] Operate:[doUpdate(%2$s)/update] MongoSyntax:[%3$s]", this.getClass().getCanonicalName(), bean.fetchAnnotationTableName(), query));
            if (storage.update(query, upt, bean.getClass()) <= 0) {
                throw new ServiceException("10003", "{0} {1} [{2}] does not exist", new Object[]{MessageSourceHelper.getMessage((String)bean.fetchAnnotationTableName(), (String)bean.getLang(), (Object[])new Object[0]), id, fld.get(bean)});
            }
            if (original != null) {
                String[] ks = new String[keys.size()];
                OperationLogBean log = this.createOperationLog("UPDATE", "\u7528\u6237 [" + bean.getModifier() + "] \u66f4\u65b0 " + id + " = [" + fld.get(bean) + "] \u7684\u6570\u636e", original, bean, keys.toArray(ks));
                if (log != null) {
                    storage.insert((Object)log);
                }
            }
            AbstractEntityBean abstractEntityBean = original;
            return abstractEntityBean;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    protected void onOriginalDeleteValid(AbstractEntityBean original, AbstractEntityBean bean, String id, String ... keys) throws Exception {
        if ("2".equalsIgnoreCase(original.getStatus())) {
            Field idfld = bean.fetchDeclaredField(id);
            throw new ServiceException("10002", "{0} {1} [{2}] already publish,can not delete", new Object[]{MessageSourceHelper.getMessage((String)bean.fetchAnnotationTableName(), (String)bean.getLang(), (Object[])new Object[0]), id, idfld.get(bean)});
        }
    }

    public AbstractEntityBean onDeleteValid(FStorageOperations storage, AbstractEntityBean bean, String id, String ... keys) throws Exception {
        ArrayList<String> vk = new ArrayList<String>();
        vk.add("ent_id");
        vk.add(id);
        if (keys != null) {
            for (String k : keys) {
                vk.add(k);
            }
        }
        bean.validateBeanForSpecified(vk.toArray(new String[vk.size()]));
        AbstractEntityBean original = null;
        if (storage != null) {
            Query query;
            Field idfld = bean.fetchDeclaredField(id);
            Criteria criteria = Criteria.where((String)"ent_id").is((Object)bean.getEnt_id()).and(id).is(idfld.get(bean));
            if (keys != null) {
                for (String k : keys) {
                    Field fd = bean.fetchDeclaredField(k);
                    criteria = criteria.and(k).is(fd.get(bean));
                }
            }
            if ((original = (AbstractEntityBean)storage.selectOne(query = new Query(criteria), bean.getClass())) != null) {
                this.onOriginalDeleteValid(original, bean, id, keys);
            }
        }
        return original;
    }

    public long doDelete(AbstractEntityBean bean, String id, String ... keys) throws Exception {
        AbstractEntityBean original = this.execDelete(bean, id, keys);
        if (original != null) {
            Field fld = bean.fetchDeclaredField(id);
            return fld.getLong(original);
        }
        return 0L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractEntityBean execDelete(AbstractEntityBean bean, String id, String ... keys) throws Exception {
        FStorageOperations storage = null;
        try {
            OperationLogBean log;
            storage = this.getStorageOperations();
            AbstractEntityBean original = this.onDeleteValid(storage, bean, id, keys);
            Field fld = bean.fetchDeclaredField(id);
            Criteria criteria = Criteria.where((String)"ent_id").is((Object)bean.getEnt_id()).and(id).is(fld.get(bean));
            if (keys != null) {
                for (String k : keys) {
                    Field fd = bean.fetchDeclaredField(k);
                    criteria = criteria.and(k).is(fd.get(bean));
                }
            }
            Query query = new Query(criteria);
            this.printDebug((Object)String.format("Bean:[%1$s] Operate:[doDelete(%2$s)] MongoSyntax:[%3$s]", this.getClass().getCanonicalName(), bean.fetchAnnotationTableName(), query));
            storage.delete(query, bean.getClass());
            if (original != null && (log = this.createOperationLog("DELETE", "\u7528\u6237 [" + bean.getModifier() + "] \u5220\u9664 " + id + " = [" + fld.get(bean) + "] \u7684\u6570\u636e", original, bean, keys)) != null) {
                storage.insert((Object)log);
            }
            AbstractEntityBean abstractEntityBean = original;
            return abstractEntityBean;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    protected OperationLogBean createOperationLog(String oper, String message, AbstractEntityBean originalbean, AbstractEntityBean newbean, String ... keys) {
        try {
            OperationLogBean operlog = (OperationLogBean)SpringBeanFactory.getBean((String)"OperationLog", OperationLogBean.class);
            if (operlog == null) {
                return null;
            }
            if (newbean != null) {
                operlog.initUpdateMember(newbean);
            } else {
                operlog.initUpdateMember(originalbean);
            }
            String[] uniquekeys = null;
            String idkey = (String)AbstractEntityBean.fetchDeclaredField(originalbean.getClass(), (String)"ID_KEY").get(null);
            Field uniquefld = AbstractEntityBean.fetchDeclaredField(originalbean.getClass(), (String)"UNIQUE_KEYS");
            if (uniquefld != null) {
                uniquekeys = (String[])uniquefld.get(null);
            }
            operlog.setOper(oper);
            operlog.setMessage(message);
            operlog.setTable(AbstractEntityBean.fetchAnnotationTableName(originalbean.getClass()));
            operlog.setDataid(AbstractEntityBean.fetchDeclaredField(originalbean.getClass(), (String)idkey).getLong(originalbean));
            HashMap<String, Object> map = new HashMap<String, Object>();
            if (uniquekeys != null) {
                for (String key : uniquekeys) {
                    String[] uks = key.split(",");
                    if (uks.length <= 0) continue;
                    for (String k : uks) {
                        Field fld = originalbean.fetchDeclaredField(k = k.trim());
                        if (fld == null || idkey.equalsIgnoreCase(k)) continue;
                        map.put(k, fld.get(originalbean));
                    }
                }
            }
            if (keys != null && "UPDATE".equalsIgnoreCase(oper)) {
                HashMap<String, Object> newmap = new HashMap<String, Object>();
                for (String k : keys) {
                    Field fld;
                    String assign;
                    Map assignMap;
                    String ignore;
                    Map ignoreMap;
                    if ("timestamp".equalsIgnoreCase(k = k.trim()) || "modifier_id".equalsIgnoreCase(k) || "modifier".equalsIgnoreCase(k) || (ignoreMap = operlog.getIgnore()) != null && ignoreMap.containsKey(operlog.getTable()) && ("*".equals(ignore = ignoreMap.get(operlog.getTable()).toString()) || Utils.stringArrayContainsKey((String[])ignore.split(","), (String)k, (boolean)true)) || (assignMap = operlog.getAssign()) != null && assignMap.containsKey(operlog.getTable()) && !"*".equals(assign = assignMap.get(operlog.getTable()).toString()) && !Utils.stringArrayContainsKey((String[])assign.split(","), (String)k, (boolean)true) && !Utils.stringArrayContainsKey((String[])uniquekeys, (String)k, (boolean)true) || (fld = originalbean.fetchDeclaredField(k)) == null || idkey.equalsIgnoreCase(k)) continue;
                    Object originalobj = fld.get(originalbean);
                    Object newobj = fld.get(newbean);
                    if (String.valueOf(originalobj).equals(String.valueOf(newobj))) continue;
                    map.put(k, originalobj);
                    newmap.put(k, newobj);
                }
                if (newmap.size() > 0) {
                    operlog.setNew_value(newmap);
                }
            }
            if (map.size() > 0) {
                operlog.setOriginal_value(map);
            }
            return operlog;
        }
        catch (Exception ex) {
            return null;
        }
    }

    public List<Map<String, Object>> doSearchForMap(JSONObject jsonparam, Class<?> objClass, StringBuffer total) throws Exception {
        if (!jsonparam.containsKey((Object)"fields")) {
            StringBuffer sb = new StringBuffer();
            AbstractEntityBean.fetchAllDeclaredField(objClass, (StringBuffer)sb);
            jsonparam.put("fields", (Object)sb.toString());
        }
        return this.doGet(jsonparam, objClass, total);
    }

    public Map<String, Object> doSearchOneForMap(JSONObject jsonparam, Class<?> objClass) throws Exception {
        jsonparam.put("page_size", (Object)1);
        List list = this.doSearchForMap(jsonparam, objClass, null);
        if (list != null && list.size() > 0) {
            return (Map)list.get(0);
        }
        return null;
    }

    public <T> List<T> doSearch(JSONObject jsonparam, Class<T> objClass, StringBuffer total) throws Exception {
        jsonparam.remove((Object)"fields");
        return this.doGet(jsonparam, objClass, total);
    }

    public <T> T doSearchOne(JSONObject jsonparam, Class<T> objClass) throws Exception {
        jsonparam.put("page_size", (Object)1);
        List list = this.doSearch(jsonparam, objClass, null);
        if (list != null && list.size() > 0) {
            return (T)list.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<?> doGet(JSONObject jsonparam, Class<?> objClass, StringBuffer total) throws Exception {
        FStorageOperations storage = null;
        try {
            storage = this.getStorageOperations();
            Query query = null;
            query = total == null && !jsonparam.containsKey((Object)"page_size") ? AuthStorageUtils.createQueryFormJson((JSONObject)jsonparam, objClass, (boolean)false) : AuthStorageUtils.createQueryFormJson((JSONObject)jsonparam, objClass);
            List list = null;
            if (jsonparam.containsKey((Object)"fields") && !StringUtils.isEmpty((Object)jsonparam.get((Object)"fields"))) {
                this.printDebug((Object)String.format("Bean:[%1$s] Operate:[doGet(%2$s)Map] MongoSyntax:[%3$s]", this.getClass().getCanonicalName(), AbstractEntityBean.fetchAnnotationTableName(objClass), query));
                list = storage.select(query, AbstractEntityBean.fetchAnnotationTableName(objClass));
            } else {
                this.printDebug((Object)String.format("Bean:[%1$s] Operate:[doGet(%2$s)Bean] MongoSyntax:[%3$s]", this.getClass().getCanonicalName(), AbstractEntityBean.fetchAnnotationTableName(objClass), query));
                list = storage.select(query, objClass);
            }
            if (total != null) {
                total.delete(0, total.length());
                if (list == null || list.size() <= 0) {
                    total.append("0");
                } else if (query.getLimit() > 0) {
                    total.append(storage.count(query, objClass));
                } else {
                    total.append(list.size());
                }
            }
            List list2 = list;
            return list2;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }
}

