/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.amp.auth.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.amp.auth.base.AuthBasicComponent;
import com.efuture.amp.auth.entity.AccountBean;
import com.efuture.amp.auth.intf.AccountService;
import com.efuture.omd.common.entity.AbstractEntityBean;
import com.efuture.omd.common.entity.ServiceResponse;
import com.efuture.omd.common.entity.ServiceSession;
import com.efuture.omd.common.exception.ServiceException;
import com.efuture.omd.common.util.QueryUtils;
import com.efuture.omd.common.util.UniqueID;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.util.StringUtils;

public class AccountServiceImpl
extends AuthBasicComponent
implements AccountService {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResponse add(ServiceSession session, String param) throws Exception {
        Object storage = null;
        try {
            if (session == null) {
                ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"50001", null, (Object[])new Object[0]);
                return serviceResponse;
            }
            if (StringUtils.isEmpty((Object)param)) {
                ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
                return serviceResponse;
            }
            AccountBean account = (AccountBean)JSON.parseObject((String)param, AccountBean.class);
            if (StringUtils.isEmpty((Object)account.getPassword())) {
                ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"50000", (String)"account password is empty", (Object[])new Object[0]);
                return serviceResponse;
            }
            account.setAid(UniqueID.getUniqueID());
            account.initInsertMember(session);
            long bid = this.doAdd((AbstractEntityBean)account, "aid", new String[]{"code"});
            JSONObject respdata = new JSONObject();
            respdata.put("aid", (Object)bid);
            ServiceResponse serviceResponse = ServiceResponse.buildSuccess((Object)respdata);
            return serviceResponse;
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)ex.getErrorCode(), (String)ex.getMessage(), (Object[])ex.getErrorArgs());
            return serviceResponse;
        }
        finally {
            if (storage != null) {
                storage.destroy();
            }
        }
    }

    public ServiceResponse update(ServiceSession session, String param) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
            }
            if (StringUtils.isEmpty((Object)param)) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
            }
            AccountBean accountBean = (AccountBean)JSON.parseObject((String)param, AccountBean.class);
            accountBean.initUpdateMember(session);
            Set updateFields = JSON.parseObject((String)param).keySet();
            updateFields.remove("password");
            if (!updateFields.contains("aid")) {
                try {
                    accountBean.validateBeanForSpecified(new String[]{"ent_id", "code"});
                }
                catch (Exception e) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"\u5165\u53e3\u53c2\u6570\u5fc5\u987b\u542b\u5e10\u53f7\u53c2\u6570(\u6216\u4f01\u4e1a+\u5de5\u53f7\u53c2\u6570)");
                }
                String query = QueryUtils.getInstance().getQuery((Object)accountBean, "aid,code,name", "ent_id,code");
                JSONObject jsonparam = JSON.parseObject((String)query);
                AccountBean accountOne = (AccountBean)this.doSearchOne(jsonparam, AccountBean.class);
                if (accountOne == null) {
                    throw new Exception("\u9700\u8981\u4fee\u6539\u7684\u8d26\u6237\u8d44\u6599\u4e0d\u5b58\u5728!");
                }
                accountBean.setAid(accountOne.getAid());
            }
            long aid = this.doUpdate((AbstractEntityBean)accountBean, updateFields, "aid", new String[]{"code"});
            JSONObject respdata = new JSONObject();
            respdata.put("aid", (Object)aid);
            return ServiceResponse.buildSuccess((Object)respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure((ServiceSession)session, (String)ex.getErrorCode(), (String)ex.getMessage(), (Object[])ex.getErrorArgs());
        }
    }

    public ServiceResponse delete(ServiceSession session, String param) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
            }
            if (StringUtils.isEmpty((Object)param)) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
            }
            AccountBean accountBean = (AccountBean)JSON.parseObject((String)param, AccountBean.class);
            accountBean.setEnt_id(session.getEnt_id());
            Set filterFields = JSON.parseObject((String)param).keySet();
            if (!filterFields.contains("aid")) {
                try {
                    accountBean.validateBeanForSpecified(new String[]{"ent_id", "code"});
                }
                catch (Exception e) {
                    return ServiceResponse.buildFailure((ServiceSession)session, (String)"\u5165\u53e3\u53c2\u6570\u5fc5\u987b\u542b\u5e10\u53f7\u53c2\u6570(\u6216\u4f01\u4e1a+\u5de5\u53f7\u53c2\u6570)");
                }
                String query = QueryUtils.getInstance().getQuery((Object)accountBean, "aid,code,name", "ent_id,code");
                JSONObject jsonparam = JSON.parseObject((String)query);
                AccountBean accountOne = (AccountBean)this.doSearchOne(jsonparam, AccountBean.class);
                if (accountOne == null) {
                    throw new Exception("\u9700\u8981\u5220\u9664\u7684\u8d26\u6237\u8d44\u6599\u4e0d\u5b58\u5728!");
                }
                accountBean.setAid(accountOne.getAid());
            }
            long aid = this.doDelete((AbstractEntityBean)accountBean, "aid", new String[0]);
            JSONObject respdata = new JSONObject();
            respdata.put("aid", (Object)aid);
            return ServiceResponse.buildSuccess((Object)respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure((ServiceSession)session, (String)ex.getErrorCode(), (String)ex.getMessage(), (Object[])ex.getErrorArgs());
        }
    }

    public ServiceResponse get(ServiceSession session, JSONObject jsonparam) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
            }
            String id = "aid";
            if (!jsonparam.containsKey((Object)id) || StringUtils.isEmpty((Object)jsonparam.getLong(id))) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50000", (String)"{0} {1} is empty", (Object[])new Object[]{AbstractEntityBean.fetchAnnotationTableName(AccountBean.class), id});
            }
            jsonparam.put("ent_id", (Object)session.getEnt_id());
            Object obj = null;
            obj = !jsonparam.containsKey((Object)"fields") ? this.doSearchOne(jsonparam, AccountBean.class) : this.doSearchOneForMap(jsonparam, AccountBean.class);
            if (obj == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"{0} {1} [{2}] does not exist", (Object[])new Object[]{AbstractEntityBean.fetchAnnotationTableName(AccountBean.class), id, jsonparam.getLong(id)});
            }
            JSONObject respdata = new JSONObject();
            respdata.put("account", obj);
            return ServiceResponse.buildSuccess((Object)respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure((ServiceSession)session, (String)ex.getErrorCode(), (String)ex.getMessage(), (Object[])ex.getErrorArgs());
        }
    }

    public ServiceResponse search(ServiceSession session, JSONObject jsonparam) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
            }
            if (StringUtils.isEmpty((Object)jsonparam)) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
            }
            StringBuffer total = new StringBuffer();
            List list = null;
            list = !jsonparam.containsKey((Object)"fields") ? this.doSearch(jsonparam, AccountBean.class, total) : this.doSearchForMap(jsonparam, AccountBean.class, total);
            JSONObject respdata = new JSONObject();
            respdata.put("total_results", (Object)Long.parseLong(total.toString()));
            respdata.put("account", (Object)list);
            return ServiceResponse.buildSuccess((Object)respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure((ServiceSession)session, (String)ex.getErrorCode(), (String)ex.getMessage(), (Object[])ex.getErrorArgs());
        }
    }

    public long count(ServiceSession session, JSONObject jsonparam) throws Exception {
        JSONObject responseData;
        ServiceResponse serviceResponse = this.search(session, jsonparam);
        if (serviceResponse != null && "0".equalsIgnoreCase(serviceResponse.getReturncode()) && serviceResponse.getData() != null && (responseData = (JSONObject)serviceResponse.getData()).containsKey((Object)"total_results")) {
            return responseData.getLongValue("total_results");
        }
        return -1L;
    }

    public ServiceResponse changePassword(ServiceSession session, String param) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
            }
            if (StringUtils.isEmpty((Object)param)) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
            }
            JSONObject jsonParam = JSON.parseObject((String)param);
            JSONObject findParam = new JSONObject();
            findParam.put("ent_id", (Object)session.getEnt_id());
            findParam.put("code", (Object)jsonParam.getString("code"));
            StringBuffer total = new StringBuffer();
            List list = this.doSearch(findParam, AccountBean.class, total);
            if (list != null && list.size() < 1) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50000", (String)"\u975e\u6cd5\u7528\u6237\u8d44\u6599", (Object[])new Object[0]);
            }
            AccountBean accountBean = (AccountBean)list.get(0);
            accountBean.setPassword(jsonParam.getString("password"));
            accountBean.initUpdateMember(session);
            HashSet<String> updateFields = new HashSet<String>();
            updateFields.add("password");
            long aid = this.doUpdate((AbstractEntityBean)accountBean, updateFields, "aid", new String[]{"code"});
            JSONObject respdata = new JSONObject();
            respdata.put("aid", (Object)aid);
            return ServiceResponse.buildSuccess((Object)respdata);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure((ServiceSession)session, (String)ex.getErrorCode(), (String)ex.getMessage(), (Object[])ex.getErrorArgs());
        }
    }
}

