/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.amp.auth.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.efuture.amp.auth.base.AuthBasicComponent;
import com.efuture.amp.auth.component.AccountServiceImpl;
import com.efuture.amp.auth.entity.AccountBean;
import com.efuture.amp.auth.entity.AuthenticationBean;
import com.efuture.amp.auth.intf.AuthenticationService;
import com.efuture.omd.common.entity.AbstractEntityBean;
import com.efuture.omd.common.entity.ServiceResponse;
import com.efuture.omd.common.entity.ServiceSession;
import com.efuture.omd.common.exception.ServiceException;
import com.efuture.omd.common.util.SimplePropertyFilter;
import com.efuture.omd.common.util.UniqueID;
import org.springframework.util.StringUtils;

public class AuthenticationServiceImpl
extends AuthBasicComponent
implements AuthenticationService {
    public ServiceResponse signIn(ServiceSession session, String param) throws Exception {
        if (session == null) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001", null, (Object[])new Object[0]);
        }
        if (StringUtils.isEmpty((Object)param)) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
        }
        if (StringUtils.isEmpty((Object)param)) {
            param = "{}";
        }
        AuthenticationBean authentication = (AuthenticationBean)JSON.parseObject((String)param, AuthenticationBean.class);
        try {
            authentication.validateBeanForSpecified(new String[]{"ent_id"});
            session.setEnt_id(authentication.getEnt_id());
        }
        catch (Exception e) {
            authentication.setEnt_id(session.getEnt_id());
        }
        authentication.setToken(Long.toString(UniqueID.getUniqueID()));
        authentication.initInsertMember(session);
        if (StringUtils.isEmpty((Object)authentication.getPassword())) {
            authentication.setPassword("#");
        }
        String password = authentication.getPassword();
        AccountServiceImpl accountService = new AccountServiceImpl();
        JSONObject query = new JSONObject();
        query.put("fields", (Object)"aid,code,name,password");
        query.put("order_field", (Object)"code");
        query.put("order_direction", (Object)"desc");
        query.put("page_no", (Object)1);
        query.put("page_size", (Object)1);
        query.put("ent_id", (Object)authentication.getEnt_id());
        query.put("code", (Object)authentication.getCode());
        query.put("password", (Object)password);
        try {
            AccountBean accountBean = (AccountBean)accountService.doSearchOne(query, AccountBean.class);
            if (accountBean == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50000", (String)"authentication code or password faiure", (Object[])new Object[0]);
            }
            authentication.setAuthid(accountBean.getAid());
            authentication.setCode(accountBean.getCode());
            authentication.setName(accountBean.getName());
            authentication.setPassword(accountBean.getPassword());
            authentication.initInsertMember(session);
            this.doAdd((AbstractEntityBean)authentication, "serialno", new String[0]);
            JSONObject response = new JSONObject();
            response.put("token", (Object)authentication.getToken());
            response.put("extData", (Object)authentication.getExtData());
            return ServiceResponse.buildSuccess((Object)response);
        }
        catch (ServiceException ex) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)ex.getErrorCode(), (String)ex.getMessage(), (Object[])ex.getErrorArgs());
        }
    }

    public ServiceResponse signOut(ServiceSession session, String param) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001", null, (Object[])new Object[0]);
            }
            if (StringUtils.isEmpty((Object)param)) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003");
            }
            if (StringUtils.isEmpty((Object)param)) {
                param = "{}";
            }
            AuthenticationBean authenticationBean = (AuthenticationBean)JSON.parseObject((String)param, AuthenticationBean.class);
            authenticationBean.validateBeanForSpecified(new String[]{"token"});
            JSONObject query = new JSONObject();
            query.put("fields", (Object)"authid,code,name,password");
            query.put("order_field", (Object)"code");
            query.put("order_direction", (Object)"desc");
            query.put("page_no", (Object)1);
            query.put("page_size", (Object)1);
            query.put("token", (Object)authenticationBean.getToken());
            authenticationBean = (AuthenticationBean)this.doSearchOne(query, AuthenticationBean.class);
            if (authenticationBean == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50000", (String)"authentication token is invalid", (Object[])new Object[0]);
            }
            this.doDelete((AbstractEntityBean)authenticationBean, "serialno", new String[0]);
            JSONObject response = new JSONObject();
            response.put("token", (Object)authenticationBean.getToken());
            return ServiceResponse.buildSuccess((Object)response);
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure((ServiceSession)session, (String)ex.getErrorCode(), (String)ex.getMessage(), (Object[])ex.getErrorArgs());
        }
    }

    public ServiceResponse checkState(ServiceSession session, String param) throws Exception {
        try {
            if (session == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001", null, (Object[])new Object[0]);
            }
            if (param == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50003", null, (Object[])new Object[0]);
            }
            if (StringUtils.isEmpty((Object)param)) {
                param = "{}";
            }
            AuthenticationBean authenticationBean = (AuthenticationBean)JSON.parseObject((String)param, AuthenticationBean.class);
            authenticationBean.validateBeanForSpecified(new String[]{"token"});
            JSONObject query = new JSONObject();
            query.put("fields", (Object)"authid,code,name,ent_id,extData");
            query.put("order_field", (Object)"code");
            query.put("order_direction", (Object)"desc");
            query.put("page_no", (Object)1);
            query.put("page_size", (Object)1);
            query.put("token", (Object)authenticationBean.getToken());
            authenticationBean = (AuthenticationBean)this.doSearchOne(query, AuthenticationBean.class);
            if (authenticationBean == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50000", (String)"authentication token is invalid", (Object[])new Object[0]);
            }
            SimplePropertyFilter filter = new SimplePropertyFilter(new String[]{"token", "authid", "code", "name", "ent_id", "extData"});
            String jsonParam = JSON.toJSONString((Object)authenticationBean, (SerializeFilter)filter, (SerializerFeature[])new SerializerFeature[0]);
            return ServiceResponse.buildSuccess((Object)JSON.parse((String)jsonParam));
        }
        catch (ServiceException ex) {
            this.getLogger().error((Object)ex.getMessage(), (Throwable)ex);
            return ServiceResponse.buildFailure((ServiceSession)session, (String)ex.getErrorCode(), (String)ex.getMessage(), (Object[])ex.getErrorArgs());
        }
    }

    public ServiceResponse changePassword(ServiceSession session, String param) throws Exception {
        return new AccountServiceImpl().changePassword(session, param);
    }
}

