/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.amp.sso.component;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.amp.sso.component.SSOConfig;
import com.efuture.amp.sso.intf.AccountBean;
import com.efuture.amp.sso.intf.AuthenticationBean;
import com.efuture.amp.sso.service.ServiceResponse;
import com.efuture.amp.sso.utils.WebRequester;
import com.efuture.omd.common.util.QueryUtils;
import java.util.ArrayList;
import java.util.Set;

public class SSOComponent
extends SSOConfig {
    private static SSOComponent ssoInstance = null;

    private static synchronized void initInstance() {
        if (ssoInstance == null) {
            ssoInstance = new SSOComponent();
        }
    }

    public static SSOComponent getInstance() {
        if (ssoInstance == null) {
            SSOComponent.initInstance();
        }
        return ssoInstance;
    }

    public String doInsertAccount(String tokenID, Long entID, String code, String name, String idno, String telNo, String mobileNo, String typeNO, String eMail, String sourceNo, String password) throws Exception {
        String method = "amp.auth.account.add";
        SSOComponent.initSSOConfig();
        if (!SSOComponent.isSsoEnable()) {
            return "";
        }
        AccountBean accountBean = new AccountBean();
        accountBean.setEnt_id(entID);
        accountBean.setToken(tokenID);
        accountBean.setCode(code);
        accountBean.setName(name);
        accountBean.setIdentityNo(idno);
        accountBean.setTelNo(telNo);
        accountBean.setMobileNo(mobileNo);
        accountBean.setTypeNo(typeNO);
        accountBean.seteMail(eMail);
        accountBean.setSourceNo(sourceNo);
        accountBean.setPassword(password);
        this.validateBean(accountBean.getClass(), new String[0]);
        String query = QueryUtils.getInstance().getInsert((Object)accountBean, new String[]{"ent_id", "token", "code", "name", "identityNo", "telNo", "mobileNo", "eMail", "typeNo", "sourceNo", "password"});
        String responseData = WebRequester.getInstance().post(SSOComponent.getSsoRemoteURL(), method, tokenID, SSOComponent.getAppKey(), SSOComponent.getVersion(), SSOComponent.getSignMethod(), query);
        ServiceResponse respose = (ServiceResponse)JSON.parseObject((String)responseData, ServiceResponse.class);
        if (!"0".equalsIgnoreCase(respose.getReturncode())) {
            throw new Exception("\u6267\u884c\u5e10\u53f7\u6dfb\u52a0\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:" + respose.getData());
        }
        JSONObject beanObject = (JSONObject)respose.getData();
        AccountBean resposeBean = (AccountBean)JSON.parseObject((String)beanObject.toJSONString(), AccountBean.class);
        return resposeBean.getToken();
    }

    public String doUpdateAccount(String tokenID, Long entID, String code, String params) throws Exception {
        String method = "amp.auth.account.update";
        SSOComponent.initSSOConfig();
        if (!SSOComponent.isSsoEnable()) {
            return "";
        }
        AccountBean accountBean = (AccountBean)JSON.parseObject((String)params, AccountBean.class);
        JSONObject jsonParams = JSON.parseObject((String)params);
        accountBean.setEnt_id(entID);
        accountBean.setToken(tokenID);
        accountBean.setCode(code);
        Set keys = jsonParams.keySet();
        ArrayList<String> vk = new ArrayList<String>();
        vk.add("entid");
        vk.add("token");
        vk.add("code");
        for (String k : keys) {
            if (!keys.contains(k)) continue;
            vk.add(k);
        }
        this.validateBeanForSpecified(vk.toArray(new String[vk.size()]), new String[0]);
        String query = QueryUtils.getInstance().getUpdate((Object)accountBean, "ent_id,token,code,name,identityNo,telNo,mobileNo,eMail,typeNo,sourceNo,password");
        String responseData = WebRequester.getInstance().post(SSOComponent.getSsoRemoteURL(), method, tokenID, SSOComponent.getAppKey(), SSOComponent.getVersion(), SSOComponent.getSignMethod(), query);
        ServiceResponse respose = (ServiceResponse)JSON.parseObject((String)responseData, ServiceResponse.class);
        if (!"0".equalsIgnoreCase(respose.getReturncode())) {
            throw new Exception("\u6267\u884c\u5e10\u53f7\u4fee\u6539\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:" + respose.getData());
        }
        JSONObject beanObject = (JSONObject)respose.getData();
        AccountBean resposeBean = (AccountBean)JSON.parseObject((String)beanObject.toJSONString(), AccountBean.class);
        return resposeBean.getToken();
    }

    public String doDeleteAccount(String tokenID, Long entID, String code) throws Exception {
        String method = "amp.auth.account.delete";
        SSOComponent.initSSOConfig();
        if (!SSOComponent.isSsoEnable()) {
            return "";
        }
        AccountBean accountBean = new AccountBean();
        accountBean.setEnt_id(entID);
        accountBean.setCode(code);
        this.validateBeanForSpecified(accountBean, "ent_id", "code");
        String query = QueryUtils.getInstance().getDelete((Object)accountBean, "ent_id,code");
        String responseData = WebRequester.getInstance().post(SSOComponent.getSsoRemoteURL(), method, tokenID, SSOComponent.getAppKey(), SSOComponent.getVersion(), SSOComponent.getSignMethod(), query);
        ServiceResponse respose = (ServiceResponse)JSON.parseObject((String)responseData, ServiceResponse.class);
        if (!"0".equalsIgnoreCase(respose.getReturncode())) {
            throw new Exception("\u6267\u884c\u5e10\u53f7\u5220\u9664\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:" + respose.getData());
        }
        JSONObject beanObject = (JSONObject)respose.getData();
        AccountBean resposeBean = (AccountBean)JSON.parseObject((String)beanObject.toJSONString(), AccountBean.class);
        return resposeBean.getToken();
    }

    public String doSignIn(Long entID, String code, String password) throws Exception {
        String method = "amp.auth.authentication.signIn";
        SSOComponent.initSSOConfig();
        if (!SSOComponent.isSsoEnable()) {
            return "";
        }
        AuthenticationBean authenticationBean = new AuthenticationBean();
        authenticationBean.setEnt_id(entID);
        authenticationBean.setCode(code);
        authenticationBean.setPassword(password);
        this.validateBeanForSpecified(authenticationBean, "entid", "code", "password");
        String query = QueryUtils.getInstance().getQuery((Object)authenticationBean, "ent_id,code,password");
        String responseData = WebRequester.getInstance().post(SSOComponent.getSsoRemoteURL(), method, null, SSOComponent.getAppKey(), SSOComponent.getVersion(), SSOComponent.getSignMethod(), query);
        ServiceResponse respose = (ServiceResponse)JSON.parseObject((String)responseData, ServiceResponse.class);
        if (!"0".equalsIgnoreCase(respose.getReturncode())) {
            throw new Exception("\u6267\u884c\u5e10\u53f7\u767b\u5165\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:" + respose.getData());
        }
        JSONObject beanObject = (JSONObject)respose.getData();
        AuthenticationBean resposeBean = (AuthenticationBean)JSON.parseObject((String)beanObject.toJSONString(), AuthenticationBean.class);
        return resposeBean.getToken();
    }

    public String doCheckState(String tokenID) throws Exception {
        String method = "amp.auth.authentication.checkState";
        SSOComponent.initSSOConfig();
        if (!SSOComponent.isSsoEnable()) {
            return "";
        }
        AuthenticationBean authenticationBean = new AuthenticationBean();
        authenticationBean.setToken(tokenID);
        QueryUtils.getInstance().validateBeanForSpecified((Object)authenticationBean, new String[]{"token"});
        String query = QueryUtils.getInstance().getQuery((Object)authenticationBean, "authid,code,name,token,ent_id,serialno", "code,desc", 1, 1, "token");
        String responseData = WebRequester.getInstance().post(SSOComponent.getSsoRemoteURL(), method, tokenID, SSOComponent.getAppKey(), SSOComponent.getVersion(), SSOComponent.getSignMethod(), query);
        ServiceResponse respose = (ServiceResponse)JSON.parseObject((String)responseData, ServiceResponse.class);
        if (!"0".equalsIgnoreCase(respose.getReturncode())) {
            throw new Exception("\u6267\u884c\u767b\u5165\u72b6\u6001\u68c0\u67e5\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:" + respose.getData());
        }
        JSONObject beanObject = (JSONObject)respose.getData();
        AuthenticationBean resposeBean = (AuthenticationBean)JSON.parseObject((String)beanObject.toJSONString(), AuthenticationBean.class);
        return resposeBean.getToken();
    }

    public String doChangePassword(Long entID, String tokenID, String code, String password, String newpassword) throws Exception {
        String method = "amp.auth.account.changePassword";
        SSOComponent.initSSOConfig();
        if (!SSOComponent.isSsoEnable()) {
            return "";
        }
        AccountBean accountBean = new AccountBean();
        accountBean.setEnt_id(entID);
        accountBean.setToken(tokenID);
        accountBean.setCode(code);
        accountBean.setSourceNo(password);
        accountBean.setPassword(newpassword);
        this.validateBeanForSpecified(accountBean, "ent_id", "token", "code", "password", "newpassword");
        String query = QueryUtils.getInstance().getQuery((Object)accountBean, "token,ent_id,code,password,newpassword");
        String responseData = WebRequester.getInstance().post(SSOComponent.getSsoRemoteURL(), method, tokenID, SSOComponent.getAppKey(), SSOComponent.getVersion(), SSOComponent.getSignMethod(), query);
        ServiceResponse respose = (ServiceResponse)JSON.parseObject((String)responseData, ServiceResponse.class);
        if (!"0".equalsIgnoreCase(respose.getReturncode())) {
            throw new Exception("\u6267\u884c\u5bc6\u7801\u4fee\u6539\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:" + respose.getData());
        }
        JSONObject beanObject = (JSONObject)respose.getData();
        AccountBean resposeBean = (AccountBean)JSON.parseObject((String)beanObject.toJSONString(), AccountBean.class);
        return String.valueOf(resposeBean.getAid());
    }

    public String doSignOut(Long entID, String tokenID) throws Exception {
        String method = "amp.auth.authentication.signOut";
        SSOComponent.initSSOConfig();
        if (!SSOComponent.isSsoEnable()) {
            return "";
        }
        AuthenticationBean authenticationBean = new AuthenticationBean();
        authenticationBean.setEnt_id(entID);
        authenticationBean.setToken(tokenID);
        this.validateBeanForSpecified(authenticationBean, "entid", "token");
        String query = QueryUtils.getInstance().getQuery((Object)authenticationBean, "token,ent_id");
        String responseData = WebRequester.getInstance().post(SSOComponent.getSsoRemoteURL(), method, tokenID, SSOComponent.getAppKey(), SSOComponent.getVersion(), SSOComponent.getSignMethod(), query);
        ServiceResponse respose = (ServiceResponse)JSON.parseObject((String)responseData, ServiceResponse.class);
        if (!"0".equalsIgnoreCase(respose.getReturncode())) {
            throw new Exception("\u6267\u884c\u5e10\u53f7\u767b\u51fa\u5931\u8d25\uff0c\u9519\u8bef\u4fe1\u606f:" + respose.getData());
        }
        JSONObject beanObject = (JSONObject)respose.getData();
        AuthenticationBean resposeBean = (AuthenticationBean)JSON.parseObject((String)beanObject.toJSONString(), AuthenticationBean.class);
        return resposeBean.getToken();
    }
}

