/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.amp.sso.component;

import com.efuture.amp.sso.component.BaseComponent;
import com.efuture.omd.common.util.IniReader;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import org.apache.commons.lang.StringUtils;

public class SSOConfig
extends BaseComponent {
    private static boolean initSSOConfig = false;
    private static String ssoRemoteURL = "";
    private static boolean ssoEnable = false;
    private static String appKey = "12345";
    private static String version = "1.0";
    private static String signMethod = "MD5";

    public static String getBaseIniPath() {
        URL sPath = Thread.currentThread().getContextClassLoader().getResource("");
        String path = "";
        if (sPath != null) {
            path = sPath.toString();
        } else {
            File file = new File(".");
            try {
                path = file.getCanonicalPath() + File.separator;
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        path = path.replaceAll("file:", "");
        path = path.replaceAll("%20", " ");
        return path;
    }

    protected static void initSSOConfig() {
        if (initSSOConfig) {
            return;
        }
        SSOConfig.initReaderConfig();
    }

    public static boolean isSsoEnable() {
        SSOConfig.initSSOConfig();
        return ssoEnable;
    }

    public static void setSsoEnable(boolean ssoEnable) {
        SSOConfig.ssoEnable = ssoEnable;
    }

    public static String getSsoRemoteURL() {
        return ssoRemoteURL;
    }

    public static void setSsoRemoteURL(String ssoRemoteURL) {
        SSOConfig.ssoRemoteURL = ssoRemoteURL;
    }

    public static String getAppKey() {
        return appKey;
    }

    public static String getVersion() {
        return version;
    }

    public static String getSignMethod() {
        return signMethod;
    }

    private static synchronized void initReaderConfig() {
        if (initSSOConfig) {
            return;
        }
        String filename = SSOConfig.getBaseIniPath() + "ssoConfig.ini";
        if (!new File(filename).exists()) {
            filename = SSOConfig.getBaseIniPath() + "conf/ssoConfig.ini";
        }
        try {
            IniReader reader = new IniReader(filename);
            String remoteURL = reader.getValue("config", "RemoteURL");
            String enableState = reader.getValue("config", "Enable");
            appKey = reader.getValue("config", "appKey");
            version = reader.getValue("config", "version");
            signMethod = reader.getValue("config", "signMethod");
            if (StringUtils.isEmpty((String)enableState) || StringUtils.isEmpty((String)remoteURL) || enableState.equals("0") || enableState.equalsIgnoreCase("N")) {
                ssoEnable = false;
                ssoRemoteURL = "";
                initSSOConfig = true;
            } else {
                ssoEnable = true;
                ssoRemoteURL = remoteURL;
                initSSOConfig = true;
            }
        }
        catch (IOException ioe) {
            System.out.println(ioe.getMessage());
            ssoEnable = false;
            ssoRemoteURL = "";
            initSSOConfig = true;
            return;
        }
    }
}

