/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.remote;

import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.HessianService;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.service.SyjMainLogRemoteService;
import com.efuture.business.service.SyjMainLogSaleBS;
import com.efuture.business.util.ThreadContextUtils;
import com.product.model.ServiceSession;
import java.math.BigDecimal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HessianService(value="/apiSyjMainLogRemoteService.do", interf=SyjMainLogRemoteService.class)
@Service
public class SyjMainLogRemoteServiceImpl
implements SyjMainLogRemoteService {
    private static final Logger log = LoggerFactory.getLogger(SyjMainLogRemoteServiceImpl.class);
    @Autowired
    private SyjMainLogSaleBS syjMainLogSaleBS;
    @Autowired
    private ThreadContextUtils threadContextUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxPreCount(JSONObject jsonObject) {
        try {
            this.threadContextUtils.setLogFlag(jsonObject);
            long l = this.syjMainLogSaleBS.getMaxPreCount(jsonObject);
            return l;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public int saveEntity(JSONObject jsonObject) {
        try {
            this.threadContextUtils.setLogFlag(jsonObject);
            int n = this.syjMainLogSaleBS.saveEntity(jsonObject);
            return n;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public String getCashList(JSONObject param) {
        try {
            this.threadContextUtils.setLogFlag(param);
            String string = this.syjMainLogSaleBS.getCashList(param);
            return string;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public BigDecimal getTotalPreje(JSONObject jsonObject) {
        try {
            this.threadContextUtils.setLogFlag(jsonObject);
            BigDecimal bigDecimal = this.syjMainLogSaleBS.getTotalPreje(jsonObject);
            return bigDecimal;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public BigDecimal getTotalPay(JSONObject jsonObject) {
        try {
            this.threadContextUtils.setLogFlag(jsonObject);
            BigDecimal bigDecimal = this.syjMainLogSaleBS.getTotalPay(jsonObject);
            return bigDecimal;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase getTemporaryPayLog(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        try {
            this.threadContextUtils.setLogFlag(jsonObject);
            RespBase respBase = this.syjMainLogSaleBS.getTemporaryPayLog(session, vo, jsonObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase getInsertCashLog(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        try {
            this.threadContextUtils.setLogFlag(jsonObject);
            RespBase respBase = this.syjMainLogSaleBS.getInsertCashLog(session, vo, jsonObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase insertCash(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        try {
            this.threadContextUtils.setLogFlag(jsonObject);
            RespBase respBase = this.syjMainLogSaleBS.insertCash(session, vo, jsonObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }
}

