/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.dao.impl;

import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.dao.OperUserExpService;
import com.efuture.business.dao.impl.FunctionBaseServiceImpl;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.mapper.base.OperUserModelMapper;
import com.efuture.business.model.OperUserModel;
import com.efuture.business.util.HttpClientUtils;
import com.efuture.business.util.MD5Util;
import com.efuture.business.util.PwdUtils;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.ParamValidateUtil;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class OperUserExpServiceImpl
extends FunctionBaseServiceImpl<OperUserModelMapper, OperUserModel>
implements OperUserExpService {
    private static final Logger log = LoggerFactory.getLogger(OperUserExpServiceImpl.class);
    @Autowired
    private DbTools dbTools;
    @Value(value="${localcache.enabled}")
    private Boolean localcache;

    public boolean getOperRange(ServiceSession session, JSONObject paramsObject) {
        log.info("getOperRange" + paramsObject.toJSONString());
        if (StringUtils.isEmpty((Object)paramsObject.getString("mkt"))) {
            return false;
        }
        if (StringUtils.isEmpty((Object)paramsObject.getString("syjh"))) {
            return false;
        }
        if (StringUtils.isEmpty((Object)paramsObject.getString("erpCode"))) {
            return false;
        }
        if (StringUtils.isEmpty((Object)paramsObject.getString("syjcursyyh"))) {
            return false;
        }
        List list = this.getOperRangeByGH(paramsObject);
        log.info("getOperRangeByGH===list" + JSONObject.toJSONString((Object)list));
        for (int i = 0; i < list.size(); ++i) {
            Map map = (Map)list.get(i);
            if (!"Y".equals(map.get("operrange"))) continue;
            return true;
        }
        return false;
    }

    public List<Map> getOperRangeByGH(JSONObject paramsObject) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("gh", paramsObject.getString("syjcursyyh"));
        param.put("mkt", paramsObject.getString("mkt"));
        param.put("erpCode", paramsObject.getString("erpCode"));
        if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("shopCode") != null) {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("operuser", paramsObject.getString("shopCode")));
        } else {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("operuser"));
        }
        List list = ((OperUserModelMapper)this.baseMapper).getOperRangeByGH(param);
        return list;
    }

    public List<Map> getOperRangeByGhPwd(JSONObject paramsObject) {
        HashMap<String, String> param = new HashMap<String, String>();
        param.put("gh", paramsObject.getString("gh"));
        param.put("mkt", paramsObject.getString("shopCode"));
        param.put("erpCode", paramsObject.getString("erpCode"));
        if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("shopCode") != null) {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("operuser", paramsObject.getString("shopCode")));
        } else {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("operuser"));
        }
        List list = ((OperUserModelMapper)this.baseMapper).getOperRangeByGH(param);
        return list;
    }

    public RespBase checkPasswd(ServiceSession session, JSONObject paramsObject) {
        if (!Objects.equals(paramsObject.getString("newPassword"), paramsObject.getString("confirmPassword"))) {
            return Code.CODE_70023.getRespBase(new Object[0]);
        }
        if (Objects.equals(paramsObject.getString("oldPassword"), paramsObject.getString("confirmPassword"))) {
            return Code.CODE_70024.getRespBase(new Object[0]);
        }
        List operusers = new ArrayList();
        List list = this.getOperRangeByGhPwd(paramsObject);
        if (list == null || list.size() <= 0) {
            return Code.CODE_70025.getRespBase(new Object[0]);
        }
        JSONObject ob = new JSONObject();
        ob.put("gh", (Object)paramsObject.getString("gh"));
        ob.put("erpCode", paramsObject.get((Object)"erpCode"));
        ob.put("passwd", (Object)MD5Util.MD5((String)paramsObject.getString("oldPassword")));
        operusers = this.listByMap((Map)ob, "operuser");
        if (Objects.isNull(operusers) || operusers.isEmpty()) {
            return Code.CODE_70026.getRespBase(new Object[0]);
        }
        return Code.SUCCESS.getRespBase(new Object[0]);
    }

    public RespBase changePassword(ServiceSession session, JSONObject paramsObject) {
        boolean flag = true;
        ServiceResponse checkReponse = ParamValidateUtil.checkParam((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"gh", "oldPassword", "newPassword", "confirmPassword", "erpCode", "shopCode"});
        String newPwd = paramsObject.getString("newPassword");
        if (!PwdUtils.isValidPwd((String)newPwd)) {
            return Code.CODE_70036.getRespBase(new Object[0]);
        }
        if (!Objects.equals("0", checkReponse.getReturncode())) {
            return Code.CODE_70022.getRespBase(new Object[0]);
        }
        RespBase checkPasswdResponse = this.checkPasswd(session, paramsObject);
        log.info("changePassword  \u6821\u9a8c\u5bc6\u7801 " + JSONObject.toJSONString((Object)checkPasswdResponse));
        if (!Objects.equals("0", String.valueOf(checkPasswdResponse.getRetflag()))) {
            return checkPasswdResponse;
        }
        if (this.localcache.booleanValue()) {
            try {
                log.info("\u4fee\u6539\u5bc6\u7801\u8131\u673a\u8c03\u7ebf\u4e0a\u670d\u52a1!");
                String response = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)"UTF-8", (String)paramsObject.toJSONString(), (int)5000, (int)15000);
                log.info("\u4fee\u6539\u5bc6\u7801\u8131\u673a\u8c03\u7ebf\u4e0a\u670d\u52a1\u8fd4\u56de==>{}", JSONObject.toJSON((Object)response));
                if (org.apache.commons.lang.StringUtils.isNotBlank((String)response)) {
                    RespBase respBase = (RespBase)JSONObject.parseObject((String)response, RespBase.class);
                    JSONObject jsonResponse = JSONObject.parseObject((String)response);
                    int retFlag = jsonResponse.getInteger("returncode");
                    respBase.setRetflag(retFlag);
                    if (0 != retFlag) {
                        respBase.setRetmsg(jsonResponse.getString("data"));
                    } else {
                        respBase = this.changePassword2(session, paramsObject);
                        log.info("\u7ebf\u4e0a\u4fee\u6539\u5bc6\u7801\u6210\u529f!\u672c\u5730\u4fee\u6539\u5bc6\u7801==>{}", JSONObject.toJSON((Object)respBase));
                    }
                    return respBase;
                }
                log.info("\u7cfb\u7edf\u7ebf\u4e0a\u4fee\u6539\u5bc6\u7801\u63a5\u53e3\u8bbf\u95ee\u5931\u8d25==>{}", (Object)response);
            }
            catch (IOException e) {
                e.printStackTrace();
                log.info("\u4fee\u6539\u5bc6\u7801\u8fde\u63a5\u7ebf\u4e0a\u5f02\u5e38:", (Throwable)e);
            }
        }
        try {
            RespBase sr = this.changePassword2(session, paramsObject);
            log.info("changePassword  \u4fee\u6539\u5bc6\u7801 " + JSONObject.toJSONString((Object)sr));
            return sr;
        }
        catch (Exception e) {
            return Code.CODE_70027.getRespBase(new Object[]{e.getMessage()});
        }
    }

    public RespBase changePassword2(ServiceSession session, JSONObject paramsObject) {
        this.updatePwdByGh(paramsObject);
        return Code.SUCCESS.getRespBase(new Object[0]);
    }

    private void updatePwdByGh(JSONObject paramsObject) {
        log.info("updatePwdByGh===");
        JSONObject updateObjects = new JSONObject();
        updateObjects.put("gh", paramsObject.get((Object)"gh"));
        updateObjects.put("passwd", (Object)MD5Util.MD5((String)paramsObject.getString("newPassword")));
        updateObjects.put("pwddate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        updateObjects.put("updateDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        updateObjects.put("updateDate", (Object)new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
        updateObjects.put("erpCode", paramsObject.get((Object)"erpCode"));
        if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("shopCode") != null) {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("operuser", paramsObject.getString("shopCode")));
        } else {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("operuser"));
        }
        try {
            ((OperUserModelMapper)this.baseMapper).updateUserNameAndPasswd((Map)updateObjects);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        log.info("updateUserNameAndPasswd");
    }
}

