/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.dao.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.dao.OperUserExpService;
import com.efuture.business.dao.PosWorkLogService;
import com.efuture.business.dao.SyjMainLogService;
import com.efuture.business.dao.impl.FunctionBaseServiceImpl;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.mapper.base.SyjMainLogMapper;
import com.efuture.business.model.PosWorkLogModel;
import com.efuture.business.model.SyjMainLogModel;
import com.efuture.business.model.Syjmain;
import com.efuture.business.model.TemporaryPayModel;
import com.efuture.business.service.SyjMainExpService;
import com.efuture.business.service.SyjMainRemoteService;
import com.efuture.business.util.HttpClientUtils;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.UniqueID;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.Utils;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class SyjMainLogServiceImpl
extends FunctionBaseServiceImpl<SyjMainLogMapper, SyjMainLogModel>
implements SyjMainLogService {
    private static final Logger log = LoggerFactory.getLogger(SyjMainLogServiceImpl.class);
    @Autowired
    private DbTools dbTools;
    @Autowired
    SyjMainExpService syjMainServiceImpl;
    @Autowired
    OperUserExpService operUserServiceImpl;
    @Autowired
    private RedisUtil redisUtil;
    @Autowired
    PosWorkLogService posWorkLogService;
    @SoaAnnotation(value="/syjMainRemoteService.do")
    private SyjMainRemoteService syjmainRemoteService;
    @Value(value="${localcache.enabled}")
    private Boolean localcache;
    @Value(value="${hazelcast.enabled:false}")
    private Boolean hazelcast;

    public int saveEntity(SyjMainLogModel model) {
        if ("Y".equals(GlobalInfo.centrally) && model.getMkt() != null) {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("syjmainlog", model.getMkt()));
        } else {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("syjmainlog"));
        }
        return ((SyjMainLogMapper)this.baseMapper).insertSelective(model);
    }

    public int getPosClearCount(JSONObject jsonObject) {
        if ("Y".equals(GlobalInfo.centrally) && jsonObject.getString("mkt") != null) {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("syjmainlog", jsonObject.getString("mkt")));
        } else {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("syjmainlog"));
        }
        return ((SyjMainLogMapper)this.baseMapper).getPosClearCount(jsonObject);
    }

    public long getMaxPreCount(JSONObject paramsObject) {
        if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("mkt") != null) {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("syjmainlog", paramsObject.getString("mkt")));
        } else {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("syjmainlog"));
        }
        return ((SyjMainLogMapper)this.baseMapper).getMaxPreCount((Map)paramsObject);
    }

    public BigDecimal getTotalPreje(JSONObject jsonObject) {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("syjmainlog"));
        return ((SyjMainLogMapper)this.baseMapper).getTotalPreje(jsonObject);
    }

    public BigDecimal getTotalPay(JSONObject jsonObject) {
        MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("syjmainlog"));
        return ((SyjMainLogMapper)this.baseMapper).getTotalPay(jsonObject);
    }

    public List<Map> getPayTodayHistory(JSONObject paramsObject) {
        if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("mkt") != null) {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("syjmainlog", paramsObject.getString("mkt")));
        } else {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("syjmainlog"));
        }
        List list = new LinkedList<Map>();
        try {
            list = ((SyjMainLogMapper)this.baseMapper).getPayTodayHistory((Map)paramsObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List<Map> getPayTodayHistory2(JSONObject paramsObject) {
        if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("mkt") != null) {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("syjmainlog", paramsObject.getString("mkt")));
        } else {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("syjmainlog"));
        }
        List list = new LinkedList<Map>();
        try {
            list = ((SyjMainLogMapper)this.baseMapper).getPayTodayHistory2((Map)paramsObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List<Map> getPayTodayHistory3(JSONObject paramsObject) {
        if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("mkt") != null) {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("syjmainlog", paramsObject.getString("mkt")));
        } else {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("syjmainlog"));
        }
        List list = new LinkedList<Map>();
        try {
            list = ((SyjMainLogMapper)this.baseMapper).getPayTodayHistory3((Map)paramsObject);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public ServiceResponse getTemporaryPayLog(ServiceSession session, JSONObject paramsObject) throws Exception {
        List list;
        JSONObject object3;
        TemporaryPayModel tempPay = (TemporaryPayModel)JSONObject.parseObject((String)paramsObject.toJSONString(), TemporaryPayModel.class);
        Syjmain syjmain = new Syjmain();
        syjmain.setSyjh(tempPay.getSyjh());
        syjmain.setMkt(tempPay.getMkt());
        syjmain.setErpCode(tempPay.getErpCode());
        Syjmain syj = this.syjmainRemoteService.selectOneByMKTAndSYJ(syjmain);
        if (null == syj) {
            log.info("\u672a\u627e\u5230\u6b3e\u673a\u4fe1\u606f,\u65e0\u6cd5\u7f34\u6b3e:");
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u672a\u627e\u5230\u6b3e\u673a\u4fe1\u606f,\u8bf7\u68c0\u67e5\u8131\u673a\u6b3e\u673a\u914d\u7f6e\u5426\u5219\u65e0\u6cd5\u7f34\u6b3e");
        }
        String paravalue = "0";
        String obj = this.redisUtil.get(RedisKey.CACHEID + tempPay.getMkt() + tempPay.getSyjh());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        JSONArray array = new JSONArray();
        List sysParaList = modeDetailsVo.getSyspara();
        JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
        if (sysParaArray.size() != 0) {
            for (int i = 0; i < sysParaArray.size(); ++i) {
                JSONObject sys = sysParaArray.getJSONObject(i);
                if (!"RJZS".equals(sys.get((Object)"code"))) continue;
                array.add((Object)sys);
            }
        }
        if (array.size() != 0 && (object3 = array.getJSONObject(0)).containsKey((Object)"paravalue")) {
            paravalue = object3.getString("paravalue");
        }
        String clearTime = "";
        if (StringUtils.isNotBlank((String)tempPay.getClearTime())) {
            clearTime = String.valueOf(tempPay.getClearTime());
        } else {
            clearTime = this.syjMainServiceImpl.getClearTime(session, tempPay.getErpCode(), tempPay.getMkt(), tempPay.getSyjh());
            log.info("\u6e05\u673a\u65f6\u95f4==>clearTime={}", (Object)clearTime);
            tempPay.setClearTime(clearTime);
        }
        log.info("\u6e05\u673a\u65f6\u95f4====>{}", (Object)clearTime);
        String accountDate = this.syjMainServiceImpl.getOutLineTime();
        log.info("\u7f34\u6b3e\u65f6\u95f4{}", (Object)accountDate);
        if (this.localcache.booleanValue()) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            long startDay = 0L;
            long endDay = 0L;
            try {
                Date dateStart = format.parse(accountDate + " 00:00:00");
                Date dateEnd = format.parse(clearTime + " 23:59:59");
                log.info("dateStart" + dateStart.getTime());
                log.info("dateEnd" + dateEnd.getTime());
                startDay = dateStart.getTime();
                endDay = dateEnd.getTime();
                tempPay.setAccountDate(String.valueOf(startDay));
                tempPay.setClearTime(String.valueOf(endDay));
                log.info("\u8131\u673a\u6a21\u5f0f\u7f34\u6b3e\u65f6\u95f4\u5f00\u59cb{}", (Object)startDay);
                log.info("\u8131\u673a\u6a21\u5f0f\u7f34\u6b3e\u65f6\u95f4\u7ed3\u675f{}", (Object)endDay);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u83b7\u53d6\u7f34\u6b3e\u5217\u8868\u5f00\u59cb\u65f6\u95f4 \u5f02\u5e38");
            }
        } else {
            tempPay.setAccountDate(accountDate);
            tempPay.setClearTime(clearTime);
        }
        log.info("\u7f34\u6b3e\u5217\u8868\u67e5\u8be2\u53c2\u6570{}", (Object)JSON.toJSONString((Object)tempPay));
        log.info("paravalue=====>" + paravalue);
        if (paravalue.equals("1")) {
            boolean flag = this.operUserServiceImpl.getOperRange(session, JSON.parseObject((String)JSON.toJSONString((Object)tempPay)));
            log.info("\u6536\u94f6\u5458\u67e5\u770b\u6570\u636e\u6743\u9650" + flag);
            List list2 = !flag ? this.getPayTodayHistory(JSON.parseObject((String)JSON.toJSONString((Object)tempPay))) : this.getPayTodayHistory3(JSON.parseObject((String)JSON.toJSONString((Object)tempPay)));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("todayhistory", (Object)list2);
            return ServiceResponse.buildSuccess((Object)jsonObject);
        }
        if (paravalue.equals("0")) {
            log.info("\u6240\u6709\u6b3e\u673a");
            tempPay.setSyjh(null);
            list = this.getPayTodayHistory2(JSON.parseObject((String)JSON.toJSONString((Object)tempPay)));
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("todayhistory", (Object)list);
            return ServiceResponse.buildSuccess((Object)jsonObject);
        }
        log.info("\u6b3e\u673a\u4e0b\u6240\u6709\u6536\u94f6\u5458");
        list = this.getPayTodayHistory3(JSON.parseObject((String)JSON.toJSONString((Object)tempPay)));
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("todayhistory", (Object)list);
        return ServiceResponse.buildSuccess((Object)jsonObject);
    }

    public List<Map> getPreCashTodayHistory(JSONObject paramsObject) {
        if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("mkt") != null) {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("syjmainlog", paramsObject.getString("mkt")));
        } else {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("syjmainlog"));
        }
        List list = new LinkedList<Map>();
        try {
            list = ((SyjMainLogMapper)this.baseMapper).getPreCashTodayHistory((Map)paramsObject);
            log.info("===>getPreCashTodayHistory" + JSONObject.toJSONString(list));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List<Map> getPreCashTodayHistory2(JSONObject paramsObject) {
        if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("mkt") != null) {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("syjmainlog", paramsObject.getString("mkt")));
        } else {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("syjmainlog"));
        }
        log.info("===>getPreCashTodayHistory2");
        List list = new LinkedList<Map>();
        try {
            list = ((SyjMainLogMapper)this.baseMapper).getPreCashTodayHistory2((Map)paramsObject);
            log.info("===>getPreCashTodayHistory" + JSONObject.toJSONString(list));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public List<Map> getPreCashTodayHistory3(JSONObject paramsObject) {
        if ("Y".equals(GlobalInfo.centrally) && paramsObject.getString("mkt") != null) {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("syjmainlog", paramsObject.getString("mkt")));
        } else {
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("syjmainlog"));
        }
        log.info("===>getPreCashTodayHistory3");
        List list = new LinkedList<Map>();
        try {
            list = ((SyjMainLogMapper)this.baseMapper).getPreCashTodayHistory3((Map)paramsObject);
            log.info("===>getPreCashTodayHistory" + JSONObject.toJSONString(list));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return list;
    }

    public ServiceResponse getInsertCashLog(ServiceSession session, JSONObject paramsObject) throws Exception {
        List list;
        JSONObject object3;
        log.info("getInsertCashLog");
        String paravalue = "1";
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.get((Object)"mkt") + paramsObject.get((Object)"syjh"));
        if (null == obj) {
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"-1", (String)"\u6536\u94f6\u673a\u7f13\u5b58\u4e3a\u7a7a");
        }
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        JSONArray array = new JSONArray();
        List sysParaList = modeDetailsVo.getSyspara();
        JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
        if (sysParaArray.size() != 0) {
            for (int i = 0; i < sysParaArray.size(); ++i) {
                JSONObject sys = sysParaArray.getJSONObject(i);
                if (!sys.get((Object)"code").equals("RJZS")) continue;
                array.add((Object)sys);
            }
        }
        if (array.size() != 0 && (object3 = array.getJSONObject(0)).containsKey((Object)"paravalue")) {
            paravalue = object3.getString("paravalue");
        }
        String clearTime = this.syjMainServiceImpl.getClearTime(session, paramsObject.getString("erpCode"), paramsObject.getString("mkt"), paramsObject.getString("syjh"));
        if (!paramsObject.containsKey((Object)"clearTime")) {
            paramsObject.put("clearTime", (Object)clearTime);
        }
        String accountDate = this.syjMainServiceImpl.getOutLineTime();
        paramsObject.put("accountDate", (Object)accountDate);
        if (this.localcache.booleanValue()) {
            SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
            int startDay = 0;
            boolean endDay = false;
            try {
                Date dateStart = format.parse(accountDate);
                startDay = (int)dateStart.getTime();
                paramsObject.put("accountDate", (Object)startDay);
            }
            catch (Exception e) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u83b7\u53d6\u7f34\u6b3e\u5217\u8868\u5f00\u59cb\u65f6\u95f4 \u5f02\u5e38");
            }
        }
        if (paravalue.equals("1")) {
            boolean flag = this.operUserServiceImpl.getOperRange(session, paramsObject);
            log.info("\u6536\u94f6\u5458\u67e5\u770b\u6570\u636e\u6743\u9650" + flag);
            List list2 = !flag ? this.getPreCashTodayHistory(paramsObject) : this.getPreCashTodayHistory3(paramsObject);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("todayhistory", (Object)list2);
            return ServiceResponse.buildSuccess((Object)jsonObject);
        }
        if (paravalue.equals("0")) {
            paramsObject.remove((Object)"syjh");
            list = this.getPreCashTodayHistory2(paramsObject);
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("todayhistory", (Object)list);
            return ServiceResponse.buildSuccess((Object)jsonObject);
        }
        list = this.getPreCashTodayHistory3(paramsObject);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("todayhistory", (Object)list);
        return ServiceResponse.buildSuccess((Object)jsonObject);
    }

    public RespBase insertCash(ServiceSession session, JSONObject paramsObject) {
        JSONObject requstParam = (JSONObject)paramsObject.clone();
        try {
            Date startTime = new Date();
            paramsObject.put("startTime", (Object)startTime);
            String clearTime = this.syjMainServiceImpl.getClearTime(session, paramsObject.getString("erpCode"), paramsObject.getString("mkt"), paramsObject.getString("syjh"));
            String accountDate = this.syjMainServiceImpl.getOutLineTime();
            if (paramsObject.containsKey((Object)"clearTime")) {
                clearTime = paramsObject.getString("clearTime");
            }
            log.info("accountDate:", (Object)accountDate);
            paramsObject.put("accountDate", (Object)accountDate);
            BigDecimal cashIn = paramsObject.getBigDecimal("syjcurpreje");
            log.info("\u5165\u91d1\u91d1\u989d\uff1a" + cashIn);
            String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.get((Object)"mkt") + paramsObject.get((Object)"syjh"));
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            JSONArray array = new JSONArray();
            List sysParaList = modeDetailsVo.getSyspara();
            JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
            if (sysParaArray.size() != 0) {
                for (int i = 0; i < sysParaArray.size(); ++i) {
                    JSONObject sys = sysParaArray.getJSONObject(i);
                    if (!sys.get((Object)"code").equals("4C")) continue;
                    array.add((Object)sys);
                }
            }
            Syjmain syjmain = modeDetailsVo.getSyjmain();
            String syjcursyyh = "";
            JSONObject b = new JSONObject();
            b.put("erpCode", paramsObject.get((Object)"erpCode"));
            b.put("mkt", paramsObject.get((Object)"mkt"));
            b.put("syjh", paramsObject.get((Object)"syjh"));
            if (paramsObject.containsKey((Object)"syjcursyyh")) {
                syjcursyyh = paramsObject.getString("syjcursyyh");
                b.put("syjcursyyh", (Object)syjcursyyh);
            } else {
                syjcursyyh = syjmain.getSyjcursyyh();
                b.put("syjcursyyh", (Object)syjcursyyh);
            }
            paramsObject.put("syjcursyyh", (Object)syjcursyyh);
            if (paramsObject.containsKey((Object)"erpCode")) {
                syjmain.setErpCode(paramsObject.getString("erpCode"));
            }
            if (paramsObject.containsKey((Object)"mkt")) {
                syjmain.setMkt(paramsObject.getString("mkt"));
            }
            if (paramsObject.containsKey((Object)"syjh")) {
                syjmain.setSyjh(paramsObject.getString("syjh"));
            }
            syjmain.setSyjcursyyh(syjcursyyh);
            Syjmain syjObj = this.syjmainRemoteService.selectOneByMKTAndSYJ(syjmain);
            BigDecimal oldpreje = syjObj.getSyjcurpreje();
            BigDecimal je = syjObj.getSyjcurcashje();
            log.info("\u5f53\u524d\u6b3e\u673a\u73b0\u91d1\u5b58\u91cf\uff1a" + je);
            BigDecimal newpreje = cashIn.add(oldpreje);
            b.put("clearTime", (Object)clearTime);
            long insertprecashcount = this.getMaxPreCount(b);
            paramsObject.put("insertprecashcount", (Object)(insertprecashcount + 1L));
            paramsObject.put("syjcurpreje", (Object)newpreje);
            paramsObject.put("cashje", (Object)je.add(cashIn));
            paramsObject.put("cashlog_status", (Object)"4");
            if (array.size() == 0) {
                ServiceResponse re = this.doUpdates(session, paramsObject);
                JSONObject redata = (JSONObject)re.getData();
                long ph_key = Long.valueOf(redata.get((Object)"ph_key").toString());
                log.info("\u67e5\u8be2\u5f53\u65e5\u5165\u91d1\u53c2\u6570\uff1a" + b);
                ServiceResponse response = this.getInsertCashLog(session, b);
                JSONObject json = (JSONObject)response.getData();
                JSONArray array3 = json.getJSONArray("todayhistory");
                BigDecimal totalpreje = new BigDecimal(0.0);
                for (int i = 0; i < array3.size(); ++i) {
                    BigDecimal curpreje = array3.getJSONObject(i).getBigDecimal("syjcurpreje");
                    totalpreje = totalpreje.add(curpreje);
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("ph_key", (Object)ph_key);
                jsonObject.put("insertprecashcount", paramsObject.get((Object)"insertprecashcount"));
                jsonObject.put("totalinsertcash", (Object)totalpreje);
                jsonObject.put("todayhistory", (Object)array3);
                jsonObject.put("requstParam", (Object)requstParam);
                jsonObject.put("clearTime", (Object)clearTime);
                log.info("\u5165\u94f6\u5934--->\u8bb0\u8d26\u65e5\u671faccountDate\uff1a" + accountDate);
                return new RespBase(Code.SUCCESS, (Object)jsonObject, "PREMONEYCERTIFY");
            }
            BigDecimal paravalue = new BigDecimal(0.0);
            for (int j = 0; j < array.size(); ++j) {
                JSONObject map2 = array.getJSONObject(j);
                log.info("map2===" + map2.toJSONString());
                if (!map2.containsKey((Object)"paravalue")) {
                    ServiceResponse re = this.doUpdates(session, paramsObject);
                    JSONObject redata = (JSONObject)re.getData();
                    long ph_key = Long.valueOf(redata.get((Object)"ph_key").toString());
                    log.info("\u67e5\u8be2\u5f53\u65e5\u5165\u91d1\u53c2\u6570\uff1a" + b);
                    ServiceResponse response = this.getInsertCashLog(session, b);
                    JSONObject json = (JSONObject)response.getData();
                    JSONArray array3 = json.getJSONArray("todayhistory");
                    BigDecimal totalpreje = new BigDecimal(0.0);
                    for (int i = 0; i < array3.size(); ++i) {
                        BigDecimal curpreje = array3.getJSONObject(i).getBigDecimal("syjcurpreje");
                        totalpreje = totalpreje.add(curpreje);
                    }
                    JSONObject jsonObject = new JSONObject();
                    jsonObject.put("ph_key", (Object)ph_key);
                    jsonObject.put("insertprecashcount", paramsObject.get((Object)"insertprecashcount"));
                    jsonObject.put("totalinsertcash", (Object)totalpreje);
                    jsonObject.put("todayhistory", (Object)array3);
                    jsonObject.put("requstParam", (Object)requstParam);
                    jsonObject.put("clearTime", (Object)clearTime);
                    log.info("\u5165\u94f6\u5934--->\u8bb0\u8d26\u65e5\u671faccountDate\uff1a" + accountDate);
                    return new RespBase(Code.SUCCESS, (Object)jsonObject, "PREMONEYCERTIFY");
                }
                if (!map2.getBigDecimal("paravalue").equals(null)) {
                    paravalue = map2.getBigDecimal("paravalue");
                }
                log.info("\u53c2\u6570\u8bbe\u7f6e\u6536\u94f6\u53f0\u6700\u9ad8\u73b0\u91d1\u5b58\u91cf(\u5143):" + paravalue);
                if (paravalue.compareTo(BigDecimal.ZERO) != 0) continue;
                ServiceResponse re = this.doUpdates(session, paramsObject);
                JSONObject redata = (JSONObject)re.getData();
                long ph_key = Long.valueOf(redata.get((Object)"ph_key").toString());
                log.info("\u67e5\u8be2\u5f53\u65e5\u5165\u91d1\u53c2\u6570\uff1a" + b);
                ServiceResponse response = this.getInsertCashLog(session, b);
                JSONObject json = (JSONObject)response.getData();
                JSONArray array3 = json.getJSONArray("todayhistory");
                BigDecimal totalpreje = new BigDecimal(0.0);
                for (int i = 0; i < array3.size(); ++i) {
                    BigDecimal curpreje = array3.getJSONObject(i).getBigDecimal("syjcurpreje");
                    totalpreje = totalpreje.add(curpreje);
                }
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("ph_key", (Object)ph_key);
                jsonObject.put("insertprecashcount", paramsObject.get((Object)"insertprecashcount"));
                jsonObject.put("totalinsertcash", (Object)totalpreje);
                jsonObject.put("todayhistory", (Object)array3);
                jsonObject.put("requstParam", (Object)requstParam);
                jsonObject.put("clearTime", (Object)clearTime);
                log.info("\u5165\u94f6\u5934--->\u8bb0\u8d26\u65e5\u671faccountDate\uff1a" + accountDate);
                return new RespBase(Code.SUCCESS, (Object)jsonObject, "PREMONEYCERTIFY");
            }
            ServiceResponse re = this.doUpdates(session, paramsObject);
            JSONObject redata = (JSONObject)re.getData();
            long ph_key = Long.valueOf(redata.get((Object)"ph_key").toString());
            log.info("\u67e5\u8be2\u5f53\u65e5\u5165\u91d1\u53c2\u6570\uff1a" + b);
            ServiceResponse response = this.getInsertCashLog(session, b);
            JSONObject json = (JSONObject)response.getData();
            JSONArray array3 = json.getJSONArray("todayhistory");
            BigDecimal totalpreje = new BigDecimal(0.0);
            for (int i = 0; i < array3.size(); ++i) {
                BigDecimal curpreje = array3.getJSONObject(i).getBigDecimal("syjcurpreje");
                totalpreje = totalpreje.add(curpreje);
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("ph_key", (Object)ph_key);
            jsonObject.put("insertprecashcount", paramsObject.get((Object)"insertprecashcount"));
            jsonObject.put("totalinsertcash", (Object)totalpreje);
            jsonObject.put("clearTime", (Object)clearTime);
            jsonObject.put("todayhistory", (Object)array3);
            jsonObject.put("requstParam", (Object)requstParam);
            log.info("\u5165\u94f6\u5934--->\u8bb0\u8d26\u65e5\u671faccountDate\uff1a" + accountDate);
            return new RespBase(Code.SUCCESS, (Object)jsonObject, "PREMONEYCERTIFY");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info(e.toString());
            return Code.CODE_70020.getRespBase(new Object[]{Utils.getLastExceptionMessage((Exception)e)});
        }
    }

    public ServiceResponse doUpdates(ServiceSession session, JSONObject paramsObject) throws Exception {
        log.info("doUpdates==" + JSONObject.toJSONString((Object)paramsObject));
        String netType = "0";
        if (this.hazelcast.booleanValue() || this.localcache.booleanValue()) {
            netType = "1";
        }
        Syjmain syjmain = new Syjmain();
        if (paramsObject.containsKey((Object)"mkt")) {
            syjmain.setMkt(paramsObject.getString("mkt"));
        }
        if (paramsObject.containsKey((Object)"syjh")) {
            syjmain.setSyjh(paramsObject.getString("syjh"));
        }
        if (paramsObject.containsKey((Object)"erpCode")) {
            syjmain.setErpCode(paramsObject.getString("erpCode"));
        }
        if (paramsObject.containsKey((Object)"syjcurinvje")) {
            syjmain.setSyjcurinvje(paramsObject.getBigDecimal("syjcurinvje"));
        }
        if (paramsObject.containsKey((Object)"cashje")) {
            syjmain.setSyjcurcashje(paramsObject.getBigDecimal("cashje"));
        }
        if (paramsObject.containsKey((Object)"syjcurpreje")) {
            syjmain.setSyjcurpreje(paramsObject.getBigDecimal("syjcurpreje"));
        }
        if (paramsObject.containsKey((Object)"syjcurinvbs")) {
            syjmain.setSyjcurinvbs(paramsObject.getLong("syjcurinvbs"));
        }
        if (paramsObject.containsKey((Object)"syjcurnum")) {
            syjmain.setSyjcurnum(paramsObject.getLong("syjcurnum"));
        }
        if (paramsObject.containsKey((Object)"syjcurstatus")) {
            syjmain.setSyjcurstatus(paramsObject.getString("syjcurstatus"));
        }
        if (paramsObject.containsKey((Object)"syjcursyyh")) {
            syjmain.setSyjcursyyh(paramsObject.getString("syjcursyyh"));
        }
        syjmain.setInsertprecashcount(Long.valueOf(1L));
        paramsObject.put("syjcurtime", (Object)new Date());
        boolean flag = this.syjmainRemoteService.updateByMKTAndSYJH(syjmain);
        if (flag) {
            String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.get((Object)"mkt") + paramsObject.get((Object)"syjh"));
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            Syjmain syjMainData = modeDetailsVo.getSyjmain();
            String syjcursyyh = "";
            syjcursyyh = paramsObject.containsKey((Object)"syjcursyyh") ? paramsObject.getString("syjcursyyh") : syjMainData.getSyjcursyyh();
            JSONObject ob = new JSONObject();
            ob.put("mkt", paramsObject.get((Object)"mkt"));
            ob.put("erpCode", paramsObject.get((Object)"erpCode"));
            ob.put("syjh", paramsObject.get((Object)"syjh"));
            ob.put("syjcursyyh", (Object)syjcursyyh);
            ob.put("syjopentime", (Object)syjMainData.getSyjopentime());
            ob.put("syjcleartime", (Object)syjMainData.getSyjcleartime());
            ob.put("syjcurstatus", (Object)syjMainData.getSyjcurstatus());
            ob.put("syjcurtime", paramsObject.get((Object)"syjcurtime"));
            ob.put("syjcurinvbs", (Object)syjMainData.getSyjcurinvbs());
            ob.put("syjcurinvje", (Object)syjMainData.getSyjcurinvje());
            ob.put("syjcurcashje", paramsObject.get((Object)"cashje"));
            ob.put("syjcurnum", (Object)syjMainData.getSyjcurnum());
            ob.put("authsyyh", (Object)paramsObject.getString("authsyyh"));
            ob.put("status", paramsObject.get((Object)"cashlog_status"));
            ob.put("accountDate", paramsObject.get((Object)"accountDate"));
            ob.put("syjcurpreje", paramsObject.get((Object)"syjcurpreje"));
            ob.put("insertprecashcount", (Object)syjMainData.getInsertprecashcount());
            JSONObject worklog = new JSONObject();
            worklog.put("erpCode", paramsObject.get((Object)"erpCode"));
            worklog.put("mkt", paramsObject.get((Object)"mkt"));
            worklog.put("syjh", paramsObject.get((Object)"syjh"));
            worklog.put("syyh", (Object)syjcursyyh);
            worklog.put("rqsj", (Object)new Date());
            worklog.put("logtype", (Object)"2");
            worklog.put("logdesc", (Object)"\u5f55\u5165\u5907\u7528\u91d1");
            worklog.put("updateDate", (Object)new Date());
            if (paramsObject.containsKey((Object)"ph_key1")) {
                ob.put("ph_key", paramsObject.get((Object)"ph_key1"));
                worklog.put("ph_key", paramsObject.get((Object)"ph_key1"));
            } else {
                long ph_key1 = UniqueID.getUniqueID();
                ob.put("ph_key", (Object)ph_key1);
                worklog.put("ph_key", (Object)ph_key1);
            }
            SyjMainLogModel syjMainLogModel = (SyjMainLogModel)JSONObject.parseObject((String)ob.toJSONString(), SyjMainLogModel.class);
            this.saveEntity(syjMainLogModel);
            PosWorkLogModel posWorkLogModel = (PosWorkLogModel)JSONObject.parseObject((String)worklog.toJSONString(), PosWorkLogModel.class);
            long ph_key = syjMainLogModel.getPh_key();
            JSONObject data = new JSONObject();
            data.put("syjcurstatus", (Object)syjMainData.getSyjcurstatus());
            data.put("netType", (Object)netType);
            data.put("ph_key", (Object)ph_key);
            Date startTime = paramsObject.getDate("startTime");
            Date endTime = new Date();
            log.info("\u66f4\u65b0\u6536\u94f6\u673a\u72b6\u6001netType:" + netType);
            log.error("{\u66f4\u65b0\u6536\u94f6\u673a\u72b6\u6001\u65f6\u95f4} -->" + (endTime.getTime() - startTime.getTime()));
            return ServiceResponse.buildSuccess((Object)data);
        }
        log.info("\u66f4\u65b0\u6536\u94f6\u673a\u72b6\u6001netType:" + netType);
        return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u6ca1\u6709\u6b64\u6536\u94f6\u673a\u6570\u636e\uff0c\u66f4\u65b0\u5931\u8d25");
    }

    private RespBase synchronizPayData(String commandId, JSONObject param) {
        try {
            param.put("command_id", (Object)commandId);
            String res = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)param.toString());
            if (null != res && !"".equals(res)) {
                RespBase resp = (RespBase)JSONObject.parseObject((String)res, RespBase.class);
                return resp.setCommand_id(commandId);
            }
            log.info("\u540c\u6b65\u7ebf\u4e0a\u6570\u636e\u5931\u8d25!");
            return new RespBase(-1, "\u540c\u6b65\u7ebf\u4e0a\u6570\u636e\u5931\u8d25!");
        }
        catch (Exception e) {
            log.info("\u540c\u6b65\u7ebf\u4e0a\u6570\u636e\u53d1\u751f\u5f02\u5e38: " + e.toString());
            return new RespBase(-1, "\u540c\u6b65\u7ebf\u4e0a\u6570\u636e\u53d1\u751f\u5f02\u5e38!" + e.toString());
        }
    }
}

