/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.remote;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.annotation.HessianService;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.dao.PosWorkLogService;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.model.PosOperLogModel;
import com.efuture.business.model.PosWorkLogModel;
import com.efuture.business.service.PosWorkLogRemoteService;
import com.efuture.business.service.PosWorkLogSaleBS;
import com.efuture.business.util.ArrayUtils;
import com.efuture.business.util.HttpClientUtils;
import com.efuture.business.util.ThreadContextUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HessianService(value="/apiPosWorkLogRemoteService.do", interf=PosWorkLogRemoteService.class)
@Service
public class PosWorkLogRemoteServiceImpl
implements PosWorkLogRemoteService {
    private static final Logger log = LoggerFactory.getLogger(PosWorkLogRemoteServiceImpl.class);
    @Autowired
    private PosWorkLogSaleBS posWorkLogSaleBS;
    @Autowired
    private PosWorkLogService posWorkLogService;
    @Autowired
    private ThreadContextUtils threadContextUtils;

    public boolean onInsert(JSONObject param) {
        try {
            this.threadContextUtils.setLogFlag(param);
            boolean bl = this.posWorkLogSaleBS.onInsert(param);
            return bl;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public Map<String, Object> queryByUpdateDate(JSONObject param) {
        try {
            this.threadContextUtils.setLogFlag(param);
            Map map = this.posWorkLogSaleBS.queryByUpdateDate(param);
            return map;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public RespBase uploadData(JSONObject param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((String)param.getString("syyh"))) {
            queryWrapper.eq((Object)"syjh", (Object)param.getString("syyh"));
        }
        if (StringUtils.isNotBlank((String)param.getString("mkt"))) {
            queryWrapper.eq((Object)"mkt", (Object)param.getString("mkt"));
        }
        if (StringUtils.isNotBlank((String)param.getString("erpCode"))) {
            queryWrapper.eq((Object)"erpCode", (Object)param.getString("erpCode"));
        }
        if (StringUtils.isNotBlank((String)param.getString("beginTime"))) {
            queryWrapper.ge((Object)"updateDate", (Object)param.getString("beginTime"));
        }
        if (StringUtils.isNotBlank((String)param.getString("endTime"))) {
            queryWrapper.le((Object)"updateDate", (Object)param.getString("endTime"));
        }
        if (StringUtils.isNotBlank((String)param.getString("synstatus"))) {
            queryWrapper.isNull((Object)"synstatus");
        }
        List list = this.posWorkLogService.list((Wrapper)queryWrapper, "posworklog");
        log.info("\u67e5\u8be2\u5230posworklog\u65e5\u5fd7\u4e3a{}\u6761", (Object)list.size());
        if (ArrayUtils.isNotEmpty((List)list)) {
            try {
                log.info("\u4e0a\u4f20\u672c\u5730posworklog\u65e5\u5fd7!");
                JSONObject request = new JSONObject();
                request.put("list", (Object)list);
                request.put("command_id", (Object)"UPLOADPOSWORKLOG");
                String response = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)"UTF-8", (String)JSONObject.toJSONString((Object)request), (int)5000, (int)15000);
                log.info("\u4e0a\u4f20\u672c\u5730posworklog\u65e5\u5fd7\u8fd4\u56de==>{}", (Object)response);
                if (StringUtils.isNotBlank((String)response)) {
                    RespBase respBase = (RespBase)JSONObject.parseObject((String)response, RespBase.class);
                    JSONObject jsonResponse = JSONObject.parseObject((String)response);
                    int retFlag = jsonResponse.getInteger("returncode");
                    respBase.setRetflag(retFlag);
                    if (0 != retFlag) {
                        respBase.setRetmsg(jsonResponse.getString("data"));
                        return respBase;
                    }
                }
                ArrayList<Long> ids = new ArrayList<Long>();
                for (int i = 0; i < list.size(); ++i) {
                    ids.add(((PosWorkLogModel)list.get(i)).getPh_key());
                }
                boolean b = this.posWorkLogService.remove((Wrapper)queryWrapper);
                if (b) {
                    log.info("\u672c\u5730posworklog\u65e5\u5fd7\u5220\u9664\u6210\u529f{}\u6761,begin:{},end{}", new Object[]{list.size(), param.getString("beginTime"), param.getString("endTime")});
                } else {
                    log.info("\u672c\u5730posworklog\u65e5\u5fd7\u5220\u9664\u5931\u8d25");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.info("\u7cfb\u7edf\u521d\u59cb\u5316\u8fde\u63a5\u7ebf\u4e0a\u5f02\u5e38:", (Throwable)e);
                return Code.FAIL.getRespBase(new Object[0]);
            }
        }
        return new RespBase(Code.SUCCESS, "");
    }

    public boolean saveBatch(JSONObject param) {
        JSONArray jsonList = param.getJSONArray("list");
        List list = JSONArray.parseArray((String)jsonList.toJSONString(), PosWorkLogModel.class);
        boolean b = this.posWorkLogService.saveBatch((Collection)list, "posworklog");
        if (b) {
            log.info("\u4e0a\u4f20\u6210\u529f!");
        } else {
            log.info("\u4e0a\u4f20\u5931\u8d25!");
        }
        return b;
    }

    public Boolean savePosOperLog(PosOperLogModel posOperLogModel) {
        return this.posWorkLogSaleBS.savePosOperLog(posOperLogModel);
    }
}

