/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.remote;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.annotation.HessianService;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.dao.SyjMainLogService;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.model.SyjMainLogModel;
import com.efuture.business.model.Syjmain;
import com.efuture.business.service.SyjMainLogRemoteService;
import com.efuture.business.service.SyjMainLogSaleBS;
import com.efuture.business.service.SyjMainRemoteService;
import com.efuture.business.util.ArrayUtils;
import com.efuture.business.util.HttpClientUtils;
import com.efuture.business.util.ThreadContextUtils;
import com.product.model.ServiceSession;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@HessianService(value="/apiSyjMainLogRemoteService.do", interf=SyjMainLogRemoteService.class)
@Service
public class SyjMainLogRemoteServiceImpl
implements SyjMainLogRemoteService {
    private static final Logger log = LoggerFactory.getLogger(SyjMainLogRemoteServiceImpl.class);
    @Autowired
    private SyjMainLogSaleBS syjMainLogSaleBS;
    @Autowired
    private SyjMainLogService syjMainLogService;
    @Autowired
    private ThreadContextUtils threadContextUtils;
    @SoaAnnotation(value="/syjMainRemoteService.do")
    private SyjMainRemoteService syjMainRemoteService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getMaxPreCount(JSONObject jsonObject) {
        try {
            this.threadContextUtils.setLogFlag(jsonObject);
            long l = this.syjMainLogSaleBS.getMaxPreCount(jsonObject);
            return l;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public int saveEntity(JSONObject jsonObject) {
        try {
            this.threadContextUtils.setLogFlag(jsonObject);
            int n = this.syjMainLogSaleBS.saveEntity(jsonObject);
            return n;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public String getCashList(JSONObject param) {
        try {
            this.threadContextUtils.setLogFlag(param);
            String string = this.syjMainLogSaleBS.getCashList(param);
            return string;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public BigDecimal getTotalPreje(JSONObject jsonObject) {
        try {
            this.threadContextUtils.setLogFlag(jsonObject);
            BigDecimal bigDecimal = this.syjMainLogSaleBS.getTotalPreje(jsonObject);
            return bigDecimal;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public BigDecimal getTotalPay(JSONObject jsonObject) {
        try {
            this.threadContextUtils.setLogFlag(jsonObject);
            BigDecimal bigDecimal = this.syjMainLogSaleBS.getTotalPay(jsonObject);
            return bigDecimal;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase getTemporaryPayLog(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        try {
            this.threadContextUtils.setLogFlag(jsonObject);
            RespBase respBase = this.syjMainLogSaleBS.getTemporaryPayLog(session, vo, jsonObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase getInsertCashLog(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        try {
            this.threadContextUtils.setLogFlag(jsonObject);
            RespBase respBase = this.syjMainLogSaleBS.getInsertCashLog(session, vo, jsonObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase insertCash(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        try {
            this.threadContextUtils.setLogFlag(jsonObject);
            RespBase respBase = this.syjMainLogSaleBS.insertCash(session, vo, jsonObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public RespBase uploadData(JSONObject param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((String)param.getString("syyh"))) {
            queryWrapper.eq((Object)"syjh", (Object)param.getString("syyh"));
        }
        if (StringUtils.isNotBlank((String)param.getString("mkt"))) {
            queryWrapper.eq((Object)"mkt", (Object)param.getString("mkt"));
        }
        if (StringUtils.isNotBlank((String)param.getString("erpCode"))) {
            queryWrapper.eq((Object)"erpCode", (Object)param.getString("erpCode"));
        }
        if (StringUtils.isNotBlank((String)param.getString("beginTime"))) {
            queryWrapper.ge((Object)"updateDate", (Object)param.getString("beginTime"));
        }
        if (StringUtils.isNotBlank((String)param.getString("endTime"))) {
            queryWrapper.le((Object)"updateDate", (Object)param.getString("endTime"));
        }
        if (StringUtils.isNotBlank((String)param.getString("synstatus"))) {
            queryWrapper.isNull((Object)"synstatus");
        }
        List list = this.syjMainLogService.list((Wrapper)queryWrapper, "syjmainlog");
        log.info("\u67e5\u8be2\u5230syjmainlog\u65e5\u5fd7\u4e3a{}\u6761:{}", (Object)list.size(), (Object)JSONArray.toJSONString((Object)list));
        if (ArrayUtils.isNotEmpty((List)list)) {
            try {
                log.info("\u4e0a\u4f20\u672c\u5730syjmainlog\u65e5\u5fd7!");
                JSONObject request = new JSONObject();
                request.put("list", (Object)list);
                request.put("command_id", (Object)"UPLOADSYJMAINLOG");
                String response = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)"UTF-8", (String)JSONObject.toJSONString((Object)request), (int)5000, (int)15000);
                log.info("\u4e0a\u4f20\u672c\u5730syjmainlog\u65e5\u5fd7\u8fd4\u56de==>{}", (Object)response);
                if (StringUtils.isNotBlank((String)response)) {
                    RespBase respBase = (RespBase)JSONObject.parseObject((String)response, RespBase.class);
                    JSONObject jsonResponse = JSONObject.parseObject((String)response);
                    int retFlag = jsonResponse.getInteger("returncode");
                    respBase.setRetflag(retFlag);
                    if (0 != retFlag) {
                        respBase.setRetmsg(jsonResponse.getString("data"));
                        return respBase;
                    }
                }
                SyjMainLogModel syjMainLogModel = new SyjMainLogModel();
                syjMainLogModel.setSynstatus("0");
                boolean b = this.syjMainLogService.update((Object)syjMainLogModel, (Wrapper)queryWrapper);
                if (b) {
                    log.info("\u672c\u5730syjmainlog\u65e5\u5fd7\u79fb\u9664\u6210\u529f{}\u6761,begin:{},end{}", new Object[]{list.size(), param.getString("beginTime"), param.getString("endTime")});
                } else {
                    log.info("\u672c\u5730syjmainlog\u65e5\u5fd7\u79fb\u9664\u5931\u8d25");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.info("\u7cfb\u7edf\u521d\u59cb\u5316\u8fde\u63a5\u7ebf\u4e0a\u5f02\u5e38:", (Throwable)e);
                return Code.FAIL.getRespBase(new Object[0]);
            }
        }
        return new RespBase(Code.SUCCESS, (Object)new ResqVo());
    }

    @Transactional(rollbackFor={Exception.class})
    public boolean saveBatch(JSONObject param) {
        JSONArray jsonList = param.getJSONArray("list");
        List list = JSONArray.parseArray((String)jsonList.toJSONString(), SyjMainLogModel.class);
        if (ArrayUtils.isNotEmpty((List)list)) {
            boolean b = this.syjMainLogService.saveBatch((Collection)list, "syjmainlog");
            SyjMainLogModel syjMainLogModel = (SyjMainLogModel)ArrayUtils.getFirstOne((List)list);
            if (b) {
                log.info("\u4e0a\u4f20\u6210\u529f!{}\u6761\u8bb0\u5f55", (Object)jsonList.size());
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"erpCode", (Object)syjMainLogModel.getErpCode());
                queryWrapper.eq((Object)"mkt", (Object)syjMainLogModel.getMkt());
                queryWrapper.eq((Object)"syjh", (Object)syjMainLogModel.getSyjh());
                queryWrapper.orderByDesc((Object)"syjcurtime");
                List listAll = this.syjMainLogService.list((Wrapper)queryWrapper);
                Syjmain queryData = new Syjmain();
                queryData.setErpCode(syjMainLogModel.getErpCode());
                queryData.setSyjh(syjMainLogModel.getSyjh());
                queryData.setMkt(syjMainLogModel.getMkt());
                Syjmain syjmain = this.syjMainRemoteService.selectOneByMKTAndSYJ(queryData);
                if (listAll.size() > 0) {
                    SyjMainLogModel syjMainLogModelNew = (SyjMainLogModel)ArrayUtils.getFirstOne((List)listAll);
                    if (null != syjMainLogModelNew.getSyjcurpreje()) {
                        syjmain.setSyjcurpreje(syjMainLogModelNew.getSyjcurpreje());
                    }
                    if (null != syjMainLogModelNew.getSyjcurcashje()) {
                        syjmain.setSyjcurcashje(syjMainLogModelNew.getSyjcurcashje());
                    }
                } else {
                    syjmain.setSyjcurpreje(new BigDecimal(0));
                    syjmain.setSyjcurcashje(new BigDecimal(0));
                }
                log.info(">>>>>>>>syjmain:{}", (Object)JSONObject.toJSONString((Object)syjmain));
                boolean bool = this.syjMainRemoteService.updateByMKTAndSYJH(syjmain);
                if (bool) {
                    log.info("syjmain\u5907\u7528\u91d1\u66f4\u65b0\u6210\u529f!");
                } else {
                    log.info("syjmain\u5907\u7528\u91d1\u6ca1\u6709\u66f4\u65b0!");
                }
            } else {
                log.info("\u4e0a\u4f20\u5931\u8d25!");
            }
            return b;
        }
        log.info("\u65e0\u6570\u636e\u4e0a\u4f20!");
        return true;
    }
}

