/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.efuture.business.bean.CheckDetailPageVO;
import com.efuture.business.bean.CheckDetailVO;
import com.efuture.business.bean.CheckHeadPageVO;
import com.efuture.business.bean.CheckPlanModelPageVO;
import com.efuture.business.bean.CheckPlanModelVO;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.dao.CheckDetaiService;
import com.efuture.business.dao.CheckHeadService;
import com.efuture.business.dao.CheckPlanDetailService;
import com.efuture.business.dao.CheckPlanService;
import com.efuture.business.exception.EfutureException;
import com.efuture.business.model.CheckDetailModel;
import com.efuture.business.model.CheckHeadModel;
import com.efuture.business.model.CheckPlanDetailModel;
import com.efuture.business.model.CheckPlanHeadModel;
import com.efuture.business.model.CheckPlanModel;
import com.efuture.business.service.CheckPlanServiceBS;
import com.efuture.business.util.ArrayUtils;
import com.efuture.business.util.DateHelpUtil;
import com.efuture.business.util.RandomNum;
import com.efuture.business.util.ReflectUtils;
import com.efuture.business.util.db.MultipleDataSource;
import com.product.model.ServiceSession;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.TransactionDefinition;
import org.springframework.transaction.TransactionStatus;

public class CheckPlanServiceBSImpl
implements CheckPlanServiceBS {
    private static final Logger log = LoggerFactory.getLogger(CheckPlanServiceBSImpl.class);
    @Autowired
    private CheckPlanService checkPlanServic;
    @Autowired
    private CheckHeadService checkHeadService;
    @Autowired
    private CheckDetaiService checkDetaiService;
    @Autowired
    private CheckPlanDetailService checkPlanDetailService;
    @Resource
    DataSourceTransactionManager dataSourceTransactionManager;
    @Resource
    TransactionDefinition transactionDefinition;

    public RespBase<Boolean> saveCheckPlan(ServiceSession session, CheckPlanModelPageVO inVo) {
        QueryWrapper queryWrapper = new QueryWrapper();
        int seqNo = this.checkPlanServic.countCheckPlan((Wrapper)queryWrapper) + 1;
        inVo.setId(ReflectUtils.getUUID()).setSeqNo(Long.valueOf(seqNo)).setStatus("0").setCreateDate(new Date());
        String errorMessage = ReflectUtils.checkParam((Object)inVo);
        if (!StringUtils.isEmpty((String)errorMessage)) {
            return Code.CODE_70013.getRespBase(new Object[]{errorMessage});
        }
        if (ArrayUtils.isEmpty((List)inVo.getCheckPlanDetailModels())) {
            return Code.CODE_70013.getRespBase(new Object[]{"checkPlanDetailModels"});
        }
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = this.dataSourceTransactionManager.getTransaction(this.transactionDefinition);
            MultipleDataSource.setDataSourceKey((String)"dataSource09");
            this.checkPlanServic.saveCheckPlan((CheckPlanModel)inVo);
            List list = this.buildSessionCheckPlanDetailModelList(inVo);
            this.checkPlanDetailService.saveBatch((Collection)list, "checkplandetil");
            this.dataSourceTransactionManager.commit(transactionStatus);
            return new RespBase(Code.SUCCESS, (Object)true);
        }
        catch (EfutureException e) {
            this.dataSourceTransactionManager.rollback(transactionStatus);
            throw e;
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(transactionStatus);
            throw new EfutureException(Code.CODE_70040.getRespBase(new Object[]{e.getMessage()}));
        }
    }

    public RespBase<Boolean> updateCheckPlan(ServiceSession session, CheckPlanModelPageVO inVo) {
        if (StringUtils.isEmpty((String)inVo.getId())) {
            return Code.CODE_70013.getRespBase(new Object[]{"id"});
        }
        CheckPlanModel checkPlanModel = this.checkPlanServic.queryCheckPlanById((CheckPlanModel)inVo);
        if (null == checkPlanModel) {
            return Code.CODE_70041.getRespBase(new Object[]{inVo.getSeqNo()});
        }
        String status = checkPlanModel.getStatus();
        if ("-1".equals(status)) {
            return Code.CODE_70042.getRespBase(new Object[0]);
        }
        if ("1".equals(status)) {
            return Code.CODE_70043.getRespBase(new Object[0]);
        }
        if ("2".equals(status)) {
            return Code.CODE_70044.getRespBase(new Object[0]);
        }
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = this.dataSourceTransactionManager.getTransaction(this.transactionDefinition);
            MultipleDataSource.setDataSourceKey((String)"dataSource09");
            this.checkPlanServic.updateCheckPlanById((CheckPlanModel)inVo);
            if (ArrayUtils.isNotEmpty((List)inVo.getCheckPlanDetailModels())) {
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"checkplanId", (Object)checkPlanModel.getId());
                this.checkPlanDetailService.removeCheckPlanDetail((Wrapper)queryWrapper);
                List list = this.buildSessionCheckPlanDetailModelList(inVo);
                this.checkPlanDetailService.saveBatch((Collection)list, "checkplandetail");
            }
            this.dataSourceTransactionManager.commit(transactionStatus);
            return new RespBase(Code.SUCCESS, (Object)true);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(transactionStatus);
            throw new EfutureException(Code.CODE_70040.getRespBase(new Object[]{e.getMessage()}));
        }
    }

    private List<CheckPlanDetailModel> buildSessionCheckPlanDetailModelList(CheckPlanModelPageVO inVo) {
        List list = inVo.getCheckPlanDetailModels();
        for (CheckPlanDetailModel shopCode : list) {
            CheckPlanModelVO checkPlanModelVO = new CheckPlanModelVO();
            checkPlanModelVO.setShopCode(shopCode.getShopCode());
            checkPlanModelVO.setCheckDate(inVo.getCheckDate());
            checkPlanModelVO.setStatus("-1");
            int num = this.checkPlanServic.queryCheckPlanStatus(checkPlanModelVO);
            if (num > 0) {
                throw new EfutureException(Code.CODE_70045.getRespBase(new Object[]{shopCode.getShopCode()}));
            }
            shopCode.setId(ReflectUtils.getUUID()).setCheckDate(inVo.getCheckDate()).setCheckPlanId(inVo.getId());
        }
        return list;
    }

    public RespBase<IPage<CheckPlanModelPageVO>> queryCheckPlanList(ServiceSession session, CheckPlanModelPageVO inVo) {
        log.info("\u67e5\u8be2\u76d8\u70b9\u8ba1\u5212\u5217\u8868:{}", (Object)inVo.toString());
        QueryWrapper queryWrapper = new QueryWrapper();
        if (null != inVo.getCheckDate()) {
            queryWrapper.apply("checkDate = {0}", new Object[]{DateHelpUtil.getDateStringFromMillisecond((Long)inVo.getCheckDate().getTime())});
        }
        if (null != inVo.getCreateDate()) {
            queryWrapper.apply("createDate = {0}", new Object[]{DateHelpUtil.getDateStringFromMillisecond((Long)inVo.getCreateDate().getTime())});
        }
        if (null != inVo.getCancelDate()) {
            queryWrapper.apply("cancelDate = {0}", new Object[]{DateHelpUtil.getDateStringFromMillisecond((Long)inVo.getCancelDate().getTime())});
        }
        if (!StringUtils.isEmpty((String)inVo.getOperuser())) {
            queryWrapper.eq((Object)"operuser", (Object)inVo.getOperuser());
        }
        if (!StringUtils.isEmpty((String)inVo.getStatus())) {
            queryWrapper.eq((Object)"status", (Object)inVo.getStatus());
        }
        queryWrapper.select(new String[0]).orderByDesc((Object)"checkDate");
        if (null == inVo.getPageCurrent() || null == inVo.getPageSize()) {
            inVo.setPageCurrent(Integer.valueOf(1)).setPageSize(Integer.valueOf(20));
        }
        Page page = new Page((long)inVo.getPageCurrent().intValue(), (long)inVo.getPageSize().intValue());
        IPage list = this.checkPlanServic.queryCheckPlanPage(page, (Wrapper)queryWrapper);
        for (int i = 0; i < list.getRecords().size(); ++i) {
            int stater = (int)((list.getCurrent() - 1L) * list.getSize());
            CheckPlanModelPageVO checkPlanModel = (CheckPlanModelPageVO)list.getRecords().get(i);
            QueryWrapper planDetailModelQueryWrapper = new QueryWrapper();
            planDetailModelQueryWrapper.eq((Object)"checkPlanId", (Object)checkPlanModel.getId());
            List checkPlanDetailModelList = this.checkPlanDetailService.list((Wrapper)planDetailModelQueryWrapper);
            checkPlanModel.setCheckPlanDetailModels(checkPlanDetailModelList);
            checkPlanModel.setSeqNo(Long.valueOf(i + 1 + stater));
        }
        return new RespBase(Code.SUCCESS, (Object)list);
    }

    public RespBase<Boolean> auditCheckPlan(ServiceSession session, CheckPlanModel inVo) {
        if (StringUtils.isEmpty((String)inVo.getId())) {
            return Code.CODE_70013.getRespBase(new Object[]{"id"});
        }
        if (StringUtils.isEmpty((String)inVo.getChecker())) {
            return Code.CODE_70013.getRespBase(new Object[]{"checker"});
        }
        if (null == inVo.getApproveDate()) {
            return Code.CODE_70013.getRespBase(new Object[]{"approveDate"});
        }
        CheckPlanModel queryCheckPlan = this.checkPlanServic.queryCheckPlanById(inVo);
        if (null == queryCheckPlan) {
            return Code.CODE_70046.getRespBase(new Object[0]);
        }
        String status = queryCheckPlan.getStatus();
        if (!"0".equals(status)) {
            return Code.CODE_70047.getRespBase(new Object[0]);
        }
        queryCheckPlan.setStatus("1").setChecker(inVo.getChecker()).setApproveDate(inVo.getApproveDate());
        boolean update = this.checkPlanServic.updateCheckPlanById(queryCheckPlan);
        if (!update) {
            throw new EfutureException(Code.CODE_70048.getRespBase(new Object[0]));
        }
        return new RespBase(Code.SUCCESS, (Object)true);
    }

    public RespBase<Boolean> cancelCheckPlan(ServiceSession session, CheckPlanModel inVo) {
        if (StringUtils.isEmpty((String)inVo.getId())) {
            return Code.CODE_70013.getRespBase(new Object[]{"id"});
        }
        if (StringUtils.isEmpty((String)inVo.getCanceluser())) {
            return Code.CODE_70013.getRespBase(new Object[]{"canceluser"});
        }
        if (null == inVo.getCancelDate()) {
            return Code.CODE_70013.getRespBase(new Object[]{"cancelDate"});
        }
        CheckPlanModel queryCheckPlan = this.checkPlanServic.queryCheckPlanById(inVo);
        String status = queryCheckPlan.getStatus();
        if ("2".equals(status)) {
            return Code.CODE_70049.getRespBase(new Object[0]);
        }
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"checkPlanId", (Object)queryCheckPlan.getId());
        List list = this.checkHeadService.list((Wrapper)queryWrapper, "checkhead");
        if (ArrayUtils.isNotEmpty((List)list)) {
            return Code.CODE_70050.getRespBase(new Object[0]);
        }
        queryCheckPlan.setStatus("-1").setCanceluser(inVo.getCanceluser()).setCancelDate(inVo.getCancelDate());
        boolean update = this.checkPlanServic.updateCheckPlanById(queryCheckPlan);
        if (!update) {
            throw new EfutureException(Code.CODE_70051.getRespBase(new Object[0]));
        }
        return new RespBase(Code.SUCCESS, (Object)true);
    }

    public RespBase<Boolean> completeCheckPlan(ServiceSession session, CheckPlanModel inVo) {
        if (StringUtils.isEmpty((String)inVo.getId())) {
            return Code.CODE_70013.getRespBase(new Object[]{"id"});
        }
        CheckPlanModel queryCheckPlan = this.checkPlanServic.queryCheckPlanById(inVo);
        if (null == queryCheckPlan) {
            return Code.CODE_70052.getRespBase(new Object[0]);
        }
        String status = queryCheckPlan.getStatus();
        if (!"1".equals(status)) {
            return Code.CODE_70053.getRespBase(new Object[0]);
        }
        queryCheckPlan.setStatus("2").setCompletionDate(new Date());
        TransactionStatus transactionStatus = null;
        try {
            transactionStatus = this.dataSourceTransactionManager.getTransaction(this.transactionDefinition);
            MultipleDataSource.setDataSourceKey((String)"dataSource09");
            this.checkPlanServic.updateCheckPlanById(queryCheckPlan);
            CheckHeadModel checkHeadModel = new CheckHeadModel().setApproveDate(new Date()).setChecker(queryCheckPlan.getChecker());
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"checkPlanId", (Object)queryCheckPlan.getId());
            this.checkHeadService.updateCheckHead(checkHeadModel, (Wrapper)queryWrapper);
            this.dataSourceTransactionManager.commit(transactionStatus);
            return new RespBase(Code.SUCCESS, (Object)true);
        }
        catch (Exception e) {
            this.dataSourceTransactionManager.rollback(transactionStatus);
            throw new EfutureException(Code.CODE_70054.getRespBase(new Object[0]));
        }
    }

    public RespBase<List<CheckPlanModel>> queryCheckPlanListTimeLow(ServiceSession session, CheckPlanModelVO inVo) {
        if (null == inVo.getCheckDate()) {
            return Code.CODE_70013.getRespBase(new Object[]{"checkDate"});
        }
        inVo.setStatus("1");
        List list = this.checkPlanServic.queryCheckPlan(inVo);
        return new RespBase(Code.SUCCESS, (Object)list);
    }

    public RespBase<CheckHeadModel> saveCheckHead(ServiceSession session, CheckHeadModel inVo) {
        inVo.setBillno(RandomNum.getTime() + RandomNum.generateString((int)5)).setId(ReflectUtils.getUUID()).setBillDate(new Date());
        String errorMessage = ReflectUtils.checkParam((Object)inVo);
        if (!StringUtils.isEmpty((String)errorMessage)) {
            return Code.CODE_70013.getRespBase(new Object[]{errorMessage});
        }
        boolean save = this.checkHeadService.saveCheckHead(inVo);
        if (!save) {
            throw new EfutureException(Code.CODE_70055.getRespBase(new Object[0]));
        }
        return new RespBase(Code.SUCCESS, (Object)inVo);
    }

    public RespBase<IPage<CheckPlanHeadModel>> queryCheckHead(ServiceSession session, CheckHeadPageVO inVo) {
        IPage list = this.checkHeadService.queryCheckPlanHeadList(inVo);
        return new RespBase(Code.SUCCESS, (Object)list);
    }

    public RespBase<Boolean> saveCheckDetail(ServiceSession session, CheckDetailVO inVo) {
        if (StringUtils.isEmpty((String)inVo.getCheckPlanId())) {
            return Code.CODE_70013.getRespBase(new Object[]{"id"});
        }
        CheckPlanModel checkPlanModel = new CheckPlanModel().setId(inVo.getCheckPlanId());
        CheckPlanModel reqCheckPlanModel = this.checkPlanServic.queryCheckPlanById(checkPlanModel);
        if (!"1".equals(reqCheckPlanModel.getStatus())) {
            String date = DateHelpUtil.getDateStringFrom((Date)reqCheckPlanModel.getCheckDate());
            throw new EfutureException(Code.CODE_70056.getRespBase(new Object[]{date}));
        }
        List checkDetailModelList = inVo.getCheckDetailModelList();
        if (ArrayUtils.isEmpty((List)checkDetailModelList)) {
            throw new EfutureException(Code.CODE_70013.getRespBase(new Object[]{"checkDetailModelList"}));
        }
        inVo.setShopName(((CheckDetailPageVO)checkDetailModelList.get(0)).getShopName());
        TransactionStatus transactionStatus = null;
        try {
            CheckHeadModel checkHeadModel;
            String checkHeadId = inVo.getCheckHeadId();
            MultipleDataSource.setDataSourceKey((String)"dataSource09");
            transactionStatus = this.dataSourceTransactionManager.getTransaction(this.transactionDefinition);
            if (StringUtils.isEmpty((String)checkHeadId)) {
                RespBase respBase = this.saveCheckHead(session, (CheckHeadModel)inVo);
                if (respBase.getRetflag() != Code.SUCCESS.getIndex()) {
                    throw new EfutureException(Code.CODE_70057.getRespBase(new Object[0]));
                }
                checkHeadModel = (CheckHeadModel)respBase.getData();
            } else {
                checkHeadModel = new CheckHeadModel().setUpdateDate(new Date()).setId(checkHeadId).setUpdateUser(inVo.getUpdateUser());
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"id", (Object)checkHeadModel.getId());
                this.checkHeadService.updateCheckHead(checkHeadModel, (Wrapper)queryWrapper);
            }
            ArrayList<CheckDetailPageVO> checkDetailModels = new ArrayList<CheckDetailPageVO>();
            for (CheckDetailPageVO checkDetailModel : checkDetailModelList) {
                boolean isNotId = StringUtils.isEmpty((String)checkDetailModel.getId());
                if (isNotId) {
                    checkDetailModel.setCheckHeadId(checkHeadModel.getId());
                    checkDetailModel.setId(ReflectUtils.getUUID());
                }
                if ("D".equals(checkDetailModel.getOperateType())) {
                    this.checkDetaiService.removeById((Serializable)((Object)checkDetailModel.getId()));
                    continue;
                }
                String errorMessage = ReflectUtils.checkParam((Object)checkDetailModel);
                if (!StringUtils.isEmpty((String)errorMessage)) {
                    return Code.CODE_70013.getRespBase(new Object[]{errorMessage});
                }
                if (!"N".equals(inVo.getCheckBarNo()) && isNotId) {
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("checkPlanId", inVo.getCheckPlanId());
                    map.put("goodsCode", checkDetailModel.getGoodsCode());
                    List list = this.checkDetaiService.queryCheckDetailId(map);
                    if (!ArrayUtils.isEmpty((List)list)) {
                        throw new EfutureException(Code.CODE_70038.getRespBase(new Object[]{checkDetailModel.getGoodsCode()}));
                    }
                }
                checkDetailModels.add(checkDetailModel);
            }
            this.checkDetaiService.saveOrUpdateBatch(checkDetailModels, "checkdetail");
            this.dataSourceTransactionManager.commit(transactionStatus);
            return new RespBase(Code.SUCCESS, (Object)true);
        }
        catch (EfutureException e) {
            this.dataSourceTransactionManager.rollback(transactionStatus);
            throw e;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.dataSourceTransactionManager.rollback(transactionStatus);
            throw new EfutureException(Code.CODE_70057.getRespBase(new Object[0]));
        }
    }

    public RespBase<IPage<CheckDetailModel>> queryCheckDetail(ServiceSession session, CheckDetailPageVO inVo) {
        IPage list = this.checkDetaiService.queryCheckDetail(inVo);
        return new RespBase(Code.SUCCESS, (Object)list);
    }

    public RespBase<CheckDetailModel> updateCheckDetailById(ServiceSession session, CheckDetailModel inVo) {
        if (StringUtils.isEmpty((String)inVo.getId())) {
            return Code.CODE_70013.getRespBase(new Object[]{"\u4e3b\u952eid"});
        }
        if (null == inVo.getQty() || 0.0 > inVo.getQty()) {
            this.checkDetaiService.deleteCheckDetailById(inVo);
            return new RespBase(Code.SUCCESS, (Object)inVo);
        }
        boolean update = this.checkDetaiService.updateCheckDetailById(inVo);
        if (!update) {
            throw new EfutureException(Code.CODE_70058.getRespBase(new Object[0]));
        }
        return new RespBase(Code.SUCCESS, (Object)inVo);
    }

    public RespBase<CheckPlanHeadModel> queryCheckDetailById(ServiceSession session, CheckDetailPageVO checkDetailPageVO) {
        if (StringUtils.isEmpty((String)checkDetailPageVO.getCheckHeadId())) {
            return Code.CODE_70013.getRespBase(new Object[]{"id"});
        }
        CheckHeadPageVO checkHeadModel = new CheckHeadPageVO();
        checkHeadModel.setId(checkDetailPageVO.getCheckHeadId());
        IPage list = this.checkHeadService.queryCheckPlanHeadList(checkHeadModel);
        if (ArrayUtils.isEmpty((List)list.getRecords())) {
            return new RespBase(Code.SUCCESS, (Object)new CheckPlanHeadModel());
        }
        CheckPlanHeadModel checkPlanHeadModel = (CheckPlanHeadModel)list.getRecords().get(0);
        CheckDetailPageVO checkDetailModel = new CheckDetailPageVO();
        checkDetailModel.setCheckHeadId(checkPlanHeadModel.getId());
        checkDetailModel.setPageSize(checkDetailPageVO.getPageSize());
        checkDetailModel.setPageCurrent(checkDetailPageVO.getPageCurrent());
        RespBase checkDetailModelList = this.queryCheckDetail(session, checkDetailModel);
        if (Code.SUCCESS.getIndex() != checkDetailModelList.getRetflag()) {
            return new RespBase(checkDetailModelList.getRetflag(), checkDetailModelList.getRetmsg());
        }
        checkPlanHeadModel.setCheckDetailModelList((IPage)checkDetailModelList.getData());
        return new RespBase(Code.SUCCESS, (Object)checkPlanHeadModel);
    }
}

