/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.dao.PosWorkAcountService;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.model.PosWorkAcountModel;
import com.efuture.business.service.PosWorkAcountSaleBS;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.TimeZoneUtil;
import com.product.model.ServiceSession;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class PosWorkAcountSaleBSImpl
implements PosWorkAcountSaleBS {
    private static final Logger log = LoggerFactory.getLogger(PosWorkAcountSaleBSImpl.class);
    @Autowired
    PosWorkAcountService posWorkAcountServiceImpl;
    @Autowired
    protected RedisUtil redisUtil;
    @Value(value="${localcache.enabled}")
    private Boolean localcache;

    public List<Map> countPosWork(ServiceSession session, JSONObject param) {
        String syyh;
        String mkt = param.getString("mkt");
        String erpCode = param.getString("erpCode");
        String syjh = param.getString("syjh");
        String clearTime = param.getString("clearTime");
        String obj = this.redisUtil.get(RedisKey.CACHEID + mkt + syjh);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String timeZone = modeDetailsVo.getSysparainfo().getTimeZone();
        QueryWrapper queryWrapper = new QueryWrapper();
        String searchType = param.getString("searchType");
        if ("1".equals(searchType)) {
            syyh = param.getString("operuserGh");
            queryWrapper.eq((Object)"syyh", (Object)syyh);
        }
        if ("2".equals(searchType)) {
            queryWrapper.eq((Object)"syjh", (Object)syjh);
        }
        if ("3".equals(searchType)) {
            syyh = param.getString("operuserGh");
            queryWrapper.eq((Object)"syyh", (Object)syyh);
            queryWrapper.eq((Object)"syjh", (Object)syjh);
        }
        queryWrapper.eq((Object)"erpCode", (Object)erpCode);
        queryWrapper.in((Object)"logtype", new Object[]{"17", "23", "24", "35"});
        queryWrapper.eq((Object)"mkt", (Object)mkt);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = sdf.parse(clearTime);
            queryWrapper.gt((Object)"rqsj", (Object)date);
        }
        catch (Exception e) {
            log.error("\u6e05\u673a\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
        }
        queryWrapper.lt((Object)"rqsj", (Object)TimeZoneUtil.ConvertTimeByTimeZone((Date)new Date(), (String)timeZone, (Boolean)this.localcache));
        List workList = this.posWorkAcountServiceImpl.list((Wrapper)queryWrapper, "posworkacount");
        HashMap<String, Integer> countNumber = new HashMap<String, Integer>();
        HashMap<String, Double> countAmount = new HashMap<String, Double>();
        HashMap<String, Integer> countEveryType = new HashMap<String, Integer>();
        HashSet<String> types = new HashSet<String>();
        for (PosWorkAcountModel log : workList) {
            String logtype = log.getLogtype();
            double amount = log.getAmount();
            Integer count = log.getCount();
            if (countNumber.get(logtype) == null) {
                countNumber.put(logtype, count);
            } else {
                Integer counded = (Integer)countNumber.get(logtype);
                countNumber.put(logtype, counded + count);
            }
            if (countAmount.get(logtype) == null) {
                countAmount.put(logtype, amount);
            } else {
                Double amounted = (Double)countAmount.get(logtype);
                countAmount.put(logtype, ManipulatePrecision.add((double)amounted, (double)amount));
            }
            if (countEveryType.get(logtype) == null) {
                countEveryType.put(logtype, 1);
            } else {
                Integer c = (Integer)countEveryType.get(logtype);
                Integer cN = c + 1;
                countEveryType.put(logtype, cN);
            }
            types.add(logtype);
        }
        ArrayList<Map> results = new ArrayList<Map>();
        for (String type : types) {
            HashMap<String, String> ontType = new HashMap<String, String>();
            ontType.put("logType", type);
            ontType.put("count", (String)countEveryType.get(type));
            ontType.put("amount", (String)countAmount.get(type));
            results.add(ontType);
        }
        return results;
    }

    public boolean onInsert(JSONObject param) {
        return this.posWorkAcountServiceImpl.saveEntity((PosWorkAcountModel)JSON.toJavaObject((JSON)param, PosWorkAcountModel.class));
    }

    public List<PosWorkAcountModel> onQuery(JSONObject param) {
        return this.posWorkAcountServiceImpl.listByMap((Map)param);
    }
}

