/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.dao.RebateCodeService;
import com.efuture.business.javaPos.struct.posManager.RebateCodeHead;
import com.efuture.business.service.RebateCodeHeadSaleBS;
import com.product.model.ServiceSession;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class RebateCodeHeadSaleBSImpl
implements RebateCodeHeadSaleBS {
    private static final Logger log = LoggerFactory.getLogger(RebateCodeHeadSaleBSImpl.class);
    @Value(value="${localcache.enabled}")
    private Boolean localcache;
    @Autowired
    RebateCodeService rebateCodeService;

    public RespBase search(ServiceSession session, JSONObject paramsObject) {
        if (this.localcache.booleanValue()) {
            return Code.CODE_70012.getRespBase(new Object[0]);
        }
        if (!paramsObject.containsKey((Object)"erpCode") || paramsObject.getString("erpCode").equals("")) {
            return Code.CODE_70013.getRespBase(new Object[]{"erpCode"});
        }
        if (!paramsObject.containsKey((Object)"mkt") || paramsObject.getString("mkt").equals("")) {
            return Code.CODE_70013.getRespBase(new Object[]{"mkt"});
        }
        Calendar now = Calendar.getInstance();
        String effectivedate = new SimpleDateFormat("yyyy-MM-dd").format(now.getTime());
        paramsObject.put("effectivedate", (Object)effectivedate);
        paramsObject.put("rhstatus", (Object)"Y");
        List list = this.rebateCodeService.search(paramsObject);
        JSONObject result = new JSONObject();
        JSONArray resultArray = new JSONArray();
        if (list.size() == 0) {
            result.put("rebatecodehead", (Object)resultArray);
            result.put("total_results", (Object)resultArray.size());
            return new RespBase(Code.SUCCESS, (Object)result);
        }
        JSONArray rhids = new JSONArray();
        for (Map map : list) {
            String rhid = map.get("rhid").toString();
            rhids.add((Object)rhid);
        }
        paramsObject.put("rhids", (Object)rhids);
        List list2 = this.rebateCodeService.searchMfid(paramsObject);
        JSONArray rmids = new JSONArray();
        if (list2.size() != 0) {
            for (Map map : list2) {
                String rmid = map.get("rmid").toString();
                rmids.add((Object)rmid);
            }
        }
        if (rmids.size() == 0) {
            result.put("rebatecodehead", (Object)list);
            result.put("total_results", (Object)list.size());
            return new RespBase(Code.SUCCESS, (Object)result);
        }
        paramsObject.put("rmids", (Object)rmids);
        List list3 = this.rebateCodeService.searchHead(paramsObject);
        result.put("rebatecodehead", (Object)list3);
        result.put("total_results", (Object)list3.size());
        return new RespBase(Code.SUCCESS, (Object)result);
    }

    public RespBase detail(ServiceSession session, JSONObject paramsObject) {
        JSONObject object = new JSONObject();
        object.put("hid", (Object)paramsObject.getString("hid"));
        List rebateCodeHeads = this.rebateCodeService.listByMap((Map)object, "rebatecodehead");
        if (rebateCodeHeads.size() == 0) {
            return Code.CODE_70014.getRespBase(new Object[0]);
        }
        RebateCodeHead head = (RebateCodeHead)rebateCodeHeads.get(0);
        String rhid = head.getRhid();
        String erpCode = head.getErpCode();
        JSONObject object2 = new JSONObject();
        object2.put("rhid", (Object)rhid);
        object2.put("erpCode", (Object)erpCode);
        object2.put("pdcode", (Object)paramsObject.getString("pdcode"));
        Calendar now = Calendar.getInstance();
        String pdedate = new SimpleDateFormat("yyyy-MM-dd").format(now.getTime());
        object2.put("pdedate", (Object)pdedate);
        List list = this.rebateCodeService.detail(object2);
        if (list.size() == 0) {
            return Code.CODE_70014.getRespBase(new Object[0]);
        }
        List list2 = this.rebateCodeService.searchRemovecat(object2);
        JSONObject result = new JSONObject();
        result.put("rebatecodehead", (Object)rebateCodeHeads);
        result.put("rebatecodedetail", (Object)list);
        result.put("rebateremovecat", (Object)list2);
        return new RespBase(Code.SUCCESS, (Object)result);
    }
}

