/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.dao.SyjCashLogService;
import com.efuture.business.dao.SyjMainLogService;
import com.efuture.business.dao.SyjPreCashDetailService;
import com.efuture.business.dao.SyjPreMoneyService;
import com.efuture.business.model.SyjCashLogModel;
import com.efuture.business.model.SyjMainLogModel;
import com.efuture.business.service.SyjCashLogSaleBS;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.TimeZoneUtil;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;

public class SyjCashLogSaleBSImpl
implements SyjCashLogSaleBS {
    private static final Logger log = LoggerFactory.getLogger(SyjCashLogSaleBSImpl.class);
    @Autowired
    SyjCashLogService syjCashLogServiceImpl;
    @Autowired
    SyjMainLogService syjMainLogServiceImpl;
    @Autowired
    SyjPreMoneyService syjPreMoneyService;
    @Autowired
    private SyjPreCashDetailService syjCashDetailService;
    @Autowired
    protected RedisUtil redisUtil;
    @Value(value="${localcache.enabled}")
    private Boolean localcache;

    public List<Map> countCashLog(ServiceSession session, JSONObject param) {
        String syyh;
        String mkt = param.getString("mkt");
        String erpCode = param.getString("erpCode");
        String syjh = param.getString("syjh");
        String clearTime = param.getString("clearTime");
        String obj = this.redisUtil.get(RedisKey.CACHEID + mkt + syjh);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String timeZone = modeDetailsVo.getSysparainfo().getTimeZone();
        JSONObject findP = new JSONObject();
        QueryWrapper syjCashLogWrapper = new QueryWrapper();
        String searchType = param.getString("searchType");
        if ("1".equals(searchType)) {
            syyh = param.getString("operuserGh");
            syjCashLogWrapper.eq((Object)"syjcursyyh", (Object)syyh);
        }
        if ("2".equals(searchType)) {
            syjCashLogWrapper.eq((Object)"syjh", (Object)syjh);
        }
        if ("3".equals(searchType)) {
            syyh = param.getString("operuserGh");
            syjCashLogWrapper.eq((Object)"syjcursyyh", (Object)syyh);
            syjCashLogWrapper.eq((Object)"syjh", (Object)syjh);
        }
        syjCashLogWrapper.eq((Object)"erpCode", (Object)erpCode);
        syjCashLogWrapper.eq((Object)"mkt", (Object)mkt);
        syjCashLogWrapper.in((Object)"status", (Object[])new String[]{"4", "11", "3", "14", "12", "13", "15"});
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            Date date = sdf.parse(clearTime);
            syjCashLogWrapper.gt((Object)"syjcurtime", (Object)date);
        }
        catch (Exception e) {
            log.error("\u6e05\u673a\u65f6\u95f4\u8f6c\u6362\u5f02\u5e38\uff1a" + e.getMessage());
        }
        syjCashLogWrapper.lt((Object)"syjcurtime", (Object)TimeZoneUtil.ConvertTimeByTimeZone((Date)new Date(), (String)timeZone, (Boolean)this.localcache));
        List cashLogList = this.syjMainLogServiceImpl.list((Wrapper)syjCashLogWrapper, "syjcashlog");
        HashMap<String, Object> countEnterCash = new HashMap<String, Object>();
        HashMap<String, Object> countCancelEnter = new HashMap<String, Object>();
        HashMap<String, Object> countMidEnter = new HashMap<String, Object>();
        HashMap<String, Object> countCancelMidEnter = new HashMap<String, Object>();
        HashMap<String, Object> countMidConvert = new HashMap<String, Object>();
        HashMap<String, Object> countLastPayment = new HashMap<String, Object>();
        HashMap<String, Object> countCancelLastPayment = new HashMap<String, Object>();
        for (SyjMainLogModel log : cashLogList) {
            Integer cNumber;
            BigDecimal cAmount;
            String status = log.getStatus();
            BigDecimal curpreje = log.getSyjcurpreje();
            BigDecimal paychashje = log.getSyjpaycashje();
            if ("4".equals(status)) {
                countEnterCash.put("status", "4");
                if (countEnterCash.get("syjcurpreje") == null) {
                    countEnterCash.put("syjcurpreje", curpreje);
                    countEnterCash.put("count", 1);
                } else {
                    cAmount = (BigDecimal)countEnterCash.get("syjcurpreje");
                    cNumber = (Integer)countEnterCash.get("count");
                    countEnterCash.put("syjcurpreje", cAmount.add(curpreje));
                    countEnterCash.put("count", cNumber + 1);
                }
            }
            if ("11".equals(status)) {
                countCancelEnter.put("status", "11");
                if (countCancelEnter.get("syjcurpreje") == null) {
                    countCancelEnter.put("syjcurpreje", curpreje);
                    countCancelEnter.put("count", 1);
                } else {
                    cAmount = (BigDecimal)countCancelEnter.get("syjcurpreje");
                    cNumber = (Integer)countCancelEnter.get("count");
                    countCancelEnter.put("syjcurpreje", cAmount.add(curpreje));
                    countCancelEnter.put("count", cNumber + 1);
                }
            }
            if ("3".equals(status)) {
                countMidEnter.put("status", "3");
                if (countMidEnter.get("syjpaycashje") == null) {
                    countMidEnter.put("syjpaycashje", paychashje);
                    countMidEnter.put("count", 1);
                } else {
                    cAmount = (BigDecimal)countMidEnter.get("syjpaycashje");
                    cNumber = (Integer)countMidEnter.get("count");
                    countMidEnter.put("syjpaycashje", cAmount.add(paychashje));
                    countMidEnter.put("count", cNumber + 1);
                }
            }
            if ("13".equals(status)) {
                countCancelMidEnter.put("status", "13");
                if (countCancelMidEnter.get("syjpaycashje") == null) {
                    countCancelMidEnter.put("syjpaycashje", paychashje);
                    countCancelMidEnter.put("count", 1);
                } else {
                    cAmount = (BigDecimal)countCancelMidEnter.get("syjpaycashje");
                    cNumber = (Integer)countCancelMidEnter.get("count");
                    countCancelMidEnter.put("syjpaycashje", cAmount.add(paychashje));
                    countCancelMidEnter.put("count", cNumber + 1);
                }
            }
            if ("14".equals(status)) {
                countMidConvert.put("status", "14");
                if (countMidConvert.get("syjpaycashje") == null) {
                    countMidConvert.put("syjpaycashje", paychashje);
                    countMidConvert.put("count", 1);
                } else {
                    cAmount = (BigDecimal)countMidConvert.get("syjpaycashje");
                    cNumber = (Integer)countMidConvert.get("count");
                    countMidConvert.put("syjpaycashje", cAmount.add(paychashje));
                    countMidConvert.put("count", cNumber + 1);
                }
            }
            if ("12".equals(status)) {
                countLastPayment.put("status", "12");
                if (countLastPayment.get("syjpaycashje") == null) {
                    countLastPayment.put("syjpaycashje", paychashje);
                    countLastPayment.put("count", 1);
                } else {
                    cAmount = (BigDecimal)countLastPayment.get("syjpaycashje");
                    cNumber = (Integer)countLastPayment.get("count");
                    countLastPayment.put("syjpaycashje", cAmount.add(paychashje));
                    countLastPayment.put("count", cNumber + 1);
                }
            }
            if (!"15".equals(status)) continue;
            countCancelLastPayment.put("status", "15");
            if (countCancelLastPayment.get("syjpaycashje") == null) {
                countCancelLastPayment.put("syjpaycashje", paychashje);
                countCancelLastPayment.put("count", 1);
                continue;
            }
            cAmount = (BigDecimal)countCancelLastPayment.get("syjpaycashje");
            cNumber = (Integer)countCancelLastPayment.get("count");
            countCancelLastPayment.put("syjpaycashje", cAmount.add(paychashje));
            countCancelLastPayment.put("count", cNumber + 1);
        }
        ArrayList<Map> result = new ArrayList<Map>();
        if (countEnterCash.entrySet().size() != 0) {
            result.add(countEnterCash);
        }
        if (countCancelEnter.entrySet().size() != 0) {
            result.add(countCancelEnter);
        }
        if (countMidEnter.entrySet().size() != 0) {
            result.add(countMidEnter);
        }
        if (countCancelMidEnter.entrySet().size() != 0) {
            result.add(countCancelMidEnter);
        }
        if (countMidConvert.entrySet().size() != 0) {
            result.add(countMidConvert);
        }
        if (countLastPayment.entrySet().size() != 0) {
            result.add(countLastPayment);
        }
        if (countCancelLastPayment.entrySet().size() != 0) {
            result.add(countCancelLastPayment);
        }
        return result;
    }

    public RespBase insertCash(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        log.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u5165\u91d1", jsonObject.toJSONString()});
        RespBase response = this.syjCashLogServiceImpl.insertCash(session, jsonObject);
        log.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u5165\u91d1", JSONObject.toJSONString((Object)response)});
        return response;
    }

    public RespBase getTemporaryPayLog(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        try {
            ServiceResponse response = this.syjCashLogServiceImpl.getTemporaryPayLog(session, jsonObject);
            if ("0".equals(response.getReturncode())) {
                return new RespBase(Code.SUCCESS, response.getData(), "GETTEMPORARYPAYLOG");
            }
            return new RespBase(Code.FAIL, response.getData().toString());
        }
        catch (Exception e) {
            return Code.FAIL.getRespBase(new Object[]{"-1", e.getMessage()});
        }
    }

    public long getMaxPreCount(JSONObject jsonObject) {
        return this.syjCashLogServiceImpl.getMaxPreCount(jsonObject);
    }

    public boolean updateCashLog(JSONObject jsonObject) {
        return this.syjCashLogServiceImpl.updateCashLog(jsonObject);
    }

    public String getCashList(ServiceSession session, JSONObject param) {
        return this.syjCashLogServiceImpl.getCashList(param);
    }

    public int saveEntity(JSONObject jsonObject) {
        return this.syjCashLogServiceImpl.saveEntity((SyjCashLogModel)JSONObject.toJavaObject((JSON)jsonObject, SyjCashLogModel.class));
    }

    public RespBase getInsertCashLog(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        log.info("getInsertCashLog==>" + jsonObject.toJSONString());
        try {
            ServiceResponse response = this.syjCashLogServiceImpl.getInsertCashLog(session, jsonObject);
            log.info("getInsertCashLog==>response:" + response.toString());
            if ("0".equals(response.getReturncode())) {
                return new RespBase(Code.SUCCESS, response.getData(), "GETINSERTCASHLOG");
            }
            return new RespBase(Code.FAIL, response.getData(), "GETINSERTCASHLOG");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Code.FAIL.getRespBase(new Object[]{"-1", e.getMessage()});
        }
    }

    public RespBase getCashDetail(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        try {
            ServiceResponse response = this.syjCashDetailService.searchList(session, jsonObject);
            if ("0".equals(response.getReturncode())) {
                return new RespBase(Code.SUCCESS, response.getData(), "PRECASHLOGDETAIL");
            }
            return Code.FAIL.getRespBase(new Object[]{response.getReturncode(), response.getData()});
        }
        catch (Exception e) {
            return Code.FAIL.getRespBase(new Object[]{"-1", e.getMessage()});
        }
    }

    public RespBase insertPreMoney(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        log.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u5907\u7528\u91d1", jsonObject.toJSONString()});
        try {
            ServiceResponse response = this.syjPreMoneyService.insertPreMoney(session, jsonObject);
            log.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u5907\u7528\u91d1", JSONObject.toJSONString((Object)response)});
            if ("0".equals(response.getReturncode())) {
                return new RespBase(Code.SUCCESS, response.getData(), "PREMONEYCERTIFY");
            }
            return new RespBase(Code.FAIL, response.getData(), "PREMONEYCERTIFY");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new RespBase(Code.FAIL, (Object)e.getMessage(), "PREMONEYCERTIFY");
        }
    }
}

