/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.dao.SyjMainLogService;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.model.SyjMainLogModel;
import com.efuture.business.model.Syjmain;
import com.efuture.business.service.SyjMainLogSaleBS;
import com.efuture.business.service.SyjMainRemoteService;
import com.efuture.business.util.ArrayUtils;
import com.efuture.business.util.HttpClientUtils;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.TimeZoneUtil;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class SyjMainLogSaleBSImpl
implements SyjMainLogSaleBS {
    private static final Logger log = LoggerFactory.getLogger(SyjMainLogSaleBSImpl.class);
    @Autowired
    SyjMainLogService syjMainLogServiceImpl;
    @Autowired
    protected RedisUtil redisUtil;
    @Autowired
    protected SyjMainLogService syjMainLogService;
    @SoaAnnotation(value="/syjMainRemoteService.do")
    protected SyjMainRemoteService syjMainRemoteService;

    public long getMaxPreCount(JSONObject jsonObject) {
        return this.syjMainLogServiceImpl.getMaxPreCount(jsonObject);
    }

    public int saveEntity(JSONObject jsonObject) {
        return this.syjMainLogServiceImpl.saveEntity((SyjMainLogModel)JSONObject.toJavaObject((JSON)jsonObject, SyjMainLogModel.class));
    }

    public String getCashList(JSONObject param) {
        JSONObject j = new JSONObject();
        j.put("cancelph_key", (Object)Long.valueOf(param.getString("ph_key")));
        return JSON.toJSONString((Object)this.syjMainLogServiceImpl.listByMap((Map)j, "syjmainlog"));
    }

    public BigDecimal getTotalPreje(JSONObject jsonObject) {
        return this.syjMainLogServiceImpl.getTotalPreje(jsonObject);
    }

    public BigDecimal getTotalPay(JSONObject jsonObject) {
        return this.syjMainLogServiceImpl.getTotalPay(jsonObject);
    }

    public RespBase getTemporaryPayLog(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        try {
            ServiceResponse response = this.syjMainLogServiceImpl.getTemporaryPayLog(session, jsonObject);
            if ("0".equals(response.getReturncode())) {
                return new RespBase(Code.SUCCESS, response.getData(), "GETTEMPORARYPAYLOG");
            }
            return new RespBase(Code.FAIL, response.getData().toString());
        }
        catch (Exception e) {
            return Code.FAIL.getRespBase(new Object[]{"-1", e.getMessage()});
        }
    }

    public RespBase getInsertCashLog(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        log.info("getInsertCashLog==>" + jsonObject.toJSONString());
        try {
            ServiceResponse response = this.syjMainLogServiceImpl.getInsertCashLog(session, jsonObject);
            log.info("getInsertCashLog==>response:" + response.toString());
            if ("0".equals(response.getReturncode())) {
                return new RespBase(Code.SUCCESS, response.getData(), "GETINSERTCASHLOG");
            }
            return new RespBase(Code.FAIL, response.getData(), "GETINSERTCASHLOG");
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Code.FAIL.getRespBase(new Object[]{"-1", e.getMessage()});
        }
    }

    public RespBase insertCash(ServiceSession session, ResqVo vo, JSONObject jsonObject) {
        log.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u5165\u91d1", jsonObject.toJSONString()});
        RespBase response = this.syjMainLogServiceImpl.insertCash(session, jsonObject);
        log.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{jsonObject.getString("flowNo"), "\u5165\u91d1", JSONObject.toJSONString((Object)response)});
        return response;
    }

    public RespBase uploadData(JSONObject param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((String)param.getString("syyh"))) {
            queryWrapper.eq((Object)"syjh", (Object)param.getString("syyh"));
        }
        if (StringUtils.isNotBlank((String)param.getString("mkt"))) {
            queryWrapper.eq((Object)"mkt", (Object)param.getString("mkt"));
        }
        if (StringUtils.isNotBlank((String)param.getString("erpCode"))) {
            queryWrapper.eq((Object)"erpCode", (Object)param.getString("erpCode"));
        }
        if (StringUtils.isNotBlank((String)param.getString("beginTime"))) {
            queryWrapper.ge((Object)"updateDate", (Object)param.getString("beginTime"));
        }
        if (StringUtils.isNotBlank((String)param.getString("endTime"))) {
            queryWrapper.le((Object)"updateDate", (Object)param.getString("endTime"));
        }
        if (StringUtils.isNotBlank((String)param.getString("synstatus"))) {
            queryWrapper.isNull((Object)"synstatus");
        }
        log.info("\u67e5\u8be2\u5230syjmainlog\u5165\u53c2\uff1a" + param.toJSONString());
        List list = this.syjMainLogService.getSyjMainLog(param);
        log.info("\u67e5\u8be2\u5230syjmainlog\u65e5\u5fd7\u4e3a{}\u6761:{}", (Object)list.size(), (Object)JSONArray.toJSONString((Object)list));
        if (ArrayUtils.isNotEmpty((List)list)) {
            try {
                log.info("\u4e0a\u4f20\u672c\u5730syjmainlog\u65e5\u5fd7!");
                JSONObject request = new JSONObject();
                request.put("list", (Object)list);
                request.put("command_id", (Object)"UPLOADSYJMAINLOG");
                String response = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)"UTF-8", (String)JSONObject.toJSONString((Object)request), (int)5000, (int)15000);
                log.info("\u4e0a\u4f20\u672c\u5730syjmainlog\u65e5\u5fd7\u8fd4\u56de==>{}", (Object)response);
                if (StringUtils.isNotBlank((String)response)) {
                    RespBase respBase = (RespBase)JSONObject.parseObject((String)response, RespBase.class);
                    JSONObject jsonResponse = JSONObject.parseObject((String)response);
                    int retFlag = jsonResponse.getInteger("returncode");
                    respBase.setRetflag(retFlag);
                    if (0 != retFlag) {
                        respBase.setRetmsg(jsonResponse.getString("data"));
                        return respBase;
                    }
                }
                SyjMainLogModel syjMainLogModel = new SyjMainLogModel();
                syjMainLogModel.setSynstatus("0");
                boolean b = this.syjMainLogService.update((Object)syjMainLogModel, (Wrapper)queryWrapper);
                if (b) {
                    log.info("\u672c\u5730syjmainlog\u65e5\u5fd7\u79fb\u9664\u6210\u529f{}\u6761,begin:{},end{}", new Object[]{list.size(), param.getString("beginTime"), param.getString("endTime")});
                } else {
                    log.info("\u672c\u5730syjmainlog\u65e5\u5fd7\u79fb\u9664\u5931\u8d25");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.info("\u7cfb\u7edf\u521d\u59cb\u5316\u8fde\u63a5\u7ebf\u4e0a\u5f02\u5e38:", (Throwable)e);
                return Code.FAIL.getRespBase(new Object[0]);
            }
        }
        return new RespBase(Code.SUCCESS, (Object)new ResqVo());
    }

    public boolean saveBatch(JSONObject param) {
        JSONArray jsonList = param.getJSONArray("list");
        List list = JSONArray.parseArray((String)jsonList.toJSONString(), SyjMainLogModel.class);
        if (ArrayUtils.isNotEmpty((List)list)) {
            String obj = this.redisUtil.get(RedisKey.CACHEID + ((SyjMainLogModel)list.get(0)).getMkt() + ((SyjMainLogModel)list.get(0)).getSyjh());
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            String timeZone = modeDetailsVo.getSysparainfo().getTimeZone();
            for (SyjMainLogModel syjMainLog : list) {
                syjMainLog.setUpdateDate(TimeZoneUtil.ConvertTimeByTimeZone((Date)syjMainLog.getUpdateDate(), (String)timeZone));
            }
            boolean b = this.syjMainLogService.saveBatch((Collection)list, "syjmainlog");
            SyjMainLogModel syjMainLogModel = (SyjMainLogModel)ArrayUtils.getFirstOne((List)list);
            if (b) {
                log.info("\u4e0a\u4f20\u6210\u529f!{}\u6761\u8bb0\u5f55", (Object)jsonList.size());
                QueryWrapper queryWrapper = new QueryWrapper();
                queryWrapper.eq((Object)"erpCode", (Object)syjMainLogModel.getErpCode());
                queryWrapper.eq((Object)"mkt", (Object)syjMainLogModel.getMkt());
                queryWrapper.eq((Object)"syjh", (Object)syjMainLogModel.getSyjh());
                queryWrapper.orderByDesc((Object)"syjcurtime");
                List listAll = this.syjMainLogService.list((Wrapper)queryWrapper);
                Syjmain queryData = new Syjmain();
                queryData.setErpCode(syjMainLogModel.getErpCode());
                queryData.setSyjh(syjMainLogModel.getSyjh());
                queryData.setMkt(syjMainLogModel.getMkt());
                Syjmain syjmain = this.syjMainRemoteService.selectOneByMKTAndSYJ(queryData);
                log.info("\u540c\u6b65\u8c03\u7528init\u8fd4\u56de\u6536\u94f6\u673a\u4fe1\u606f\uff1a" + JSON.toJSONString((Object)syjmain));
                if (listAll.size() > 0) {
                    SyjMainLogModel syjMainLogModelNew = (SyjMainLogModel)ArrayUtils.getFirstOne((List)listAll);
                    if (null != syjMainLogModelNew.getSyjcurpreje()) {
                        syjmain.setSyjcurpreje(syjMainLogModelNew.getSyjcurpreje());
                    }
                    if (null != syjMainLogModelNew.getSyjcurcashje()) {
                        syjmain.setSyjcurcashje(syjMainLogModelNew.getSyjcurcashje());
                    }
                } else {
                    syjmain.setSyjcurpreje(new BigDecimal(0));
                    syjmain.setSyjcurcashje(new BigDecimal(0));
                }
                log.info(">>>>>>>>syjmain:{}", (Object)JSONObject.toJSONString((Object)syjmain));
                boolean bool = this.syjMainRemoteService.updateByMKTAndSYJH(syjmain);
                if (bool) {
                    log.info("syjmain\u5907\u7528\u91d1\u66f4\u65b0\u6210\u529f!");
                } else {
                    log.info("syjmain\u5907\u7528\u91d1\u6ca1\u6709\u66f4\u65b0!");
                }
            } else {
                log.info("\u4e0a\u4f20\u5931\u8d25!");
            }
            return b;
        }
        log.info("\u65e0\u6570\u636e\u4e0a\u4f20!");
        return true;
    }
}

