/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.remote;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.annotation.HessianService;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.dao.PosWorkAcountService;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.model.PosWorkAcountModel;
import com.efuture.business.service.PosWorkAcountRemoteService;
import com.efuture.business.service.PosWorkAcountSaleBS;
import com.efuture.business.util.ArrayUtils;
import com.efuture.business.util.HttpClientUtils;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.ThreadContextUtils;
import com.efuture.business.util.TimeZoneUtil;
import com.product.model.ServiceSession;
import java.io.IOException;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HessianService(value="/apiPosWorkAcountRemoteService.do", interf=PosWorkAcountRemoteService.class)
@Service
public class PosWorkAcountRemoteServiceImpl
implements PosWorkAcountRemoteService {
    private static final Logger log = LoggerFactory.getLogger(PosWorkAcountRemoteServiceImpl.class);
    @Autowired
    private PosWorkAcountSaleBS posWorkAcountSaleBS;
    @Autowired
    private PosWorkAcountService posWorkAcountService;
    @Autowired
    private ThreadContextUtils threadContextUtils;
    @Autowired
    protected RedisUtil redisUtil;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map> countPosWork(ServiceSession session, JSONObject param) {
        try {
            this.threadContextUtils.setLogFlag(param);
            List list = this.posWorkAcountSaleBS.countPosWork(session, param);
            return list;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public boolean onInsert(JSONObject param) {
        try {
            this.threadContextUtils.setLogFlag(param);
            boolean bl = this.posWorkAcountSaleBS.onInsert(param);
            return bl;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public boolean saveBatch(JSONObject param) {
        JSONArray jsonList = param.getJSONArray("list");
        List list = JSONArray.parseArray((String)jsonList.toJSONString(), PosWorkAcountModel.class);
        if (ArrayUtils.isNotEmpty((List)list)) {
            String obj = this.redisUtil.get(RedisKey.CACHEID + ((PosWorkAcountModel)list.get(0)).getMkt() + ((PosWorkAcountModel)list.get(0)).getSyjh());
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            String timeZone = modeDetailsVo.getSysparainfo().getTimeZone();
            for (PosWorkAcountModel posWorkAcount : list) {
                posWorkAcount.setUpdateDate(TimeZoneUtil.ConvertTimeByTimeZone((Date)posWorkAcount.getUpdateDate(), (String)timeZone));
                posWorkAcount.setSynDate(TimeZoneUtil.ConvertTimeByTimeZone((Date)posWorkAcount.getSynDate(), (String)timeZone));
            }
            boolean b = this.posWorkAcountService.saveBatch((Collection)list, "posworkacount");
            if (b) {
                log.info("\u4e0a\u4f20\u6210\u529f!{}\u6761\u8bb0\u5f55", (Object)jsonList.size());
            } else {
                log.info("\u4e0a\u4f20\u5931\u8d25!");
            }
            return b;
        }
        log.info("\u65e0\u6570\u636e\u4e0a\u4f20!");
        return true;
    }

    public RespBase uploadData(JSONObject param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((String)param.getString("syyh"))) {
            queryWrapper.eq((Object)"syjh", (Object)param.getString("syyh"));
        }
        if (StringUtils.isNotBlank((String)param.getString("mkt"))) {
            queryWrapper.eq((Object)"mkt", (Object)param.getString("mkt"));
        }
        if (StringUtils.isNotBlank((String)param.getString("erpCode"))) {
            queryWrapper.eq((Object)"erpCode", (Object)param.getString("erpCode"));
        }
        if (StringUtils.isNotBlank((String)param.getString("beginTime"))) {
            queryWrapper.ge((Object)"updateDate", (Object)param.getString("beginTime"));
        }
        if (StringUtils.isNotBlank((String)param.getString("endTime"))) {
            queryWrapper.le((Object)"updateDate", (Object)param.getString("endTime"));
        }
        if (StringUtils.isNotBlank((String)param.getString("synstatus"))) {
            queryWrapper.isNull((Object)"synstatus");
        }
        List list = this.posWorkAcountService.list((Wrapper)queryWrapper, "posworkacount");
        log.info("\u67e5\u8be2\u5230posworkacount\u65e5\u5fd7\u4e3a{}\u6761", (Object)list.size());
        Object transactionStatus = null;
        if (ArrayUtils.isNotEmpty((List)list)) {
            try {
                boolean b;
                log.info("\u4e0a\u4f20\u672c\u5730posworkacount\u65e5\u5fd7!");
                JSONObject request = new JSONObject();
                request.put("list", (Object)list);
                request.put("command_id", (Object)"UPLOADPOSWORKACOUNT");
                String response = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)"UTF-8", (String)JSONObject.toJSONString((Object)request), (int)5000, (int)15000);
                log.info("\u4e0a\u4f20\u672c\u5730posworkacount\u65e5\u5fd7\u8fd4\u56de==>{}", (Object)response);
                if (StringUtils.isNotBlank((String)response)) {
                    RespBase respBase = (RespBase)JSONObject.parseObject((String)response, RespBase.class);
                    JSONObject jsonResponse = JSONObject.parseObject((String)response);
                    int retFlag = jsonResponse.getInteger("returncode");
                    respBase.setRetflag(retFlag);
                    if (0 != retFlag) {
                        respBase.setRetmsg(jsonResponse.getString("data"));
                        return respBase;
                    }
                }
                if (b = this.posWorkAcountService.remove((Wrapper)queryWrapper)) {
                    log.info("\u672c\u5730posworkacount\u65e5\u5fd7\u79fb\u9664\u6210\u529f{}\u6761,begin:{},end{}", new Object[]{list.size(), param.getString("beginTime"), param.getString("endTime")});
                } else {
                    log.info("\u672c\u5730posworkacount\u65e5\u5fd7\u79fb\u9664\u5931\u8d25");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.info("\u7cfb\u7edf\u521d\u59cb\u5316\u8fde\u63a5\u7ebf\u4e0a\u5f02\u5e38:", (Throwable)e);
                return Code.FAIL.getRespBase(new Object[0]);
            }
        }
        return new RespBase(Code.SUCCESS, (Object)new ResqVo());
    }
}

