/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.bean.YPopStatusType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.dao.gzyy.CategoryService_GZYY;
import com.efuture.business.dao.gzyy.SaleGoodsModelService_GZYY;
import com.efuture.business.dao.wslf.CategoryPropertyService_WSLF;
import com.efuture.business.javaPos.commonkit.Convert;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.struct.AnalyzeBarcodeDef;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.ConsumersData;
import com.efuture.business.javaPos.struct.DzcGoodsDetail;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.OperUser;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.OrderForPos;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.javaPos.struct.SysPara;
import com.efuture.business.javaPos.struct.mainDataCentre.GoodsInfo;
import com.efuture.business.javaPos.struct.mainDataCentre.request.GetGoodsDetailIn;
import com.efuture.business.javaPos.struct.mainDataCentre.response.GetGoodsDetailOut;
import com.efuture.business.javaPos.struct.posManager.request.OperUserIn;
import com.efuture.business.javaPos.struct.posManager.response.OperUserOut;
import com.efuture.business.javaPos.struct.request.ConfirmSaleReturnIn;
import com.efuture.business.javaPos.struct.request.ElectronicIn;
import com.efuture.business.model.Elecscalecoderule;
import com.efuture.business.model.Syspara;
import com.efuture.business.model.gzyy.CategoryModel_GZYY;
import com.efuture.business.model.gzyy.VIPManualDiscountVo;
import com.efuture.business.model.wslf.CategoryPropertyModel_WSLF;
import com.efuture.business.service.CalcPopRemoteService;
import com.efuture.business.service.InitializationRemoteService;
import com.efuture.business.service.VipRemoteService;
import com.efuture.business.service.localize.GoodsSaleBSImpl_WSLF;
import com.efuture.business.task.GoodsTask;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.DataExchageUtils;
import com.efuture.business.util.DefaultParametersUtils;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.UUIDUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

/*
 * Exception performing whole class analysis ignored.
 */
public class GoodsSaleBSImpl_GZYY
extends GoodsSaleBSImpl_WSLF {
    private static final Logger log = LoggerFactory.getLogger(GoodsSaleBSImpl_GZYY.class);
    @SoaAnnotation(value="/apiInitializeRemoteService.do")
    private InitializationRemoteService initializationRemoteService;
    @SoaAnnotation(value="/apiCalcPopRemoteService.do")
    private CalcPopRemoteService calcPopRemoteService;
    @Autowired
    private SaleGoodsModelService_GZYY saleGoodsModelService;
    @Autowired
    private CategoryPropertyService_WSLF categoryPropertyService;
    @Autowired
    private CategoryService_GZYY categoryService;
    @Autowired(required=false)
    GoodsTask goodsTask;
    @SoaAnnotation(value="/apiVipRemoteService.do")
    protected VipRemoteService vipRemoteService;

    public Goods getGoods(ConsumersData consumersData, Goods goods, CacheModel cacheModel) {
        return this.getErpcustdiscount(consumersData, goods, 0.0);
    }

    private Goods getErpcustdiscount(ConsumersData consumersData, Goods goods, double marketzk) {
        String precisionMode;
        if ("Y".equals(goods.getNoPricing())) {
            return goods;
        }
        if (null == consumersData || StringUtils.isEmpty((String)consumersData.getConsumersType())) {
            return goods;
        }
        if ("2".equals(consumersData.getLoginMode())) {
            return goods;
        }
        if ("10".equals(consumersData.getConsumersType()) && !"1".equals(goods.getDiscountFlag()) && goods.getMemberPrice() > 0.0) {
            precisionMode = DataExchageUtils.exchangePrecisionMode((String)goods.getPrcutMode());
            goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow((double)(goods.getSalePrice() - goods.getMemberPrice()), (String)precisionMode));
            goods.setDisMode(3);
            goods.setDisValue(goods.getMemberPrice());
            goods.setDiscType("0");
            marketzk = goods.getShareDiscount2();
        }
        if (("30".equals(consumersData.getConsumersType()) || "32".equals(consumersData.getConsumersType())) && !"1".equals(goods.getDiscountFlag()) && goods.getBulkPrice() > 0.0) {
            precisionMode = DataExchageUtils.exchangePrecisionMode((String)goods.getPrcutMode());
            goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow((double)(goods.getSalePrice() - goods.getBulkPrice()), (String)precisionMode));
            goods.setDisMode(3);
            goods.setDisValue(goods.getBulkPrice());
            goods.setDiscType("0");
            marketzk = goods.getShareDiscount1();
        }
        goods.setAdjustDiscountValue(this.posLogicCompoment.getAdjustDiscount(goods));
        goods.setTotalDiscountValue(PosLogicCompoment.getZZK((Goods)goods));
        goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert((double)(goods.getTotalDiscountValue() - goods.getNoDisAmountValue())));
        goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
        goods.setFdmode("3");
        goods.setVipfdzkfd(ManipulatePrecision.doubleConvert((double)(marketzk / 100.0), (int)4, (int)1));
        return goods;
    }

    public ServiceResponse searcheSaleGoodsDetails(ServiceSession session, JSONObject paramsObject) {
        try {
            log.info("\u67e5\u5546\u54c1{}", (Object)JSONObject.toJSONString((Object)paramsObject));
            long startTime = new Date().getTime();
            log.debug("begin process ------- " + new Date().getTime());
            if (session == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
            }
            if (!paramsObject.containsKey((Object)"entId")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"\u96f6\u552e\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!paramsObject.containsKey((Object)"shopCode")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!paramsObject.containsKey((Object)"terminalNo")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"\u6536\u94f6\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!paramsObject.containsKey((Object)"code") || StringUtils.isBlank((String)paramsObject.getString("code"))) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"\u5546\u54c1\u7f16\u7801\u6216\u6761\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!paramsObject.containsKey((Object)"erpCode")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"\u7ecf\u8425\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String goodsStatus = "";
            String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)(obj = this.reCacheMode(obj, paramsObject)).toString(), ModeDetailsVo.class);
            List sysParaList = modeDetailsVo.getSyspara();
            JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
            if (sysParaArray.size() != 0) {
                for (int i = 0; i < sysParaArray.size(); ++i) {
                    JSONObject sys = sysParaArray.getJSONObject(i);
                    if (!sys.get((Object)"code").equals("GSS")) continue;
                    goodsStatus = sys.getString("paravalue");
                }
            }
            Long entId = paramsObject.getLong("entId");
            String erpCode = paramsObject.getString("erpCode");
            if (paramsObject.containsKey((Object)"orgCode") && !StringUtils.isEmpty((String)paramsObject.getString("orgCode"))) {
                String orgCode = paramsObject.getString("orgCode");
                String[] orgCodeArray = orgCode.split(",");
                paramsObject.put("orgCode", (Object)orgCodeArray);
            }
            if (!paramsObject.containsKey((Object)"searchType") || !"2".equals(paramsObject.getString("searchType"))) {
                paramsObject.remove((Object)"orgCode");
            }
            if (!paramsObject.containsKey((Object)"goodsStatus") || StringUtils.isEmpty((String)paramsObject.getString("goodsStatus")) || paramsObject.get((Object)"goodsStatus") instanceof JSONArray && paramsObject.getJSONArray("goodsStatus").size() <= 0) {
                ArrayList<Integer> goodStauts = new ArrayList<Integer>();
                if (null != goodsStatus && !"".equals(goodsStatus)) {
                    String[] slist = goodsStatus.split(",");
                    for (String gs : slist) {
                        goodStauts.add(Integer.valueOf(gs));
                    }
                }
                paramsObject.put("goodsStatus", goodStauts);
            }
            DefaultParametersUtils.removeEmptyParams((JSONObject)paramsObject);
            log.debug("start searchSaleGoodsDetails ------- " + new Date().getTime());
            if (StringUtils.isBlank((String)paramsObject.getString("code"))) {
                log.debug("code is null" + paramsObject);
            }
            paramsObject.put("barNo", paramsObject.get((Object)"code"));
            List list = this.saleGoodsModelService.splitSearchSaleGoodsDetails(paramsObject);
            if (list == null || list.size() < 1) {
                paramsObject.put("goodsCode", paramsObject.get((Object)"code"));
                paramsObject.remove((Object)"barNo");
                list = this.saleGoodsModelService.splitSearchSaleGoodsDetails(paramsObject);
            }
            if (null == list || list.size() <= 0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u67e5\u8be2\u5546\u54c1\u5931\u8d25");
            }
            if (list != null && !list.isEmpty()) {
                for (Map salegoodsMap : list) {
                    Map categoryMap = this.saleGoodsModelService.splitCategoryQuery(salegoodsMap);
                    if (categoryMap != null && categoryMap.size() > 0) {
                        salegoodsMap.putAll(categoryMap);
                        continue;
                    }
                    salegoodsMap.put("artCode", "");
                    salegoodsMap.put("isFresh", "");
                    salegoodsMap.put("isChangePrice", "");
                }
            }
            log.debug("end   searchSaleGoodsDetails ------- " + new Date().getTime());
            ServiceResponse response = this.decorateResponseData4SaleGoodsDetail(session, paramsObject, list);
            if (!"0".equals(response.getReturncode())) {
                return response;
            }
            HashSet<String> categoryCodeSet = new HashSet<String>();
            if (list != null && !list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    Map tmpMap = (Map)list.get(i);
                    if (tmpMap.get("categoryCode") == null) continue;
                    categoryCodeSet.add(tmpMap.get("categoryCode").toString());
                }
            }
            QueryWrapper cpqueryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)cpqueryWrapper.eq((Object)"entId", (Object)entId)).eq((Object)"erpCode", (Object)erpCode)).eq((Object)"status", (Object)1)).in((Object)"categoryCode", categoryCodeSet);
            List categoryProperty = this.categoryPropertyService.list((Wrapper)cpqueryWrapper);
            for (int i = 0; i < list.size(); ++i) {
                Map tmpMap = (Map)list.get(i);
                ArrayList subCategoryProperty = new ArrayList();
                if (tmpMap.get("categoryCode") != null) {
                    String tmpCategoryCode = tmpMap.get("categoryCode").toString();
                    for (int j = 0; j < categoryProperty.size(); ++j) {
                        CategoryPropertyModel_WSLF model = (CategoryPropertyModel_WSLF)categoryProperty.get(j);
                        if (!tmpCategoryCode.equals(model.getCategoryCode())) continue;
                        HashMap<String, String> tmpCategoryProperty = new HashMap<String, String>();
                        tmpCategoryProperty.put("propertyName", model.getPropertyName() == null ? "" : model.getPropertyName());
                        tmpCategoryProperty.put("propertyCode", model.getPropertyCode() == null ? "" : model.getPropertyCode());
                        subCategoryProperty.add(tmpCategoryProperty);
                    }
                }
                tmpMap.put("categoryProperty", subCategoryProperty);
            }
            JSONObject result = new JSONObject();
            if (list.size() > 0 && list != null) {
                result.put("goods", (Object)list);
                result.put("total_result", (Object)list.size());
            }
            long endTime = new Date().getTime();
            log.error("countTimeOmd----" + (startTime - endTime));
            return ServiceResponse.buildSuccess((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38");
        }
    }

    public CacheModel changeSaleDate(CacheModel cacheModel, List<Syspara> syspara) {
        try {
            String date;
            String[] split;
            String ta = ModeDetailsVo.getSysParaValue(syspara, (String)"TA");
            String tb = ModeDetailsVo.getSysParaValue(syspara, (String)"TB");
            if (StringUtils.isNotBlank((String)tb) && "Y".equals(tb) && (split = ta.split("-")).length >= 2 && null != (date = GoodsSaleBSImpl_GZYY.computeSaleDate((String)split[0], (String)split[1]))) {
                cacheModel.getOrder().setSaleDate(date);
            }
        }
        catch (Exception e) {
            log.error("\u4fee\u6539SaleDate\u5f02\u5e38");
            e.printStackTrace();
        }
        return cacheModel;
    }

    public static String computeSaleDate(String start, String end) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Calendar calendar;
            Date nowDate = new Date();
            String searchDate = dateFormat.format(nowDate);
            start = searchDate + " " + start;
            end = searchDate + " " + end;
            String format = "";
            if (start.length() == "yyyy-MM-dd HH:mm".length()) {
                format = "yyyy-MM-dd HH:mm";
                dateFormat = new SimpleDateFormat(format);
            } else if (start.length() == "yyyy-MM-dd HH:mm:ss".length()) {
                format = "yyyy-MM-dd HH:mm:ss";
                dateFormat = new SimpleDateFormat(format);
            }
            Date startDate = dateFormat.parse(start);
            Date endDate = dateFormat.parse(end);
            if (endDate.before(startDate)) {
                if (nowDate.before(endDate)) {
                    calendar = Calendar.getInstance();
                    calendar.setTime(dateFormat.parse(start));
                    calendar.add(5, -1);
                    startDate = calendar.getTime();
                } else {
                    calendar = Calendar.getInstance();
                    calendar.setTime(dateFormat.parse(end));
                    calendar.add(5, 1);
                    endDate = calendar.getTime();
                }
            }
            if (endDate.before(startDate) && nowDate.before(endDate)) {
                calendar = Calendar.getInstance();
                calendar.setTime(dateFormat.parse(start));
                calendar.add(5, -1);
                startDate = calendar.getTime();
            }
            if (nowDate.after(startDate) && nowDate.before(endDate)) {
                dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                String date = dateFormat.format(startDate);
                return date;
            }
            return null;
        }
        catch (Exception e) {
            log.error("\u5224\u7aef\u5f53\u524d\u65f6\u95f4\u662f\u5426\u5728\u67d0\u4e2a\u65f6\u95f4\u6bb5\u5f02\u5e38: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public RespBase vipManualDiscount(ServiceSession session, ResqVo vo) {
        JSONObject paramsObject = vo.getJsonObject();
        log.info("GoodsSaleBSImpl_GZYY vipManualDiscount begin param:{}", (Object)paramsObject.toJSONString());
        VIPManualDiscountVo manualDiscountVo = (VIPManualDiscountVo)JSONObject.parseObject((String)paramsObject.toJSONString(), VIPManualDiscountVo.class);
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_20047.getRespBase(new Object[0]);
        }
        if (StringUtils.isEmpty((String)manualDiscountVo.getEntId())) {
            return Code.CODE_20100.getRespBase(new Object[]{"\u96f6\u552e\u5546ID"});
        }
        if (StringUtils.isEmpty((String)manualDiscountVo.getErpCode())) {
            return Code.CODE_20100.getRespBase(new Object[]{"\u7ecf\u8425\u516c\u53f8\u7f16\u7801"});
        }
        if (StringUtils.isEmpty((String)manualDiscountVo.getGuid())) {
            return Code.CODE_20100.getRespBase(new Object[]{"guid"});
        }
        if (StringUtils.isEmpty((String)manualDiscountVo.getManualType())) {
            return Code.CODE_20100.getRespBase(new Object[]{"\u624b\u5de5\u7c7b\u578b"});
        }
        if (!"1".equals(manualDiscountVo.getManualType()) && !"0".equals(manualDiscountVo.getManualType())) {
            return Code.CODE_20101.getRespBase(new Object[]{"\u624b\u5de5\u7c7b\u578b\u4e0d\u5408\u6cd5"});
        }
        CacheModel cacheModel = vo.getCacheModel();
        ConsumersData consumersData = cacheModel.getOrder().getConsumersData();
        if (null == consumersData || StringUtils.isEmpty((String)consumersData.getConsumersType())) {
            return Code.CODE_20101.getRespBase(new Object[]{"\u8bf7\u5148\u767b\u9646\u4f1a\u5458"});
        }
        if ("2".equals(consumersData.getLoginMode())) {
            return Code.CODE_20101.getRespBase(new Object[]{"\u201cVIP\u6263\u5206\u201d\u65b9\u5f0f\u767b\u9646\uff0c\u5546\u54c1\u4e0d\u4eab\u53d7\u4f1a\u5458\u4ef7!"});
        }
        List goodsList = cacheModel.getGoodsList();
        Goods goods = null;
        for (Goods orderGoods : goodsList) {
            if (!manualDiscountVo.getGuid().equals(orderGoods.getGuid())) continue;
            goods = orderGoods;
        }
        if (null == goods) {
            return Code.CODE_20121.getRespBase(new Object[0]);
        }
        if (!"Y".equals(goods.getNoPricing())) {
            return Code.CODE_20122.getRespBase(new Object[0]);
        }
        double vipDiscount = 100.0;
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"entId", (Object)paramsObject.getString("entId"));
        queryWrapper.eq((Object)"erpCode", (Object)paramsObject.getString("erpCode"));
        queryWrapper.eq((Object)"categoryCode", (Object)goods.getCategoryCode());
        CategoryModel_GZYY categoryModel = this.categoryService.selectOne(queryWrapper, paramsObject.getString("shopCode"), "category");
        HashMap<String, Double> map = new HashMap<String, Double>();
        if ("10".equals(consumersData.getConsumersType())) {
            double d = vipDiscount = categoryModel.getVIPDiscount() == 0.0 ? 100.0 : categoryModel.getVIPDiscount() * 100.0;
        }
        if ("30".equals(consumersData.getConsumersType()) || "32".equals(consumersData.getConsumersType())) {
            vipDiscount = categoryModel.getSaleDiscount() == 0.0 ? 100.0 : categoryModel.getSaleDiscount() * 100.0;
        }
        log.info("vipDiscount :{}", (Object)vipDiscount);
        if ("1".equals(manualDiscountVo.getManualType())) {
            map.put("vipDiscount", vipDiscount);
            return new RespBase(Code.SUCCESS, map);
        }
        if (manualDiscountVo.getVipManualDiscount() < vipDiscount) {
            return Code.CODE_20101.getRespBase(new Object[]{"\u624b\u5de5\u6298\u6263\u7387\u65e0\u6548!"});
        }
        double discountRate = ManipulatePrecision.doubleConvert((double)(manualDiscountVo.getVipManualDiscount() / 100.0));
        log.info("discountRate :{}", (Object)discountRate);
        String precisionMode = DataExchageUtils.exchangePrecisionMode((String)goods.getPrcutMode());
        discountRate = ManipulatePrecision.sub((double)1.0, (double)discountRate);
        goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow((double)(goods.getSaleValue() * discountRate), (String)precisionMode));
        goods.setDisValue(discountRate);
        goods.setDisMode(2);
        goods.setDiscType("0");
        goods.setAdjustDiscountValue(this.posLogicCompoment.getAdjustDiscount(goods));
        goods.setTotalDiscountValue(PosLogicCompoment.getZZK((Goods)goods));
        goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert((double)(goods.getTotalDiscountValue() - goods.getNoDisAmountValue())));
        goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
        for (int i = 0; i < goods.getPopDetailsInfo().size(); ++i) {
            PopDetail pop = (PopDetail)goods.getPopDetailsInfo().get(i);
            if (!YPopStatusType.pop_policy_group_barcode_discB.equals(pop.getPopPolicyGroup())) continue;
            goods.getPopDetailsInfo().remove(pop);
            --i;
        }
        log.info("barcodeDiscount :{}|adjustDiscountValue:{}|totalDiscountValue:{}|realTotalDiscountValue:{}|saleAmount:{}", new Object[]{goods.getBarcodeDiscount(), goods.getAdjustDiscountValue(), goods.getTotalDiscountValue(), goods.getRealTotalDiscountValue(), goods.getSaleAmount()});
        RespBase respBase = this.calcPopRemoteService.calcSinglePopAfterVipService(session, vo, true);
        if (respBase.getRetflag() != 0) {
            return respBase;
        }
        ResqVo req = (ResqVo)respBase.getData();
        cacheModel = req.getCacheModel();
        this.posLogicCompoment.calcOrderAmount(cacheModel);
        BaseOutModel out = new BaseOutModel();
        OrderForPos order = OrderForPos.toOrderForPosSingle((CacheModel)cacheModel);
        out.setOrder(order);
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "VIPMANUALDISCOUNT");
    }

    public RespBase merchantDiscountAllocation(ServiceSession session, ResqVo vo) {
        JSONObject paramsObject = vo.getJsonObject();
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_20047.getRespBase(new Object[0]);
        }
        if (!paramsObject.containsKey((Object)"guid")) {
            return Code.CODE_20100.getRespBase(new Object[]{"\u5546\u54c1guid"});
        }
        if (!paramsObject.containsKey((Object)"handmadeRate")) {
            return Code.CODE_20100.getRespBase(new Object[]{"\u624b\u5de5\u6307\u5b9a\u6298\u6263\u5206\u62c5\u6bd4\u7387"});
        }
        if (paramsObject.getDouble("handmadeRate") <= 0.0) {
            return Code.CODE_20101.getRespBase(new Object[]{"\u624b\u5de5\u6307\u5b9a\u6298\u6263\u5206\u62c5\u6bd4\u7387\u65e0\u6548"});
        }
        CacheModel cacheModel = vo.getCacheModel();
        List goodsList = cacheModel.getGoodsList();
        for (Goods goods : goodsList) {
            if (!paramsObject.getString("guid").equals(goods.getGuid())) continue;
            double fdzkfd = ManipulatePrecision.doubleConvert((double)(paramsObject.getDouble("handmadeRate") / 100.0), (int)4, (int)1);
            goods.setFdzkfd(fdzkfd);
            goods.setHandmadeFlag(true);
            goods.setFdmode("3");
        }
        BaseOutModel out = new BaseOutModel();
        OrderForPos order = OrderForPos.toOrderForPosSingle((CacheModel)cacheModel);
        out.setOrder(order);
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "VIPMANUALDISCOUNT");
    }

    public RespBase isAllowEditQty(CacheModel cacheModel, int flowId, double qty) {
        Goods sg = (Goods)cacheModel.getGoodsList().get(flowId - 1);
        if (null == sg) {
            return Code.CODE_20090.getRespBase(new Object[]{"\u672a\u627e\u5230\u4fee\u6539\u5546\u54c1"});
        }
        if (sg.getEscaleFlag().equals("Y")) {
            return Code.CODE_20090.getRespBase(new Object[]{"\u7535\u5b50\u79e4\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u91cf"});
        }
        if (sg.getFlag().equals("0")) {
            return Code.CODE_20090.getRespBase(new Object[]{"\u8d60\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u91cf"});
        }
        if (sg.getControlFlag()) {
            return Code.CODE_20090.getRespBase(new Object[]{"\u7ba1\u5236\u5546\u54c1\u4e0d\u5141\u8bb8\u4fee\u6539\u6570\u91cf"});
        }
        if (!"Y".equals(sg.getIsWeight()) && qty != (double)((int)qty)) {
            return Code.CODE_20090.getRespBase(new Object[]{"\u8be5\u5546\u54c1\u53ea\u80fd\u6574\u4ef6\u9500\u552e"});
        }
        return Code.SUCCESS.getRespBase(new Object[0]);
    }

    public RespBase confirmSalesReturn(ServiceSession session, ResqVo vo) {
        JSONObject paramsObject = vo.getJsonObject();
        ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
        if (!paramsValidateUtils.validate()) {
            return Code.CODE_20071.getRespBase(new Object[0]);
        }
        ConfirmSaleReturnIn confirmSalesReturnIn = (ConfirmSaleReturnIn)JSON.parseObject((String)paramsObject.toJSONString(), ConfirmSaleReturnIn.class);
        CacheModel cacheModel = vo.getCacheModel();
        List orderGoods = cacheModel.getReturnGoodsList();
        List selectGoods = confirmSalesReturnIn.getGoodsList();
        ArrayList<Goods> returnGoods = new ArrayList<Goods>();
        int i = 0;
        if (cacheModel.getOrder().getOriginOrderState() == 7 && (cacheModel.getOrder().getOriginLogisticsState() == 16 || cacheModel.getOrder().getOriginLogisticsState() == 1) && orderGoods.size() != selectGoods.size()) {
            return Code.CODE_20072.getRespBase(new Object[0]);
        }
        double refundAmount = 0.0;
        block0: for (Goods goodsA : selectGoods) {
            for (Goods goodsB : orderGoods) {
                ServiceResponse resp;
                if (!goodsB.getGuid().equals(goodsA.getGuid())) continue;
                if (goodsB.getAllowReturnCopies() <= 0.0) {
                    return Code.CODE_20073.getRespBase(new Object[]{goodsB.getGoodsCode(), goodsB.getAllowReturnCopies()});
                }
                Goods goods = new Goods();
                String precisionMode = DataExchageUtils.exchangePrecisionMode((String)goodsB.getPrcutMode());
                if ("2".equals(cacheModel.getOrder().getOrderType())) {
                    goods = goodsB.deepClone();
                    goods.setTempZrDiscount(goods.getAdjustDiscountValue());
                } else {
                    goods = goodsB.deepCloneWithOutPopInfo();
                }
                String jyms = SysPara.getSysParaInfo((List)cacheModel.getSysPara(), (String)"JYMS");
                String artCode = "";
                String serchType = "1";
                GetGoodsDetailIn getGoodsDetailIn = new GetGoodsDetailIn();
                getGoodsDetailIn.setEntId(cacheModel.getOrder().getEntId());
                getGoodsDetailIn.setShopCode(cacheModel.getOrder().getShopCode());
                getGoodsDetailIn.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                getGoodsDetailIn.setCode(goods.getBarNo());
                getGoodsDetailIn.setSearchType(serchType);
                getGoodsDetailIn.setOrgCode(goods.getOrgCode());
                getGoodsDetailIn.setErpCode(cacheModel.getOrder().getErpCode());
                if (vo.getJsonObject().containsKey((Object)"splitCode")) {
                    getGoodsDetailIn.setSplitCode(vo.getJsonObject().getString("splitCode"));
                }
                if (!"0".equals((resp = this.searcheSaleGoodsDetails(session, (JSONObject)JSON.toJSON((Object)getGoodsDetailIn))).getReturncode())) {
                    return Code.CODE_20074.getRespBase(new Object[0]);
                }
                GetGoodsDetailOut goodsDetailOut = (GetGoodsDetailOut)JSON.parseObject((String)JSON.toJSONString((Object)resp.getData()), GetGoodsDetailOut.class);
                if (goodsDetailOut.getGoods() != null && goodsDetailOut.getGoods().size() > 0) {
                    GoodsInfo goodsInfo = (GoodsInfo)goodsDetailOut.getGoods().get(0);
                    artCode = goodsInfo.getArtCode();
                    goods.setOutputTax(goodsInfo.getOutputTax());
                    goods.setBrandCode(goodsInfo.getBrandCode());
                    goods.setCategoryCode(goodsInfo.getCategoryCode());
                }
                goods.setArtCode(artCode);
                if ("1".equals(jyms)) {
                    goods.setTempCategory(goods.getArtCode());
                } else {
                    goods.setTempCategory(goods.getCategoryCode());
                }
                goods.setOriginalFlowId(goodsB.getFlowId());
                goods.setFlowId(++i);
                if (goodsA.getQty() != goods.getAllowReturnCopies() && cacheModel.getOrder().getOriginOrderState() == 7 && (cacheModel.getOrder().getOriginLogisticsState() == 16 || cacheModel.getOrder().getOriginLogisticsState() == 1) && orderGoods.size() != selectGoods.size()) {
                    return Code.CODE_20075.getRespBase(new Object[0]);
                }
                if (goodsA.getQty() > goods.getAllowReturnCopies()) {
                    return Code.CODE_20076.getRespBase(new Object[]{goods.getGuid(), goodsA.getQty(), goods.getAllowReturnCopies()});
                }
                if (goods.getQty() != goodsA.getQty()) {
                    if (cacheModel.getOrder().getIsAllReturn()) {
                        cacheModel.getOrder().setIsAllReturn(false);
                    }
                    goods.setSaleValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getSaleValue() * goodsA.getQty() / goodsB.getQty()), (String)precisionMode));
                    goods.setCouponValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getCouponValue() * goodsA.getQty() / goodsB.getQty()), (String)precisionMode));
                    goods.setPopDiscountValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getPopDiscountValue() * goodsA.getQty() / goodsB.getQty()), (String)precisionMode));
                    goods.setAdjustDiscountValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getAdjustDiscountValue() * goodsA.getQty() / goodsB.getQty()), (String)precisionMode));
                    goods.setCustomDiscountValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getCustomDiscountValue() * goodsA.getQty() / goodsB.getQty()), (String)precisionMode));
                    goods.setMealDiscountValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getMealDiscountValue() * goodsA.getQty() / goodsB.getQty()), (String)precisionMode));
                    goods.setPayDiscountValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getPayDiscountValue() * goodsA.getQty() / goodsB.getQty()), (String)precisionMode));
                    goods.setStudentCardDiscountValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getStudentCardDiscountValue() * goodsA.getQty() / goodsB.getQty()), (String)precisionMode));
                    goods.setTotalDiscountValue(PosLogicCompoment.getZZK((Goods)goods));
                }
                goods.setSaleAmount(ManipulatePrecision.getDetailOverFlow((double)(goods.getSaleValue() - goods.getTotalDiscountValue()), (String)precisionMode));
                goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert((double)(goods.getTotalDiscountValue() - goods.getNoDisAmountValue())));
                goods.setQty(goodsA.getQty());
                returnGoods.add(goods);
                refundAmount += goods.getSaleAmount();
                continue block0;
            }
        }
        if (cacheModel.getOrder().getOrderType() != null && !cacheModel.getOrder().getOrderType().equals("2") && refundAmount > cacheModel.getCurGrant().getPrivthje()) {
            return new RespBase(Code.CODE_1000.getIndex(), "\u9000\u8d27\u91d1\u989d\u8d85\u51fa\u5f53\u524d\u6388\u6743\u4eba\u5458\u6743\u9650\u91d1\u989d", (Object)vo);
        }
        if (cacheModel.getOrder().getIsAllReturn() && returnGoods.size() != orderGoods.size()) {
            cacheModel.getOrder().setIsAllReturn(false);
        }
        cacheModel.setGoodsList(returnGoods);
        if (null != cacheModel.getOrder().getConsumersData() && null != cacheModel.getOrder().getConsumersData().getConsumersId()) {
            JSONObject json = new JSONObject();
            json.put("vcode", (Object)cacheModel.getOrder().getConsumersData().getConsumersId());
            json.put("vmkt", (Object)cacheModel.getOrder().getShopCode());
            json.put("certifyType", (Object)"VIPLOGIN");
            RespBase respBase = this.vipRemoteService.findVip(session, json);
            if (respBase.getRetflag() == 0) {
                Order order = cacheModel.getOrder();
                ConsumersData custData = (ConsumersData)respBase.getData();
                if (StringUtils.isBlank((String)custData.getConsumersCard())) {
                    return new RespBase(Code.CODE_40001, cacheModel.getFlowNo());
                }
                custData.setConsumsersStatus("0");
                custData.setLoginMode(cacheModel.getOrder().getExtendFt2());
                order.setTotalPoint(CastUtil.castDouble((Object)custData.getPoint()));
                order.setPointCardNo(custData.getConsumersCard());
                order.setExtendFt2(cacheModel.getOrder().getExtendFt2());
                order.setConsumersData(custData);
                cacheModel.setOrder(order);
            }
        }
        this.posLogicService.calcOrderAmount(cacheModel);
        this.posLogicService.calcPayBalance(cacheModel);
        if (cacheModel.getCalcResult() == -1) {
            return Code.CODE_20078.getRespBase(new Object[]{cacheModel.getErrMsg()});
        }
        if (null != confirmSalesReturnIn.getOrderType() && SellType.ISBACK((String)confirmSalesReturnIn.getOrderType())) {
            cacheModel.getOrder().setOrderType(confirmSalesReturnIn.getOrderType());
        }
        if (null != cacheModel.getOrder().getConsumersData() && StringUtils.isNotBlank((String)cacheModel.getOrder().getConsumersData().getConsumersCard())) {
            cacheModel = this.loginMemberForRefund(session, vo, cacheModel);
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPosSingle((CacheModel)cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "FINISHBACKSALE");
    }

    public RespBase electronicInvoicing(ServiceSession session, ResqVo vo) {
        JSONObject paramsObject = vo.getJsonObject();
        ElectronicIn in = (ElectronicIn)JSONObject.toJavaObject((JSON)paramsObject, ElectronicIn.class);
        if (!paramsObject.containsKey((Object)"barCode") || paramsObject.getString("barCode").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u7535\u5b50\u5f00\u7968\u8c03\u51fa\u5fc5\u987b\u5305\u542b\u53c2\u6570[barCode]");
        }
        if (in.getBarCode().startsWith("..")) {
            return this.discountCalc(session, vo);
        }
        CacheModel cacheModel = vo.getCacheModel();
        String obj = this.redisUtil.get(RedisKey.CACHEID + in.getShopCode() + in.getTerminalNo());
        obj = this.reCacheMode(obj, paramsObject);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        List syspara = modeDetailsVo.getSyspara();
        String jyms = ModeDetailsVo.getSysParaValue((List)syspara, (String)"JYMS");
        String mode = ModeDetailsVo.getSysParaValue((List)syspara, (String)"CJZKL");
        String barCodeContent = in.getBarCode();
        String consumersType = "";
        double saleValue = 0.0;
        double qty = 0.0;
        String goodsContent = "";
        double vipDiscountRate = 0.0;
        String jffs = "";
        String popMode = "";
        String discountBurden = "";
        double discountRate = 0.0;
        double discountAmount = 0.0;
        double businessRatio = 0.0;
        String accreditNo = "";
        log.info("\u4e8c\u7ef4\u7801\u6570\u636e\u957f\u5ea6\uff1a" + barCodeContent.length());
        try {
            goodsContent = barCodeContent.substring(0, 8).trim();
            if (goodsContent.startsWith("0")) {
                goodsContent = String.valueOf(Integer.parseInt(goodsContent));
            }
            saleValue = CastUtil.castDouble((Object)barCodeContent.substring(9, 16).trim()) / 100.0;
            qty = CastUtil.castDouble((Object)barCodeContent.substring(16, 18).trim());
            consumersType = barCodeContent.substring(18, 20).trim();
            vipDiscountRate = CastUtil.castDouble((Object)barCodeContent.substring(20, 22).trim()) / 100.0;
            jffs = barCodeContent.substring(22, 23).trim();
            popMode = barCodeContent.substring(23, 24).trim();
            discountBurden = barCodeContent.substring(24, 25).trim();
            if ("1".equals(popMode)) {
                discountRate = CastUtil.castDouble((Object)barCodeContent.substring(25, 31).trim());
            } else if ("2".equals(popMode)) {
                discountAmount = CastUtil.castDouble((Object)barCodeContent.substring(25, 31).trim()) / 100.0;
            }
            businessRatio = CastUtil.castDouble((Object)barCodeContent.substring(31, 33).trim()) / 100.0;
        }
        catch (Exception e) {
            e.printStackTrace();
            return new RespBase(Code.CODE_60001.getIndex(), "\u7535\u5b50\u5f00\u7968\u8c03\u51fa\u7801\u4e0d\u6b63\u786e");
        }
        if ("1".equals(discountBurden)) {
            accreditNo = "2148";
        } else if ("2".equals(discountBurden)) {
            accreditNo = "3898";
        } else if ("3".equals(discountBurden)) {
            accreditNo = "3928";
        } else if ("4".equals(discountBurden)) {
            accreditNo = "3928";
        }
        if ("Y".equals(mode)) {
            discountRate = Double.valueOf(100.0) - discountRate;
        }
        if ("4".equals(jffs)) {
            jffs = "1";
        } else if ("6".equals(jffs)) {
            jffs = "2";
        }
        Order order = cacheModel.getOrder();
        cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
        log.info("\u6821\u9a8c\u4f1a\u5458");
        if (StringUtils.isNotBlank((String)consumersType) && !"00".equals(consumersType)) {
            if (null == cacheModel.getOrder().getConsumersData() || StringUtils.isBlank((String)cacheModel.getOrder().getConsumersData().getConsumersCard())) {
                return new RespBase(Code.CODE_60028.getIndex(), "\u8bf7\u5148\u626b\u7801\u4f1a\u5458\u7801");
            }
            if (!consumersType.equals(cacheModel.getOrder().getConsumersData().getConsumersType())) {
                return new RespBase(Code.CODE_60028.getIndex(), "\u4f1a\u5458\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u5237\u4f1a\u5458");
            }
            if (!jffs.equals(cacheModel.getOrder().getConsumersData().getLoginMode())) {
                return new RespBase(Code.CODE_60028.getIndex(), "\u4f1a\u5458\u767b\u5f55\u7c7b\u578b\u4e0d\u4e00\u81f4\uff0c\u8bf7\u91cd\u65b0\u5237\u4f1a\u5458");
            }
        }
        String originalBarNo = goodsContent;
        log.info("\u6dfb\u52a0\u5546\u54c1-start");
        Goods goods = new Goods();
        GoodsInfo goodsInfo = null;
        GetGoodsDetailIn getGoodsDetailIn = new GetGoodsDetailIn();
        List goodsInfos = null;
        boolean isdzcm = false;
        boolean isNeedFindMdm = true;
        boolean isNeedFindDzc = true;
        int barNoMode = 0;
        if ("1".equals(cacheModel.getEleCodeMode())) {
            barNoMode = 1;
        }
        if ("1".equals(jyms)) {
            barNoMode = 2;
        }
        AnalyzeBarcodeDef codeInfo = null;
        DzcGoodsDetail dzc = new DzcGoodsDetail();
        String splitCode = null;
        if (isNeedFindMdm) {
            codeInfo = this.analyzeCodeInfo(barNoMode, goodsContent, "0");
            if (!codeInfo.getValidate()) {
                return Code.CODE_20004.getRespBase(new Object[0]);
            }
            goodsContent = codeInfo.getBarNo();
            isNeedFindDzc = codeInfo.getIsNeedFindDzc();
            barNoMode = codeInfo.getBarNoMode();
            List elecCodeRules = modeDetailsVo.getElecscalecoderule();
            if (isNeedFindDzc && elecCodeRules.size() > 0) {
                dzc = this.posLogicService.analyzeBarcode(goodsContent, elecCodeRules, ((Elecscalecoderule)elecCodeRules.get(0)).getExpModeMMDDDays(), ((Elecscalecoderule)elecCodeRules.get(0)).getExpModeDDHHDays(), cacheModel.getEleCodeMode());
                if (dzc.getRetCode() == 2) {
                    return Code.CODE_20006.getRespBase(new Object[0]);
                }
                if (dzc.getRetCode() == 1) {
                    isdzcm = true;
                }
            }
            String serchType = "1";
            getGoodsDetailIn.setEntId(session.getEnt_id());
            getGoodsDetailIn.setShopCode(in.getShopCode());
            getGoodsDetailIn.setTerminalNo(in.getTerminalNo());
            getGoodsDetailIn.setCode(goodsContent);
            getGoodsDetailIn.setSearchType(serchType);
            getGoodsDetailIn.setErpCode(cacheModel.getOrder().getErpCode());
            if (isdzcm) {
                if (barNoMode == 2 && dzc.getCode().length() < 9) {
                    getGoodsDetailIn.setCode(Convert.padLeft((String)dzc.getCode(), (char)'0', (int)9));
                } else if (barNoMode == 3 && dzc.getCode().length() < 8) {
                    getGoodsDetailIn.setCode(Convert.padLeft((String)dzc.getCode(), (char)'0', (int)8));
                } else {
                    getGoodsDetailIn.setCode(dzc.getCode());
                }
                getGoodsDetailIn.setChannel(order.getChannel());
                if (StringUtils.isNotBlank(splitCode)) {
                    getGoodsDetailIn.setSplitCode(splitCode);
                }
                goodsInfos = this.GetGoodsInfo(getGoodsDetailIn, session);
            } else {
                if (barNoMode == 2 && goodsContent.length() < 9) {
                    getGoodsDetailIn.setCode(Convert.padLeft((String)goodsContent, (char)'0', (int)9));
                } else if (barNoMode == 3 && goodsContent.length() < 8) {
                    getGoodsDetailIn.setCode(Convert.padLeft((String)goodsContent, (char)'0', (int)8));
                } else {
                    getGoodsDetailIn.setCode(goodsContent);
                }
                if (StringUtils.isNotBlank(splitCode)) {
                    getGoodsDetailIn.setSplitCode(splitCode);
                }
                getGoodsDetailIn.setChannel(order.getChannel());
                if (isNeedFindMdm) {
                    goodsInfos = this.GetGoodsInfo(getGoodsDetailIn, session);
                }
            }
        }
        if (null == goodsInfos || goodsInfos.size() == 0) {
            return Code.CODE_20087.getRespBase(new Object[0]);
        }
        goodsInfo = (GoodsInfo)goodsInfos.get(0);
        goods = this.posLogicService.CalcGoodsAmountBeforeSingle(goodsInfo, accreditNo, isdzcm, dzc.getDzcmsl(), dzc.getDzcmjg(), cacheModel.getEleCodeMode(), originalBarNo, qty, true);
        String precisionMode = DataExchageUtils.exchangePrecisionMode((String)goods.getPrcutMode());
        goodsInfo.fixGoodsInfoStr();
        if (saleValue != 0.0) {
            goods.setSalePrice(saleValue);
        }
        goods.setSaleValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getQty() * goods.getSalePrice()), (String)precisionMode));
        goods.setSaleAmount(ManipulatePrecision.getDetailOverFlow((double)(goods.getSaleValue() - goods.getTotalDiscountValue()), (String)goods.getPrcutMode()));
        goods.setCalcMode("0");
        goods.setGuid(UUIDUtils.buildGuid());
        goods.setFlowNo(in.getFlowNo());
        goods.setFlowId(cacheModel.getGoodsList().size() + 1);
        goods.setFdmode(discountBurden);
        goods.setFdzkfd(ManipulatePrecision.doubleConvert((double)businessRatio, (int)4, (int)1));
        goods.setHandmadeNumber(accreditNo);
        if ("4".equals(discountBurden)) {
            goods.setHandmadeFlag(true);
        }
        log.info("tempgoods:{}", (Object)JSONObject.toJSONString((Object)goods));
        boolean isNeedRefreshBillId = false;
        if (null == cacheModel.getGoodsList() || cacheModel.getGoodsList().size() == 0) {
            isNeedRefreshBillId = true;
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String nowDateTime = dateTime.format(df);
            cacheModel.getOrder().setSaleDate(nowDateTime);
            cacheModel = this.changeSaleDate(cacheModel, syspara);
        }
        if (StringUtils.isNotBlank((String)consumersType) && !"00".equals(consumersType)) {
            double marketzk = 0.0;
            if (saleValue == 0.0) {
                if ("1".equals(jffs) && !"1".equals(goods.getDiscountFlag())) {
                    if ("10".equals(consumersType)) {
                        goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow((double)(goods.getSalePrice() - goods.getMemberPrice()), (String)precisionMode));
                        goods.setDisMode(3);
                        goods.setDisValue(goods.getMemberPrice());
                        goods.setDiscType("0");
                        marketzk = goods.getShareDiscount2();
                    } else if ("30".equals(consumersType) || "32".equals(consumersType)) {
                        goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow((double)(goods.getSalePrice() - goods.getBulkPrice()), (String)precisionMode));
                        goods.setDisMode(3);
                        goods.setDisValue(goods.getBulkPrice());
                        goods.setDiscType("0");
                        marketzk = goods.getShareDiscount1();
                    }
                    goods.setVipfdzkfd(ManipulatePrecision.doubleConvert((double)marketzk, (int)4, (int)1));
                }
            } else if (vipDiscountRate > 0.0) {
                if ("10".equals(consumersType)) {
                    marketzk = goods.getShareDiscount2();
                } else if ("30".equals(consumersType) || "32".equals(consumersType)) {
                    marketzk = goods.getShareDiscount1();
                }
                vipDiscountRate = ManipulatePrecision.sub((double)1.0, (double)vipDiscountRate);
                goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow((double)(goods.getSaleAmount() * vipDiscountRate), (String)precisionMode));
                goods.setDisValue(vipDiscountRate);
                goods.setDisMode(2);
                goods.setDiscType("0");
                goods.setVipfdzkfd(ManipulatePrecision.doubleConvert((double)marketzk, (int)4, (int)1));
            }
            goods.setAdjustDiscountValue(this.posLogicCompoment.getAdjustDiscount(goods));
            goods.setTotalDiscountValue(PosLogicCompoment.getZZK((Goods)goods));
            goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert((double)(goods.getTotalDiscountValue() - goods.getNoDisAmountValue())));
            goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
        }
        if (cacheModel.getPopMode() == 1) {
            RespBase res = this.calcPopRemoteService.calcSinglePopService(session, "0", goods.getGuid(), goods, ResqVo.buildReqVo((CacheModel)cacheModel), null, true, isNeedRefreshBillId, false);
            if (res.getRetflag() != 0) {
                return res;
            }
            ResqVo resqVo = (ResqVo)res.getData();
            cacheModel = resqVo.getCacheModel();
            this.posLogicCompoment.calcOrderAmount(cacheModel);
        } else if (cacheModel.getPopMode() != 2) {
            this.posLogicCompoment.calcOrderAmount(cacheModel);
        }
        if (StringUtils.isNotBlank((String)accreditNo)) {
            OperUserIn posManagerOperUserIn = new OperUserIn();
            posManagerOperUserIn.setErpCode(cacheModel.getOrder().getErpCode());
            posManagerOperUserIn.setCardno(accreditNo);
            posManagerOperUserIn.setMkt(in.getShopCode());
            posManagerOperUserIn.setSyjh(in.getTerminalNo());
            JSONObject response = null;
            try {
                response = this.initializationRemoteService.empower(session, posManagerOperUserIn);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (null == response) {
                return Code.CODE_100023.getRespBase(new Object[]{"\u6388\u6743\u4eba\u5458\u4fe1\u606f"});
            }
            OperUserOut posManagerOperUserOut = (OperUserOut)JSONObject.parseObject((String)response.toJSONString(), OperUserOut.class);
            OperUser operUser = new OperUser(posManagerOperUserOut);
            cacheModel.setCurGrant(operUser);
        } else if ("1".equals(popMode) || "2".equals(popMode)) {
            return Code.CODE_60028.getRespBase(new Object[]{"\u6761\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\uff01"});
        }
        if ("1".equals(popMode)) {
            cacheModel = this.posLogicService.CalcGoodsRebateByRateBeforeSingle(cacheModel, goods.getFlowId(), accreditNo, discountRate);
            this.posLogicService.calcOrderAmount(cacheModel);
        } else if ("2".equals(popMode)) {
            cacheModel = this.posLogicService.CalcGoodsRebateByAmountBeforeSingle(cacheModel, goods.getFlowId(), accreditNo, discountAmount, 0, false);
        }
        boolean ists = false;
        if (-1 == cacheModel.getCalcResult()) {
            ists = true;
            cacheModel.setCalcResult(0);
        }
        List sortGoodsList = cacheModel.getGoodsList();
        Collections.sort(sortGoodsList, new /* Unavailable Anonymous Inner Class!! */);
        cacheModel.setGoodsList(sortGoodsList);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos((CacheModel)cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        if (ists) {
            return new RespBase(Code.CODE_5, (Object)resqVo, cacheModel.getFlowNo());
        }
        return new RespBase(Code.SUCCESS, (Object)resqVo, cacheModel.getFlowNo());
    }

    public RespBase discountCalc(ServiceSession session, ResqVo vo) {
        JSONObject paramsObject = vo.getJsonObject();
        ElectronicIn in = (ElectronicIn)JSONObject.toJavaObject((JSON)paramsObject, ElectronicIn.class);
        if (!paramsObject.containsKey((Object)"barCode") || paramsObject.getString("barCode").isEmpty()) {
            return new RespBase(Code.CODE_60001.getIndex(), "\u7535\u5b50\u5f00\u7968\u8c03\u51fa\u5fc5\u987b\u5305\u542b\u53c2\u6570[barCode]");
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (null == cacheModel.getGoodsList() || cacheModel.getGoodsList().size() == 0) {
            return new RespBase(Code.CODE_60028.getIndex(), "\u8bf7\u5148\u626b\u7801\u6761\u5f62\u7801");
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + in.getShopCode() + in.getTerminalNo());
        obj = this.reCacheMode(obj, paramsObject);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        List syspara = modeDetailsVo.getSyspara();
        String mode = ModeDetailsVo.getSysParaValue((List)syspara, (String)"CJZKL");
        String barCodeContent = in.getBarCode();
        String popMode = "";
        String discountBurden = "";
        double discountRate = 0.0;
        double discountAmount = 0.0;
        String accreditNo = "";
        log.info("\u4e8c\u7ef4\u7801\u6570\u636e\u957f\u5ea6\uff1a" + barCodeContent.length());
        try {
            popMode = barCodeContent.substring(2, 3).trim();
            discountBurden = barCodeContent.substring(3, 4).trim();
            if ("1".equals(popMode)) {
                discountRate = CastUtil.castDouble((Object)barCodeContent.substring(4, 10).trim());
            } else if ("2".equals(popMode)) {
                discountAmount = CastUtil.castDouble((Object)barCodeContent.substring(4, 10).trim()) / 100.0;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return new RespBase(Code.CODE_60001.getIndex(), "\u7535\u5b50\u5f00\u7968\u8c03\u51fa\u7801\u4e0d\u6b63\u786e");
        }
        if ("1".equals(discountBurden)) {
            accreditNo = "2148";
        } else if ("2".equals(discountBurden)) {
            accreditNo = "3898";
        } else if ("3".equals(discountBurden)) {
            accreditNo = "3928";
        }
        cacheModel.getOrder().setTerminalOperatorAuthzCardNo(accreditNo);
        if ("Y".equals(mode)) {
            discountRate = Double.valueOf(100.0) - discountRate;
        }
        if (StringUtils.isNotBlank((String)accreditNo)) {
            OperUserIn posManagerOperUserIn = new OperUserIn();
            posManagerOperUserIn.setErpCode(cacheModel.getOrder().getErpCode());
            posManagerOperUserIn.setCardno(accreditNo);
            posManagerOperUserIn.setMkt(in.getShopCode());
            posManagerOperUserIn.setSyjh(in.getTerminalNo());
            JSONObject response = null;
            try {
                response = this.initializationRemoteService.empower(session, posManagerOperUserIn);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            if (null == response) {
                return Code.CODE_100023.getRespBase(new Object[]{"\u6388\u6743\u4eba\u5458\u4fe1\u606f"});
            }
            OperUserOut posManagerOperUserOut = (OperUserOut)JSONObject.parseObject((String)response.toJSONString(), OperUserOut.class);
            OperUser operUser = new OperUser(posManagerOperUserOut);
            cacheModel.setCurGrant(operUser);
        } else if ("1".equals(popMode) || "2".equals(popMode)) {
            return Code.CODE_60028.getRespBase(new Object[]{"\u6761\u7801\u683c\u5f0f\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\uff01"});
        }
        cacheModel.getOrder().setTotalDiscAuthzCardNo(accreditNo);
        if ("1".equals(popMode)) {
            double tempZzr = cacheModel.getOrder().getTempZzr();
            cacheModel = this.posLogicCompoment.removeZzr(cacheModel);
            if (-1 == (cacheModel = this.posLogicServiceImpl.CalcOrderRebateByRateBeforeOrder(cacheModel, accreditNo, discountRate)).getCalcResult()) {
                String errCode = "100000";
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                }
                return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)vo);
            }
            if (tempZzr != 0.0) {
                cacheModel = this.posLogicServiceImpl.CalcOrderRebateByAmountBeforeOrder(cacheModel, cacheModel.getCurGrant().getGh(), tempZzr, 0);
            }
        }
        if ("2".equals(popMode) && -1 == (cacheModel = this.posLogicServiceImpl.CalcOrderRebateByAmountBeforeOrder(cacheModel, accreditNo, discountAmount, 0)).getCalcResult()) {
            String errCode = "100000";
            if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                errCode = cacheModel.getErrCode();
            }
            return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)vo);
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos((CacheModel)cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, cacheModel.getFlowNo());
    }

    protected RespBase isAllowSale(CacheModel cacheModel, GoodsInfo g) {
        if ("Z1".equals(cacheModel.getOrder().getOrderType()) || "Z2".equals(cacheModel.getOrder().getOrderType())) {
            if (4 != g.getDeliveryFlag()) {
                return Code.CODE_20123.getRespBase(new Object[0]);
            }
        } else if (4 == g.getDeliveryFlag()) {
            return Code.CODE_20124.getRespBase(new Object[0]);
        }
        return super.isAllowSale(cacheModel, g);
    }
}

