/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.dao.wslf.CategoryPropertyService_WSLF;
import com.efuture.business.dao.wslf.CategoryService_WSLF;
import com.efuture.business.dao.wslf.GoodsDescService_WSLF;
import com.efuture.business.dao.wslf.SaleGoodsImageRefService_WSLF;
import com.efuture.business.dao.wslf.SaleGoodsModelService_WSLF;
import com.efuture.business.javaPos.commonkit.Convert;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicServiceImpl;
import com.efuture.business.javaPos.struct.AnalyzeBarcodeDef;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.DzcGoodsDetail;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.OrderForPos;
import com.efuture.business.javaPos.struct.SysParaInfo;
import com.efuture.business.javaPos.struct.mainDataCentre.GoodsInfo;
import com.efuture.business.javaPos.struct.mainDataCentre.request.GetGoodsDetailIn;
import com.efuture.business.javaPos.struct.mainDataCentre.response.GetGoodsDetailOut;
import com.efuture.business.javaPos.struct.posManager.request.ElecScaleCodeRuleIn;
import com.efuture.business.javaPos.struct.wslf.request.GroupBuyDataReq;
import com.efuture.business.javaPos.struct.wslf.response.GroupBuyDataResp;
import com.efuture.business.javaPos.struct.wslf.response.GroupBuyDetail;
import com.efuture.business.javaPos.struct.wslf.response.GroupBuyTemplate;
import com.efuture.business.javaPos.struct.wslf.response.GroupInfoResp;
import com.efuture.business.model.Elecscalecoderule;
import com.efuture.business.model.Syspara;
import com.efuture.business.model.wslf.CategoryModel_WSLF;
import com.efuture.business.model.wslf.CategoryPropertyModel_WSLF;
import com.efuture.business.model.wslf.GoodsDescModel_WSLF;
import com.efuture.business.model.wslf.SaleGoodsImageRefModel_WSLF;
import com.efuture.business.service.CalcPopRemoteService;
import com.efuture.business.service.InitializationRemoteService;
import com.efuture.business.service.VipRemoteService;
import com.efuture.business.service.impl.GoodsSaleBSImpl;
import com.efuture.business.util.DataExchageUtils;
import com.efuture.business.util.DefaultParametersUtils;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.UUIDUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GoodsSaleBSImpl_WSLF
extends GoodsSaleBSImpl {
    private static final Logger log = LoggerFactory.getLogger(GoodsSaleBSImpl_WSLF.class);
    @Autowired
    private SaleGoodsModelService_WSLF saleGoodsModelService;
    @Autowired
    private SaleGoodsImageRefService_WSLF saleGoodsImageRefService;
    @Autowired
    private GoodsDescService_WSLF goodsDescService;
    @Autowired
    private CategoryService_WSLF categoryService;
    @Autowired
    private CategoryPropertyService_WSLF categoryPropertyService;
    @SoaAnnotation(value="/apiCalcPopRemoteService.do")
    private CalcPopRemoteService calcPopRemoteService;
    private static String GETGROUPBUYBILLDATA = "pos.groupBuy.groupBuyInfo";
    private static String SETGROUPBUYBILLSTATUS = "pos.groupBuy.finishGroupBuy";
    private static String GETGROUPINFO = "som.cgroupsale.getGroupInfo";
    @SoaAnnotation(value="/apiInitializeRemoteService.do")
    private InitializationRemoteService initializationRemoteService;
    @SoaAnnotation(value="/apiVipRemoteService.do")
    private VipRemoteService vipRemoteService;
    @Autowired(required=false)
    PosLogicServiceImpl posLogicService;
    @Autowired
    public PosLogicCompoment posLogicCompoment;
    @Autowired
    protected PosLogicServiceImpl posLogicServiceImpl;

    public ServiceResponse searcheSaleGoodsDetails(ServiceSession session, JSONObject paramsObject) {
        try {
            log.info("\u67e5\u5546\u54c1{}", (Object)JSONObject.toJSONString((Object)paramsObject));
            long startTime = new Date().getTime();
            log.debug("begin process ------- " + new Date().getTime());
            if (session == null) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50001");
            }
            if (!paramsObject.containsKey((Object)"entId")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"\u96f6\u552e\u5546ID\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!paramsObject.containsKey((Object)"shopCode")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"\u95e8\u5e97\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!paramsObject.containsKey((Object)"terminalNo")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"\u6536\u94f6\u673a\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!paramsObject.containsKey((Object)"code") || StringUtils.isBlank((String)paramsObject.getString("code"))) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"\u5546\u54c1\u7f16\u7801\u6216\u6761\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (!paramsObject.containsKey((Object)"erpCode")) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"\u7ecf\u8425\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            }
            String goodsStatus = "";
            String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
            obj = this.reCacheMode(obj, paramsObject);
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
            String paravalue = "1";
            JSONArray array = new JSONArray();
            List sysParaList = modeDetailsVo.getSyspara();
            JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
            if (sysParaArray.size() != 0) {
                for (int i = 0; i < sysParaArray.size(); ++i) {
                    JSONObject sys = sysParaArray.getJSONObject(i);
                    if (!sys.get((Object)"code").equals("GSS")) continue;
                    goodsStatus = sys.getString("paravalue");
                }
            }
            String splitCode = null;
            if (paramsObject.containsKey((Object)"splitCode")) {
                splitCode = paramsObject.getString("splitCode");
            }
            Long entId = paramsObject.getLong("entId");
            String erpCode = paramsObject.getString("erpCode");
            if (paramsObject.containsKey((Object)"orgCode") && !StringUtils.isEmpty((String)paramsObject.getString("orgCode"))) {
                String orgCode = paramsObject.getString("orgCode");
                String[] orgCodeArray = orgCode.split(",");
                paramsObject.put("orgCode", (Object)orgCodeArray);
            }
            if (!paramsObject.containsKey((Object)"searchType") || !"2".equals(paramsObject.getString("searchType"))) {
                paramsObject.remove((Object)"orgCode");
            }
            if (!paramsObject.containsKey((Object)"goodsStatus") || StringUtils.isEmpty((String)paramsObject.getString("goodsStatus")) || paramsObject.get((Object)"goodsStatus") instanceof JSONArray && paramsObject.getJSONArray("goodsStatus").size() <= 0) {
                ArrayList<Integer> goodStauts = new ArrayList<Integer>();
                if (null != goodsStatus && !"".equals(goodsStatus)) {
                    String[] slist = goodsStatus.split(",");
                    for (String gs : slist) {
                        goodStauts.add(Integer.valueOf(gs));
                    }
                }
                paramsObject.put("goodsStatus", goodStauts);
            }
            DefaultParametersUtils.removeEmptyParams((JSONObject)paramsObject);
            log.debug("start searchSaleGoodsDetails ------- " + new Date().getTime());
            if (StringUtils.isBlank((String)paramsObject.getString("code"))) {
                log.debug("code is null" + paramsObject);
            }
            paramsObject.put("barNo", paramsObject.get((Object)"code"));
            List list = this.saleGoodsModelService.splitSearchSaleGoodsDetails(paramsObject);
            boolean isCode = false;
            if (list == null || list.size() < 1) {
                paramsObject.put("goodsCode", paramsObject.get((Object)"code"));
                paramsObject.remove((Object)"barNo");
                isCode = true;
                list = this.saleGoodsModelService.splitSearchSaleGoodsDetails(paramsObject);
            }
            if (null == list || list.size() <= 0) {
                return ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u67e5\u8be2\u5546\u54c1\u5931\u8d25");
            }
            if (list != null && !list.isEmpty()) {
                for (Map salegoodsMap : list) {
                    Map categoryMap = this.saleGoodsModelService.splitCategoryQuery(salegoodsMap);
                    if (categoryMap != null && categoryMap.size() > 0) {
                        salegoodsMap.putAll(categoryMap);
                        continue;
                    }
                    salegoodsMap.put("artCode", "");
                    salegoodsMap.put("isFresh", "");
                    salegoodsMap.put("isChangePrice", "");
                }
            }
            log.debug("end   searchSaleGoodsDetails ------- " + new Date().getTime());
            ServiceResponse response = this.decorateResponseData4SaleGoodsDetail(session, paramsObject, list);
            if (!"0".equals(response.getReturncode())) {
                return response;
            }
            HashSet<String> categoryCodeSet = new HashSet<String>();
            if (list != null && !list.isEmpty()) {
                for (int i = 0; i < list.size(); ++i) {
                    Map tmpMap = (Map)list.get(i);
                    if (tmpMap.get("categoryCode") == null) continue;
                    categoryCodeSet.add(tmpMap.get("categoryCode").toString());
                }
            }
            QueryWrapper cpqueryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)cpqueryWrapper.eq((Object)"entId", (Object)entId)).eq((Object)"erpCode", (Object)erpCode)).eq((Object)"status", (Object)1)).in((Object)"categoryCode", categoryCodeSet);
            List categoryProperty = this.categoryPropertyService.list((Wrapper)cpqueryWrapper);
            for (int i = 0; i < list.size(); ++i) {
                Map tmpMap = (Map)list.get(i);
                ArrayList subCategoryProperty = new ArrayList();
                if (tmpMap.get("categoryCode") != null) {
                    String tmpCategoryCode = tmpMap.get("categoryCode").toString();
                    for (int j = 0; j < categoryProperty.size(); ++j) {
                        CategoryPropertyModel_WSLF model = (CategoryPropertyModel_WSLF)categoryProperty.get(j);
                        if (!tmpCategoryCode.equals(model.getCategoryCode())) continue;
                        HashMap<String, String> tmpCategoryProperty = new HashMap<String, String>();
                        tmpCategoryProperty.put("propertyName", model.getPropertyName() == null ? "" : model.getPropertyName());
                        tmpCategoryProperty.put("propertyCode", model.getPropertyCode() == null ? "" : model.getPropertyCode());
                        subCategoryProperty.add(tmpCategoryProperty);
                    }
                }
                tmpMap.put("categoryProperty", subCategoryProperty);
            }
            JSONObject result = new JSONObject();
            if (list.size() > 0 && list != null) {
                result.put("goods", (Object)list);
                result.put("total_result", (Object)list.size());
            }
            long endTime = new Date().getTime();
            log.error("countTimeOmd----" + (startTime - endTime));
            return ServiceResponse.buildSuccess((Object)result);
        }
        catch (Exception e) {
            e.printStackTrace();
            return ServiceResponse.buildFailure((ServiceSession)session, (String)"50004", (String)"\u8bf7\u6c42\u53d1\u751f\u5f02\u5e38");
        }
    }

    protected ServiceResponse decorateResponseData4SaleGoodsDetail(ServiceSession session, JSONObject paramsObject, List<Map<String, Object>> list) {
        String erpCode = paramsObject.getString("erpCode");
        String splitCode = null;
        if (paramsObject.containsKey((Object)"splitCode")) {
            splitCode = paramsObject.getString("splitCode");
        }
        HashSet<String> goodsCodeSet = new HashSet<String>();
        HashSet<String> categoryCodeSet = new HashSet<String>();
        for (Map<String, Object> map : list) {
            if (map.get("partsNum") == null) {
                map.put("partsNum", 0);
            }
            if (map.get("goodsCode") != null) {
                goodsCodeSet.add(map.get("goodsCode").toString());
            }
            if (map.get("categoryCode") == null) continue;
            categoryCodeSet.add(map.get("categoryCode").toString());
        }
        List saleGoodsImageRef = new ArrayList();
        List goodsDescList = new ArrayList();
        if (CollectionUtils.isNotEmpty(goodsCodeSet)) {
            QueryWrapper sgirqueryWrapper = new QueryWrapper();
            if (goodsCodeSet.size() == 1) {
                ((QueryWrapper)((QueryWrapper)((QueryWrapper)sgirqueryWrapper.eq((Object)"entId", (Object)session.getEnt_id())).eq((Object)"erpCode", (Object)erpCode)).eq((Object)"goodsCode", goodsCodeSet.iterator().next())).eq((Object)"imageType", (Object)1);
            } else {
                ((QueryWrapper)((QueryWrapper)((QueryWrapper)sgirqueryWrapper.eq((Object)"entId", (Object)session.getEnt_id())).eq((Object)"erpCode", (Object)erpCode)).in((Object)"goodsCode", goodsCodeSet)).eq((Object)"imageType", (Object)1);
            }
            log.info("start imageRef ------- " + new Date().getTime());
            saleGoodsImageRef = this.saleGoodsImageRefService.list((Wrapper)sgirqueryWrapper);
            log.info("end imageRef ------- " + new Date().getTime());
            QueryWrapper gdqueryWrapper = new QueryWrapper();
            if (goodsCodeSet.size() == 1) {
                ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)gdqueryWrapper.eq((Object)"entId", (Object)session.getEnt_id())).eq((Object)"erpCode", (Object)erpCode)).eq((Object)"goodsCode", goodsCodeSet.iterator().next())).eq((Object)"printFlag", (Object)1)).eq((Object)"showTerm", (Object)2);
            } else {
                ((QueryWrapper)((QueryWrapper)((QueryWrapper)((QueryWrapper)gdqueryWrapper.eq((Object)"entId", (Object)session.getEnt_id())).eq((Object)"erpCode", (Object)erpCode)).in((Object)"goodsCode", goodsCodeSet)).eq((Object)"printFlag", (Object)1)).eq((Object)"showTerm", (Object)2);
            }
            log.info("start goodsDesc ------- " + new Date().getTime());
            goodsDescList = this.goodsDescService.list((Wrapper)gdqueryWrapper);
            log.info("end goodsDesc ------- " + new Date().getTime());
        }
        List categorys = new ArrayList();
        if (CollectionUtils.isNotEmpty(categoryCodeSet)) {
            paramsObject.clear();
            paramsObject.put("categoryCode", categoryCodeSet.size() == 1 ? categoryCodeSet.iterator().next() : categoryCodeSet);
            QueryWrapper cqueryWrapper = new QueryWrapper();
            if (categoryCodeSet.size() == 1) {
                cqueryWrapper.eq((Object)"categoryCode", categoryCodeSet.iterator().next());
            } else {
                cqueryWrapper.in((Object)"categoryCode", categoryCodeSet);
            }
            log.info("start category ------- " + new Date().getTime());
            categorys = this.categoryService.list((Wrapper)cqueryWrapper);
            log.info("end category ------- " + new Date().getTime());
        }
        for (Map<String, Object> map : list) {
            if (map.get("goodsCode") != null) {
                String goodsCode = map.get("goodsCode").toString();
                String imageUrl = "";
                for (SaleGoodsImageRefModel_WSLF r : saleGoodsImageRef) {
                    if (!goodsCode.equals(r.getGoodsCode())) continue;
                    imageUrl = r.getImageUrl();
                    break;
                }
                map.put("imageUrl", imageUrl);
                String goodsDesc = null;
                for (int i = 0; i < goodsDescList.size(); ++i) {
                    GoodsDescModel_WSLF goodsDescObj = (GoodsDescModel_WSLF)goodsDescList.get(i);
                    if (!goodsCode.equals(goodsDescObj.getGoodsCode())) continue;
                    goodsDesc = goodsDescObj.getGoodsDesc() == null ? "" : goodsDescObj.getGoodsDesc();
                    break;
                }
                if (goodsDesc != null) {
                    map.put("goodsDesc", goodsDesc);
                }
            }
            Short license = null;
            if (map.get("categoryCode") != null) {
                String categoryCode = map.get("categoryCode").toString();
                if (categorys != null && categorys.size() > 0) {
                    for (CategoryModel_WSLF category : categorys) {
                        if (!categoryCode.equals(category.getCategoryCode())) continue;
                        license = category.getLicense();
                        break;
                    }
                }
            }
            map.put("license", license);
        }
        return ServiceResponse.buildSuccess((Object)"");
    }

    private List<CategoryPropertyModel_WSLF> getCategoryProperty(ServiceSession session, JSONObject paramsObject, Long entId, String erpCode, List<Long> categoryIds) {
        String splitCode = null;
        if (paramsObject.containsKey((Object)"splitCode")) {
            splitCode = paramsObject.getString("splitCode");
        }
        List<Object> categoryProperty = new ArrayList<CategoryPropertyModel_WSLF>();
        if (CollectionUtils.isNotEmpty(categoryIds)) {
            paramsObject.clear();
            DefaultParametersUtils.removeRepeateParams4Long(categoryIds);
            QueryWrapper cpqueryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)((QueryWrapper)cpqueryWrapper.eq((Object)"entId", (Object)entId)).eq((Object)"erpCode", (Object)erpCode)).eq((Object)"status", (Object)1)).in((Object)"categoryCode", categoryIds);
            if (splitCode != null && !splitCode.equals("")) {
                cpqueryWrapper.eq((Object)"shardingCode", (Object)paramsObject.getString("splitCode"));
            }
            categoryProperty = this.categoryPropertyService.list((Wrapper)cpqueryWrapper);
        }
        return categoryProperty;
    }

    private List<GoodsInfo> GetGoodsInfoWithTopCategory(GetGoodsDetailIn in, ServiceSession session) {
        try {
            GetGoodsDetailOut getGoodsDetailOut;
            List goodsInfos;
            ServiceResponse resp = this.searchGoodsTopCategory(session, (JSONObject)JSON.toJSON((Object)in));
            if (null != resp && "0".equals(resp.getReturncode()) && null != (goodsInfos = (getGoodsDetailOut = (GetGoodsDetailOut)JSONObject.toJavaObject((JSON)((JSON)JSON.toJSON((Object)resp.getData())), GetGoodsDetailOut.class)).getGoods()) && goodsInfos.size() > 0) {
                return goodsInfos;
            }
            return null;
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return null;
        }
    }

    public ServiceResponse searchGoodsTopCategory(ServiceSession session, JSONObject paramsObject) {
        JSONObject data;
        ServiceResponse response = this.searcheSaleGoodsDetails(session, paramsObject);
        if (!"0".equals(response.getReturncode())) {
            return response;
        }
        Object returnData = response.getData();
        if (returnData instanceof JSONObject && !(data = (JSONObject)returnData).getJSONArray("goods").isEmpty()) {
            JSONArray array = data.getJSONArray("goods");
            for (int i = 0; i < array.size(); ++i) {
                JSONObject goods = array.getJSONObject(i);
                HashMap<String, Object> params = new HashMap<String, Object>();
                params.put("categoryCode", goods.get((Object)"categoryCode"));
                params.put("entId", goods.get((Object)"entId"));
                params.put("erpCode", goods.get((Object)"erpCode"));
                log.info("searchGoodsTopCategory() ==============================>>>>> categoryCode:{},goodsCode:{},barNo:{} ", new Object[]{goods.get((Object)"categoryCode"), goods.get((Object)"goodsCode"), goods.get((Object)"barNo")});
                Map categoryTop = this.categoryService.searchGoodsTopCategory(params);
                if (categoryTop != null) {
                    goods.putAll(categoryTop);
                    continue;
                }
                log.error("=========>>>>> category\u8868\u7684categoryId\u53ef\u80fd\u5b58\u5728\u95ee\u9898\uff0c\u67e5\u8be2\u4e0d\u5230\u9876\u7ea7ID\u6570\u636e" + paramsObject);
            }
            data.put("goods", (Object)array);
        }
        return response;
    }

    public RespBase getGroupInfo(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"groupnum") || paramsObject.getString("groupnum").isEmpty()) {
            return new RespBase(Code.CODE_20100.getIndex(), "\u56e2\u8d2d\u5165\u53c2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u56e2\u8d2d\u5355\u53f7]");
        }
        if (!paramsObject.containsKey((Object)"entid") || paramsObject.getString("entid").isEmpty()) {
            return new RespBase(Code.CODE_20100.getIndex(), "\u56e2\u8d2d\u5165\u53c2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u673a\u6784\u53f7]");
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "\u7f13\u5b58\u5df2\u5931\u6548");
        }
        if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
            cacheModel.getGoodsList().clear();
        }
        ServiceResponse response = null;
        GroupInfoResp resp = null;
        OrderForPos groupOrder = null;
        String groupnum = paramsObject.getString("groupnum");
        Long entId = paramsObject.getLong("entid");
        try {
            JSONObject groupDataIn = new JSONObject();
            groupDataIn.put("entid", (Object)entId);
            groupDataIn.put("ordertype", (Object)cacheModel.getOrder().getOrderType());
            groupDataIn.put("shopid", (Object)cacheModel.getOrder().getShopCode());
            groupDataIn.put("groupnum", (Object)groupnum);
            session.setEnt_id(entId.longValue());
            log.info("\u56e2\u8d2d\u5355\u8be6\u60c5\u8bf7\u6c42\u4e2d\u53f0  \u5165\u53c2 ==>{}", (Object)groupDataIn);
            response = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.GROUP, GETGROUPINFO, session, groupDataIn.toJSONString(), GroupInfoResp.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u67e5\u8be2\u56e2\u8d2d\u5355");
            log.info("\u56e2\u8d2d\u5355\u8be6\u60c5\u8bf7\u6c42\u4e2d\u53f0  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
            if (!"0".equals(response.getReturncode())) {
                return new RespBase(Code.CODE_20104.getIndex(), response.getData().toString());
            }
            resp = (GroupInfoResp)JSON.parseObject((String)JSONObject.toJSONString((Object)response.getData()), GroupInfoResp.class);
            groupOrder = resp.getOrder();
            if (!groupOrder.getOrderType().equals(cacheModel.getOrder().getOrderType())) {
                return new RespBase(Code.CODE_20104.getIndex(), "\u56e2\u8d2d\u8ba2\u5355\u7c7b\u578b\u4e0d\u5339\u914d\uff01");
            }
            Order order = OrderForPos.posOrderToGroupOrder((Order)cacheModel.getOrder(), (OrderForPos)groupOrder);
            order.setHasGroupBuy(true);
            order.setAllowEditGoods(false);
            order.setGroupBuyNumber(groupnum);
            List goodsList = Goods.transferPosGoodsToGoodsList((List)groupOrder.getGoodsList());
            cacheModel.setOrder(order);
            cacheModel.setGoodsList(goodsList);
            if (SellType.ISBACK((String)groupOrder.getOrderType())) {
                cacheModel.setReturnGoodsList(goodsList);
            }
            if (null == cacheModel.getBakGoods() || cacheModel.getBakGoods().size() <= 0) {
                cacheModel.backGoodsAndPayments();
            }
            vo.setCacheModel(cacheModel);
        }
        catch (Exception e) {
            log.error("\u56e2\u8d2d\u5355\u5f02\u5e38", (Throwable)e);
            return new RespBase(Code.CODE_20104.getIndex(), e.getLocalizedMessage());
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos((CacheModel)vo.getCacheModel()));
        vo.setJsonObject((JSONObject)JSON.toJSON((Object)out));
        return new RespBase(Code.SUCCESS, (Object)vo);
    }

    public RespBase getGroupBuyBillData(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"erpCode") || paramsObject.getString("erpCode").isEmpty()) {
            return new RespBase(Code.CODE_20100.getIndex(), "\u56e2\u8d2d\u5165\u53c2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u7ecf\u8425\u516c\u53f8]");
        }
        if (!paramsObject.containsKey((Object)"shopCode") || paramsObject.getString("shopCode").isEmpty()) {
            return new RespBase(Code.CODE_20100.getIndex(), "\u56e2\u8d2d\u5165\u53c2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u95e8\u5e97\u53f7]");
        }
        if (!paramsObject.containsKey((Object)"terminalNo") || paramsObject.getString("terminalNo").isEmpty()) {
            return new RespBase(Code.CODE_20100.getIndex(), "\u56e2\u8d2d\u5165\u53c2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u6536\u94f6\u673a\u53f7]");
        }
        if (!paramsObject.containsKey((Object)"sheetNo") || paramsObject.getString("sheetNo").isEmpty()) {
            return new RespBase(Code.CODE_20100.getIndex(), "\u56e2\u8d2d\u5165\u53c2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u56e2\u8d2d\u5355\u53f7]");
        }
        GroupBuyDataReq in = (GroupBuyDataReq)JSONObject.toJavaObject((JSON)paramsObject, GroupBuyDataReq.class);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "\u7f13\u5b58\u5df2\u5931\u6548");
        }
        if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
            cacheModel.getGoodsList().clear();
        }
        ServiceResponse response = null;
        try {
            log.info("\u56e2\u8d2d\u5355\u8be6\u60c5\u8bf7\u6c42\u4e2d\u53f0  \u5165\u53c2 ==>{}", (Object)in);
            response = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, GETGROUPBUYBILLDATA, session, JSON.toJSONString((Object)in), GroupBuyDataResp.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u67e5\u8be2\u56e2\u8d2d\u5355");
            log.info("\u56e2\u8d2d\u5355\u8be6\u60c5\u8bf7\u6c42\u4e2d\u53f0  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
            GroupBuyDataResp resp = new GroupBuyDataResp();
            if (!"0".equals(response.getReturncode()) && !"1".equals(response.getReturncode())) {
                return new RespBase(Code.CODE_20104.getIndex(), String.valueOf(response.getData()));
            }
            resp = (GroupBuyDataResp)JSON.parseObject((String)JSONObject.toJSONString((Object)response.getData()), GroupBuyDataResp.class);
            if (resp.getGroupbuydetail() == null || resp.getGroupbuydetail().size() == 0) {
                return new RespBase(Code.CODE_20104.getIndex(), "\u56e2\u8d2d\u5355\u5546\u54c1\u6570\u636e\u7f3a\u5931!");
            }
            if (resp.getGroupbuytemplate() == null) {
                return new RespBase(Code.CODE_20104.getIndex(), "\u56e2\u8d2d\u5355\u5934\u6570\u636e\u7f3a\u5931!");
            }
            ElecScaleCodeRuleIn elecScaleCodeRuleIn = new ElecScaleCodeRuleIn();
            elecScaleCodeRuleIn.setErpCode(cacheModel.getOrder().getErpCode());
            elecScaleCodeRuleIn.setMkt(paramsObject.getString("shopCode"));
            String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
            obj = this.reCacheMode(obj, paramsObject);
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
            List elerules = modeDetailsVo.getElecscalecoderule();
            List sysparaList = modeDetailsVo.getSyspara();
            String codeRule = "";
            String fkcxs = "";
            if (sysparaList.size() != 0 || sysparaList != null) {
                for (int i = 0; i < sysparaList.size(); ++i) {
                    Syspara syspara = (Syspara)sysparaList.get(i);
                    String code = syspara.getCode();
                    if ("CMJY".equals(code)) {
                        codeRule = syspara.getParavalue();
                    }
                    if (!code.equals("41")) continue;
                    fkcxs = syspara.getParavalue();
                }
            }
            ArrayList<String> codes = new ArrayList<String>();
            codes.add("JYMS");
            codes.add("CWYH");
            codes.add("PRTSEQ");
            codes.add("POPPRTMODE");
            codes.add("CMJY");
            codes.add("CWYH");
            codes.add("YDZC");
            SysParaInfo sysPara = this.initSysParaInfo(sysparaList);
            int barNoMode = sysPara.getBarCodeMode();
            ArrayList<String> list = new ArrayList<String>();
            ArrayList guidList = new ArrayList();
            int i = 0;
            for (GroupBuyDetail bgood : resp.getGroupbuydetail()) {
                if (bgood.getCount() < 0.001) {
                    return new RespBase(Code.CODE_20027.getIndex(), "\u5546\u54c1\u6570\u91cf\u4e0d\u80fd\u5c0f\u4e8e0.001");
                }
                Goods goods = new Goods();
                GoodsInfo goodsInfo = null;
                GetGoodsDetailIn getGoodsDetailIn = new GetGoodsDetailIn();
                List goodsInfos = null;
                boolean isdzcm = false;
                boolean isNeedFindMdm = true;
                DzcGoodsDetail dzc = null;
                boolean isNeedFindDzc = true;
                String eleMode = "";
                int priceMode = 0;
                String originalBarNo = bgood.getGoodsCode();
                int disMode = 0;
                double disValue = 0.0;
                AnalyzeBarcodeDef codeInfo = this.analyzeCodeInfo(barNoMode, bgood.getGoodsCode(), "0");
                if (!codeInfo.getValidate()) {
                    return new RespBase(Code.CODE_20104.getIndex(), "\u5339\u914d\u7535\u5b50\u79e4\u89c4\u5219\u5931\u8d25\uff01");
                }
                bgood.setBarNo(codeInfo.getBarNo());
                isNeedFindDzc = codeInfo.getIsNeedFindDzc();
                priceMode = codeInfo.getPriceMode();
                disMode = codeInfo.getDisMode();
                disValue = codeInfo.getDisValue();
                barNoMode = codeInfo.getBarNoMode();
                String serchType = "1";
                getGoodsDetailIn.setEntId(session.getEnt_id());
                getGoodsDetailIn.setShopCode(paramsObject.getString("shopCode"));
                getGoodsDetailIn.setTerminalNo(paramsObject.getString("terminalNo"));
                getGoodsDetailIn.setCode(bgood.getBarNo());
                getGoodsDetailIn.setSearchType(serchType);
                getGoodsDetailIn.setErpCode(cacheModel.getOrder().getErpCode());
                if (codeInfo.getBarNo().length() <= 18 && null != (goodsInfos = this.GetGoodsInfo(getGoodsDetailIn, session)) && goodsInfos.size() > 0 && codeInfo.getBarNo().equals(((GoodsInfo)goodsInfos.get(0)).getBarNo())) {
                    isNeedFindMdm = false;
                }
                if (isNeedFindMdm) {
                    if (elerules.size() > 0 && isNeedFindDzc) {
                        dzc = this.posLogicService.analyzeBarcode(bgood.getBarNo(), elerules, ((Elecscalecoderule)elerules.get(0)).getExpModeMMDDDays(), ((Elecscalecoderule)elerules.get(0)).getExpModeDDHHDays(), codeRule);
                        if (dzc.getRetCode() == 2) {
                            return Code.CODE_20086.getRespBase(new Object[0]);
                        }
                        if (dzc.getRetCode() == 1) {
                            isdzcm = true;
                        }
                    }
                    if (isdzcm) {
                        getGoodsDetailIn.setCode(dzc.getCode());
                    }
                    if (null == (goodsInfos = this.GetGoodsInfo(getGoodsDetailIn, session)) || goodsInfos.size() == 0) {
                        if (isdzcm) {
                            return Code.CODE_20087.getRespBase(new Object[0]);
                        }
                        if (disValue == 0.0 && getGoodsDetailIn.getCode().length() < 13) {
                            getGoodsDetailIn.setCode(Convert.padLeft((String)getGoodsDetailIn.getCode(), (char)'0', (int)13));
                            goodsInfos = this.GetGoodsInfo(getGoodsDetailIn, session);
                            if (null == goodsInfos || goodsInfos.size() == 0) {
                                return Code.CODE_20087.getRespBase(new Object[0]);
                            }
                        } else {
                            return Code.CODE_20087.getRespBase(new Object[0]);
                        }
                    }
                }
                if (goodsInfos.size() <= 0) {
                    return new RespBase(Code.CODE_20104.getIndex(), "\u8bf7\u6c42\u4e3b\u6570\u636e\u4e2d\u5fc3\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25!");
                }
                goodsInfo = (GoodsInfo)goodsInfos.get(0);
                if ("32".equals(goodsInfo.getGoodsType())) {
                    return new RespBase(Code.CODE_20104.getIndex(), "\u56e2\u8d2d\u4e0d\u5141\u8bb8\u9500\u552e\u8305\u53f0\u5546\u54c1!");
                }
                goodsInfo.fixGoodsInfoStr();
                if (isdzcm) {
                    goodsInfo.setEWCCodeAmount(dzc.getDzcmjg());
                    goodsInfo.setEWCCodeNum(dzc.getDzcmsl());
                    goodsInfo.setExpTime(dzc.getExpTime());
                    goods = this.posLogicCompoment.CalcGoodsAmount(goodsInfo, "", true, dzc.getDzcmsl(), dzc.getDzcmjg(), eleMode, originalBarNo, 1.0, false);
                    if (goods == null) {
                        return Code.CODE_20088.getRespBase(new Object[0]);
                    }
                    list.add(goodsInfo.getGoodsCode());
                } else {
                    Goods.transferGoodsInfoToGoods((GoodsInfo)goodsInfo, (Goods)goods, (double)1.0);
                    goods.setEscaleFlag("N");
                    goodsInfo.setEscaleFlag(0);
                }
                if (!"Y".equals(goods.getEscaleFlag())) {
                    Goods.transferGoodsInfoToGoods((GoodsInfo)goodsInfo, (Goods)goods, (double)bgood.getCount());
                }
                String guid = UUIDUtils.buildGuid();
                goods.setGuid(guid);
                goods.setFlowNo(cacheModel.getFlowNo());
                goods.setGoodsNo(originalBarNo);
                goods.setFlowId(++i);
                log.info("PRICEMODE=" + priceMode + ",DISVALUE=" + disValue + ",DISMODE=" + disMode + ",SALEAMOUNT=" + goods.getSaleAmount());
                if (priceMode == 2 && ManipulatePrecision.doubleCompare((double)disValue, (double)0.0, (int)2) > 0) {
                    String precisionMode;
                    if (disMode == 1) {
                        if (ManipulatePrecision.doubleCompare((double)disValue, (double)goods.getSaleAmount(), (int)2) >= 0) {
                            goods.setBarcodeDiscount(goods.getSaleAmount());
                        } else {
                            goods.setBarcodeDiscount(disValue);
                        }
                    } else if (disMode == 2) {
                        precisionMode = DataExchageUtils.exchangePrecisionMode((String)goods.getPrcutMode());
                        if (ManipulatePrecision.doubleCompare((double)disValue, (double)100.0, (int)2) > 0) {
                            return Code.CODE_20089.getRespBase(new Object[0]);
                        }
                        goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow((double)(goods.getSaleAmount() * disValue), (String)precisionMode));
                    } else if (disMode == 3 && ManipulatePrecision.doubleCompare((double)goods.getSaleAmount(), (double)disValue, (int)2) > 0) {
                        precisionMode = DataExchageUtils.exchangePrecisionMode((String)goods.getPrcutMode());
                        goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow((double)(goods.getSaleAmount() - disValue), (String)precisionMode));
                    }
                    goods.setAdjustDiscountValue(this.posLogicCompoment.getAdjustDiscount(goods));
                    goods.setTotalDiscountValue(PosLogicCompoment.getZZK((Goods)goods));
                    goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert((double)(goods.getTotalDiscountValue() - goods.getNoDisAmountValue())));
                    goods.setDisMode(disMode);
                    goods.setDisValue(disValue);
                    goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
                }
                cacheModel.getGoodsList().add(goods);
            }
            Order order = cacheModel.getOrder();
            GroupBuyTemplate groupBuyTemplate = resp.getGroupbuytemplate();
            order.setIdSheetNo(groupBuyTemplate.getSheetNo());
            order.setOughtPay(groupBuyTemplate.getSaleAmount());
            order.setSaleValue(groupBuyTemplate.getSaleAmount());
            order.setExistPay(groupBuyTemplate.getSaleAmount());
            order.setQty((int)groupBuyTemplate.getCountAmount());
            order.setSaleDate(new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(new Date()));
            order.setHasGroupBuy(true);
            order.setGroupBuyNumber(groupBuyTemplate.getSheetNo());
            order.setGroupBuyerCode(groupBuyTemplate.getCustomerCode());
            order.setGroupBuyerName(groupBuyTemplate.getCustomer());
            order.setGroupBuyManager(groupBuyTemplate.getWorkerCode());
            order.setGroupBuyManagerName(groupBuyTemplate.getWorker());
            order.setGroupBuyManagerName(groupBuyTemplate.getWorker());
            order.setOrderType("1");
            cacheModel.setOrder(order);
            paramsObject.put("calcMode", (Object)"0");
            paramsObject.put("count", (Object)resp.getGroupbuydetail().size());
            paramsObject.put("qty", (Object)resp.getGroupbuydetail().size());
            paramsObject.put("guidList", guidList);
            vo.setCacheModel(cacheModel);
            RespBase respBase = this.calcPopRemoteService.calcSinglePopAll(session, "0", cacheModel, false);
            if (respBase.getRetflag() != 0) {
                return respBase;
            }
            cacheModel = (CacheModel)respBase.getData();
            if ("N".equals(fkcxs)) {
                RespBase res = this.searchShopStock(session, cacheModel, new HashSet());
                if (Code.SUCCESS.getIndex() != res.getRetflag()) {
                    return res;
                }
            }
            log.info("\u56e2\u8d2d\u8c03\u8425\u9500\u51fa\u53c2:" + JSON.toJSON((Object)respBase));
        }
        catch (Exception e) {
            log.error("\u56e2\u8d2d\u5355\u8be6\u60c5\u67e5\u8be2\u5f02\u5e38{}", (Object)e.getMessage());
            return new RespBase(Code.CODE_20104.getIndex(), "\u56e2\u8d2d\u5355\u8be6\u60c5\u67e5\u8be2\u5f02\u5e38!");
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(OrderForPos.toOrderForPos((CacheModel)cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "GETGROUPBUYBILLDATA");
    }

    public RespBase setGroupBuyBillStatus(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"erpCode") || paramsObject.getString("erpCode").isEmpty()) {
            return new RespBase(Code.CODE_20100.getIndex(), "\u56e2\u8d2d\u5165\u53c2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u7ecf\u8425\u516c\u53f8]");
        }
        if (!paramsObject.containsKey((Object)"shopCode") || paramsObject.getString("shopCode").isEmpty()) {
            return new RespBase(Code.CODE_20100.getIndex(), "\u56e2\u8d2d\u5165\u53c2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u95e8\u5e97\u53f7]");
        }
        if (!paramsObject.containsKey((Object)"sheetNo") || paramsObject.getString("sheetNo").isEmpty()) {
            return new RespBase(Code.CODE_20100.getIndex(), "\u56e2\u8d2d\u5165\u53c2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u56e2\u8d2d\u5355\u53f7]");
        }
        ServiceResponse response = null;
        try {
            log.info("\u4fee\u6539\u56e2\u8d2d\u5355\u72b6\u6001  \u5165\u53c2 ==>{}", (Object)paramsObject);
            response = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, SETGROUPBUYBILLSTATUS, session, JSON.toJSONString((Object)paramsObject), ServiceResponse.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u4fee\u6539\u56e2\u8d2d\u5355\u72b6\u6001");
            log.info("\u4fee\u6539\u56e2\u8d2d\u5355\u72b6\u6001  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
            if (!"0".equals(response.getReturncode())) {
                return new RespBase(Code.CODE_20105.getIndex(), String.valueOf(response.getData()));
            }
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u56e2\u8d2d\u5355\u72b6\u6001{}", (Object)e.getMessage());
            return new RespBase(Code.CODE_20105.getIndex(), "\u4fee\u6539\u56e2\u8d2d\u5355\u72b6\u6001!");
        }
        return new RespBase(Code.SUCCESS.getIndex(), "SETGROUPBUYBILLSTATUS");
    }

    protected RespBase isAllowSale(CacheModel cacheModel, GoodsInfo g) {
        if ((null == cacheModel.getOrder().getConsumersData() || StringUtils.isBlank((String)cacheModel.getOrder().getConsumersData().getConsumersCard()) || "\u5de5\u4f1a\u5361".equals(cacheModel.getOrder().getConsumersData().getConsumersType())) && "32".equals(g.getGoodsType())) {
            return Code.CODE_20106.getRespBase(new Object[0]);
        }
        return super.isAllowSale(cacheModel, g);
    }

    public CacheModel loginMemberForRefund(ServiceSession session, ResqVo vo, CacheModel cacheModel) {
        if ("\u5de5\u4f1a\u5361".equals(cacheModel.getOrder().getConsumersData().getConsumersType())) {
            cacheModel.getOrder().getConsumersData().setConsumersType("GRP");
            cacheModel.getOrder().getConsumersData().setGrantCard(cacheModel.getOrder().getConsumersData().getGrantCard());
            cacheModel.getOrder().getConsumersData().setConsumersCard("");
            cacheModel.getOrder().getConsumersData().setConsumersId("");
        } else if ("\u8d85\u5e02\u5361".equals(cacheModel.getOrder().getConsumersData().getConsumersType())) {
            JSONObject object = new JSONObject();
            object.put("flowNo", (Object)cacheModel.getOrder().getFlowNo());
            object.put("erpCode", (Object)cacheModel.getOrder().getErpCode());
            object.put("shopCode", (Object)cacheModel.getOrder().getShopCode());
            object.put("channel", (Object)cacheModel.getOrder().getChannel());
            object.put("testType", (Object)"C");
            object.put("password", (Object)"");
            object.put("custNo", (Object)cacheModel.getOrder().getConsumersData().getConsumersId());
            RespBase respBase = this.vipRemoteService.promotionVipLogin(session, vo, object);
            if (null != respBase && Code.SUCCESS.getIndex() == respBase.getRetflag()) {
                CacheModel cache = (CacheModel)respBase.getData();
                cacheModel.getOrder().setConsumersData(cache.getOrder().getConsumersData());
                cacheModel.getOrder().setTotalPoint(cache.getOrder().getConsumersData().getPoint());
            }
        } else if ("1".equals(cacheModel.getOrder().getConsumersData().getCustType())) {
            JSONObject object = new JSONObject();
            object.put("flowNo", (Object)cacheModel.getOrder().getFlowNo());
            object.put("erpCode", (Object)cacheModel.getOrder().getErpCode());
            object.put("shopCode", (Object)cacheModel.getOrder().getShopCode());
            object.put("channel", (Object)cacheModel.getOrder().getChannel());
            object.put("testType", (Object)"C");
            object.put("password", (Object)"");
            object.put("custNo", (Object)cacheModel.getOrder().getConsumersData().getConsumersId());
            RespBase respBase = this.vipRemoteService.promotionVipLogin(session, vo, object);
            if (null != respBase && Code.SUCCESS.getIndex() == respBase.getRetflag()) {
                CacheModel cache = (CacheModel)respBase.getData();
                cacheModel.getOrder().setConsumersData(cache.getOrder().getConsumersData());
                cacheModel.getOrder().setTotalPoint(cache.getOrder().getConsumersData().getPoint());
            }
        }
        return cacheModel;
    }

    protected List<GoodsInfo> getGoodsInfoForParentCode(JSONObject paramsObject) {
        String goodsStatus = "";
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)(obj = this.reCacheMode(obj, paramsObject)), ModeDetailsVo.class);
        List sysParaList = modeDetailsVo.getSyspara();
        JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
        if (sysParaArray.size() != 0) {
            for (int i = 0; i < sysParaArray.size(); ++i) {
                JSONObject sys = sysParaArray.getJSONObject(i);
                if (!sys.get((Object)"code").equals("GSS")) continue;
                goodsStatus = sys.getString("paravalue");
            }
        }
        if (paramsObject.containsKey((Object)"orgCode") && StringUtils.isNotBlank((String)paramsObject.getString("orgCode"))) {
            String orgCode = paramsObject.getString("orgCode");
            String[] orgCodeArray = orgCode.split(",");
            paramsObject.put("orgCode", (Object)orgCodeArray);
        }
        if (!paramsObject.containsKey((Object)"searchType") || !"2".equals(paramsObject.getString("searchType"))) {
            paramsObject.remove((Object)"orgCode");
        }
        if (!paramsObject.containsKey((Object)"goodsStatus") || StringUtils.isEmpty((String)paramsObject.getString("goodsStatus")) || paramsObject.get((Object)"goodsStatus") instanceof JSONArray && paramsObject.getJSONArray("goodsStatus").size() <= 0) {
            ArrayList<Integer> goodStauts = new ArrayList<Integer>();
            if (null != goodsStatus && !"".equals(goodsStatus)) {
                String[] slist;
                for (String gs : slist = goodsStatus.split(",")) {
                    goodStauts.add(Integer.valueOf(gs));
                }
            }
            paramsObject.put("goodsStatus", goodStauts);
        }
        DefaultParametersUtils.removeEmptyParams((JSONObject)paramsObject);
        log.debug("start searchSaleGoodsDetails ------- " + new Date().getTime());
        paramsObject.put("parentGoodsCode", paramsObject.get((Object)"code"));
        List list = this.saleGoodsModelService.splitSearchSaleGoodsDetails(paramsObject);
        if (null == list || list.size() <= 0) {
            return null;
        }
        List goodsInfos = JSONObject.parseArray((String)JSON.toJSONString((Object)list), GoodsInfo.class);
        log.info("\u6bcd\u7801##goodsInfos:" + JSON.toJSONString((Object)goodsInfos));
        return goodsInfos;
    }

    protected String reCacheMode(String obj, JSONObject jsonObject) {
        if ("".equals(obj) || null == obj) {
            this.initializationRemoteService.reSaveCacheModel(null, jsonObject);
            obj = this.redisUtil.get(RedisKey.CACHEID + jsonObject.getString("shopCode") + jsonObject.getString("terminalNo"));
        }
        return obj;
    }
}

