/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.Convert;
import com.efuture.business.javaPos.commonkit.CountZZK;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.mainDataCentre.GoodsInfo;
import com.efuture.business.javaPos.struct.mainDataCentre.request.GetGoodsDetailIn;
import com.efuture.business.javaPos.struct.myshopr10.LsGroupRes;
import com.efuture.business.service.CalcPopRemoteService;
import com.efuture.business.service.localize.GoodsSaleBSImpl_WSLF;
import com.efuture.business.util.HttpClientUtil;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.UUIDUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoodsSaleBSImpl_MSR10
extends GoodsSaleBSImpl_WSLF {
    private static final Logger log = LoggerFactory.getLogger(GoodsSaleBSImpl_MSR10.class);
    public static String GETGROUPINFO = "myshop.groupguy.getdata";
    public static String GETTOKEN = "auth.token.create";
    @SoaAnnotation(value="/apiCalcPopRemoteService.do")
    public CalcPopRemoteService calcPopRemoteService;

    public RespBase getGroupInfo(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"groupnum") || paramsObject.getString("groupnum").isEmpty()) {
            return new RespBase(Code.CODE_20100.getIndex(), "\u56e2\u8d2d\u5165\u53c2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u56e2\u8d2d\u5355\u53f7]");
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "\u7f13\u5b58\u5df2\u5931\u6548");
        }
        if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
            cacheModel.getGoodsList().clear();
        }
        ServiceResponse response = null;
        String token = "";
        String groupnum = paramsObject.getString("groupnum");
        try {
            JSONObject jsonResponse;
            JSONObject tokenObj = new JSONObject();
            tokenObj.put("usercode", (Object)GlobalInfo.myshopTokenUseName);
            tokenObj.put("password", (Object)GlobalInfo.myshopTokenPassWord);
            log.info("\u6821\u9a8c\u8bb8\u53ef\u8bc1\u5f00\u59cb:{}", JSONObject.toJSON((Object)tokenObj));
            String res = HttpClientUtil.postJson((String)(GlobalInfo.myShopGroupUrl + "?method=" + GETTOKEN), (String)tokenObj.toJSONString());
            log.info("\u6821\u9a8c\u8bb8\u53ef\u8bc1\u8fd4\u56de:{}", (Object)res);
            if (StringUtils.isNotBlank((String)res) && "0".equals((jsonResponse = JSONObject.parseObject((String)res)).getString("returncode"))) {
                token = jsonResponse.getJSONObject("data").getString("access_token");
            }
            if (StringUtils.isBlank((String)token)) {
                return new RespBase(Code.CODE_20104.getIndex(), "\u56e2\u8d2d\u4ea4\u6613\u672a\u83b7\u53d6\u5230token");
            }
            log.info("token:" + token);
            JSONObject groupDataIn = new JSONObject();
            groupDataIn.put("mkt", (Object)cacheModel.getOrder().getShopCode());
            groupDataIn.put("sheetid", (Object)groupnum);
            log.info("\u56e2\u8d2d\u5355\u8be6\u60c5\u8bf7\u6c42\u4e2d\u53f0  \u5165\u53c2 ==>{}", (Object)groupDataIn);
            response = this.httpUtils.doMyshopPost(this.restTemplate, HttpUtils.RemoteService.MYSHOPGROUP, GETGROUPINFO, session, groupDataIn.toJSONString(), null, "myShop\u56e2\u8d2d", "\u67e5\u8be2\u56e2\u8d2d\u5355", token);
            log.info("\u56e2\u8d2d\u5355\u8be6\u60c5\u8bf7\u6c42\u4e2d\u53f0  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString((Object)response));
            if ("0".equals(response.getReturncode())) {
                JSONArray groupRes = JSONArray.parseArray((String)JSON.toJSONString((Object)response.getData()));
                if (null != groupRes && groupRes.size() > 0) {
                    log.info("\u8c03\u51fa\u56e2\u8d2d\u5546\u54c1");
                    cacheModel = this.getGroupDetail(session, cacheModel, groupRes);
                    if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                        return Code.CODE_64.getRespBase(new Object[]{cacheModel.getErrCode(), cacheModel.getErrMsg()});
                    }
                }
            } else {
                return new RespBase(Code.CODE_20104.getIndex(), response.getData().toString());
            }
            Order order = cacheModel.getOrder();
            order.setHasGroupBuy(true);
            order.setAllowEditGoods(false);
            order.setIdSheetNo(groupnum);
            order.setGroupBuyNumber(groupnum);
            cacheModel.setOrder(order);
            vo.setCacheModel(cacheModel);
            log.info("\u7535\u5b50\u5355\u6dfb\u52a0\u5546\u54c1end");
        }
        catch (Exception e) {
            log.error("\u56e2\u8d2d\u5355\u5f02\u5e38", (Throwable)e);
            return new RespBase(Code.CODE_20104.getIndex(), e.getLocalizedMessage());
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        vo.setJsonObject((JSONObject)JSON.toJSON((Object)out));
        return new RespBase(Code.SUCCESS, (Object)vo);
    }

    public CacheModel getGroupDetail(ServiceSession session, CacheModel cacheModel, JSONArray groupRes) {
        log.info("\u56e2\u8d2d\u590d\u5236\u5546\u54c1-start");
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getSyjmain().getMkt() + cacheModel.getSyjmain().getSyjh());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String cmjy = modeDetailsVo.getSysparaValue("CMJY");
        List syspara = modeDetailsVo.getSyspara();
        if (null == cacheModel.getGoodsList() || cacheModel.getGoodsList().size() == 0) {
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String nowDateTime = dateTime.format(df).toString();
            cacheModel.getOrder().setSaleDate(nowDateTime);
            cacheModel = this.changeSaleDate(cacheModel, syspara);
        }
        Order order = cacheModel.getOrder();
        ArrayList<String> guidList = new ArrayList<String>();
        try {
            String guestid = "";
            String guestname = "";
            if (null != groupRes && groupRes.size() > 0) {
                log.info("\u8c03\u51fa\u56e2\u8d2d\u5546\u54c1");
                for (Object resObj : groupRes) {
                    log.info(JSONObject.toJSONString(resObj));
                    LsGroupRes lsGroupRes = (LsGroupRes)JSON.parseObject((String)JSONObject.toJSONString(resObj), LsGroupRes.class);
                    log.info(" \u524d\uff1a" + JSONObject.toJSONString((Object)cacheModel.getGoodsList().size()));
                    guestid = lsGroupRes.getGuestid();
                    guestname = lsGroupRes.getGuestname();
                    Goods goods = new Goods();
                    GoodsInfo goodsInfo = null;
                    GetGoodsDetailIn getGoodsDetailIn = new GetGoodsDetailIn();
                    List goodsInfos = null;
                    boolean isNeedFindMdm = true;
                    boolean priceMode = false;
                    String originalBarNo = lsGroupRes.getBarcodeid();
                    boolean disMode = false;
                    double disValue = 0.0;
                    String serchType = "1";
                    getGoodsDetailIn.setEntId(session.getEnt_id());
                    getGoodsDetailIn.setShopCode(order.getShopCode());
                    getGoodsDetailIn.setTerminalNo(order.getTerminalNo());
                    getGoodsDetailIn.setCode(lsGroupRes.getBarcodeid());
                    getGoodsDetailIn.setSearchType(serchType);
                    getGoodsDetailIn.setErpCode(cacheModel.getOrder().getErpCode());
                    if (isNeedFindMdm && (null == (goodsInfos = this.GetGoodsInfo(getGoodsDetailIn, session, cmjy)) || goodsInfos.size() == 0)) {
                        if (disValue == 0.0 && getGoodsDetailIn.getCode().length() < 13) {
                            getGoodsDetailIn.setCode(Convert.padLeft((String)getGoodsDetailIn.getCode(), (char)'0', (int)13));
                            goodsInfos = this.GetGoodsInfo(getGoodsDetailIn, session, cmjy);
                            if (null == goodsInfos || goodsInfos.size() == 0) {
                                cacheModel.setErrCode("20087");
                                cacheModel.setErrMsg("\u672a\u67e5\u627e\u5230\u8be5\u5546\u54c1");
                                return cacheModel;
                            }
                        } else {
                            cacheModel.setErrCode("20087");
                            cacheModel.setErrMsg("\u672a\u67e5\u627e\u5230\u8be5\u5546\u54c1");
                            return cacheModel;
                        }
                    }
                    if (goodsInfos.size() <= 0) {
                        cacheModel.setErrCode("20104");
                        cacheModel.setErrMsg("\u8bf7\u6c42\u4e3b\u6570\u636e\u4e2d\u5fc3\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
                        return cacheModel;
                    }
                    goodsInfo = (GoodsInfo)goodsInfos.get(0);
                    goodsInfo.fixGoodsInfoStr();
                    goods.setEscaleFlag("N");
                    goodsInfo.setEscaleFlag(0);
                    this.goodsTransfer.transferGoodsInfoToGoods(goodsInfo, goods, lsGroupRes.getQty());
                    String guid = UUIDUtils.buildGuid();
                    guidList.add(guid);
                    goods.setGuid(guid);
                    goods.setGoodsNo(originalBarNo);
                    goods.setFlowId(cacheModel.getGoodsList().size() + 1);
                    goods.setFlowNo(cacheModel.getFlowNo());
                    goods.setGoodsNo(lsGroupRes.getGoodsid());
                    goods.setColourCode(lsGroupRes.getGuestid());
                    goods.setColourName(lsGroupRes.getGuestname());
                    goods.setSalePrice(ManipulatePrecision.getDetailOverFlow((double)lsGroupRes.getPromprice(), (String)goods.getPrcutMode()));
                    if (!"Y".equals(goods.getEscaleFlag())) {
                        goods.setSaleValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getQty() * goods.getSalePrice()), (String)goods.getPrcutMode()));
                    } else {
                        goods.setQty(ManipulatePrecision.doubleConvert((double)(goods.getEWCCodeAmount() / goods.getSalePrice()), (int)4, (int)1));
                        goods.setQtyrecalc(0);
                        goods.setSaleValue(goods.getEWCCodeAmount());
                        goods.setPopDiscountValue(0.0);
                    }
                    goods.setTempZkl(100.0);
                    goods.setDiscAmount(0.0);
                    goods.setTempZkDiscount(0.0);
                    goods.setTempZrDiscount(0.0);
                    goods.setTempZzkDiscount(0.0);
                    goods.setTempZzrDiscount(0.0);
                    goods.setFixedDiscountValue(0.0);
                    goods.setAdjustDiscountValue(this.posLogicCompoment.getAdjustDiscount(goods));
                    goods.setPopDiscountValue(0.0);
                    goods.getPopDetailsInfo().clear();
                    goods.setTotalDiscountValue(CountZZK.getZZK((Goods)goods));
                    goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert((double)(goods.getTotalDiscountValue() - goods.getNoDisAmountValue())));
                    goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
                    goods.setFlowId(cacheModel.getGoodsList().size() + 1);
                    cacheModel.getGoodsList().add(goods);
                    log.info(" \u4e2d\uff1a" + JSONObject.toJSONString((Object)cacheModel.getGoodsList().size()));
                }
            }
            order.setGroupBuyerCode(guestid);
            order.setGroupBuyerName(guestname);
            JSONObject paramsObject = new JSONObject();
            paramsObject.put("calcMode", (Object)"0");
            paramsObject.put("count", (Object)cacheModel.getGoodsList().size());
            paramsObject.put("qty", (Object)cacheModel.getGoodsList().size());
            paramsObject.put("guidList", guidList);
            RespBase respBase = this.calcPopRemoteService.calcSinglePopAll(session, "0", cacheModel, false);
            if (respBase.getRetflag() != 0) {
                cacheModel.setErrCode("-1");
                cacheModel.setErrMsg(((CacheModel)respBase.getData()).toString());
                return cacheModel;
            }
            cacheModel = (CacheModel)respBase.getData();
            log.info("\u91cd\u7b97\u6539\u4ef7\u91d1\u989d-end");
        }
        catch (Exception e) {
            log.error("\u56e2\u8d2d\u8c03\u51fa\u5f02\u5e38{}", (Throwable)e);
            cacheModel.setErrMsg("\u56e2\u8d2d\u8c03\u51fa\u5f02\u5e38");
            cacheModel.setErrCode("-1");
            return cacheModel;
        }
        return cacheModel;
    }
}

