/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.dao.xhd.GoodsForGroupDao;
import com.efuture.business.javaPos.commonkit.Convert;
import com.efuture.business.javaPos.commonkit.CountZZK;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.ConsumersData;
import com.efuture.business.javaPos.struct.DzcGoodsDetail;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.mainDataCentre.GoodsInfo;
import com.efuture.business.javaPos.struct.mainDataCentre.request.GetGoodsDetailIn;
import com.efuture.business.javaPos.struct.request.GetSaleGoodsInfoIn;
import com.efuture.business.javaPos.struct.xhd.response.GroupBuySPDataResp;
import com.efuture.business.service.localize.GoodsSaleBSImpl_WSLF;
import com.efuture.business.util.DataExchageUtils;
import com.efuture.business.util.UUIDUtils;
import com.product.model.ServiceSession;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GoodsSaleBSImpl_XHD
extends GoodsSaleBSImpl_WSLF {
    private static final Logger log = LoggerFactory.getLogger(GoodsSaleBSImpl_XHD.class);
    @Autowired
    private GoodsForGroupDao goodsForGroupDao;

    public Goods getGoods(ConsumersData consumersData, Goods goods, CacheModel cacheModel) {
        if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType()) && StringUtils.isEmpty((String)cacheModel.getOrder().getOriginFlowNo())) {
            return goods;
        }
        return this.getErpcustdiscount(consumersData, goods, 0.0);
    }

    private Goods getErpcustdiscount(ConsumersData consumersData, Goods goods, double marketzk) {
        if ("Y".equals(goods.getNoPricing())) {
            return goods;
        }
        if (null == consumersData || StringUtils.isEmpty((String)consumersData.getConsumersCard())) {
            return goods;
        }
        if ("2".equals(consumersData.getLoginMode())) {
            return goods;
        }
        if (goods.getMemberPrice() > 0.0) {
            String precisionMode = DataExchageUtils.exchangePrecisionMode((String)goods.getPrcutMode());
            if ("Y".equals(goods.getEscaleFlag())) {
                goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow((double)((goods.getSalePrice() - goods.getMemberPrice()) * (goods.getQty() / 1.0)), (String)precisionMode));
            } else {
                goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow((double)((goods.getSalePrice() - goods.getMemberPrice()) * goods.getQty()), (String)precisionMode));
            }
            goods.setDisMode(3);
            goods.setDisValue(goods.getMemberPrice());
            goods.setDiscType("0");
            marketzk = goods.getShareDiscount2();
        }
        goods.setAdjustDiscountValue(this.posLogicCompoment.getAdjustDiscount(goods));
        goods.setTotalDiscountValue(CountZZK.getZZK((Goods)goods));
        goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert((double)(goods.getTotalDiscountValue() - goods.getNoDisAmountValue())));
        goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
        return goods;
    }

    protected void custDzcMethod(CacheModel cacheModel, DzcGoodsDetail dzc, GoodsInfo goodsInfo) {
        cacheModel.setErrCode("");
        cacheModel.setErrMsg("");
        if (goodsInfo != null && "3".equals(goodsInfo.getGbdzcmlx())) {
            if (dzc.getDzcmsl() == 0.0) {
                dzc.setDzcmsl(1.0);
            } else {
                dzc.setDzcmsl(Double.parseDouble(dzc.getOriDzcmsl()));
            }
        }
        if (goodsInfo != null && !"3".equals(goodsInfo.getGbdzcmlx()) && dzc.getDzcmsl() == 0.0) {
            cacheModel.setErrCode("20101");
            cacheModel.setErrMsg("\u4e0d\u7b26\u5408\u79e4\u7801\u89c4\u5219");
        }
    }

    public RespBase getGroupBuyBillData(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        if (!paramsObject.containsKey((Object)"sheetNo") || paramsObject.getString("sheetNo").isEmpty()) {
            return new RespBase(Code.CODE_20100.getIndex(), "\u56e2\u8d2d\u5165\u53c2\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u56e2\u8d2d\u5355\u53f7]");
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return new RespBase(Code.CODE_60.getIndex(), "\u7f13\u5b58\u5df2\u5931\u6548");
        }
        if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
            cacheModel.getGoodsList().clear();
        }
        Object response = null;
        String token = "";
        String sheetNo = paramsObject.getString("sheetNo");
        try {
            JSONObject reqjson = new JSONObject();
            reqjson.put("mktcode", (Object)cacheModel.getOrder().getShopCode());
            reqjson.put("billno", (Object)sheetNo);
            if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType())) {
                reqjson.put("type", (Object)"1");
            } else {
                reqjson.put("type", (Object)"2");
            }
            List groupinfos = this.goodsForGroupDao.getGroupinfo(reqjson.toJSONString(), cacheModel);
            if (groupinfos != null && groupinfos.size() > 0) {
                log.info("\u8c03\u51fa\u56e2\u8d2d\u5546\u54c1");
                cacheModel = this.getGroupDetail(session, cacheModel, groupinfos);
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    return Code.CODE_64.getRespBase(new Object[]{cacheModel.getErrCode(), cacheModel.getErrMsg()});
                }
            } else {
                return new RespBase(Code.CODE_20104.getIndex(), response.getData().toString());
            }
            Order order = cacheModel.getOrder();
            if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType())) {
                order.setAllowEditGoods(false);
            }
            order.setIdSheetNo(sheetNo);
            order.setGroupBuyNumber(sheetNo);
            cacheModel.setOrder(order);
            this.posLogicCompoment.calcOrderAmount(cacheModel);
            vo.setCacheModel(cacheModel);
            log.info("\u7535\u5b50\u5355\u6dfb\u52a0\u5546\u54c1end");
        }
        catch (Exception e) {
            log.error("\u56e2\u8d2d\u5355\u5f02\u5e38", (Throwable)e);
            return new RespBase(Code.CODE_20104.getIndex(), e.getLocalizedMessage());
        }
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        vo.setJsonObject((JSONObject)JSON.toJSON((Object)out));
        return new RespBase(Code.SUCCESS, (Object)vo);
    }

    public CacheModel getGroupDetail(ServiceSession session, CacheModel cacheModel, List<GroupBuySPDataResp> groupinfos) {
        log.info("\u56e2\u8d2d\u590d\u5236\u5546\u54c1-start");
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getSyjmain().getMkt() + cacheModel.getSyjmain().getSyjh());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String cmjy = modeDetailsVo.getSysparaValue("CMJY");
        List syspara = modeDetailsVo.getSyspara();
        if (null == cacheModel.getGoodsList() || cacheModel.getGoodsList().size() == 0) {
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String nowDateTime = dateTime.format(df).toString();
            cacheModel.getOrder().setSaleDate(nowDateTime);
            cacheModel = this.changeSaleDate(cacheModel, syspara);
        }
        Order order = cacheModel.getOrder();
        ArrayList<String> guidList = new ArrayList<String>();
        try {
            String guestid = "";
            String guestname = "";
            if (null != groupinfos && groupinfos.size() > 0) {
                log.info("\u8c03\u51fa\u56e2\u8d2d\u5546\u54c1");
                for (GroupBuySPDataResp resObj : groupinfos) {
                    log.info(JSONObject.toJSONString((Object)resObj));
                    log.info(" \u524d\uff1a" + JSONObject.toJSONString((Object)cacheModel.getGoodsList().size()));
                    Goods goods = new Goods();
                    GoodsInfo goodsInfo = null;
                    GetGoodsDetailIn getGoodsDetailIn = new GetGoodsDetailIn();
                    List goodsInfos = null;
                    boolean isNeedFindMdm = true;
                    boolean priceMode = false;
                    String originalBarNo = resObj.getBarcode();
                    boolean disMode = false;
                    double disValue = 0.0;
                    String serchType = "1";
                    getGoodsDetailIn.setEntId(session.getEnt_id());
                    getGoodsDetailIn.setShopCode(order.getShopCode());
                    getGoodsDetailIn.setTerminalNo(order.getTerminalNo());
                    getGoodsDetailIn.setCode(resObj.getBarcode());
                    getGoodsDetailIn.setSearchType(serchType);
                    getGoodsDetailIn.setErpCode(cacheModel.getOrder().getErpCode());
                    if (isNeedFindMdm && (null == (goodsInfos = this.GetGoodsInfo(getGoodsDetailIn, session, cmjy)) || goodsInfos.size() == 0)) {
                        if (disValue == 0.0 && getGoodsDetailIn.getCode().length() < 13) {
                            getGoodsDetailIn.setCode(Convert.padLeft((String)getGoodsDetailIn.getCode(), (char)'0', (int)13));
                            goodsInfos = this.GetGoodsInfo(getGoodsDetailIn, session, cmjy);
                            if (null == goodsInfos || goodsInfos.size() == 0) {
                                cacheModel.setErrCode("20087");
                                cacheModel.setErrMsg("\u672a\u67e5\u627e\u5230\u8be5\u5546\u54c1");
                                return cacheModel;
                            }
                        } else {
                            cacheModel.setErrCode("20087");
                            cacheModel.setErrMsg("\u672a\u67e5\u627e\u5230\u8be5\u5546\u54c1");
                            return cacheModel;
                        }
                    }
                    if (goodsInfos.size() <= 0) {
                        cacheModel.setErrCode("20104");
                        cacheModel.setErrMsg("\u8bf7\u6c42\u4e3b\u6570\u636e\u4e2d\u5fc3\u67e5\u8be2\u5546\u54c1\u4fe1\u606f\u5931\u8d25");
                        return cacheModel;
                    }
                    goodsInfo = (GoodsInfo)goodsInfos.get(0);
                    goodsInfo.fixGoodsInfoStr();
                    goods.setEscaleFlag(resObj.getIsdzc());
                    goodsInfo.setEscaleFlag("N".equals(resObj.getIsdzc()) ? 0 : 1);
                    this.goodsTransfer.transferGoodsInfoToGoods(goodsInfo, goods, resObj.getSl());
                    String guid = UUIDUtils.buildGuid();
                    guidList.add(guid);
                    goods.setGuid(guid);
                    goods.setGoodsNo(originalBarNo);
                    goods.setFlowId(cacheModel.getGoodsList().size() + 1);
                    goods.setFlowNo(cacheModel.getFlowNo());
                    goods.setAssistantId(resObj.getYyyh());
                    goods.setPopFlag("z");
                    goods.setGoodsNo(resObj.getCode());
                    goods.setSalePrice(ManipulatePrecision.getDetailOverFlow((double)resObj.getJg(), (String)goods.getPrcutMode()));
                    goods.setListPrice(goods.getSalePrice());
                    goods.setMemberPrice(goods.getSalePrice());
                    goods.setSaleValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getQty() * goods.getSalePrice()), (String)goods.getPrcutMode()));
                    goods.setTempZkl(100.0);
                    goods.setOutputTax(resObj.getXxtax());
                    goods.setDiscAmount(0.0);
                    goods.setTempZkDiscount(resObj.getLszke());
                    goods.setTempZrDiscount(0.0);
                    goods.setTempZzkDiscount(resObj.getLszke());
                    goods.setTempZzrDiscount(0.0);
                    goods.setFixedDiscountValue(0.0);
                    goods.setAdjustDiscountValue(this.posLogicCompoment.getAdjustDiscount(goods));
                    goods.setPopDiscountValue(0.0);
                    goods.getPopDetailsInfo().clear();
                    goods.setTotalDiscountValue(CountZZK.getZZK((Goods)goods));
                    goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert((double)(goods.getTotalDiscountValue() - goods.getNoDisAmountValue())));
                    goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
                    goods.setFlowId(cacheModel.getGoodsList().size() + 1);
                    cacheModel.getGoodsList().add(goods);
                    if (SellType.ISBACK((String)order.getOrderType())) {
                        cacheModel.getOrder().setOriginTerminalNo(resObj.getYsyjh());
                        cacheModel.getOrder().setOriginTerminalSno(String.valueOf(resObj.getYfphm()));
                        cacheModel.getOrder().setOriginSeqNo(resObj.getYbillno());
                        goods.setOriginalFlowId(Integer.valueOf(resObj.getYrowno()));
                    }
                    log.info(" \u4e2d\uff1a" + JSONObject.toJSONString((Object)cacheModel.getGoodsList().size()));
                }
            }
            JSONObject paramsObject = new JSONObject();
            paramsObject.put("calcMode", (Object)"0");
            paramsObject.put("count", (Object)cacheModel.getGoodsList().size());
            paramsObject.put("qty", (Object)cacheModel.getGoodsList().size());
            paramsObject.put("guidList", guidList);
            RespBase respBase = this.calcPopRemoteService.calcSinglePopAll(session, "0", cacheModel, false);
            if (respBase.getRetflag() != 0) {
                cacheModel.setErrCode("-1");
                cacheModel.setErrMsg(((CacheModel)respBase.getData()).toString());
                return cacheModel;
            }
            cacheModel = (CacheModel)respBase.getData();
            log.info("\u91cd\u7b97\u6539\u4ef7\u91d1\u989d-end");
        }
        catch (Exception e) {
            log.error("\u56e2\u8d2d\u8c03\u51fa\u5f02\u5e38{}", (Throwable)e);
            cacheModel.setErrMsg("\u56e2\u8d2d\u8c03\u51fa\u5f02\u5e38");
            cacheModel.setErrCode("-1");
            return cacheModel;
        }
        return cacheModel;
    }

    public RespBase updateCartGoods(ServiceSession session, ResqVo vo) {
        CacheModel cacheModel = vo.getCacheModel();
        if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType()) && cacheModel.getOrder().isHasGroupBuy()) {
            return Code.CODE_20188.getRespBase(new Object[0]);
        }
        return super.updateCartGoods(session, vo);
    }

    public RespBase confirmSalesReturn(ServiceSession session, ResqVo vo) {
        CacheModel cacheModel = vo.getCacheModel();
        cacheModel.getOrder().setIsAllReturn(true);
        vo.setCacheModel(cacheModel);
        return super.confirmSalesReturn(session, vo);
    }

    public RespBase setGroupBuyBillStatus(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        Object response = null;
        try {
            JSONObject updateJson = new JSONObject();
            CacheModel cacheModel = vo.getCacheModel();
            updateJson.put("mkt", (Object)cacheModel.getOrder().getShopCode());
            updateJson.put("billno", (Object)cacheModel.getOrder().getGroupBuyNumber());
            log.info("\u4fee\u6539\u56e2\u8d2d\u5355\u72b6\u6001  \u8bf7\u6c42 ==>{}", (Object)JSON.toJSONString((Object)updateJson));
            this.goodsForGroupDao.updateGroupinfo(updateJson.toJSONString(), cacheModel);
            log.info("\u4fee\u6539\u56e2\u8d2d\u5355\u72b6\u6001  \u8fd4\u56de ==>{}", (Object)JSON.toJSONString(response));
            if (!"0".equals(response.getReturncode())) {
                return new RespBase(Code.CODE_20105.getIndex(), String.valueOf(response.getData()));
            }
        }
        catch (Exception e) {
            log.error("\u4fee\u6539\u56e2\u8d2d\u5355\u72b6\u6001{}", (Object)e.getMessage());
            return new RespBase(Code.CODE_20105.getIndex(), "\u4fee\u6539\u56e2\u8d2d\u5355\u72b6\u6001!");
        }
        return new RespBase(Code.SUCCESS.getIndex(), "SETGROUPBUYBILLSTATUS");
    }

    public Goods convertCustomDiscount(Goods goods) {
        if (goods.getSaleAmount() - goods.getCustomDiscountValue() < goods.getMemberPrice()) {
            goods.setMemberPrice(ManipulatePrecision.doubleConvert((double)(goods.getSaleAmount() - goods.getCustomDiscountValue())));
        }
        return goods;
    }

    protected boolean checkReduct(GetSaleGoodsInfoIn getSaleGoodsInfoIn, CacheModel cacheModel, JSONObject checkReductJson) {
        if (getSaleGoodsInfoIn.getBarNo().length() == 13 && getSaleGoodsInfoIn.getBarNo().startsWith("27")) {
            JSONObject reqJson = new JSONObject();
            reqJson.put("incode", (Object)getSaleGoodsInfoIn.getBarNo());
            log.info("\u8f6c\u6362\u6298\u4ef7\u7801  \u8bf7\u6c42 ==>{}", (Object)JSON.toJSONString((Object)reqJson));
            JSONObject object = this.goodsForGroupDao.checkReduct(reqJson.toJSONString(), cacheModel);
            checkReductJson.putAll((Map)object);
            getSaleGoodsInfoIn.setBarNo(checkReductJson.getString("barcode"));
            getSaleGoodsInfoIn.setQty(checkReductJson.getDouble("sl").doubleValue());
            return true;
        }
        return false;
    }

    public RespBase isAllowEdit(CacheModel cacheModel, int flowId, double qty) {
        Goods sg = (Goods)cacheModel.getGoodsList().get(flowId - 1);
        if (null == sg) {
            return Code.CODE_20087.getRespBase(new Object[0]);
        }
        if ("J".equals(sg.getPopFlag()) && StringUtils.isNotEmpty((String)sg.getExtendFt3())) {
            return Code.CODE_20191.getRespBase(new Object[0]);
        }
        return new RespBase(Code.SUCCESS);
    }

    public void convertCheckReduct(JSONObject checkReductJson, GoodsInfo goodsInfo, GetSaleGoodsInfoIn getSaleGoodsInfoIn, Goods goods) {
        if (goods == null) {
            goodsInfo.setSalePrice(ManipulatePrecision.doubleConvert((double)checkReductJson.getDouble("jg"), (int)2, (int)0));
            goodsInfo.setMemberPrice(ManipulatePrecision.doubleConvert((double)checkReductJson.getDouble("jg"), (int)2, (int)0));
            goodsInfo.setMinDiscount(1.0);
            getSaleGoodsInfoIn.setQty(ManipulatePrecision.doubleConvert((double)checkReductJson.getDouble("sl"), (int)3, (int)0));
        } else {
            goods.setPopFlag("J");
            goods.setExtendFt3(goods.getGoodsNo());
        }
    }
}

