/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.request.GetSaleGoodsInfoIn;
import com.efuture.business.service.localize.GoodsSaleBSImpl_WSLF;
import com.product.model.ServiceSession;
import com.product.util.Utils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GoodsSaleBSImpl_XJHJ
extends GoodsSaleBSImpl_WSLF {
    private static final Logger log = LoggerFactory.getLogger(GoodsSaleBSImpl_XJHJ.class);

    public RespBase getSaleGoodsInfo(ServiceSession session, ResqVo vo) {
        try {
            JSONObject paramsObject = vo.getJsonObject();
            GetSaleGoodsInfoIn getSaleGoodsInfoIn = (GetSaleGoodsInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetSaleGoodsInfoIn.class);
            CacheModel cacheModel = vo.getCacheModel();
            if (cacheModel == null) {
                return Code.CODE_20001.getRespBase(new Object[0]);
            }
            if (SellType.ISCOUPON((String)cacheModel.getOrder().getOrderType())) {
                if (StringUtils.isEmpty((String)cacheModel.getOrder().getConsumersData().getConsumersCard())) {
                    return Code.CODE_64.getRespBase(new Object[]{"\u4e70\u5238\u5fc5\u987b\u5237\u4f1a\u5458\u5361"});
                }
                if ("0".equals(getSaleGoodsInfoIn.getCalcMode()) && cacheModel.getGoodsList().size() > 0) {
                    return Code.CODE_64.getRespBase(new Object[]{"\u53ea\u5141\u8bb8\u4e701\u5f20\u5238"});
                }
                if ("2".equals(getSaleGoodsInfoIn.getCalcMode())) {
                    return Code.CODE_20152.getRespBase(new Object[]{getSaleGoodsInfoIn.getBarNo()});
                }
            }
            RespBase resp = super.getSaleGoodsInfo(session, vo);
            ResqVo resqVo = (ResqVo)resp.getData();
            if (Code.SUCCESS.getIndex() != resp.getRetflag()) {
                return resp;
            }
            if (!SellType.ISCOUPON((String)cacheModel.getOrder().getOrderType())) {
                return resp;
            }
            Goods sg = (Goods)cacheModel.getGoodsList().get(0);
            if (ManipulatePrecision.doubleCompare((double)sg.getQty(), (double)sg.getStock(), (int)4) > 0) {
                return Code.CODE_20108.getRespBase(new Object[]{sg.getGoodsNo()});
            }
            return resp;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Code.CODE_20029.getRespBase(new Object[]{Utils.getLastExceptionMessage((Exception)e)});
        }
    }

    public RespBase needFindMDMconfirmSalesReturn(ServiceSession session, ResqVo vo, CacheModel cacheModel) {
        if (cacheModel != null && cacheModel.getOrder() != null && SellType.ISCOUPON((String)cacheModel.getOrder().getOrderType())) {
            return Code.FAIL.getRespBase(new Object[0]);
        }
        return Code.SUCCESS.getRespBase(new Object[0]);
    }

    public RespBase canDeleteCartGoods(ServiceSession session, ResqVo vo, CacheModel cacheModel, Goods delGoods) {
        if (cacheModel != null && cacheModel.getOrder() != null && SellType.ISCOUPON((String)cacheModel.getOrder().getOrderType())) {
            return Code.CODE_64.getRespBase(new Object[]{"\u4e70\u5238/\u9000\u4e70\u5238\u4e0d\u53ef\u5220\u9664\u5546\u54c1"});
        }
        return Code.SUCCESS.getRespBase(new Object[0]);
    }
}

