/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.dao.wslf.CategoryPropertyService_WSLF;
import com.efuture.business.dao.zzbh.SaleGoodsModelService_ZZBH;
import com.efuture.business.javaPos.commonkit.Convert;
import com.efuture.business.javaPos.commonkit.CountZZK;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.AnalyzeBarcodeDef;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.ConsumersData;
import com.efuture.business.javaPos.struct.DzcGoodsDetail;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.GoodsForPos;
import com.efuture.business.javaPos.struct.OperUser;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.mainDataCentre.GoodsInfo;
import com.efuture.business.javaPos.struct.mainDataCentre.request.GetGoodsDetailIn;
import com.efuture.business.javaPos.struct.mss.GoodForJd;
import com.efuture.business.javaPos.struct.mss.OrderForJd;
import com.efuture.business.javaPos.struct.mss.TempDetailOut;
import com.efuture.business.javaPos.struct.mss.TempDetails;
import com.efuture.business.javaPos.struct.mss.TempHead;
import com.efuture.business.javaPos.struct.request.GetSaleGoodsInfoIn;
import com.efuture.business.javaPos.struct.response.GetSaleGoodsInfoOut;
import com.efuture.business.javaPos.struct.warehouseCentre.ShopStockJD;
import com.efuture.business.model.Elecscalecoderule;
import com.efuture.business.model.Syjgroup;
import com.efuture.business.service.V3VipRemoteService;
import com.efuture.business.service.localize.GoodsSaleBSImpl_WSLF;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.DataExchageUtils;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.ParamsValidateUtils;
import com.efuture.business.util.UUIDUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.Utils;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class GoodsSaleBSImpl_ZZBH
extends GoodsSaleBSImpl_WSLF {
    private static final Logger log = LoggerFactory.getLogger(GoodsSaleBSImpl_ZZBH.class);
    @SoaAnnotation(value="/apiV3VipRemoteService.do")
    protected V3VipRemoteService v3VipRemoteService;
    @Autowired
    private SaleGoodsModelService_ZZBH saleGoodsModelService;
    @Autowired
    private CategoryPropertyService_WSLF categoryPropertyService;
    private static String SEARCHSHOPSTOCKJD = "stock.oms.shopStock.searchShopStockInfoForJD";

    public RespBase getSaleGoodsInfo(ServiceSession session, ResqVo vo) {
        try {
            String errCode;
            JSONObject object3;
            long startTime = System.currentTimeMillis();
            JSONObject paramsObject = vo.getJsonObject();
            ParamsValidateUtils paramsValidateUtils = new ParamsValidateUtils(session, paramsObject);
            if (!paramsValidateUtils.validate()) {
                return Code.CODE_20000.getRespBase(new Object[0]);
            }
            GetSaleGoodsInfoIn getSaleGoodsInfoIn = (GetSaleGoodsInfoIn)JSONObject.toJavaObject((JSON)paramsObject, GetSaleGoodsInfoIn.class);
            log.info("\u6dfb\u52a0\u5546\u54c1\u5f00\u59cb...>{}", (Object)JSONObject.toJSONString((Object)getSaleGoodsInfoIn));
            if (getSaleGoodsInfoIn.getBarNo().length() >= 18 && getSaleGoodsInfoIn.getBarNo().contains("J")) {
                return this.getSaleGoodsByBatch(session, vo);
            }
            String type = "A";
            CacheModel cacheModel = vo.getCacheModel();
            if (cacheModel == null) {
                return Code.CODE_20001.getRespBase(new Object[0]);
            }
            if (!cacheModel.getOrder().getAllowEditGoods()) {
                return Code.CODE_20002.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
            }
            String jyms = "";
            String yyygzMode = "";
            String fkcxs = "";
            String cmjy = null;
            log.info("\u83b7\u53d6\u7cfb\u7edf\u7f13\u5b58");
            String obj = this.redisUtil.get(RedisKey.CACHEID + getSaleGoodsInfoIn.getShopCode() + getSaleGoodsInfoIn.getTerminalNo());
            log.info("\u83b7\u53d6\u7cfb\u7edf\u7f13\u5b58\u7ed3\u675f");
            obj = this.reCacheMode(obj, paramsObject);
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
            List syspara = modeDetailsVo.getSyspara();
            String grantMode = ModeDetailsVo.getSysParaValue((List)syspara, (String)"SQMS");
            String paravalue = "1";
            JSONArray array = new JSONArray();
            JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)syspara));
            if (sysParaArray.size() != 0) {
                for (int i = 0; i < sysParaArray.size(); ++i) {
                    JSONObject sys = sysParaArray.getJSONObject(i);
                    if (sys.get((Object)"code").equals("OZ")) {
                        array.add((Object)sys);
                    }
                    if (sys.get((Object)"code").equals("JYMS")) {
                        jyms = sys.getString("paravalue");
                    }
                    if (sys.get((Object)"code").equals("40")) {
                        yyygzMode = sys.getString("paravalue");
                    }
                    if (sys.get((Object)"code").equals("41")) {
                        fkcxs = sys.getString("paravalue");
                    }
                    if (!sys.get((Object)"code").equals("CMJY")) continue;
                    cmjy = sys.getString("paravalue");
                }
            }
            if (array.size() != 0 && (object3 = array.getJSONObject(0)).containsKey((Object)"paravalue")) {
                paravalue = object3.getString("paravalue");
            }
            String[] temp = paravalue.split(",");
            double maxGoodsCount = CastUtil.castDouble((Object)temp[0]);
            double maxBusinessVolume = CastUtil.castDouble((Object)temp[4]);
            double maxSaleGoodsQuantity = cacheModel.getMaxSaleGoodsQuantity();
            if (maxSaleGoodsQuantity > 0.0 && (double)cacheModel.getOrder().getQty() >= maxSaleGoodsQuantity) {
                return Code.CODE_20042.getRespBase(new Object[0]);
            }
            if (StringUtils.isNotBlank((String)cacheModel.getOrder().getStaffNo())) {
                if (!(cacheModel.getOrder().getStaffSale() || cacheModel.getOrder().getTempZzr() != 0.0 || cacheModel.getOrder().getTempZzk() != 100.0 && cacheModel.getOrder().getTempZzk() != 0.0)) {
                    log.info("\u5458\u5de5\u5361\u6298\u6263\u6539\u4e3a\u53ef\u7528");
                    cacheModel.getOrder().setStaffSale(true);
                } else if (cacheModel.getOrder().getDiscAmount() != 0.0 || cacheModel.getOrder().getTempZzr() != 0.0 || cacheModel.getOrder().getTempZzk() != 0.0 && cacheModel.getOrder().getTempZzk() != 100.0) {
                    log.info("\u5458\u5de5\u5361\u6298\u6263\u6539\u4e3a\u4e0d\u53ef\u7528");
                    cacheModel.getOrder().setStaffSale(false);
                }
            }
            Order order = cacheModel.getOrder();
            session.setEnt_id(cacheModel.getOrder().getEntId());
            Goods goods = null;
            boolean isdzcm = false;
            boolean isNeedFindDzc = true;
            boolean isNeedFindMdm = true;
            boolean isHaveQty = false;
            int priceMode = 0;
            String originalBarNo = getSaleGoodsInfoIn.getBarNo();
            if (StringUtils.isNotBlank((String)getSaleGoodsInfoIn.getScanCode())) {
                originalBarNo = getSaleGoodsInfoIn.getScanCode();
            }
            int disMode = 0;
            double disValue = 0.0;
            int barNoMode = 0;
            String discType = "0";
            AnalyzeBarcodeDef codeInfo = null;
            if ("Y".equals(yyygzMode) && StringUtils.isNotBlank((String)cacheModel.getCurYyyInfo().getYyygz()) && !this.checkYyyRange(cacheModel.getCurYyyInfo(), yyygzMode, getSaleGoodsInfoIn.getOrgCode())) {
                return Code.CODE_20003.getRespBase(new Object[0]);
            }
            if ("1".equals(cacheModel.getEleCodeMode())) {
                barNoMode = 1;
            }
            if ("1".equals(jyms)) {
                barNoMode = 2;
            }
            DzcGoodsDetail dzc = new DzcGoodsDetail();
            GoodsInfo goodsInfo = null;
            GetGoodsDetailIn queryGoodIn = new GetGoodsDetailIn();
            String splitCode = null;
            if (vo.getJsonObject().containsKey((Object)"splitCode")) {
                splitCode = vo.getJsonObject().getString("splitCode");
            }
            List goodsInfos = null;
            if ("1".equals(getSaleGoodsInfoIn.getCalcMode())) {
                isNeedFindMdm = false;
            }
            if (isNeedFindMdm) {
                log.info("\u89e3\u6790code\u5f00\u59cb");
                codeInfo = this.analyzeCodeInfo(barNoMode, getSaleGoodsInfoIn.getBarNo(), getSaleGoodsInfoIn.getCalcMode());
                log.info("\u89e3\u6790code\u7ed3\u675f==>{}", (Object)JSONObject.toJSONString((Object)codeInfo));
                if (!codeInfo.getValidate()) {
                    return Code.CODE_20004.getRespBase(new Object[0]);
                }
                getSaleGoodsInfoIn.setBarNo(codeInfo.getBarNo());
                isNeedFindDzc = codeInfo.getIsNeedFindDzc();
                priceMode = codeInfo.getPriceMode();
                disMode = codeInfo.getDisMode();
                disValue = codeInfo.getDisValue();
                barNoMode = codeInfo.getBarNoMode();
                if (disValue > 0.0 && getSaleGoodsInfoIn.getQty() > 0.0) {
                    return Code.CODE_20005.getRespBase(new Object[0]);
                }
                if (codeInfo.getBarNo().length() <= 13) {
                    queryGoodIn = GetGoodsDetailIn.transferQueryGoodIn((ServiceSession)session, (GetSaleGoodsInfoIn)getSaleGoodsInfoIn, (int)barNoMode);
                    queryGoodIn.setChannel(order.getChannel());
                    queryGoodIn.setOrderType(order.getOrderType());
                    goodsInfos = this.GetGoodsInfo(queryGoodIn, session, cmjy);
                    if (null != goodsInfos && goodsInfos.size() > 0 && codeInfo.getBarNo().equals(((GoodsInfo)goodsInfos.get(0)).getBarNo())) {
                        isNeedFindMdm = false;
                        isNeedFindDzc = false;
                    }
                }
                if (isNeedFindDzc) {
                    List elecCodeRules = modeDetailsVo.getElecscalecoderule();
                    if (isNeedFindDzc && elecCodeRules.size() > 0) {
                        log.info("\u89e3\u6790\u7535\u5b50\u79e4\u7801");
                        dzc = this.posLogicCompoment.analyzeBarcode(getSaleGoodsInfoIn.getBarNo(), elecCodeRules, ((Elecscalecoderule)elecCodeRules.get(0)).getExpModeMMDDDays(), ((Elecscalecoderule)elecCodeRules.get(0)).getExpModeDDHHDays(), cacheModel.getEleCodeMode());
                        log.info("\u89e3\u6790\u7535\u5b50\u79e4\u7801\u7ed3\u675f==>{}", (Object)JSONObject.toJSONString((Object)dzc));
                        if (!SellType.ISBACK((String)order.getOrderType()) && dzc.getRetCode() == 2) {
                            return Code.CODE_20006.getRespBase(new Object[0]);
                        }
                        if (dzc.getRetCode() == 1) {
                            isdzcm = true;
                        }
                    }
                }
                if (isdzcm) {
                    queryGoodIn = GetGoodsDetailIn.transferQueryGoodInByDZC((ServiceSession)session, (GetSaleGoodsInfoIn)getSaleGoodsInfoIn, (DzcGoodsDetail)dzc, (int)barNoMode);
                    queryGoodIn.setChannel(order.getChannel());
                    queryGoodIn.setOrderType(order.getOrderType());
                    if (StringUtils.isNotBlank((String)splitCode)) {
                        queryGoodIn.setSplitCode(splitCode);
                    }
                    goodsInfos = this.GetGoodsInfo(queryGoodIn, session, cmjy);
                } else if (isNeedFindMdm) {
                    queryGoodIn = GetGoodsDetailIn.transferQueryGoodIn((ServiceSession)session, (GetSaleGoodsInfoIn)getSaleGoodsInfoIn, (int)barNoMode);
                    if (StringUtils.isNotBlank((String)splitCode)) {
                        queryGoodIn.setSplitCode(splitCode);
                    }
                    queryGoodIn.setChannel(order.getChannel());
                    queryGoodIn.setOrderType(order.getOrderType());
                    goodsInfos = this.GetGoodsInfo(queryGoodIn, session, cmjy);
                }
            }
            if (!"1".equals(getSaleGoodsInfoIn.getCalcMode())) {
                Object resqVo;
                List goodsForCoice;
                if (goodsInfos == null || goodsInfos.size() == 0) {
                    return Code.CODE_20009.getRespBase(new Object[0]);
                }
                if ("h".equalsIgnoreCase(cacheModel.getOrder().getOrderType()) && !"33".equals(((GoodsInfo)goodsInfos.get(0)).getGoodsType())) {
                    return Code.CODE_20111.getRespBase(new Object[0]);
                }
                if (!"h".equals(cacheModel.getOrder().getOrderType()) && "33".equals(((GoodsInfo)goodsInfos.get(0)).getGoodsType())) {
                    return Code.CODE_20112.getRespBase(new Object[0]);
                }
                if (goodsInfos.size() >= 1) {
                    ArrayList syjOrg = new ArrayList();
                    Syjgroup syjgroup = cacheModel.getSyjgroup();
                    if (StringUtils.isNotBlank((String)syjgroup.getSourceitem()) && !"ALL".equals(syjgroup.getSourceitem()) && !"0".equals(syjgroup.getSourceitem())) {
                        syjOrg.addAll(syjgroup.getSourceitems());
                    }
                    if ("Y".equals(yyygzMode)) {
                        List yyyOrg = new ArrayList();
                        OperUser curYyyInfo = cacheModel.getCurYyyInfo();
                        if (StringUtils.isNotBlank((String)curYyyInfo.getYyygz()) && !"ALL".equals(curYyyInfo.getYyygz()) && !"0".equals(curYyyInfo.getYyygz())) {
                            yyyOrg = curYyyInfo.getYyygzs();
                        }
                        if (syjOrg.size() <= 0 && yyyOrg.size() > 0) {
                            syjOrg = yyyOrg;
                        } else if (syjOrg.size() > 0 && yyyOrg.size() > 0) {
                            syjOrg.retainAll(yyyOrg);
                        }
                    }
                    for (int i = 0; i < goodsInfos.size(); ++i) {
                        GoodsInfo g = (GoodsInfo)goodsInfos.get(i);
                        if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType()) && !g.isAllowSale() || SellType.ISBACK((String)cacheModel.getOrder().getOrderType()) && !g.isAllowRefund()) {
                            goodsInfos.remove(i);
                            --i;
                            continue;
                        }
                        if (this.checkGzRange(g, yyygzMode, syjOrg, grantMode)) continue;
                        goodsInfos.remove(i);
                        --i;
                    }
                    if (goodsInfos.size() == 0) {
                        if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType())) {
                            return Code.CODE_20010.getRespBase(new Object[0]);
                        }
                        if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
                            return Code.CODE_20011.getRespBase(new Object[0]);
                        }
                    }
                }
                if (goodsInfos.size() > 1) {
                    Object g;
                    int i;
                    boolean isNeedChoice = true;
                    int mainCodeNum = 0;
                    int mainCodeRow = 0;
                    for (i = 0; i < goodsInfos.size(); ++i) {
                        g = (GoodsInfo)goodsInfos.get(i);
                        if (!g.getMainBarcodeFlag()) continue;
                        ++mainCodeNum;
                        mainCodeRow = i;
                    }
                    if (mainCodeNum == 1) {
                        boolean isHaveUnit = false;
                        for (GoodsInfo g2 : goodsInfos) {
                            if (!g2.getMultiUnitFlag()) continue;
                            isHaveUnit = true;
                            break;
                        }
                        if (!isHaveUnit) {
                            goodsInfo = (GoodsInfo)goodsInfos.get(mainCodeRow);
                            isNeedChoice = false;
                        }
                    }
                    if (isNeedChoice) {
                        if (mainCodeNum > 1) {
                            for (i = 0; i < goodsInfos.size(); ++i) {
                                g = (GoodsInfo)goodsInfos.get(i);
                                if (g.getMainBarcodeFlag()) continue;
                                goodsInfos.remove(i);
                                --i;
                            }
                        }
                        GetSaleGoodsInfoOut out = new GetSaleGoodsInfoOut();
                        goodsForCoice = this.goodsTransfer.transferGoodsList(goodsInfos, getSaleGoodsInfoIn.getBarNo());
                        out.setOrder(this.toGoodsForChoice(goodsForCoice));
                        out.setSaleGoodsType("3");
                        if (mainCodeNum == 0 || mainCodeNum > 1) {
                            out.setSaleGoodsType("C");
                        }
                        resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                        return new RespBase(Code.SUCCESS, resqVo, "FINDGOODSTIFY");
                    }
                } else {
                    goodsInfo = (GoodsInfo)goodsInfos.get(0);
                }
                if (StringUtils.isNotBlank((String)goodsInfo.getColourCode()) && StringUtils.isNotBlank((String)goodsInfo.getSizeCode()) && goodsInfo.getGoodsType().equals("6")) {
                    goodsInfos = this.getGoodsInfoForParentCode((JSONObject)JSON.toJSON((Object)queryGoodIn));
                    if (goodsInfos == null || goodsInfos.size() == 0) {
                        return Code.CODE_20009.getRespBase(new Object[0]);
                    }
                    GetSaleGoodsInfoOut out = new GetSaleGoodsInfoOut();
                    List goodsForCoice2 = this.goodsTransfer.transferGoodsList(goodsInfos, getSaleGoodsInfoIn.getBarNo());
                    out.setOrder(this.toGoodsForChoice(goodsForCoice2));
                    out.setSaleGoodsType("B");
                    ResqVo resqVo2 = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, (Object)resqVo2, "FINDGOODSTIFY");
                }
                RespBase allowSale = this.isAllowSale(cacheModel, goodsInfo);
                if (Code.SUCCESS.getIndex() != allowSale.getRetflag()) {
                    log.info("allowSale===>{}", (Object)JSONObject.toJSONString((Object)allowSale));
                    return allowSale;
                }
                if (!this.checkSyjRange(cacheModel, goodsInfo)) {
                    return Code.CODE_20018.getRespBase(new Object[0]);
                }
                if (goodsInfo.getGoodsType().equals("41") && SellType.ISSALE((String)cacheModel.getOrder().getOrderType())) {
                    JSONObject object = new JSONObject();
                    object.put("erpCode", (Object)order.getErpCode());
                    object.put("shopCode", (Object)order.getShopCode());
                    object.put("code", (Object)goodsInfo.getGoodsCode());
                    log.info("\u7279\u5356\u7801\u67e5\u8be2\u5165\u53c20\uff1a" + object.toJSONString());
                    ServiceResponse res = this.querySpecialSale(object);
                    log.info("\u7279\u5356\u7801\u67e5\u8be2\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)res));
                    if ("0".equals(res.getReturncode())) {
                        JSONObject j = (JSONObject)res.getData();
                        if ("N".equals(j.getString("status"))) {
                            return Code.CODE_20110.getRespBase(new Object[0]);
                        }
                        Double price = j.getDouble("price");
                        goodsInfo.setSalePrice(price.doubleValue());
                    }
                }
                if (isdzcm) {
                    goodsInfo.setEWCCodeAmount(dzc.getDzcmjg());
                    goodsInfo.setEWCCodeNum(dzc.getDzcmsl());
                    goodsInfo.setExpTime(dzc.getExpTime());
                }
                log.info("SALEPRICE=" + goodsInfo.getSalePrice() + "PRICEMODE=" + priceMode);
                log.info("goodsInfo==>{}", (Object)JSONObject.toJSONString((Object)goodsInfo));
                if (priceMode != 2 || disMode != 3) {
                    if (!"2".equals(getSaleGoodsInfoIn.getCalcMode()) && goodsInfo.getSalePrice() == 0.0 && (priceMode == 1 || goodsInfo.getEscaleFlag() != 1 || goodsInfo.getEscaleFlag() == 1 && dzc.getDzcmjg() <= 0.0)) {
                        goodsInfo.setSalePrice(0.0);
                        GetSaleGoodsInfoOut out = new GetSaleGoodsInfoOut();
                        List goodsForCoice3 = this.goodsTransfer.transferGoodsList(goodsInfos, getSaleGoodsInfoIn.getBarNo());
                        out.setOrder(this.toGoodsForChoice(goodsForCoice3));
                        for (GoodsForPos sg : out.getOrder().getGoodsList()) {
                            sg.setSalePrice(0.0);
                        }
                        out.setSaleGoodsType("0");
                        ResqVo resqVo3 = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                        return new RespBase(Code.SUCCESS, (Object)resqVo3, "FINDGOODSTIFY");
                    }
                    if (!isdzcm && goodsInfo.getEscaleFlag() != 1 && goodsInfo.getSalePrice() < 0.1 && !"2".equals(getSaleGoodsInfoIn.getCalcMode())) {
                        GetSaleGoodsInfoOut out = new GetSaleGoodsInfoOut();
                        List goodsForCoice4 = this.goodsTransfer.transferGoodsList(goodsInfos, getSaleGoodsInfoIn.getBarNo());
                        out.setOrder(this.toGoodsForChoice(goodsForCoice4));
                        out.setSaleGoodsType("1");
                        return Code.CODE_20020.getRespBase(new Object[0]);
                    }
                }
                if (SellType.ISKD((String)order.getOrderType()) && !"2".equals(getSaleGoodsInfoIn.getCalcMode())) {
                    goodsInfo.setSalePrice(0.0);
                    GetSaleGoodsInfoOut out = new GetSaleGoodsInfoOut();
                    List goodsForCoice5 = this.goodsTransfer.transferGoodsList(goodsInfos, getSaleGoodsInfoIn.getBarNo());
                    out.setOrder(this.toGoodsForChoice(goodsForCoice5));
                    for (GoodsForPos sg : out.getOrder().getGoodsList()) {
                        sg.setSalePrice(0.0);
                    }
                    out.setSaleGoodsType("0");
                    ResqVo resqVo3 = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, (Object)resqVo3, "FINDGOODSTIFY");
                }
                if ("9".equals(goodsInfo.getGoodsType())) {
                    if (getSaleGoodsInfoIn.getQty() > 0.0) {
                        return Code.CODE_20021.getRespBase(new Object[0]);
                    }
                    GetSaleGoodsInfoOut out = new GetSaleGoodsInfoOut();
                    List goodsForCoice6 = this.goodsTransfer.transferGoodsList(goodsInfos, getSaleGoodsInfoIn.getBarNo());
                    out.setOrder(this.toGoodsForChoice(goodsForCoice6));
                    out.setSaleGoodsType("1");
                    ResqVo resqVo4 = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, (Object)resqVo4, "FINDGOODSTIFY");
                }
                if ("U".equalsIgnoreCase(cacheModel.getOrder().getOrderType()) && !"31".equals(goodsInfo.getGoodsType())) {
                    return Code.CODE_20102.getRespBase(new Object[0]);
                }
                if (!"U".equals(cacheModel.getOrder().getOrderType()) && "31".equals(goodsInfo.getGoodsType())) {
                    return Code.CODE_20103.getRespBase(new Object[0]);
                }
                if (cacheModel.getOrder().getHasGroupBuy() && cacheModel.getOrder().getSysPara().getSpecialGoodsType().contains(goodsInfo.getGoodsType())) {
                    return Code.CODE_20106.getRespBase(new Object[0]);
                }
                if (goodsInfo.getControlFlag()) {
                    for (Goods g : cacheModel.getGoodsList()) {
                        if (!g.getControlFlag()) continue;
                        return Code.CODE_20022.getRespBase(new Object[]{g.getBarNo()});
                    }
                    type = "2";
                }
                double qty = 1.0;
                if (getSaleGoodsInfoIn.getQty() > 0.0) {
                    qty = getSaleGoodsInfoIn.getQty();
                    isHaveQty = true;
                }
                goodsInfo.fixGoodsInfoStr();
                if ("2".equals(getSaleGoodsInfoIn.getCalcMode())) {
                    if (!SellType.ISKD((String)order.getOrderType()) && ManipulatePrecision.doubleCompare((double)goodsInfo.getSalePrice(), (double)0.0, (int)2) > 0 && ManipulatePrecision.doubleCompare((double)getSaleGoodsInfoIn.getRefPrice(), (double)goodsInfo.getSalePrice(), (int)2) < 0) {
                        return Code.CODE_20095.getRespBase(new Object[0]);
                    }
                    goodsInfo.setSalePrice(getSaleGoodsInfoIn.getRefPrice());
                    goodsInfo.setNoPricing("Y");
                    getSaleGoodsInfoIn.setCalcMode("0");
                }
                log.info("\u7535\u5b50\u79e4\u6807\u8bc6\uff1a" + goodsInfo.getEscaleFlag());
                if (1 == goodsInfo.getEscaleFlag() && dzc.getDzcmsl() <= 0.0 && dzc.getDzcmjg() <= 0.0 && getSaleGoodsInfoIn.getQty() <= 0.0) {
                    GetSaleGoodsInfoOut out = new GetSaleGoodsInfoOut();
                    goodsForCoice = this.goodsTransfer.transferGoodsList(goodsInfos, getSaleGoodsInfoIn.getBarNo());
                    out.setOrder(this.toGoodsForChoice(goodsForCoice));
                    for (GoodsForPos sg : out.getOrder().getGoodsList()) {
                        sg.setSalePrice(0.0);
                    }
                    out.setSaleGoodsType("4");
                    resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                    return new RespBase(Code.SUCCESS, resqVo, "FINDGOODSTIFY");
                }
                if (StringUtils.isNotEmpty((String)getSaleGoodsInfoIn.getMachineCode()) && cacheModel.getGoodsList().size() > 0 && !goodsInfo.getOrgCode().equals(((Goods)cacheModel.getGoodsList().get(0)).getOrgCode())) {
                    return Code.CODE_20101.getRespBase(new Object[]{"\u6e29\u99a8\u63d0\u793a\uff1a\u53ea\u5141\u8bb8\u540c\u4e00\u90e8\u95e8\u5546\u54c1\u4e00\u8d77\u5f00\u5355\uff0c\u8bf7\u786e\u8ba4\u540e\u91cd\u8bd5\uff01"});
                }
                ConsumersData consumersData = cacheModel.getOrder().getConsumersData();
                log.info("\u8c03\u7528\u8425\u9500\u4e4b\u524d\u8c03\u7528CalcGoodsAmountBeforeSingle\u65b9\u6cd5");
                goods = this.posLogicService.CalcGoodsAmountBeforeSingle(goodsInfo, getSaleGoodsInfoIn.getAssistantId(), isdzcm, dzc.getDzcmsl(), dzc.getDzcmjg(), cacheModel.getEleCodeMode(), originalBarNo, qty, isHaveQty, cacheModel.getPopMode().intValue());
                log.info("\u8c03\u7528CalcGoodsAmountBeforeSingle\u65b9\u6cd5\u7ed3\u675f==>{}", (Object)JSONObject.toJSONString((Object)goods));
                goods = this.getGoods(consumersData, goods, cacheModel);
                if (null == goods) {
                    if (1 == goodsInfo.getEscaleFlag()) {
                        return Code.CODE_20126.getRespBase(new Object[0]);
                    }
                    return Code.CODE_20023.getRespBase(new Object[0]);
                }
                if (goods.getQty() < 0.001) {
                    return Code.CODE_20127.getRespBase(new Object[0]);
                }
                if ("1".equals(jyms)) {
                    goods.setTempCategory(goods.getArtCode());
                }
                goods.setEatWay(order.getEatWay());
                if (getSaleGoodsInfoIn.getCalcMode().equals("3")) {
                    goods.setEatWay(getSaleGoodsInfoIn.getEatWay());
                    if (null != getSaleGoodsInfoIn.getStallCode() && getSaleGoodsInfoIn.getStallCode().length() > 0) {
                        goods.setStallCode(getSaleGoodsInfoIn.getStallCode());
                    }
                    goods.setCategoryPropertys(goodsInfo.getCategoryPropertys());
                    getSaleGoodsInfoIn.setCalcMode("0");
                }
                goods.setCalcMode(getSaleGoodsInfoIn.getCalcMode());
                goods.setGuid(UUIDUtils.buildGuid());
                goods.setFlowNo(getSaleGoodsInfoIn.getFlowNo());
                goods.setFlowId(cacheModel.getGoodsList().size() + 1);
                log.info("PRICEMODE=" + priceMode + ",DISVALUE=" + disValue + ",DISMODE=" + disMode + ",SALEAMOUNT=" + goods.getSaleAmount() + ",GOODSNO=" + goods.getGoodsNo());
                if (priceMode == 2 && ManipulatePrecision.doubleCompare((double)disValue, (double)0.0, (int)2) > 0) {
                    goods = this.posLogicCompoment.calcGoodsBarcodeDiscBeforeSingle(goods, disMode, disValue, discType);
                }
                if (maxGoodsCount > 0.0 && (double)cacheModel.getGoodsList().size() >= maxGoodsCount) {
                    return Code.CODE_20026.getRespBase(new Object[0]);
                }
                if (cacheModel.getMaxSaleGoodsQuantity() > 0.0 && goods.getQty() > cacheModel.getMaxSaleGoodsQuantity()) {
                    return Code.CODE_20027.getRespBase(new Object[0]);
                }
                if (cacheModel.getMaxSaleGoodsMoney() > 0.0 && goods.getSalePrice() > cacheModel.getMaxSaleGoodsMoney()) {
                    return Code.CODE_20028.getRespBase(new Object[0]);
                }
            }
            boolean isNeedRefreshBillId = false;
            if (null == cacheModel.getGoodsList() || cacheModel.getGoodsList().size() == 0) {
                isNeedRefreshBillId = true;
                LocalDateTime dateTime = LocalDateTime.now();
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                String nowDateTime = dateTime.format(df).toString();
                cacheModel.getOrder().setSaleDate(nowDateTime);
                cacheModel = this.changeSaleDate(cacheModel, syspara);
            }
            if (null != getSaleGoodsInfoIn.getRemark() && "" != getSaleGoodsInfoIn.getRemark()) {
                goods.setRemark(getSaleGoodsInfoIn.getRemark());
            }
            session.setEnt_id(2L);
            if (cacheModel.getPopMode() == 1) {
                log.info("\u8c03\u7528calcSinglePopService");
                RespBase respBase = this.calcPopRemoteService.calcSinglePopService(session, getSaleGoodsInfoIn.getCalcMode(), getSaleGoodsInfoIn.getGuid(), goods, vo, getSaleGoodsInfoIn.getPopDetails(), true, isNeedRefreshBillId, false);
                log.info("\u8c03\u7528\u7ed3\u675f=={}", (Object)JSONObject.toJSONString((Object)respBase));
                if (respBase.getRetflag() != 0) {
                    return respBase;
                }
                ResqVo resqVo = (ResqVo)respBase.getData();
                cacheModel = resqVo.getCacheModel();
                log.info(">>>>1.posLogicCompoment.calcOrderAmount");
                this.posLogicCompoment.calcOrderAmount(cacheModel);
                log.info("<<<<<2.posLogicCompoment.calcOrderAmount");
            } else if (cacheModel.getPopMode() == 2) {
                String calcMode = "0";
                ArrayList guidList = new ArrayList();
                if (-1 == (cacheModel = this.calcOrderPop(session, calcMode, cacheModel, vo, guidList)).getCalcResult()) {
                    errCode = "100000";
                    if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                        errCode = cacheModel.getErrCode();
                    }
                    for (Code code : Code.values()) {
                        if (code.getIndex() != Integer.parseInt(errCode)) continue;
                        return code.getRespBase(new Object[]{cacheModel.getErrMsg()});
                    }
                    return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)vo);
                }
            } else {
                cacheModel = this.addOneGoods(cacheModel, goods);
                log.info(">>>>3.posLogicCompoment.calcOrderAmount");
                this.posLogicCompoment.calcOrderAmount(cacheModel);
                log.info("<<<<<4.posLogicCompoment.calcOrderAmount");
            }
            log.info("fkcxs==>{},goods.getIsExcessSale()==>{},goods.getGbmanamode()==>{}", new Object[]{fkcxs, goods.getIsExcessSale(), goods.getGbmanamode()});
            if ("N".equals(fkcxs) && 0 == goods.getIsExcessSale() && "1".equals(goods.getGbmanamode())) {
                HashSet<String> goodsCodes = new HashSet<String>();
                goodsCodes.add(goods.getGoodsCode());
                log.info("\u5224\u65ad\u662f\u5426\u5141\u8bb8\u8d1f\u5e93\u5b58\u9500\u552e\u5f00\u59cb");
                RespBase response = this.searchShopStock(session, cacheModel, goodsCodes);
                log.info("\u5224\u65ad\u662f\u5426\u5141\u8bb8\u8d1f\u5e93\u5b58\u9500\u552e\u7ed3\u675f");
                if (Code.SUCCESS.getIndex() != response.getRetflag()) {
                    return response;
                }
            }
            long beforeSaveUpdateTime = System.currentTimeMillis();
            log.info("\u6dfb\u52a0\u5546\u54c1,flowNo:\u3010{}\u3011,\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", (Object)cacheModel.getFlowNo(), (Object)(beforeSaveUpdateTime - startTime));
            if (maxBusinessVolume > 0.0) {
                log.info("\u6574\u5355\u6700\u5927\u91d1\u989dmaxBusinessVolume\uff1a " + maxBusinessVolume);
                if (cacheModel.getOrder().getOughtPay() > maxBusinessVolume) {
                    return Code.CODE_20045.getRespBase(new Object[0]);
                }
            }
            if (cacheModel.getOrder().getTempZzk() != 100.0 && -1 == (cacheModel = this.posLogicCompoment.calcOrderRebateByRate(cacheModel, cacheModel.getCurGrant().getGh(), cacheModel.getOrder().getTempZzk())).getCalcResult()) {
                errCode = "100000";
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                }
                return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)vo);
            }
            if (cacheModel.getOrder().getTempZzr() != 0.0 && -1 == (cacheModel = this.posLogicCompoment.calcOrderRebateByAmount(cacheModel, cacheModel.getCurGrant().getGh(), cacheModel.getOrder().getTempZzr())).getCalcResult()) {
                errCode = "100000";
                if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                    errCode = cacheModel.getErrCode();
                }
                return new RespBase(Integer.parseInt(errCode), cacheModel.getErrMsg(), (Object)vo);
            }
            long afterSaveUpdateTime = System.currentTimeMillis();
            log.info("\u6dfb\u52a0\u5546\u54c1,save:\u3010{}\u3011,\u8017\u65f6\uff1a\u3010{}\u3011\u6beb\u79d2", (Object)cacheModel.getFlowNo(), (Object)(afterSaveUpdateTime - beforeSaveUpdateTime));
            GetSaleGoodsInfoOut out = new GetSaleGoodsInfoOut();
            out.setOrder(this.orderTransfer.toOrderForPosSingle(cacheModel));
            out.setSaleGoodsType(type);
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            return new RespBase(Code.SUCCESS, (Object)resqVo, "FINDGOODSTIFY");
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return Code.CODE_20029.getRespBase(new Object[]{Utils.getLastExceptionMessage((Exception)e)});
        }
    }

    public RespBase confirmSalesReturn(ServiceSession session, ResqVo vo) {
        RespBase resp;
        CacheModel cacheModel = vo.getCacheModel();
        String oldtConsumersCard = "";
        if (cacheModel.getOrder().getConsumersData() != null && StringUtils.isNotEmpty((String)cacheModel.getOrder().getConsumersData().getConsumersCard())) {
            oldtConsumersCard = cacheModel.getOrder().getConsumersData().getConsumersCard();
        }
        if (null != (resp = super.confirmSalesReturn(session, vo)) && Code.SUCCESS.getIndex() == resp.getRetflag() && StringUtils.isNotEmpty((String)oldtConsumersCard)) {
            JSONObject paramsObject = new JSONObject();
            paramsObject.put("testType", (Object)"1");
            paramsObject.put("custNo", (Object)oldtConsumersCard);
            paramsObject.put("shopCode", (Object)cacheModel.getOrder().getShopCode());
            RespBase respBase = this.v3VipRemoteService.login(session, vo, paramsObject);
            if (respBase.getRetflag() == 0) {
                CacheModel cacheModel2 = ((ResqVo)resp.getData()).getCacheModel();
                Order order = cacheModel2.getOrder();
                ConsumersData custData = ((ResqVo)respBase.getData()).getCacheModel().getOrder().getConsumersData();
                order.setTotalPoint(custData.getPoint());
                order.setPointCardNo(custData.getConsumersCard());
                order.setConsumersData(custData);
                cacheModel2.setOrder(order);
                BaseOutModel out = new BaseOutModel();
                out.setOrder(this.orderTransfer.toOrderForPosSingle(cacheModel2));
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
                return new RespBase(Code.SUCCESS, (Object)resqVo, "FINISHBACKSALE");
            }
        }
        return resp;
    }

    public RespBase getTempDetailJD(ServiceSession session, ResqVo vo) {
        log.info("\u7535\u5b50\u8ba2\u5355\u590d\u5236\u5546\u54c1-start");
        CacheModel cacheModel = vo.getCacheModel();
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getSyjmain().getMkt() + cacheModel.getSyjmain().getSyjh());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String cmjy = modeDetailsVo.getSysparaValue("CMJY");
        JSONArray res = vo.getJsonObject().getJSONArray("tempDetailList");
        List tempDetailOuts = res.toJavaList(TempDetailOut.class);
        double oughtPay = 0.0;
        double saleValue = 0.0;
        int qty = 0;
        ArrayList<String> guidList = new ArrayList<String>();
        for (TempDetailOut tempDetailOut : tempDetailOuts) {
            TempHead tempHead = tempDetailOut.getOrderstemphead();
            boolean i = false;
            HashMap stampaCodelist = new HashMap();
            try {
                for (TempDetails tempDetail : tempDetailOut.getOrderstempdetail()) {
                    log.info("\u7535\u5b50\u7968\u8be6\u60c5===\u300b{}", (Object)JSONObject.toJSONString((Object)tempDetail));
                    if (tempDetail.getFlag().equals("9") && tempDetail.getGoodsType().equals("97")) {
                        log.info("\u5370\u82b1\u5546\u54c1\uff1a{}", (Object)JSON.toJSONString((Object)tempDetail));
                        cacheModel = this.posLogicService.CalcGoodsAmountAfterStampCode(cacheModel, tempDetail.getGoodsCode(), cacheModel.getGoodsList().size() + 1);
                        if (cacheModel.getCalcResult() == -1 && StringUtils.isNotBlank((String)cacheModel.getErrMsg())) {
                            return Code.CODE_20134.getRespBase(new Object[]{cacheModel.getErrMsg()});
                        }
                    } else {
                        Goods goods = new Goods();
                        GoodsInfo goodsInfo = null;
                        GetGoodsDetailIn getGoodsDetailIn = new GetGoodsDetailIn();
                        List goodsInfos = null;
                        boolean isNeedFindMdm = true;
                        int priceMode = 0;
                        String originalBarNo = tempDetail.getGoodsCode();
                        int disMode = 0;
                        double disValue = 0.0;
                        String serchType = "2";
                        getGoodsDetailIn.setEntId(session.getEnt_id());
                        getGoodsDetailIn.setShopCode(cacheModel.getOrder().getShopCode());
                        getGoodsDetailIn.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                        getGoodsDetailIn.setCode(tempDetail.getBarNo());
                        getGoodsDetailIn.setSearchType(serchType);
                        getGoodsDetailIn.setErpCode(cacheModel.getOrder().getErpCode());
                        getGoodsDetailIn.setMachineCode(tempDetail.getMachineType());
                        getGoodsDetailIn.setOrgCode(tempDetail.getOrgCode());
                        if (isNeedFindMdm && (null == (goodsInfos = this.GetGoodsInfo(getGoodsDetailIn, session, cmjy)) || goodsInfos.size() == 0)) {
                            if (disValue == 0.0 && getGoodsDetailIn.getCode().length() < 13) {
                                getGoodsDetailIn.setCode(Convert.padLeft((String)getGoodsDetailIn.getCode(), (char)'0', (int)13));
                                goodsInfos = this.GetGoodsInfo(getGoodsDetailIn, session, cmjy);
                                if (null == goodsInfos || goodsInfos.size() == 0) {
                                    return Code.CODE_20087.getRespBase(new Object[0]);
                                }
                            } else {
                                return Code.CODE_20087.getRespBase(new Object[0]);
                            }
                        }
                        if (goodsInfos.size() <= 0) {
                            return Code.CODE_20104.getRespBase(new Object[0]);
                        }
                        goodsInfo = (GoodsInfo)goodsInfos.get(0);
                        goodsInfo.fixGoodsInfoStr();
                        this.goodsTransfer.transferGoodsInfoToGoods(goodsInfo, goods, 1.0);
                        goods.setEscaleFlag("N");
                        goodsInfo.setEscaleFlag(0);
                        this.goodsTransfer.transferGoodsInfoToGoods(goodsInfo, goods, tempDetail.getQty());
                        String guid = UUIDUtils.buildGuid();
                        guidList.add(guid);
                        goods.setGuid(guid);
                        goods.setGoodsNo(originalBarNo);
                        goods.setFlowId(cacheModel.getGoodsList().size() + 1);
                        goods.setFlowNo(cacheModel.getFlowNo());
                        goods.setAssistantId(tempDetail.getAssistantId());
                        goods.setSaleAmount(tempDetail.getSaleAmount());
                        goods.setSalePrice(tempDetail.getSalePrice());
                        goods.setListPrice(tempDetail.getListPrice());
                        goods.setSaleValue(tempDetail.getSaleValue());
                        goods.setPopFlag("C");
                        goods.setOrgCode(tempDetail.getOrgCode());
                        goods.setGoodsNo(tempDetail.getGoodsNo());
                        goods.setMachineCode(tempDetail.getMachineType());
                        goods.setExtendFt2(tempHead.getExtendFt1());
                        goods.setExtendFt3(goods.getMachineCode());
                        goods.setMemo(tempDetail.getExtendFt2());
                        goods.setOfcMarketCode(tempDetailOut.getOrderstempext().getOfcMarketCode());
                        if (cacheModel.getOrder().getHasEbill() == 1) {
                            goods.setEBillFlowNo(tempHead.getFlowNo());
                        }
                        if (priceMode == 2 && ManipulatePrecision.doubleCompare((double)disValue, (double)0.0, (int)2) > 0) {
                            if (disMode == 1) {
                                if (ManipulatePrecision.doubleCompare((double)disValue, (double)goods.getSaleAmount(), (int)2) >= 0) {
                                    goods.setBarcodeDiscount(goods.getSaleAmount());
                                } else {
                                    goods.setBarcodeDiscount(disValue);
                                }
                            } else if (disMode == 2) {
                                precisionMode = DataExchageUtils.exchangePrecisionMode((String)goods.getPrcutMode());
                                if (ManipulatePrecision.doubleCompare((double)disValue, (double)100.0, (int)2) > 0) {
                                    return Code.CODE_20089.getRespBase(new Object[0]);
                                }
                                goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow((double)(goods.getSaleAmount() * disValue), (String)precisionMode));
                            } else if (disMode == 3 && ManipulatePrecision.doubleCompare((double)goods.getSaleAmount(), (double)disValue, (int)2) > 0) {
                                precisionMode = DataExchageUtils.exchangePrecisionMode((String)goods.getPrcutMode());
                                goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow((double)(goods.getSaleAmount() - disValue), (String)precisionMode));
                            }
                            goods.setDisMode(disMode);
                            goods.setDisValue(disValue);
                        }
                        log.info("tempgoods:{}", (Object)JSONObject.toJSONString((Object)goods));
                        goods.setFixedDiscountValue(tempDetail.getFixedDiscount());
                        goods.setTempZrDiscount(tempDetail.getTempZrDiscount());
                        goods.setAdjustDiscountValue(this.posLogicCompoment.getAdjustDiscount(goods));
                        goods.setTotalDiscountValue(CountZZK.getZZK((Goods)goods));
                        goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert((double)(goods.getTotalDiscountValue() - goods.getNoDisAmountValue())));
                        goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
                        goods.setFlowId(cacheModel.getGoodsList().size() + 1);
                        goods.setSaleSpec(tempDetail.getSaleSpec());
                        if (StringUtils.isNotEmpty((String)tempDetail.getExtendFt1())) {
                            goods.setJdcouponAmount(tempDetail.getExtendFt1());
                        }
                        goods.setJdcouponNo(tempDetailOut.getOrderstempext().getReference());
                        cacheModel.getGoodsList().add(goods);
                    }
                    log.info("\u91cd\u7b97\u6298\u6263\u6298\u8ba9\u91d1\u989d-start");
                    log.info("\u91cd\u7b97\u6298\u6263\u6298\u8ba9\u91d1\u989d-end");
                }
                log.info("\u7535\u5b50\u5355\u6dfb\u52a0\u5546\u54c1end");
                oughtPay = ManipulatePrecision.doubleConvert((double)(oughtPay + tempHead.getOughtPay()));
                saleValue = ManipulatePrecision.doubleConvert((double)(saleValue + tempHead.getSaleValue()));
                qty += tempHead.getQty();
            }
            catch (Exception e) {
                log.error("\u7535\u5b50\u5b9a\u5355\u8be6\u60c5\u8c03\u51fa\u5f02\u5e38{}", (Throwable)e);
                return Code.CODE_20136.getRespBase(new Object[0]);
            }
        }
        Order order = cacheModel.getOrder();
        order.setOughtPay(ManipulatePrecision.doubleConvert((double)(oughtPay + order.getOughtPay())));
        order.setSaleValue(ManipulatePrecision.doubleConvert((double)(oughtPay + order.getSaleValue())));
        order.setQty(qty + order.getQty());
        SimpleDateFormat format = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
        order.setSaleDate(format.format(new Date()));
        order.setOrderType("1");
        JSONObject paramsObject = new JSONObject();
        paramsObject.put("calcMode", (Object)"0");
        paramsObject.put("count", (Object)guidList.size());
        paramsObject.put("qty", (Object)qty);
        paramsObject.put("guidList", guidList);
        log.info("\u7535\u5b50\u5355\u6574\u5355\u8ba1\u7b97start");
        log.info("\u7535\u5b50\u5355\u6574\u5355\u524d-goods====>{}", (Object)JSONObject.toJSONString((Object)cacheModel.getGoodsList()));
        RespBase respBase = this.calcPopRemoteService.calcSinglePopAll(session, "0", cacheModel, true);
        log.info("\u7535\u5b50\u5355\u6574\u5355\u8ba1\u7b97end");
        if (respBase.getRetflag() != 0) {
            return respBase;
        }
        cacheModel = (CacheModel)respBase.getData();
        log.info("\u7535\u5b50\u5355\u6574\u5355\u540e-goods====>{}", (Object)JSONObject.toJSONString((Object)cacheModel.getGoodsList()));
        cacheModel.setOrder(order);
        vo.setCacheModel(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "APPLIANCEORDER");
    }

    public RespBase searchShopStockJD(ServiceSession session, ResqVo vo) {
        log.info("\u5bb6\u7535\u5e93\u5b58\u67e5\u8be2-start");
        CacheModel cacheModel = vo.getCacheModel();
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getSyjmain().getMkt() + cacheModel.getSyjmain().getSyjh());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String extendFt2 = "";
        int ofcMarketCode = 0;
        if (vo.getJsonObject() != null && vo.getJsonObject().containsKey((Object)"extendFt2") && vo.getJsonObject().containsKey((Object)"ofcMarketCode")) {
            extendFt2 = vo.getJsonObject().getString("extendFt2");
            ofcMarketCode = vo.getJsonObject().getInteger("ofcMarketCode");
        }
        if (!SellType.ISSALE((String)cacheModel.getOrder().getOrderType()) || "U".equals(cacheModel.getOrder().getOrderType())) {
            return Code.SUCCESS.getRespBase(new Object[0]);
        }
        ArrayList codes = new ArrayList();
        try {
            JSONObject object = new JSONObject();
            object.put("erpCode", (Object)cacheModel.getOrder().getErpCode());
            JSONArray goods = new JSONArray();
            for (Goods good : cacheModel.getGoodsList()) {
                if (!StringUtils.isNotEmpty((String)good.getMachineCode())) continue;
                JSONObject goodobj = new JSONObject();
                goodobj.put("code", (Object)good.getBarNo());
                goodobj.put("bmdm", (Object)good.getOrgCode());
                goodobj.put("spjx", (Object)good.getMachineCode());
                if (StringUtils.isNotEmpty((String)extendFt2)) {
                    good.setExtendFt2(extendFt2);
                    good.setOfcMarketCode(ofcMarketCode);
                }
                goods.add((Object)goodobj);
            }
            object.put("goods", (Object)goods);
            ServiceResponse rs = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, SEARCHSHOPSTOCKJD, session, JSON.toJSONString((Object)object), ShopStockJD.class, "\u5e93\u5b58\u4e2d\u5fc3", "\u5546\u54c1\u5e93\u5b58\u67e5\u8be2");
            if (!"0".equals(rs.getReturncode()) && rs.getData() != null) {
                return new RespBase(Code.CODE_20109.getIndex(), rs.getData().toString());
            }
            List stockJDS = (List)rs.getData();
            if (null == stockJDS || null == stockJDS || stockJDS.size() <= 0) {
                return Code.CODE_20109.getRespBase(new Object[0]);
            }
            if (vo.getJsonObject() != null && vo.getJsonObject().containsKey((Object)"search")) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("stockJDS", (Object)stockJDS);
                ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)jsonObject);
                return new RespBase(Code.SUCCESS, (Object)resqVo, "APPLIANCESTOCK");
            }
            return this.checkStockJD(cacheModel, stockJDS);
        }
        catch (Exception e) {
            return Code.CODE_20109.getRespBase(new Object[0]);
        }
    }

    public RespBase splitMachineTypeQuery(ServiceSession session, JSONObject bodyJson) {
        log.info("\u5bb6\u7535\u578b\u53f7\u67e5\u8be2-start");
        Map stringObjectMap = this.saleGoodsModelService.splitMachineTypeQuery((Map)bodyJson);
        try {
            return new RespBase(Code.SUCCESS, (Object)stringObjectMap);
        }
        catch (Exception e) {
            return Code.CODE_20079.getRespBase(new Object[0]);
        }
    }

    protected RespBase checkStockJD(CacheModel cacheModel, List<ShopStockJD> shopStocks) {
        for (Goods sg : cacheModel.getGoodsList()) {
            if ("1".equals(sg.getExtendFt2()) || "0".equals(sg.getExtendFt2()) && "3".equals(sg.getGbmanamode()) && sg.getOperateFlag() >= 4) continue;
            for (ShopStockJD stockJD : shopStocks) {
                if (!stockJD.getSPCODE().equals(sg.getBarNo()) || !stockJD.getBMDM().equals(sg.getOrgCode()) || !sg.getMachineCode().equals(stockJD.getSPJX())) continue;
                if (sg.getOfcMarketCode() == 0) {
                    if (!(sg.getQty() > (double)stockJD.getPSZXKC())) continue;
                    return Code.CODE_20101.getRespBase(new Object[]{"\u5546\u54c1" + sg.getBarNo() + "\u914d\u9001\u90e8\u95e8\u5e93\u5b58\u4e0d\u8db3\u65e0\u6cd5\u9500\u552e,\u5f53\u524d\u53ef\u7528\u5e93\u5b58\uff1a" + stockJD.getPSZXKC()});
                }
                if (!(sg.getQty() > (double)stockJD.getXSBMKC())) continue;
                return Code.CODE_20101.getRespBase(new Object[]{"\u5546\u54c1" + sg.getBarNo() + "\u9500\u552e\u90e8\u95e8\u5e93\u5b58\u4e0d\u8db3\u65e0\u6cd5\u9500\u552e,\u5f53\u524d\u53ef\u7528\u5e93\u5b58\uff1a" + stockJD.getXSBMKC()});
            }
        }
        return Code.SUCCESS.getRespBase(new Object[0]);
    }

    protected RespBase checkfunc(CacheModel cacheModel, GetSaleGoodsInfoIn getSaleGoodsInfoIn) {
        return Code.SUCCESS.getRespBase(new Object[0]);
    }

    public RespBase getGoodsDetailJD(ServiceSession session, ResqVo vo) {
        log.info("\u65e0\u5355\u9000\u8d27\u5bb6\u7535\u8ba2\u5355\u590d\u5236\u5546\u54c1-start");
        CacheModel cacheModel = vo.getCacheModel();
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getSyjmain().getMkt() + cacheModel.getSyjmain().getSyjh());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String cmjy = modeDetailsVo.getSysparaValue("CMJY");
        JSONArray res = vo.getJsonObject().getJSONArray("spList");
        String orderno = vo.getJsonObject().getString("orderno");
        JSONObject jdOrder = vo.getJsonObject().getJSONObject("jdOrder");
        List spList = res.toJavaList(GoodForJd.class);
        OrderForJd orderForJd = (OrderForJd)jdOrder.toJavaObject(OrderForJd.class);
        double oughtPay = 0.0;
        double saleValue = 0.0;
        int qty = 0;
        for (GoodForJd sp : spList) {
            log.info("\u7535\u5b50\u7968\u8be6\u60c5===\u300b{}", (Object)JSONObject.toJSONString((Object)sp));
            Goods goods = new Goods();
            GoodsInfo goodsInfo = null;
            GetGoodsDetailIn getGoodsDetailIn = new GetGoodsDetailIn();
            List goodsInfos = null;
            boolean isNeedFindMdm = true;
            int priceMode = 0;
            String originalBarNo = sp.getSPCODE();
            int disMode = 0;
            double disValue = 0.0;
            String serchType = "2";
            getGoodsDetailIn.setEntId(session.getEnt_id());
            getGoodsDetailIn.setShopCode(cacheModel.getOrder().getShopCode());
            getGoodsDetailIn.setTerminalNo(cacheModel.getOrder().getTerminalNo());
            getGoodsDetailIn.setCode(sp.getSPCODE());
            getGoodsDetailIn.setSearchType(serchType);
            getGoodsDetailIn.setErpCode(cacheModel.getOrder().getErpCode());
            getGoodsDetailIn.setMachineCode(String.valueOf(sp.getSPJX()));
            getGoodsDetailIn.setOrgCode(sp.getBMDM());
            if (isNeedFindMdm && (null == (goodsInfos = this.GetGoodsInfo(getGoodsDetailIn, session, cmjy)) || goodsInfos.size() == 0)) {
                if (disValue == 0.0 && getGoodsDetailIn.getCode().length() < 13) {
                    getGoodsDetailIn.setCode(Convert.padLeft((String)getGoodsDetailIn.getCode(), (char)'0', (int)13));
                    goodsInfos = this.GetGoodsInfo(getGoodsDetailIn, session, cmjy);
                    if (null == goodsInfos || goodsInfos.size() == 0) {
                        return Code.CODE_20087.getRespBase(new Object[0]);
                    }
                } else {
                    return Code.CODE_20087.getRespBase(new Object[0]);
                }
            }
            if (goodsInfos.size() <= 0) {
                return Code.CODE_20104.getRespBase(new Object[0]);
            }
            goodsInfo = (GoodsInfo)goodsInfos.get(0);
            goodsInfo.fixGoodsInfoStr();
            this.goodsTransfer.transferGoodsInfoToGoods(goodsInfo, goods, 1.0);
            goods.setEscaleFlag("N");
            goodsInfo.setEscaleFlag(0);
            this.goodsTransfer.transferGoodsInfoToGoods(goodsInfo, goods, (double)sp.getTHSL());
            String guid = UUIDUtils.buildGuid();
            goods.setGuid(guid);
            goods.setGoodsNo(originalBarNo);
            goods.setFlowId(cacheModel.getGoodsList().size() + 1);
            goods.setFlowNo(cacheModel.getFlowNo());
            goods.setAssistantId(orderForJd.getYYYDM());
            goods.setSaleAmount(sp.getXSJE());
            goods.setSalePrice(sp.getLSDJ());
            goods.setListPrice(sp.getLSDJ());
            goods.setSaleValue(sp.getLSDJ() * (double)sp.getTHSL());
            goods.setOrgCode(sp.getBMDM());
            goods.setMachineCode(String.valueOf(sp.getSPJX()));
            goods.setExtendFt2(orderForJd.getYDFS());
            goods.setExtendFt3(String.valueOf(sp.getSPJX()));
            goods.setMemo(String.valueOf(sp.getXSDJ()));
            goods.setOriginalFlowId(Integer.valueOf(sp.getSKT_INX()));
            goods.setJdcouponAmount(String.valueOf(sp.getRCJE()));
            if (cacheModel.getOrder().getHasEbill() == 1) {
                goods.setEBillFlowNo(sp.getJLBH());
            }
            if (priceMode == 2 && ManipulatePrecision.doubleCompare((double)disValue, (double)0.0, (int)2) > 0) {
                if (disMode == 1) {
                    if (ManipulatePrecision.doubleCompare((double)disValue, (double)goods.getSaleAmount(), (int)2) >= 0) {
                        goods.setBarcodeDiscount(goods.getSaleAmount());
                    } else {
                        goods.setBarcodeDiscount(disValue);
                    }
                } else if (disMode == 2) {
                    precisionMode = DataExchageUtils.exchangePrecisionMode((String)goods.getPrcutMode());
                    if (ManipulatePrecision.doubleCompare((double)disValue, (double)100.0, (int)2) > 0) {
                        return Code.CODE_20089.getRespBase(new Object[0]);
                    }
                    goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow((double)(goods.getSaleAmount() * disValue), (String)precisionMode));
                } else if (disMode == 3 && ManipulatePrecision.doubleCompare((double)goods.getSaleAmount(), (double)disValue, (int)2) > 0) {
                    precisionMode = DataExchageUtils.exchangePrecisionMode((String)goods.getPrcutMode());
                    goods.setBarcodeDiscount(ManipulatePrecision.getDetailOverFlow((double)(goods.getSaleAmount() - disValue), (String)precisionMode));
                }
                goods.setDisMode(disMode);
                goods.setDisValue(disValue);
            }
            log.info("tempgoods:{}", (Object)JSONObject.toJSONString((Object)goods));
            goods.setAllowReturnCopies(Double.valueOf(CastUtil.castDouble((Object)sp.getTHSL())));
            goods.setTempZrDiscount(ManipulatePrecision.doubleConvert((double)(sp.getLSDJ() - sp.getXSDJ())));
            goods.setAdjustDiscountValue(this.posLogicCompoment.getAdjustDiscount(goods));
            goods.setTotalDiscountValue(CountZZK.getZZK((Goods)goods));
            goods.setRealTotalDiscountValue(ManipulatePrecision.doubleConvert((double)(goods.getTotalDiscountValue() - goods.getNoDisAmountValue())));
            goods.setSaleAmount(goods.getSaleValue() - goods.getTotalDiscountValue());
            goods.setFlowId(cacheModel.getGoodsList().size() + 1);
            cacheModel.getGoodsList().add(goods);
            cacheModel.setPopMode(Integer.valueOf(0));
            qty = (int)((double)qty + goods.getQty());
            oughtPay = ManipulatePrecision.doubleConvert((double)(oughtPay + sp.getXSJE()));
            saleValue = ManipulatePrecision.doubleConvert((double)(saleValue + goods.getSaleValue()));
            log.info("\u91cd\u7b97\u6298\u6263\u6298\u8ba9\u91d1\u989d-start");
            log.info("\u91cd\u7b97\u6298\u6263\u6298\u8ba9\u91d1\u989d-end");
        }
        Order order = cacheModel.getOrder();
        order.setOughtPay(oughtPay);
        order.setSaleValue(saleValue);
        order.setQty(qty);
        SimpleDateFormat format = new SimpleDateFormat("YYYY-MM-dd HH:mm:ss");
        order.setSaleDate(format.format(new Date()));
        cacheModel.getOrder().setYpopBillNo(orderForJd.getSKTNO() + "|" + orderForJd.getSKTJLBH() + "|" + orderno);
        cacheModel.setOrder(order);
        vo.setCacheModel(cacheModel);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "GETAPPLIANCERETURN");
    }
}

