/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Coupon;
import com.efuture.business.javaPos.struct.CouponGain;
import com.efuture.business.javaPos.struct.CouponUse;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.OrderForPos;
import com.efuture.business.javaPos.struct.OrderGains;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailPopModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersGainDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersUseCouponModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrders_WSLF;
import com.efuture.business.javaPos.struct.orderCentre.response.OrdersDetailOut;
import com.efuture.business.javaPos.struct.orderCentre.response.OrdersQueryOut;
import com.efuture.business.javaPos.struct.request.SkpResqVo;
import com.efuture.business.javaPos.struct.response.PayConfirmOut;
import com.efuture.business.javaPos.struct.response.SkpRespVo;
import com.efuture.business.javaPos.struct.skp.Article;
import com.efuture.business.javaPos.struct.skp.PresaleBill;
import com.efuture.business.javaPos.struct.skp.PromBillId;
import com.efuture.business.javaPos.struct.skp.UploadGoodsReq;
import com.efuture.business.javaPos.struct.skp.UploadGoodsRes;
import com.efuture.business.model.GetHdOrderListIn;
import com.efuture.business.model.ToSaleIn;
import com.efuture.business.model.UpdateHdBillDate;
import com.efuture.business.service.OrderPosOuterService;
import com.efuture.business.service.OrderSaleBS;
import com.efuture.business.service.SkpHdSaleBS;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.OrderUtil;
import com.efuture.business.util.PaymentUtil;
import com.efuture.business.util.RedisUtil;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

public class SkpHdSaleBSImpl
implements SkpHdSaleBS {
    private static final Logger log = LoggerFactory.getLogger(SkpHdSaleBSImpl.class);
    @Autowired(required=false)
    public OrderPosOuterService orderPosOuterService;
    @Autowired
    private RedisUtil redisUtil;
    RestTemplate restTemplate;
    @Resource(name="possvHttpUtils")
    protected HttpUtils httpUtils;
    @Value(value="${localcache.enabled}")
    protected Boolean localcache;
    @Autowired
    private OrderSaleBS orderSaleBS;
    private static String SEARCHYSORDERLIST = "order.online.query.searchYsOrderList";
    private static String SEARCHHDSALEORDERLIST = "order.online.query.searchHdSaleOrderList";
    private static String UPDATEYSORDERBILLDATE = "order.online.query.updateYsOrderBillDate";
    private static String CONVERTYSORDERTOSALE = "order.online.query.convertYsOrderToSale";

    public RespBase getHdOrderList(ServiceSession session, JSONObject paramsObject) {
        if (this.localcache.booleanValue()) {
            return new RespBase(Code.CODE_50025.getIndex(), "\u8d27\u8ba2\u529f\u80fd\u5fc5\u987b\u8054\u7f51\u4f7f\u7528\uff01");
        }
        GetHdOrderListIn getOrdersIn = (GetHdOrderListIn)JSON.parseObject((String)paramsObject.toJSONString(), GetHdOrderListIn.class);
        if (getOrdersIn == null) {
            return Code.CODE_60028.getRespBase(new Object[]{"\u5165\u53c2\u8f6c\u6362\u5931\u8d25"});
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + getOrdersIn.getShopCode() + getOrdersIn.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        getOrdersIn.setCabinetGroup(modeDetailsVo.getSyjmain().getSyjgz());
        getOrdersIn.setBusiTakeMarketCode(getOrdersIn.getShopCode());
        getOrdersIn.setShopCode(null);
        getOrdersIn.setExtendFt4(getOrdersIn.getTerminalOperator());
        getOrdersIn.setTerminalOperator(null);
        getOrdersIn.setOrder_field("saleDate");
        getOrdersIn.setOrder_direction("desc");
        getOrdersIn.setTerminalNo(null);
        JSONObject jsonObject = new JSONObject();
        jsonObject.put(">=", (Object)getOrdersIn.getStartDate());
        jsonObject.put("<=", (Object)getOrdersIn.getEndDate());
        getOrdersIn.setSaleDate(jsonObject);
        getOrdersIn.setStartDate(null);
        getOrdersIn.setEndDate(null);
        ServiceResponse resp = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, SEARCHYSORDERLIST, session, JSON.toJSONString((Object)getOrdersIn), OrdersQueryOut.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u67e5\u8be2\u672a\u786e\u8ba4\u9500\u552e\u7684\u9884\u552e\u8ba2\u5355");
        if ("0".equals(resp.getReturncode())) {
            OrdersQueryOut data = (OrdersQueryOut)resp.getData();
            return new RespBase(Code.SUCCESS, (Object)data.transferOrderToGetOrdersOut());
        }
        return Code.CODE_60028.getRespBase(new Object[]{resp.getData()});
    }

    public RespBase searchHdSaleOrderList(ServiceSession session, ResqVo vo) {
        JSONObject paramsObject = vo.getJsonObject();
        if (this.localcache.booleanValue()) {
            return new RespBase(Code.CODE_50025.getIndex(), "\u8d27\u8ba2\u529f\u80fd\u5fc5\u987b\u8054\u7f51\u4f7f\u7528\uff01");
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        GetHdOrderListIn getOrdersIn = (GetHdOrderListIn)JSON.parseObject((String)paramsObject.toJSONString(), GetHdOrderListIn.class);
        if (getOrdersIn == null) {
            return Code.CODE_60028.getRespBase(new Object[]{"\u5165\u53c2\u8f6c\u6362\u5931\u8d25"});
        }
        getOrdersIn.setBusiTakeMarketCode(getOrdersIn.getShopCode());
        getOrdersIn.setShopCode(null);
        ServiceResponse resp = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, SEARCHHDSALEORDERLIST, session, JSON.toJSONString((Object)getOrdersIn), OrdersQueryOut.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u67e5\u8be2\u5df2\u8f6c\u9500\u552e\u7684\u8d27\u8ba2\u8ba2\u5355");
        if ("0".equals(resp.getReturncode())) {
            OrdersQueryOut data = (OrdersQueryOut)resp.getData();
            if (data.getTotal_results() == 0) {
                return Code.CODE_60028.getRespBase(new Object[]{"\u8ba2\u5355\u4e0d\u5b58\u5728"});
            }
            cacheModel.getOrder().setOriginIdSheetNo(((OrdersModel)data.getOrders().get(0)).getSheetNo());
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)data.transferOrderToGetOrdersOut())));
            return new RespBase(Code.SUCCESS, (Object)resqVo);
        }
        return Code.CODE_60028.getRespBase(new Object[]{resp.getData()});
    }

    public RespBase updateHdBillDate(ServiceSession session, JSONObject paramsObject) {
        if (this.localcache.booleanValue()) {
            return new RespBase(Code.CODE_50025.getIndex(), "\u8d27\u8ba2\u529f\u80fd\u5fc5\u987b\u8054\u7f51\u4f7f\u7528\uff01");
        }
        if (!paramsObject.containsKey((Object)"oid") || paramsObject.getString("oid").isEmpty()) {
            return new RespBase(Code.CODE_50025.getIndex(), "\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u8ba2\u5355\u4e3b\u952e]");
        }
        UpdateHdBillDate in = (UpdateHdBillDate)JSONObject.toJavaObject((JSON)paramsObject, UpdateHdBillDate.class);
        ServiceResponse resp = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, UPDATEYSORDERBILLDATE, session, JSON.toJSONString((Object)in), Object.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u6279\u91cf\u4fee\u6539\u8bb0\u8d26\u65e5\u671f");
        if ("0".equals(resp.getReturncode())) {
            return new RespBase(Code.SUCCESS);
        }
        return new RespBase(Code.CODE_60028.getIndex(), "\u4fee\u6539\u8bb0\u8d26\u65e5\u671f\u5931\u8d25\uff1a" + resp.getData());
    }

    public RespBase convertHdOrderToSale(ServiceSession session, JSONObject paramsObject) {
        SkpRespVo out;
        if (!paramsObject.containsKey((Object)"oid") || paramsObject.getString("oid").isEmpty()) {
            return new RespBase(Code.CODE_50025.getIndex(), "\u8d27\u8ba2\u8ba2\u5355\u8f6c\u9500\u552e\u5fc5\u987b\u5305\u542b\u53c2\u6570[\u8ba2\u5355\u4e3b\u952e]");
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("oid", (Object)paramsObject.getString("oid"));
        int orderQty = paramsObject.getInteger("orderQty");
        if (orderQty == 0) {
            return Code.CODE_50100.getRespBase(new Object[]{"\u975e\u6cd5\u6570\u636eorderQty == 0"});
        }
        CacheModel cacheModel = new CacheModel();
        SaleOrders_WSLF saleOrder = null;
        RespBase resp = this.orderPosOuterService.searchOrdersDetailFromCloud(session, jsonObject);
        if (Code.SUCCESS.getIndex() == resp.getRetflag()) {
            OrdersDetailOut getOrdersDetailOut = (OrdersDetailOut)JSONObject.toJavaObject((JSON)((JSONObject)JSONObject.toJSON((Object)resp.getData())), OrdersDetailOut.class);
            saleOrder = getOrdersDetailOut.getOrderInfo();
            if (saleOrder.getOrders() == null) {
                return Code.CODE_60016.getRespBase(new Object[]{resp.getData()});
            }
            cacheModel = this.TransferCacheModel(saleOrder, cacheModel);
        }
        Order order = cacheModel.getOrder();
        String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("mkt") + paramsObject.getString("terminalNo"));
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String hydz = modeDetailsVo.getSyjmain().getHydz();
        String storeCode = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MDDM");
        String cykey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"CYKEY");
        cacheModel.getOrder().setExtendMode(modeDetailsVo.getExtendMode());
        UploadGoodsReq in = this.loadRequestPara(cacheModel);
        in.setStoreCode(storeCode);
        SkpResqVo req = new SkpResqVo((Object)in);
        ServiceResponse res = this.httpUtils.doSkpPost(cykey, hydz, "BFPLAT.CRM.VIP.SAVERSALEBILLARTICLES", session, JSON.toJSONString((Object)req), SkpRespVo.class, "Skp", "\u4f1a\u5458\u4ea4\u6613\u4e0a\u4f20\u5546\u54c1");
        String serverBillid = "";
        if ("0".equals(res.getReturncode())) {
            out = (SkpRespVo)res.getData();
            if (!"0".equals(out.getRetCode())) {
                return Code.CODE_50025.getRespBase(new Object[]{"\u4ea4\u6613\u4e0a\u4f20\u5546\u54c1\u5931\u8d25\uff1a" + out.getRetMsg()});
            }
        } else {
            return Code.CODE_50100.getRespBase(new Object[]{"\u8fde\u63a5\u5f02\u5e38"});
        }
        UploadGoodsRes res1 = (UploadGoodsRes)JSONObject.toJavaObject((JSON)out.getData(), UploadGoodsRes.class);
        serverBillid = String.valueOf(res1.getServerBillid());
        cacheModel.getOrder().setExtendFt2(serverBillid);
        cacheModel.getOrder().setExtendFt1("0");
        order.setTerminalNo(paramsObject.getString("terminalNo"));
        order.setShopCode(paramsObject.getString("mkt"));
        RespBase respBase = this.orderSaleBS.checkoutbill(session, ResqVo.buildReqVo((CacheModel)cacheModel));
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        ToSaleIn in1 = new ToSaleIn();
        in1.setBusiTakeMarketCode(cacheModel.getOrder().getShopCode());
        in1.setOid(saleOrder.getOrders().getOid().longValue());
        if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
            ArrayList couponGains = new ArrayList();
            ArrayList couponGainsDetail = new ArrayList();
            for (Goods g : cacheModel.getGoodsList()) {
                if (g.getCouponGains() == null || g.getCouponGains().size() <= 0) continue;
                couponGainsDetail.addAll(CouponGain.transferOrderGainModel((List)g.getCouponGains(), (int)g.getFlowId()));
            }
            if (couponGains.size() > 0) {
                in1.setOrdersGainDetail(couponGainsDetail);
            }
        }
        if (null != order.getCouponDetails() && order.getCouponDetails().size() > 0) {
            in1.setOrdersGain(Coupon.transferOrdersGainModel((List)order.getCouponDetails()));
        }
        in1.setThisTimeGivePoint(order.getThisTimePoint());
        in1.setServerBillId(serverBillid);
        in1.setOrderQty(orderQty);
        ServiceResponse resp2 = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, CONVERTYSORDERTOSALE, session, JSON.toJSONString((Object)in1), String.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u6279\u91cf\u8f6c\u9500\u552e");
        if ("0".equals(resp2.getReturncode())) {
            PayConfirmOut out2 = new PayConfirmOut();
            OrderForPos orderForPos = OrderForPos.toOrderForPosSingle((CacheModel)cacheModel);
            orderForPos.setOrderState(7);
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            try {
                String nowDateTime = sdf.format(new Date());
                orderForPos.setScanSubmitTime(nowDateTime);
            }
            catch (Exception nowDateTime) {
                // empty catch block
            }
            List couponDetails = cacheModel.getOrder().getCouponDetails();
            OrderGains orderGain = OrderGains.toOrderGains((List)couponDetails);
            if (null != orderGain) {
                out2.setCouponGain(orderGain.getOrderCouponGains());
            }
            if (null != cacheModel.getLeftSaleMoneyList()) {
                out2.setLeftSaleMoneyList(cacheModel.getLeftSaleMoneyList());
            }
            out2.setAchievePoints(cacheModel.getOrder().getThisTimePoint());
            orderForPos.setTotalPoint(ManipulatePrecision.doubleConvert((double)(cacheModel.getOrder().getTotalPoint() - cacheModel.getOrder().getThisTimeUsedPoint() + cacheModel.getOrder().getThisTimePoint())));
            orderForPos.setTotalBasePoint(ManipulatePrecision.doubleConvert((double)(cacheModel.getOrder().getTotalBasePoint() - cacheModel.getOrder().getThisTimeUsedPoint() + cacheModel.getOrder().getThisTimeBasePoint())));
            out2.setOrder(orderForPos);
            return new RespBase(Code.SUCCESS, (Object)out2, "CONVERTYSORDERTOSALE", cacheModel.getOrder().getFlowNo());
        }
        JSONObject j = new JSONObject();
        j.put("serverBillId", (Object)CastUtil.castInt((Object)order.getExtendFt2()));
        SkpResqVo request = new SkpResqVo((Object)j);
        ServiceResponse response = this.httpUtils.doSkpPost(cykey, hydz, "BFPLAT.CRM.VIP.CANCELCHECKOUTBILL", session, JSON.toJSONString((Object)request), SkpRespVo.class, "Skp", "\u51c6\u5907\u7ed3\u8d26\u53d6\u6d88");
        if ("0".equals(response.getReturncode())) {
            SkpRespVo re = (SkpRespVo)response.getData();
            if ("0".equals(re.getRetCode())) {
                return Code.CODE_60028.getRespBase(new Object[]{resp2.getData()});
            }
            return Code.CODE_60046.getRespBase(new Object[]{"\u51b2\u6b63\u5931\u8d25," + re.getRetMsg()});
        }
        return Code.CODE_60046.getRespBase(new Object[]{"\u51b2\u6b63\u5931\u8d25,\u8fde\u63a5\u5f02\u5e38"});
    }

    public JSONObject computeBillDateForSearch(String createDate) {
        if (StringUtils.isBlank((String)createDate)) {
            return null;
        }
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            Date date = dateFormat.parse(createDate);
            String beginDate = createDate + " 00:00:00";
            String endDate = createDate + " 23:59:59";
            JSONObject j = new JSONObject();
            j.put(">=", (Object)beginDate);
            j.put("<=", (Object)endDate);
            return j;
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u4e2d\u5fc3\u8ba1\u7b97\u8bb0\u8d26\u65e5\u671f\u5931\u8d25: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public UploadGoodsReq loadRequestPara(CacheModel cacheModel) {
        int i;
        Order order = cacheModel.getOrder();
        UploadGoodsReq in = new UploadGoodsReq();
        in.setPosId(order.getTerminalNo());
        in.setOrderNo(order.getFlowNo());
        in.setBillId(CastUtil.castInt((Object)order.getTerminalSno()));
        in.setCashier(order.getTerminalOperator());
        if (null != order.getConsumersData() && StringUtils.isNotBlank((String)order.getConsumersData().getConsumersId())) {
            in.setVipId(Integer.parseInt(order.getConsumersData().getConsumersId()));
        } else {
            in.setVipId(0);
        }
        in.setType(0);
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            in.setAccountDate(sdf.format(new Date()));
            sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            in.setShoppingTime(sdf.format(new Date()));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean jjhg = false;
        if (null != cacheModel.getGoodsList() && cacheModel.getGoodsList().size() > 0) {
            for (i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                Goods goods = (Goods)cacheModel.getGoodsList().get(i);
                if (goods.getIsNoBackGift() || "9".equals(goods.getFlag())) continue;
                Article article = new Article();
                if (SellType.ISBACK((String)order.getOrderType())) {
                    article.setAmount(goods.getSaleAmount() * -1.0);
                } else {
                    article.setAmount(goods.getSaleAmount());
                }
                article.setIsBrandOrder(true);
                article.setBrandOrderNo(cacheModel.getOrder().getFlowNo());
                article.setCode(goods.getGoodsCode());
                article.setInx(goods.getFlowId());
                if (SellType.ISBACK((String)order.getOrderType())) {
                    if (null != cacheModel.getReturnGoodsList() && cacheModel.getReturnGoodsList().size() > 0) {
                        for (Goods g : cacheModel.getReturnGoodsList()) {
                            if (!goods.getGuid().equals(g.getGuid())) continue;
                            article.setOriginalInx(g.getFlowId());
                        }
                    } else {
                        article.setOriginalInx(-1);
                    }
                }
                article.setQuantity(goods.getQty());
                if ("1".equals(order.getChannel())) {
                    article.setSaleDept(goods.getOrgCode());
                } else {
                    article.setSaleDept(order.getShopCode());
                }
                in.getArticleList().add(article);
                if (jjhg || !"8".equals(goods.getFlag())) continue;
                jjhg = true;
            }
        }
        if (null != order.getBilllist() && order.getBilllist().size() > 0) {
            for (i = 0; i < order.getBilllist().size(); ++i) {
                PresaleBill presaleBill = (PresaleBill)order.getBilllist().get(i);
                PromBillId promBillId = new PromBillId();
                promBillId.setBillId(CastUtil.castInt((Object)presaleBill.getPopbillid()));
                promBillId.setInx(i + 1);
                promBillId.setBillType(CastUtil.castInt((Object)presaleBill.getPopbilltype()));
                in.getPromBillIds().add(promBillId);
            }
            if (null != order.getRealBillDate()) {
                in.setPreSaleDate(order.getRealBillDate().substring(0, 10));
            }
        }
        boolean cwzf = false;
        if (null != cacheModel.getPayments() && cacheModel.getPayments().size() > 0) {
            for (Payment p : cacheModel.getPayments()) {
                if (!StringUtils.isNotBlank((String)p.getMemo()) || !"1".equals(p.getMemo())) continue;
                cwzf = true;
                break;
            }
        }
        if (jjhg) {
            in.setIsNotDelete(1);
        }
        if (cwzf) {
            in.setIsNotDelete(1);
        }
        return in;
    }

    public CacheModel TransferCacheModel(SaleOrders_WSLF orderQueryOut, CacheModel cacheModel) {
        Double totalQty = 0.0;
        ArrayList<Goods> goodslist = new ArrayList<Goods>();
        for (OrdersDetailModel saleDetail : orderQueryOut.getOrdersDetail()) {
            if ("0".equals(saleDetail.getGoodsFlag()) || "97".equals(saleDetail.getGoodType())) continue;
            totalQty = saleDetail.getWeighGood() != false ? Double.valueOf(totalQty + 1.0) : Double.valueOf(totalQty + saleDetail.getQty());
            goodslist.add(Goods.transferGoods2((OrdersDetailModel)saleDetail));
        }
        cacheModel.getOrder().setQty(totalQty.intValue());
        cacheModel.setPayments(PaymentUtil.transferPayment((List)orderQueryOut.getOrdersPay()));
        cacheModel.setOrder(OrderUtil.transferOrder((SaleOrders_WSLF)orderQueryOut, (Order)cacheModel.getOrder()));
        double gainPoints = 0.0;
        if (orderQueryOut.getOrdersGainDetail() != null && !orderQueryOut.getOrdersGainDetail().isEmpty()) {
            List orderGainDetails = orderQueryOut.getOrdersGainDetail();
            for (int i = 0; i < orderGainDetails.size(); ++i) {
                OrdersGainDetailModel ordersGainDetailModel = (OrdersGainDetailModel)orderGainDetails.get(i);
                if ("01".equals(ordersGainDetailModel.getCouponGroup())) {
                    gainPoints = ManipulatePrecision.add((double)gainPoints, (double)ordersGainDetailModel.getAmount().doubleValue());
                }
                for (int j = 0; j < goodslist.size(); ++j) {
                    Goods goods = (Goods)goodslist.get(j);
                    if (goods.getFlowId() != ordersGainDetailModel.getRowNo().intValue()) continue;
                    if (goods.getCouponGains() == null) {
                        goods.setCouponGains(new ArrayList());
                    }
                    goods.getCouponGains().add(Goods.transferCouponGain((OrdersGainDetailModel)ordersGainDetailModel));
                }
            }
            if (null != orderQueryOut.getOrdersMember() && StringUtils.isNotBlank((String)orderQueryOut.getOrdersMember().getCid()) && null != orderQueryOut.getOrdersMember().getThisTimeGivePoint()) {
                cacheModel.getOrder().setThisTimePoint(orderQueryOut.getOrdersMember().getThisTimeGivePoint().doubleValue());
            }
        }
        if (null != orderQueryOut.getOrdersDetailPop() && orderQueryOut.getOrdersDetailPop().size() > 0) {
            for (OrdersDetailPopModel orderPop : orderQueryOut.getOrdersDetailPop()) {
                int rowNo = orderPop.getRowNo() - 1;
                if (goodslist.size() < rowNo + 1) continue;
                ((Goods)goodslist.get(rowNo)).getPopDetailsInfo().add(PopDetail.transferPopDetail((OrdersDetailPopModel)orderPop));
            }
            for (int i = 0; i < goodslist.size(); ++i) {
                Goods goods = (Goods)goodslist.get(i);
                if (!"97".equals(goods.getGoodsType())) continue;
                goodslist.remove(i);
                --i;
            }
        }
        log.info("popdetail\u884c\u6570\uff1a" + ((Goods)goodslist.get(0)).getPopDetailsInfo().size());
        if (null != orderQueryOut.getOrdersUseCoupon() && orderQueryOut.getOrdersUseCoupon().size() > 0) {
            for (OrdersUseCouponModel orderPop : orderQueryOut.getOrdersUseCoupon()) {
                int rowNo = orderPop.getRowNo() - 1;
                if (goodslist.size() < rowNo + 1) continue;
                ((Goods)goodslist.get(rowNo)).getCouponUses().add(CouponUse.transferCouponUse3((OrdersUseCouponModel)orderPop, (Order)cacheModel.getOrder()));
            }
        }
        cacheModel.setGoodsList(goodslist);
        return cacheModel;
    }
}

