/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.ConsumersData;
import com.efuture.business.javaPos.struct.CouponUse;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.SkpVipDef;
import com.efuture.business.javaPos.struct.mss.TempDetailOut;
import com.efuture.business.javaPos.struct.orderCentre.OrdersPayModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrders;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrdersMemberModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrdersModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrders_WSLF;
import com.efuture.business.javaPos.struct.orderCentre.request.OrderQueryIn;
import com.efuture.business.javaPos.struct.orderCentre.response.OrdersDetailOut;
import com.efuture.business.javaPos.struct.request.GetOrderIn;
import com.efuture.business.javaPos.struct.request.SaleReturnQueryIn;
import com.efuture.business.javaPos.struct.request.SkpCheckBillReq;
import com.efuture.business.javaPos.struct.request.SkpResqVo;
import com.efuture.business.javaPos.struct.request.SkpVipLoginReq;
import com.efuture.business.javaPos.struct.response.PayConfirmOut;
import com.efuture.business.javaPos.struct.response.SkpCheckBillRes;
import com.efuture.business.javaPos.struct.response.SkpRespVo;
import com.efuture.business.javaPos.struct.response.SkpVipLoginRes;
import com.efuture.business.javaPos.struct.skp.CodeCouponShare;
import com.efuture.business.javaPos.struct.skp.CouponArticleShare;
import com.efuture.business.model.CheckHasReturnRes;
import com.efuture.business.model.Syspara;
import com.efuture.business.service.InitializationRemoteService;
import com.efuture.business.service.SkpCodeCouponRemoteService;
import com.efuture.business.service.SkpCouponRemoteService;
import com.efuture.business.service.SkpMzkRemoteService;
import com.efuture.business.service.SkpVipRemoteService;
import com.efuture.business.service.localize.OrderSaleBSImpl_WSLF;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.HttpUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderSaleBSImpl_SKP
extends OrderSaleBSImpl_WSLF {
    private static final Logger log = LoggerFactory.getLogger(OrderSaleBSImpl_SKP.class);
    @SoaAnnotation(value="/apiSkpMzkRemoteService.do")
    public SkpMzkRemoteService skpMzkRemoteService;
    @SoaAnnotation(value="/apiSkpCouponRemoteService.do")
    public SkpCouponRemoteService skpCouponRemoteService;
    @SoaAnnotation(value="/apiSkpCodeCouponRemoteService.do")
    public SkpCodeCouponRemoteService skpCodeCouponRemoteService;
    @SoaAnnotation(value="/apiInitializeRemoteService.do")
    public InitializationRemoteService initRemoteService;
    @SoaAnnotation(value="/apiSkpVipRemoteService.do")
    private SkpVipRemoteService skpVipService;
    private static String CHECKHASRETURN = "order.online.account.checkHasReturn";

    public RespBase payConfirm(ServiceSession session, ResqVo vo) {
        CacheModel cacheModel = vo.getCacheModel();
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        vo.getCacheModel().getOrder().setExtendMode(modeDetailsVo.getExtendMode());
        RespBase resp = super.payConfirm(session, vo);
        if (null == resp || Code.SUCCESS.getIndex() != resp.getRetflag()) {
            String hydz = modeDetailsVo.getSyjmain().getHydz();
            String cykey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"CYKEY");
            JSONObject j = new JSONObject();
            j.put("serverBillId", (Object)CastUtil.castInt((Object)cacheModel.getOrder().getExtendFt2()));
            SkpResqVo request = new SkpResqVo((Object)j);
            this.httpUtils.doSkpPost(cykey, hydz, "BFPLAT.CRM.VIP.CANCELCHECKOUTBILL", session, JSON.toJSONString((Object)request), SkpRespVo.class, "Skp", "\u51c6\u5907\u7ed3\u8d26\u53d6\u6d88");
        }
        return resp;
    }

    public CacheModel cancelOrder(ServiceSession session, CacheModel cacheModel, String netType, String newTerminalSno) {
        if (SellType.isTgOrder((String)cacheModel.getOrder().getChannel())) {
            return cacheModel;
        }
        return super.cancelOrder(session, cacheModel, netType, newTerminalSno);
    }

    public RespBase saleReturnQuery(ServiceSession session, ResqVo vo) {
        RespBase resp = super.saleReturnQuery(session, vo);
        JSONObject paramsObject = vo.getJsonObject();
        SaleReturnQueryIn saleReturnQueryIn = (SaleReturnQueryIn)JSON.parseObject((String)paramsObject.toJSONString(), SaleReturnQueryIn.class);
        boolean flag = true;
        if (null != resp && Code.SUCCESS.getIndex() == resp.getRetflag()) {
            CacheModel cacheModel = (CacheModel)resp.getData();
            Order order = cacheModel.getOrder();
            if (SellType.ISKD((String)order.getOrderType())) {
                JSONObject jo = new JSONObject();
                jo.put("busiTakeMarketCode", (Object)order.getOriginShopCode());
                jo.put("terminalNo", (Object)order.getOriginTerminalNo());
                jo.put("terminalSno", (Object)order.getOriginTerminalSno());
                jo.put("orderType", (Object)order.getOrderType());
                ServiceResponse rs = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, CHECKHASRETURN, session, jo.toJSONString(), CheckHasReturnRes.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u7a7a\u8ba2\u8ba2\u5355\u662f\u5426\u53ef\u4ee5\u9000\u8d27");
                if (!"0".equals(String.valueOf(rs.getReturncode()))) {
                    return Code.CODE_60048.getRespBase(new Object[]{rs.getData()});
                }
                CheckHasReturnRes res = (CheckHasReturnRes)rs.getData();
                double balanceMoney = res.getBalanceMoney();
                if (order.getOughtPay() > balanceMoney) {
                    double kjje = order.getOughtPay() - balanceMoney;
                    for (int i = 0; i < cacheModel.getReturnGoodsList().size(); ++i) {
                        Goods g = (Goods)cacheModel.getReturnGoodsList().get(i);
                        if (g.getSaleAmount() > kjje) {
                            g.setSaleAmount(g.getSaleAmount() - kjje);
                            if (g.getTotalDiscountValue() > 0.0) {
                                g.setSaleValue(ManipulatePrecision.doubleConvert((double)(g.getSaleAmount() + g.getTotalDiscountValue()), (int)2, (int)1));
                                break;
                            }
                            g.setSaleValue(g.getSaleAmount());
                            break;
                        }
                        cacheModel.getReturnGoodsList().remove(i--);
                        kjje -= g.getSaleAmount();
                    }
                }
            }
            for (Goods g : cacheModel.getReturnGoodsList()) {
                if (!StringUtils.isNotBlank((String)g.getRemark())) continue;
                g.setAssistantId(g.getRemark());
            }
            log.info("\u4f1a\u5458\u4fe1\u606f\uff1a" + JSONObject.toJSONString((Object)cacheModel.getOrder().getConsumersData()));
            ConsumersData consumersData = cacheModel.getOrder().getConsumersData();
            if (null != consumersData && StringUtils.isNotBlank((String)consumersData.getConsumersCard())) {
                String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
                ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
                String hydz = modeDetailsVo.getSyjmain().getHydz();
                String cykey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"CYKEY");
                String storeCode = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MDDM");
                SkpVipLoginReq paraIn = new SkpVipLoginReq();
                paraIn.setOrgType(saleReturnQueryIn.getOrgType());
                paraIn.setOrgCode(saleReturnQueryIn.getOrgCode());
                paraIn.setStoreCode(storeCode);
                paraIn.setCondType(1);
                paraIn.setCondValue(consumersData.getConsumersId());
                paraIn.setTerminalNo(saleReturnQueryIn.getTerminalNo());
                SkpResqVo req = new SkpResqVo((Object)paraIn);
                ServiceResponse response = this.httpUtils.doSkpPost(cykey, hydz, "BFPLAT.CRM.VIP.CARDINFO2", session, JSON.toJSONString((Object)req), SkpRespVo.class, "Skp", "\u4f1a\u5458\u4fe1\u606f\u67e5\u8be2");
                if ("0".equals(response.getReturncode())) {
                    SkpRespVo res = (SkpRespVo)response.getData();
                    if ("0".equals(res.getRetCode())) {
                        SkpVipLoginRes queryOut = (SkpVipLoginRes)JSON.toJavaObject((JSON)res.getData(), SkpVipLoginRes.class);
                        SkpVipDef skpVipDef = (SkpVipDef)queryOut.getVipCardInfos().get(0);
                        consumersData.setPoint(skpVipDef.getValidPoint());
                        consumersData.setBasePoint(skpVipDef.getBaseCent());
                        order.setTotalPoint(skpVipDef.getValidPoint());
                        order.setTotalBasePoint(skpVipDef.getBaseCent());
                        if (null != queryOut.getBrandMemberInfo()) {
                            consumersData.setBrandMemberInfo(queryOut.getBrandMemberInfo());
                        }
                        List list = new ArrayList();
                        String orgReturnPayments = JSONObject.toJSONString((Object)cacheModel.getReturnPayments());
                        log.info("\u652f\u4ed8\u884c\u5904\u74061\uff1a" + orgReturnPayments);
                        list = JSONArray.parseArray((String)orgReturnPayments, Payment.class);
                        cacheModel = this.handleZl(cacheModel);
                        return new RespBase(Code.SUCCESS, (Object)cacheModel, cacheModel.getFlowNo());
                    }
                    return Code.CODE_40000.getRespBase(new Object[]{res.getRetMsg()});
                }
                return Code.CODE_40000.getRespBase(new Object[]{"\u8fde\u63a5\u5f02\u5e38"});
            }
            cacheModel = this.handleZl(cacheModel);
            return new RespBase(Code.SUCCESS, (Object)cacheModel, cacheModel.getFlowNo());
        }
        return resp;
    }

    public CacheModel handleZl(CacheModel cacheModel) {
        boolean flag = true;
        List list = new ArrayList();
        String orgReturnPayments = JSONObject.toJSONString((Object)cacheModel.getReturnPayments());
        log.info("\u652f\u4ed8\u884c\u5904\u74061\uff1a" + orgReturnPayments);
        list = JSONArray.parseArray((String)orgReturnPayments, Payment.class);
        for (int i = 0; i < list.size(); ++i) {
            Payment p = (Payment)list.get(i);
            if ("2".equals(p.getFlag())) {
                log.info("\u652f\u4ed8\u884c\u5904\u74062");
                list.remove(i);
                --i;
                continue;
            }
            if ("1".equals(p.getFlag()) && "0".equals(p.getPayType()) && flag) {
                log.info("\u652f\u4ed8\u884c\u5904\u74063");
                p.setMoney(ManipulatePrecision.sub((double)p.getAmount(), (double)cacheModel.getOrder().getChangeValue()));
                p.setAmount(ManipulatePrecision.sub((double)p.getAmount(), (double)cacheModel.getOrder().getChangeValue()));
                flag = false;
            }
            log.info("\u652f\u4ed8\u884c\u5904\u74064\uff1a" + JSONObject.toJSONString(list));
            cacheModel.setReturnViwePayments(list);
        }
        return cacheModel;
    }

    public RespBase checkOrderBalance(ServiceSession session, ResqVo vo) {
        return this.tradeConfirm(session, vo);
    }

    private RespBase tradeConfirm(ServiceSession session, ResqVo vo) {
        ConsumersData consumersData;
        RespBase respBase;
        CacheModel cacheModel = vo.getCacheModel();
        Order order = cacheModel.getOrder();
        if (!cacheModel.getOrder().getSysPara().isBF) {
            return super.checkOrderBalance(session, vo);
        }
        String assistant = cacheModel.getAssistant();
        if (StringUtils.isNotBlank((String)assistant)) {
            String[] cardNos = assistant.split(",");
            boolean b = false;
            for (Goods g : cacheModel.getGoodsList()) {
                if ("0".equals(g.getFlag()) || "8".equals(g.getFlag())) {
                    g.setAssistantId(assistant);
                }
                if (cardNos.length != 1 || b || g.getAssistantId().equals(assistant)) continue;
                b = true;
            }
            if (!b) {
                cacheModel.getOrder().setExtendFt4(assistant);
            }
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String dydz = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"DYDZ");
        cacheModel.getOrder().setShopAddress(modeDetailsVo.getMktinfo().getAddress());
        if (StringUtils.isNotBlank((String)dydz) && "Y".equals(dydz) && StringUtils.isNotBlank((String)modeDetailsVo.getSyjmain().getOrgAddress())) {
            cacheModel.getOrder().setShopAddress(modeDetailsVo.getSyjmain().getOrgAddress());
        }
        boolean upCacheModel = false;
        boolean isUseMzk = false;
        boolean isUseCoupon = false;
        boolean isUseCodeCoupon = false;
        String errmsg = "";
        List paymentList = cacheModel.getPayments();
        for (int i = 0; i < paymentList.size(); ++i) {
            Payment p = (Payment)paymentList.get(i);
            if (p.getIsSuccess() || !StringUtils.isNotBlank((String)p.getPayMemo())) continue;
            if ("SKPMZK".equals(p.getPayMemo())) {
                isUseMzk = true;
                continue;
            }
            if ("SKPCOUPON".equals(p.getPayMemo())) {
                isUseCoupon = true;
                continue;
            }
            if (!"SKPCODECOUPON".equals(p.getPayMemo())) continue;
            isUseCodeCoupon = true;
        }
        if (isUseMzk) {
            try {
                RespBase respBase2 = this.skpMzkRemoteService.skpMzkFreeze(session, vo);
                if (Code.SUCCESS.getIndex() == respBase2.getRetflag()) {
                    upCacheModel = true;
                    cacheModel = (CacheModel)respBase2.getData();
                    vo.setCacheModel(cacheModel);
                } else {
                    errmsg = "\u50a8\u503c\u5361\u96c6\u4e2d\u6838\u9500\u5931\u8d25\uff1a" + respBase2.getRetmsg();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                errmsg = "\u50a8\u503c\u5361\u96c6\u4e2d\u6838\u9500\u5f02\u5e38";
            }
        }
        JSONObject j = new JSONObject();
        j.put("shopCode", (Object)order.getShopCode());
        j.put("terminalNo", (Object)order.getTerminalNo());
        j.put("erpCode", (Object)order.getErpCode());
        if (StringUtils.isNotBlank((String)errmsg)) {
            this.skpMzkRemoteService.saleReserve(session, null, j);
            return new RespBase(Code.CODE_60038.getIndex(), errmsg);
        }
        if (isUseCoupon) {
            try {
                respBase = this.skpCouponRemoteService.skpCouponFreeze(session, vo);
                if (Code.SUCCESS.getIndex() == respBase.getRetflag()) {
                    upCacheModel = true;
                    cacheModel = (CacheModel)respBase.getData();
                    vo.setCacheModel(cacheModel);
                } else {
                    errmsg = "\u4f18\u60e0\u5238\u96c6\u4e2d\u6838\u9500\u5931\u8d25\uff1a" + respBase.getRetmsg();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                errmsg = "\u4f18\u60e0\u5238\u96c6\u4e2d\u6838\u9500\u5f02\u5e38";
            }
        }
        log.info("errmsg:" + errmsg);
        if (StringUtils.isNotBlank((String)errmsg)) {
            this.skpMzkRemoteService.saleReserve(session, null, j);
            return new RespBase(Code.CODE_60038.getIndex(), errmsg);
        }
        if (isUseCodeCoupon) {
            try {
                respBase = this.skpCodeCouponRemoteService.skpCouponFreeze(session, vo);
                if (Code.SUCCESS.getIndex() == respBase.getRetflag()) {
                    upCacheModel = true;
                    cacheModel = (CacheModel)respBase.getData();
                    vo.setCacheModel(cacheModel);
                } else {
                    errmsg = "\u7f16\u7801\u5238\u96c6\u4e2d\u6838\u9500\u5931\u8d25\uff1a" + respBase.getRetmsg();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        if (StringUtils.isNotBlank((String)errmsg)) {
            this.skpMzkRemoteService.saleReserve(session, null, j);
            return new RespBase(Code.CODE_60038.getIndex(), errmsg);
        }
        String extendFt1 = cacheModel.getOrder().getExtendFt1();
        String extendFt3 = cacheModel.getOrder().getExtendFt3();
        boolean isUpload = true;
        if (StringUtils.isNotBlank((String)extendFt1) && "1".equals(extendFt1)) {
            isUpload = false;
        }
        if (StringUtils.isNotBlank((String)extendFt3) && "0".equals(extendFt3)) {
            isUpload = false;
        }
        if (null != (consumersData = cacheModel.getOrder().getConsumersData()) && StringUtils.isNotBlank((String)consumersData.getConsumersId()) && "OFFLINE".equals(consumersData.getConsumersId())) {
            isUpload = false;
        }
        if (SellType.ISKD((String)cacheModel.getOrder().getOrderType()) || SellType.ISHD((String)cacheModel.getOrder().getOrderType())) {
            cacheModel.getOrder().setExtendFt1("1");
            isUpload = false;
        }
        if (isUpload) {
            RespBase checkoutbill = this.checkoutbill(session, vo);
            if (Code.SUCCESS.getIndex() != checkoutbill.getRetflag()) {
                this.skpMzkRemoteService.saleReserve(session, null, j);
                return checkoutbill;
            }
        }
        RespBase resp = super.checkOrderBalance(session, vo);
        if (Code.SUCCESS.getIndex() != resp.getRetflag()) {
            this.skpMzkRemoteService.saleReserve(session, null, j);
            return resp;
        }
        ArrayList<Long> delList = new ArrayList<Long>();
        for (int i = 0; i < cacheModel.getPayments().size(); ++i) {
            Payment p = (Payment)cacheModel.getPayments().get(i);
            if (!p.getIsSuccess() || !StringUtils.isNotBlank((String)p.getPayMemo()) || !"SKPMZK".equals(p.getPayMemo()) && !"SKPCOUPON".equals(p.getPayMemo()) && !"SKPCODECOUPON".equals(p.getPayMemo())) continue;
            delList.add(p.getTrace());
        }
        if (delList.size() > 0) {
            RespBase respBase3 = this.skpMzkRemoteService.deleteSkpTrade(session, delList);
            if (Code.SUCCESS.getIndex() != respBase3.getRetflag()) {
                return new RespBase(Code.CODE_60038.getIndex(), "\u652f\u4ed8\u96c6\u4e2d\u6838\u9500\u5931\u8d25\uff1a\u5220\u9664\u51b2\u6b63\u6587\u4ef6\u5931\u8d25");
            }
        }
        return resp;
    }

    public RespBase checkoutbill(ServiceSession session, ResqVo vo) {
        CacheModel cacheModel = vo.getCacheModel();
        Order order = cacheModel.getOrder();
        SkpCheckBillReq req = new SkpCheckBillReq();
        req.setServerBillId(CastUtil.castInt((Object)order.getExtendFt2()));
        if (null != order.getConsumersData() && StringUtils.isNotBlank((String)order.getConsumersData().getConsumersId())) {
            req.setPayBackCouponVipId(CastUtil.castInt((Object)order.getConsumersData().getConsumersId()));
        }
        JSONObject jo = new JSONObject();
        log.info("\u51c6\u5907\u7ed3\u8d26\u524d \u652f\u4ed8\u884c\uff1a" + JSONObject.toJSONString((Object)cacheModel.getPayments()));
        for (Object p : cacheModel.getPayments()) {
            JSONObject object = new JSONObject();
            if ("DJ".equals(p.getDescription())) {
                List payModels = JSON.parseArray((String)p.getExtMemo(), OrdersPayModel.class);
                for (OrdersPayModel op : payModels) {
                    JSONObject object2 = new JSONObject();
                    if (jo.containsKey((Object)op.getPayCode())) {
                        double amount = SellType.ISBACK((String)order.getOrderType()) ? ManipulatePrecision.sub((double)jo.getJSONObject(op.getPayCode()).getDouble("PayMoney"), (double)op.getAmount().doubleValue()) : ManipulatePrecision.add((double)jo.getJSONObject(op.getPayCode()).getDouble("PayMoney"), (double)op.getAmount().doubleValue());
                        jo.getJSONObject(op.getPayCode()).put("PayMoney", (Object)amount);
                        continue;
                    }
                    object2.put("PayTypeCode", (Object)op.getPayCode());
                    if (SellType.ISBACK((String)order.getOrderType())) {
                        object2.put("PayMoney", (Object)(op.getAmount().doubleValue() * -1.0));
                    } else {
                        object2.put("PayMoney", (Object)op.getAmount().doubleValue());
                    }
                    if (StringUtils.isNotBlank((String)op.getPayMemo()) && "SKPMZK".equals(op.getPayMemo())) {
                        object2.put("IsCashCard", (Object)1);
                    } else {
                        object2.put("IsCashCard", (Object)0);
                    }
                    jo.put(op.getPayCode(), (Object)object2);
                    log.info("jo\u8f93\u51fa\uff1a" + jo.toJSONString());
                }
                continue;
            }
            if (StringUtils.isNotBlank((String)p.getPayMemo()) && ("SKPCOUPON".equals(p.getPayMemo()) || "SKPCODECOUPON".equals(p.getPayMemo()))) {
                if (jo.containsKey((Object)p.getDescription())) {
                    double amount;
                    if (SellType.ISBACK((String)order.getOrderType())) {
                        amount = ManipulatePrecision.sub((double)jo.getJSONObject(p.getDescription()).getDouble("PayMoney"), (double)p.getAmount());
                    } else {
                        amount = ManipulatePrecision.add((double)jo.getJSONObject(p.getDescription()).getDouble("PayMoney"), (double)p.getAmount());
                        amount = ManipulatePrecision.sub((double)amount, (double)p.getOverage());
                    }
                    jo.getJSONObject(p.getDescription()).put("PayMoney", (Object)amount);
                    continue;
                }
                object.put("PayTypeCode", (Object)p.getDescription());
                if (SellType.ISBACK((String)order.getOrderType())) {
                    object.put("PayMoney", (Object)(p.getAmount() * -1.0));
                } else {
                    object.put("PayMoney", (Object)(p.getAmount() - p.getOverage()));
                }
                object.put("IsCashCard", (Object)0);
                jo.put(p.getDescription(), (Object)object);
                continue;
            }
            if (jo.containsKey((Object)p.getPayCode())) {
                double amount = "2".equals(p.getFlag()) ? ManipulatePrecision.sub((double)jo.getJSONObject(p.getPayCode()).getDouble("PayMoney"), (double)p.getAmount()) : (SellType.ISBACK((String)order.getOrderType()) ? ManipulatePrecision.sub((double)jo.getJSONObject(p.getPayCode()).getDouble("PayMoney"), (double)ManipulatePrecision.sub((double)p.getAmount(), (double)p.getOverage())) : ManipulatePrecision.add((double)jo.getJSONObject(p.getPayCode()).getDouble("PayMoney"), (double)ManipulatePrecision.sub((double)p.getAmount(), (double)p.getOverage())));
                jo.getJSONObject(p.getPayCode()).put("PayMoney", (Object)amount);
                continue;
            }
            object.put("PayTypeCode", (Object)p.getPayCode());
            if (SellType.ISBACK((String)order.getOrderType())) {
                object.put("PayMoney", (Object)(ManipulatePrecision.sub((double)p.getAmount(), (double)p.getOverage()) * -1.0));
            } else {
                object.put("PayMoney", (Object)ManipulatePrecision.sub((double)p.getAmount(), (double)p.getOverage()));
            }
            if ("2".equals(p.getFlag())) {
                object.put("PayMoney", (Object)(object.getDoubleValue("PayMoney") * -1.0));
            }
            if (StringUtils.isNotBlank((String)p.getPayMemo()) && "SKPMZK".equals(p.getPayMemo())) {
                object.put("IsCashCard", (Object)1);
            } else {
                object.put("IsCashCard", (Object)0);
            }
            jo.put(p.getPayCode(), (Object)object);
        }
        Set entries = jo.entrySet();
        for (Map.Entry o : entries) {
            log.info("entries==>" + JSONObject.toJSONString((Object)entries));
            req.getPaymentList().add(o.getValue());
        }
        SkpResqVo request = new SkpResqVo((Object)req);
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String hydz = modeDetailsVo.getSyjmain().getHydz();
        String cykey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"CYKEY");
        ServiceResponse resp = this.httpUtils.doSkpPost(cykey, hydz, "BFPLAT.CRM.VIP.PRECHECKOUTBILL", session, JSON.toJSONString((Object)request), SkpRespVo.class, "Skp", "\u51c6\u5907\u7ed3\u8d26");
        if ("0".equals(resp.getReturncode())) {
            SkpRespVo res = (SkpRespVo)resp.getData();
            if ("0".equals(res.getRetCode())) {
                SkpCheckBillRes out = (SkpCheckBillRes)JSON.toJavaObject((JSON)res.getData(), SkpCheckBillRes.class);
                if (null != out.getCouponArticleShareList() && out.getCouponArticleShareList().size() > 0) {
                    for (CouponArticleShare o : out.getCouponArticleShareList()) {
                        for (Goods g : cacheModel.getGoodsList()) {
                            if (g.getFlowId() != o.getArticleInx()) continue;
                            if (null != o.getCodeCouponShareList() && o.getCodeCouponShareList().size() > 0) {
                                block5: for (CodeCouponShare codeCouponShare : o.getCodeCouponShareList()) {
                                    CouponUse couponUse = new CouponUse();
                                    couponUse.setAmount(Math.abs(codeCouponShare.getShareMoney()));
                                    couponUse.setOriAmount(Math.abs(codeCouponShare.getShareMoney()));
                                    couponUse.setCouponType(String.valueOf(codeCouponShare.getCodeCouponId()));
                                    couponUse.setCouponGroup("B");
                                    for (Payment p : cacheModel.getPayments()) {
                                        if (!codeCouponShare.getCouponCode().equals(p.getPayNo())) continue;
                                        if ("1".equals(p.getMemo())) continue block5;
                                        couponUse.setPayRowNo(p.getRowno());
                                        couponUse.setPayCode(p.getPayCode());
                                        couponUse.setRownoId(p.getRownoId());
                                        break;
                                    }
                                    couponUse.setGoodsRowNo(g.getFlowId());
                                    g.getOutCouponUses().add(couponUse);
                                }
                                continue;
                            }
                            boolean iscw = false;
                            CouponUse couponUse = new CouponUse();
                            couponUse.setAmount(Math.abs(o.getShareMoney()));
                            couponUse.setOriAmount(Math.abs(o.getShareMoney()));
                            couponUse.setCouponType(String.valueOf(o.getCouponType()));
                            couponUse.setCouponGroup("B");
                            for (Payment p : cacheModel.getPayments()) {
                                if (!StringUtils.isNotBlank((String)p.getCouponType()) || !couponUse.getCouponType().equals(p.getCouponType())) continue;
                                if ("1".equals(p.getMemo())) {
                                    iscw = true;
                                    break;
                                }
                                couponUse.setPayRowNo(p.getRowno());
                                couponUse.setPayCode(p.getPayCode());
                                couponUse.setRownoId(p.getRownoId());
                                break;
                            }
                            couponUse.setGoodsRowNo(g.getFlowId());
                            if (iscw) continue;
                            g.getOutCouponUses().add(couponUse);
                        }
                    }
                }
                if (null != out.getLeftSaleMoneyList()) {
                    log.info("\u672c\u6bd4\u5f85\u8fd4\u5238\uff1a" + out.getLeftSaleMoneyList());
                    cacheModel.setLeftSaleMoneyList(out.getLeftSaleMoneyList());
                }
                log.info("\u672c\u6bd4\u4ea4\u6613\u83b7\u5f97\u79ef\u5206\uff1a" + out.getBillCent());
                cacheModel.getOrder().setNeedVipToOfferCoupon(out.isNeedVipToOfferCoupon());
                cacheModel.getOrder().setThisTimePoint(out.getBillCent() - out.getBillBaseCent());
                cacheModel.getOrder().setThisTimeBasePoint(out.getBillBaseCent());
                cacheModel.getOrder().setTotalPoint(ManipulatePrecision.doubleConvert((double)(cacheModel.getOrder().getTotalPoint() - cacheModel.getOrder().getThisTimeUsedPoint() + cacheModel.getOrder().getThisTimePoint())));
                cacheModel.getOrder().setTotalBasePoint(ManipulatePrecision.doubleConvert((double)(cacheModel.getOrder().getTotalBasePoint() - cacheModel.getOrder().getThisTimeUsedPoint() + cacheModel.getOrder().getThisTimeBasePoint())));
                if (null != out.getBrandMemberInfo()) {
                    log.info("\u672c\u6bd4\u4ea4\u6613\u83b7\u5f97\u54c1\u724c\u4f1a\u5458\u79ef\u5206\uff1a" + JSONObject.toJSONString((Object)out.getBrandMemberInfo()));
                    cacheModel.getOrder().setBrandMemberInfo(out.getBrandMemberInfo());
                }
                List coupons = out.transferToCoupon();
                List coupons1 = out.transferToCouponByPaperCoupon();
                if (null != cacheModel.getOrder().getConsumersData() && StringUtils.isNotBlank((String)cacheModel.getOrder().getConsumersData().getConsumersId())) {
                    if (null != coupons) {
                        if (null != coupons1) {
                            coupons.addAll(coupons1);
                        }
                        cacheModel.getOrder().setCouponDetails(coupons);
                    } else {
                        cacheModel.getOrder().setCouponDetails(coupons1);
                    }
                } else {
                    cacheModel.getOrder().setCouponDetails(coupons1);
                    cacheModel.getOrder().setPreCouponDetails(coupons);
                }
                cacheModel.getOrder().setUpGradeMsg(out.getUPGRADEMSG());
                return new RespBase(Code.SUCCESS, (Object)cacheModel);
            }
            JSONObject j = new JSONObject();
            j.put("serverBillId", (Object)CastUtil.castInt((Object)order.getExtendFt2()));
            request = new SkpResqVo((Object)j);
            resp = this.httpUtils.doSkpPost(cykey, hydz, "BFPLAT.CRM.VIP.CANCELCHECKOUTBILL", session, JSON.toJSONString((Object)request), SkpRespVo.class, "Skp", "\u51c6\u5907\u7ed3\u8d26\u53d6\u6d88");
            if ("0".equals(resp.getReturncode())) {
                SkpRespVo res1 = (SkpRespVo)resp.getData();
                if ("0".equals(res1.getRetCode())) {
                    return Code.CODE_60046.getRespBase(new Object[]{res.getRetMsg()});
                }
                return Code.CODE_60046.getRespBase(new Object[]{"\u51b2\u6b63\u5931\u8d25," + res1.getRetMsg()});
            }
            return Code.CODE_60046.getRespBase(new Object[]{"\u51b2\u6b63\u5931\u8d25,\u8fde\u63a5\u5f02\u5e38"});
        }
        JSONObject j = new JSONObject();
        j.put("serverBillId", (Object)CastUtil.castInt((Object)order.getExtendFt2()));
        request = new SkpResqVo((Object)j);
        resp = this.httpUtils.doSkpPost(cykey, hydz, "BFPLAT.CRM.VIP.CANCELCHECKOUTBILL", session, JSON.toJSONString((Object)request), SkpRespVo.class, "Skp", "\u51c6\u5907\u7ed3\u8d26\u53d6\u6d88");
        if ("0".equals(resp.getReturncode())) {
            SkpRespVo res = (SkpRespVo)resp.getData();
            if ("0".equals(res.getRetCode())) {
                return Code.CODE_60046.getRespBase(new Object[]{"\u5df2\u51b2\u6b63"});
            }
            return Code.CODE_60046.getRespBase(new Object[]{"\u51b2\u6b63\u5931\u8d25," + res.getRetMsg()});
        }
        return Code.CODE_60046.getRespBase(new Object[]{"\u51b2\u6b63\u5931\u8d25,\u8fde\u63a5\u5f02\u5e38"});
    }

    public JSONObject confirmBill(ServiceSession session, JSONObject jsonObject, CacheModel cacheModel) {
        try {
            SkpRespVo res;
            SaleOrders orders = (SaleOrders)JSONObject.parseObject((String)jsonObject.toJSONString(), SaleOrders.class);
            SaleOrdersModel order = orders.getSaleOrders();
            SaleOrdersMemberModel saleOrdersMember = orders.getSaleOrdersMember();
            if (null != saleOrdersMember && StringUtils.isNotBlank((String)saleOrdersMember.getCid()) && "OFFLINE".equals(saleOrdersMember.getCid())) {
                return jsonObject;
            }
            if (SellType.ISKD((String)order.getSheetTypeCode()) || SellType.ISHD((String)order.getSheetTypeCode())) {
                return jsonObject;
            }
            String obj = this.redisUtil.get(RedisKey.CACHEID + order.getSaleMarketCode() + order.getTerminalNo());
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            String hydz = modeDetailsVo.getSyjmain().getHydz();
            String cykey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"CYKEY");
            String isBF = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"ISBF");
            if (StringUtils.isBlank((String)isBF) || "N".equals(isBF)) {
                return jsonObject;
            }
            JSONObject j = new JSONObject();
            j.put("serverBillId", (Object)CastUtil.castInt((Object)order.getExtendFt2()));
            SkpResqVo request = new SkpResqVo((Object)j);
            ServiceResponse resp = this.httpUtils.doSkpPost(cykey, hydz, "BFPLAT.CRM.VIP.CONFIRMCHECKOUTBILL", session, JSON.toJSONString((Object)request), SkpRespVo.class, "Skp", "\u7ed3\u8d26");
            if ("0".equals(resp.getReturncode()) && "0".equals((res = (SkpRespVo)resp.getData()).getRetCode())) {
                order.setExtendFt1("1");
                if (null != cacheModel) {
                    cacheModel.getOrder().setExtendFt1("1");
                }
                jsonObject = (JSONObject)JSONObject.toJSON((Object)orders);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return jsonObject;
    }

    protected void cancelCheckOutBill(CacheModel cacheModel, ServiceSession session) {
        Order order = cacheModel.getOrder();
        String obj = this.redisUtil.get(RedisKey.CACHEID + order.getShopCode() + order.getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String hydz = modeDetailsVo.getSyjmain().getHydz();
        String cykey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"CYKEY");
        JSONObject j = new JSONObject();
        j.put("serverBillId", (Object)CastUtil.castInt((Object)order.getExtendFt2()));
        SkpResqVo request = new SkpResqVo((Object)j);
        ServiceResponse resp = this.httpUtils.doSkpPost(cykey, hydz, "BFPLAT.CRM.VIP.CANCELCHECKOUTBILL", session, JSON.toJSONString((Object)request), SkpRespVo.class, "Skp", "\u51c6\u5907\u7ed3\u8d26\u53d6\u6d88");
        if ("0".equals(resp.getReturncode())) {
            SkpRespVo res = (SkpRespVo)resp.getData();
            if ("0".equals(res.getRetCode())) {
                log.info("\u5df2\u51b2\u6b63");
            } else {
                log.info("\u51b2\u6b63\u5931\u8d25," + res.getRetMsg());
            }
        } else {
            log.info("\u51b2\u6b63\u5931\u8d25,\u8fde\u63a5\u5f02\u5e38");
        }
    }

    public RespBase getOrder(ServiceSession session, GetOrderIn getOrderIn) {
        try {
            OrderQueryIn in = new OrderQueryIn();
            in.setBusiTakeMarketCode(getOrderIn.getShopCode());
            in.setTerminalNo(getOrderIn.getTerminalNo());
            in.setTerminalSno(getOrderIn.getTerminalSno());
            in.setCreateDate(getOrderIn.getBillDate());
            in.setSearchType(getOrderIn.getSearchType());
            if (StringUtils.isNotBlank((String)getOrderIn.getShardingCode())) {
                in.setShardingCode(getOrderIn.getShardingCode());
            }
            log.info("\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)in));
            RespBase resp = this.orderPosOuterService.searchOrdersDetail(session, (JSONObject)JSONObject.toJSON((Object)in));
            log.info("\u67e5\u8ba2\u5355\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)resp.getData()));
            if (Code.SUCCESS.getIndex() != resp.getRetflag()) {
                if ("60003".equals(String.valueOf(resp.getRetflag()))) {
                    return Code.CODE_60021.getRespBase(new Object[]{resp.getData()});
                }
                if ("10001".equals(String.valueOf(resp.getRetflag()))) {
                    return Code.CODE_60021.getRespBase(new Object[]{resp.getData()});
                }
                log.info("\u83b7\u53d6\u8ba2\u5355\u5931\u8d25:" + resp.getData());
                return Code.CODE_60035.getRespBase(new Object[]{resp.getData()});
            }
            OrdersDetailOut getOrdersDetailOut = (OrdersDetailOut)JSONObject.toJavaObject((JSON)((JSONObject)JSONObject.toJSON((Object)resp.getData())), OrdersDetailOut.class);
            SaleOrders_WSLF saleOrder = new SaleOrders_WSLF();
            SaleOrders_WSLF oriOrder = null;
            saleOrder = getOrdersDetailOut.getOrderInfo();
            if (saleOrder.getOrders() == null) {
                return Code.CODE_60016.getRespBase(new Object[]{resp.getData()});
            }
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("erpCode", (Object)getOrderIn.getErpCode());
            jsonObject.put("mkt", (Object)getOrderIn.getShopCode());
            jsonObject.put("code", (Object)"CWYH");
            RespBase res = this.initRemoteService.getSyspara(session, jsonObject);
            ArrayList<String> calcPriceType = new ArrayList<String>();
            if (null != res && Code.SUCCESS.getIndex() == res.getRetflag()) {
                List data = (List)res.getData();
                Syspara s = (Syspara)data.get(0);
                log.info("CWYH\u7cfb\u7edf\u53c2\u6570\uff1a" + s.getParavalue());
                if (StringUtils.isNotBlank((String)s.getParavalue())) {
                    String[] values;
                    for (String code : values = s.getParavalue().split(",")) {
                        calcPriceType.add(code);
                    }
                }
            } else {
                log.info("\u672a\u627e\u5230\u8be5\u7cfb\u7edf\u53c2\u6570");
            }
            boolean isReprint = true;
            if ("0".equals(getOrderIn.getType())) {
                isReprint = false;
            }
            String obj = this.redisUtil.get(RedisKey.CACHEID + getOrderIn.getShopCode() + getOrderIn.getTerminalNo());
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            PayConfirmOut out = this.toPayConfirmOut(session, saleOrder, oriOrder, calcPriceType, isReprint);
            out.getOrder().setExtendMode(modeDetailsVo.getExtendMode());
            if (out.getOrder().getConsumersData() != null && out.getOrder().getTotalPoint() != 0.0 && !"1".equals(out.getOrder().getOrderType())) {
                double totalPoint = out.getOrder().getTotalPoint() + out.getOrder().getThisTimeUsedPoint() - Math.abs(out.getOrder().getThisTimePoint());
                out.getOrder().setTotalPoint(totalPoint);
            }
            log.info("PayConfirmOut\u53c2\u6570\uff1a{}", (Object)JSONObject.toJSONString((Object)out));
            return new RespBase(Code.SUCCESS, (Object)out, "GETORDERMESSCERTIFY");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8c03\u7528\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            return new RespBase(Code.CODE_60007.getIndex(), e.getMessage());
        }
    }

    public RespBase tempVipLogin(ServiceSession session, CacheModel cacheModel, JSONObject paramsObject, TempDetailOut tempDetailOut) {
        paramsObject.put("condType", (Object)"2");
        paramsObject.put("certifyType", (Object)"login");
        paramsObject.put("condValue", (Object)tempDetailOut.getOrderstemphead().getConsumersCard());
        paramsObject.put("terminalNo", (Object)cacheModel.getOrder().getTerminalNo());
        paramsObject.put("terminalOperator", (Object)cacheModel.getOrder().getTerminalOperator());
        log.info("\u590d\u5236\u4f1a\u5458info,{}", (Object)paramsObject.toJSONString());
        RespBase respBase = this.skpVipService.getCardinfo(session, ResqVo.buildReqVo((CacheModel)cacheModel), paramsObject);
        log.info("\u590d\u5236\u4f1a\u5458return,{}", (Object)respBase.getRetflag());
        return respBase;
    }

    public RespBase tempSave(ServiceSession session, CacheModel cacheModel) {
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        cacheModel.getOrder().setExtendMode(modeDetailsVo.getExtendMode());
        return super.tempSave(session, cacheModel);
    }
}

