/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.remote;

import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.HessianService;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.SyncTradeModel;
import com.efuture.business.javaPos.struct.request.GetOrderIn;
import com.efuture.business.service.OrderRemoteService;
import com.efuture.business.service.OrderSaleBS;
import com.efuture.business.util.ThreadContextUtils;
import com.product.model.ServiceSession;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@HessianService(value="/apiOrderRemoteService.do", interf=OrderRemoteService.class)
@Service
public class OrderRemoteServiceImpl
implements OrderRemoteService {
    private static final Logger log = LoggerFactory.getLogger(OrderRemoteServiceImpl.class);
    @Autowired
    private OrderSaleBS orderSaleBS;
    @Autowired
    private ThreadContextUtils threadContextUtils;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase payConfirm(ServiceSession session, ResqVo vo) {
        try {
            this.threadContextUtils.setLogFlag(vo);
            RespBase respBase = this.orderSaleBS.payConfirm(session, vo);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase saleReturnQuery(ServiceSession session, ResqVo vo) {
        try {
            this.threadContextUtils.setLogFlag(vo);
            RespBase respBase = this.orderSaleBS.saleReturnQuery(session, vo);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase copySno(ServiceSession session, ResqVo vo) {
        try {
            this.threadContextUtils.setLogFlag(vo);
            RespBase respBase = this.orderSaleBS.copySno(session, vo);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public RespBase getOrder(ServiceSession session, GetOrderIn getOrderIn) {
        return this.orderSaleBS.getOrder(session, getOrderIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase getOrders(ServiceSession session, JSONObject paramsObject) {
        try {
            this.threadContextUtils.setLogFlag(paramsObject);
            RespBase respBase = this.orderSaleBS.getOrders(session, paramsObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase confirmSalesReturn(ServiceSession session, ResqVo vo) {
        try {
            this.threadContextUtils.setLogFlag(vo);
            RespBase respBase = this.orderSaleBS.confirmSalesReturn(session, vo);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase<ResqVo> changeOrderSno(ServiceSession session, ResqVo vo) {
        try {
            this.threadContextUtils.setLogFlag(vo);
            RespBase respBase = this.orderSaleBS.changeOrderSno(session, vo);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase changeOrderType(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        try {
            this.threadContextUtils.setLogFlag(vo);
            RespBase respBase = this.orderSaleBS.changeOrderType(session, vo, paramsObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase saveOrderInfoForCloud(ServiceSession session, JSONObject jsonObject) {
        try {
            this.threadContextUtils.setLogFlag(jsonObject);
            RespBase respBase = this.orderSaleBS.saveOrderInfoForCloud(session, jsonObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase receiveOrderSync(ServiceSession session, JSONObject paramsObject) {
        try {
            this.threadContextUtils.setLogFlag(paramsObject);
            RespBase respBase = this.orderSaleBS.receiveOrderSync(session, paramsObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public RespBase getSyncList(ServiceSession session) {
        return this.orderSaleBS.getSyncList(session);
    }

    public RespBase synLocalOrder(ServiceSession session, List<SyncTradeModel> synTradeList) {
        return this.orderSaleBS.synLocalOrder(session, synTradeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase searchTerminalReport(ServiceSession session, JSONObject paramsObject) {
        try {
            this.threadContextUtils.setLogFlag(paramsObject);
            RespBase respBase = this.orderSaleBS.searchTerminalReport(session, paramsObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase recordPrintLog(ServiceSession session, JSONObject paramsObject) {
        try {
            this.threadContextUtils.setLogFlag(paramsObject);
            RespBase respBase = this.orderSaleBS.recordPrintLog(session, paramsObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase checkOrderBalance(ServiceSession session, ResqVo vo) {
        try {
            this.threadContextUtils.setLogFlag(vo);
            RespBase respBase = this.orderSaleBS.checkOrderBalance(session, vo);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public RespBase recalc(ServiceSession session) {
        RespBase respBase = this.orderSaleBS.recalc(session);
        return respBase;
    }

    public RespBase tempSave(ServiceSession session, CacheModel cacheModel) {
        return this.orderSaleBS.tempSave(session, cacheModel);
    }

    public RespBase searchTempInfo(ServiceSession session, JSONObject paramsObject) {
        return this.orderSaleBS.searchTempInfo(session, paramsObject);
    }

    public RespBase searchTempDetail(ServiceSession session, CacheModel cacheModel, JSONObject paramsObject) {
        return this.orderSaleBS.searchTempDetail(session, cacheModel, paramsObject);
    }

    public RespBase updateTempOrderState(ServiceSession session, JSONObject paramsObject) {
        return this.orderSaleBS.updateTempOrderState(session, paramsObject);
    }

    public RespBase copyTempOrder(ServiceSession session, CacheModel cacheModel, JSONObject paramsObject) {
        return this.orderSaleBS.copyTempOrder(session, cacheModel, paramsObject);
    }
}

