/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.util.CloudUrl;
import com.product.exception.NotDataRuntimeException;
import com.product.exception.ServiceRuntimeException;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.DateTimeFormatUtil;
import com.product.util.RestBaseUtils;
import com.product.util.ServiceAssert;
import com.product.util.UniqueID;
import java.util.HashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CloudService {
    private static Logger logger = LoggerFactory.getLogger(CloudService.class);
    private static ServiceSession session;

    private CloudService() {
    }

    public static ServiceResponse sendPost(String service, String method, ServiceSession session, JSONObject paramsObject) {
        String url = CloudUrl.getUrl(service, method);
        ServiceAssert.notNull((Object)url, (String)("\u8c03\u7528\u670d\u52a1URL\u7a7a[" + service + "];"));
        String param = paramsObject.toJSONString();
        logger.info("\u2554=========================[\u8bf7\u6c42\u5730\u5740]=========================\u2557");
        logger.info(String.format("[URL]%s", url));
        logger.info("\u2560===========================================================\u2563");
        logger.info(String.format("[Param]%s", param));
        logger.info("\u2560===========================================================\u2563");
        try {
            long traceId = UniqueID.getUniqueID((boolean)true);
            HashMap<String, String> sessionMap = new HashMap<String, String>();
            sessionMap.put("session", JSON.toJSONString((Object)session));
            String res = (String)RestBaseUtils.onHttpPost((long)traceId, (int)3000, (int)3000, null, (String)url, sessionMap, (String)param, String.class, null, null);
            logger.info(String.format("[Result]%s", res));
            ServiceResponse resp = (ServiceResponse)JSON.parseObject((String)res, ServiceResponse.class);
            if ("10003".equals(resp.getReturncode())) {
                logger.error(String.format("[Error_Result]%s", JSON.toJSONString((Object)resp)));
                throw new NotDataRuntimeException();
            }
            if (!"0".equals(resp.getReturncode())) {
                logger.error(String.format("[Error_Result]%s", JSON.toJSONString((Object)resp)));
                throw new ServiceRuntimeException(String.format("\u8c03\u7528[%s]\u670d\u52a1\u5931\u8d25,\u65f6\u95f4[%s]", service.split("\\.")[0], DateTimeFormatUtil.nowToDateTime()));
            }
            ServiceResponse serviceResponse = resp;
            return serviceResponse;
        }
        catch (RuntimeException e) {
            logger.error("[ERROR]\u8c03\u7528\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        finally {
            logger.info("\u255a=========================================================\u255d");
        }
    }

    public static ServiceResponse sendPost(String service, String method, ServiceSession session, JSONObject paramsObject, int connectTimeout, int readTimeout) {
        String url = CloudUrl.getUrl(service, method);
        ServiceAssert.notNull((Object)url, (String)("\u8c03\u7528\u670d\u52a1URL\u7a7a[" + service + "];"));
        String param = paramsObject.toJSONString();
        logger.info("\u2554=========================[\u8bf7\u6c42\u5730\u5740]=========================\u2557");
        logger.info(String.format("[URL]%s", url));
        logger.info("\u2560==============================================================\u2563");
        logger.info(String.format("[Param]%s", param));
        logger.info("\u2560==============================================================\u2563");
        try {
            long traceId = UniqueID.getUniqueID((boolean)true);
            HashMap<String, String> sessionMap = new HashMap<String, String>();
            sessionMap.put("session", JSON.toJSONString((Object)session));
            String res = (String)RestBaseUtils.onHttpPost((long)traceId, (int)connectTimeout, (int)readTimeout, null, (String)url, sessionMap, (String)param, String.class, null, null);
            logger.info(String.format("[Result]%s", res));
            ServiceResponse resp = (ServiceResponse)JSON.parseObject((String)res, ServiceResponse.class);
            if ("10003".equals(resp.getReturncode())) {
                logger.error(String.format("[Error_Result]%s", JSON.toJSONString((Object)resp)));
                throw new NotDataRuntimeException();
            }
            if (!"0".equals(resp.getReturncode())) {
                logger.error(String.format("[Error_Result]%s", JSON.toJSONString((Object)resp)));
                throw new ServiceRuntimeException(String.format("\u8c03\u7528[%s]\u670d\u52a1\u5931\u8d25,\u65f6\u95f4[%s]", service.split("\\.")[0], DateTimeFormatUtil.nowToDateTime()));
            }
            ServiceResponse serviceResponse = resp;
            return serviceResponse;
        }
        catch (RuntimeException e) {
            logger.error("[ERROR]\u8c03\u7528\u670d\u52a1\u5f02\u5e38", (Throwable)e);
            throw e;
        }
        finally {
            logger.info("\u255a==============================================================\u255d");
        }
    }

    public static ServiceSession defaultSession() {
        if (session == null) {
            session = new ServiceSession();
            session.setEnt_id(2L);
            session.setUser_id(0L);
            session.setUser_code("10002");
            session.setUser_name("\u7cfb\u7edf\u7ba1\u7406\u5458");
            session.setErpCode("003");
            session.setLocale("CN");
        }
        return session;
    }
}

