/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.OrdersTemp;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.bean.WorkLogType;
import com.efuture.business.bean.YPopStatusType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.dao.SaleOrdersModelService;
import com.efuture.business.dao.SaleOrdersPrintLogInfoModelService;
import com.efuture.business.dao.wslf.OrdersPayModelService;
import com.efuture.business.exception.EfutureException;
import com.efuture.business.javaPos.commonkit.CountZZK;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.commonkit.PosLogicCompoment;
import com.efuture.business.javaPos.commonkit.PosLogicService;
import com.efuture.business.javaPos.commonkit.beantransfer.CouponTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.GoodsTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.OrderTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.PaymentTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.PopdetailTransfer;
import com.efuture.business.javaPos.commonkit.beantransfer.PrintTransfer;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.AnalyzeBarcodeDef;
import com.efuture.business.javaPos.struct.BaseOutModel;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.ConsumersData;
import com.efuture.business.javaPos.struct.DzcGoodsDetail;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.OperUser;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.OrderForPos;
import com.efuture.business.javaPos.struct.OrderGains;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.javaPos.struct.PrintInfo;
import com.efuture.business.javaPos.struct.SaleOrderStateEnum;
import com.efuture.business.javaPos.struct.SyncTradeModel;
import com.efuture.business.javaPos.struct.SysParaInfo;
import com.efuture.business.javaPos.struct.mainDataCentre.GoodsInfo;
import com.efuture.business.javaPos.struct.mainDataCentre.request.GetGoodsDetailIn;
import com.efuture.business.javaPos.struct.mainDataCentre.response.GetGoodsDetailOut;
import com.efuture.business.javaPos.struct.mss.SaveTempOut;
import com.efuture.business.javaPos.struct.mss.SearchTempDef;
import com.efuture.business.javaPos.struct.mss.TempDetailOut;
import com.efuture.business.javaPos.struct.mss.TempDetails;
import com.efuture.business.javaPos.struct.mss.TempHead;
import com.efuture.business.javaPos.struct.orderCentre.OrderStateEnum;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailPopModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersGainDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersModel4Pos;
import com.efuture.business.javaPos.struct.orderCentre.OrdersPayModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersPrintLogInfoModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersUseCouponModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderDetailPopModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderGainDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderGainModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderPayModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderUseCouponModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrders;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrdersModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrders_WSLF;
import com.efuture.business.javaPos.struct.orderCentre.request.OrderQueryIn;
import com.efuture.business.javaPos.struct.orderCentre.request.PrintLogIn;
import com.efuture.business.javaPos.struct.orderCentre.response.GetOrdersDetailOut;
import com.efuture.business.javaPos.struct.orderCentre.response.OrdersDetailOut;
import com.efuture.business.javaPos.struct.orderCentre.response.SaleOrdersQueryOut;
import com.efuture.business.javaPos.struct.orderCentre.response.SaveOrdersOut;
import com.efuture.business.javaPos.struct.posManager.BankCardInfoDef;
import com.efuture.business.javaPos.struct.posManager.request.GetBankCardInfoIn;
import com.efuture.business.javaPos.struct.posManager.request.OperUserIn;
import com.efuture.business.javaPos.struct.posManager.response.GetBankCardInfoOut;
import com.efuture.business.javaPos.struct.posManager.response.OperUserOut;
import com.efuture.business.javaPos.struct.promotionCentre.SellCoupon;
import com.efuture.business.javaPos.struct.promotionCentre.request.CalcCancelOrderIn;
import com.efuture.business.javaPos.struct.promotionCentre.request.CouponuseConsumeIn;
import com.efuture.business.javaPos.struct.promotionCentre.response.CouponGainCalcOut;
import com.efuture.business.javaPos.struct.request.ChangeOrderSnoIn;
import com.efuture.business.javaPos.struct.request.ChangeOrderTypeIn;
import com.efuture.business.javaPos.struct.request.ConfirmSaleReturnIn;
import com.efuture.business.javaPos.struct.request.CopySnoIn;
import com.efuture.business.javaPos.struct.request.CountAllIn;
import com.efuture.business.javaPos.struct.request.GetOrderIn;
import com.efuture.business.javaPos.struct.request.GetOrdersIn;
import com.efuture.business.javaPos.struct.request.PayConfirmIn;
import com.efuture.business.javaPos.struct.request.PickUpIn;
import com.efuture.business.javaPos.struct.request.RecordPrintLogIn;
import com.efuture.business.javaPos.struct.request.SaleReturnQueryIn;
import com.efuture.business.javaPos.struct.response.GetSaleGoodsInfoOut;
import com.efuture.business.javaPos.struct.response.PayConfirmOut;
import com.efuture.business.model.Elecscalecoderule;
import com.efuture.business.model.Syjmain;
import com.efuture.business.model.Syspara;
import com.efuture.business.service.AllVpayRemoteService;
import com.efuture.business.service.CalcPopRemoteService;
import com.efuture.business.service.CouponRemoteService;
import com.efuture.business.service.DFRemoteService;
import com.efuture.business.service.FunctionRemoteService;
import com.efuture.business.service.GoodsRemoteService;
import com.efuture.business.service.InitializationRemoteService;
import com.efuture.business.service.OrderCheckService;
import com.efuture.business.service.OrderPosCommonService;
import com.efuture.business.service.OrderPosOuterService;
import com.efuture.business.service.OrderPosUploadService;
import com.efuture.business.service.OrderSaleBS;
import com.efuture.business.service.OrderStatisticsService;
import com.efuture.business.service.PosWorkLogRemoteService;
import com.efuture.business.service.SkpMzkRemoteService;
import com.efuture.business.service.SyjMainLogRemoteService;
import com.efuture.business.service.SyncTradeService;
import com.efuture.business.service.VipRemoteService;
import com.efuture.business.task.OrderTask;
import com.efuture.business.util.ArrayUtils;
import com.efuture.business.util.CastUtil;
import com.efuture.business.util.Convert;
import com.efuture.business.util.DataExchageUtils;
import com.efuture.business.util.DateHelpUtil;
import com.efuture.business.util.DateUtils;
import com.efuture.business.util.HttpClientUtils;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.JsonUtils;
import com.efuture.business.util.ListUtils;
import com.efuture.business.util.LocalUtil;
import com.efuture.business.util.ParamsValidateUtil;
import com.efuture.business.util.PaymentUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.TimeZoneUtil;
import com.efuture.business.util.UUIDUtils;
import com.efuture.business.util.UniqueID;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import com.efuture.business.vo.FindOperUserInVo;
import com.efuture.ocp.common.entity.ServiceResponse;
import com.efuture.ocp.common.rest.ServiceMethodReflect;
import com.product.model.ServiceSession;
import com.product.util.ParamValidateUtil;
import com.product.util.TypeUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.client.RestTemplate;

public class OrderSaleBSImpl
implements OrderSaleBS {
    private static final Logger log = LoggerFactory.getLogger(OrderSaleBSImpl.class);
    @Resource(name="possvHttpUtils")
    protected HttpUtils httpUtils;
    protected static String EXECUTEONLINE = "order.online.tempsave.executeOnline";
    private static String UPDATETEMPORDERSTATE = "order.online.query.updateTempOrderState";
    protected static String TEMPORDERINFO = "order.online.query.searchTempOrderInfo";
    protected static String TEMPORDERDETAIL = "order.online.query.searchTempOrderDetail";
    public static String SENDTAILPAYINFO = "order.out.tailPaymentInfo";
    private static String PICKUPORDER = "order.online.save.pickUp";
    public static String PRINTCOUNT_URL = "order.outer.pos.getPrintCount";
    private static final String BILL_END_TIME = " 05:00:00";
    protected static String TEMPORDERLIST = "order.online.query.searchReturnTempOrderList";
    RestTemplate restTemplate;
    @Value(value="${localcache.enabled}")
    protected Boolean localcache;
    @Value(value="${hazelcast.enabled:false}")
    private Boolean hazelcast;
    @Autowired
    protected RedisUtil redisUtil;
    @Autowired
    public OrderTransfer orderTransfer;
    @Autowired
    public GoodsTransfer goodsTransfer;
    @Autowired
    public PaymentTransfer paymentTransfer;
    @Autowired
    public CouponTransfer couponTransfer;
    @Autowired
    public PopdetailTransfer popdetailTransfer;
    @Autowired
    public PrintTransfer printTransfer;
    @Autowired
    private GlobalInfo globalInfo;
    @Autowired(required=false)
    private OrderCheckService orderCheckService;
    @Autowired(required=false)
    public OrderPosOuterService orderPosOuterService;
    @Autowired(required=false)
    private OrderPosCommonService orderPosCommonService;
    @Autowired(required=false)
    private SyncTradeService syncTradeService;
    @Autowired(required=false)
    public OrderPosUploadService orderPosUploadService;
    @Autowired(required=false)
    private OrderStatisticsService orderStatisticsService;
    @Autowired(required=false)
    private SaleOrdersModelService ordersModelService;
    @Autowired(required=false)
    private SaleOrdersPrintLogInfoModelService ordersPrintLogInfoModelService;
    @Autowired(required=false)
    protected PosLogicService posLogicService;
    @Autowired(required=false)
    private PosLogicCompoment posLogicCompoment;
    public ServiceMethodReflect rcm = new ServiceMethodReflect();
    @SoaAnnotation(value="/apiCalcPopRemoteService.do")
    public CalcPopRemoteService calcPopRemoteService;
    @SoaAnnotation(value="/allVpayServer.do")
    public AllVpayRemoteService allVpayRemoteService;
    @SoaAnnotation(value="/apiGoodsRemoteService.do")
    protected GoodsRemoteService goodsRemoteService;
    @SoaAnnotation(value="/apiFunctionRemoteService.do")
    private FunctionRemoteService functionRemoteService;
    @SoaAnnotation(value="/apiCouponRemoteService.do")
    protected CouponRemoteService couponRemoteService;
    @SoaAnnotation(value="/apiVipRemoteService.do")
    protected VipRemoteService vipRemoteService;
    @SoaAnnotation(value="/apiInitializeRemoteService.do")
    protected InitializationRemoteService initRemoteService;
    private String errCode;
    @SoaAnnotation(value="/apiPosWorkLogRemoteService.do")
    private PosWorkLogRemoteService posWorkLogRemoteService;
    @SoaAnnotation(value="/apiSyjMainLogRemoteService.do")
    private SyjMainLogRemoteService syjMainLogRemoteService;
    @SoaAnnotation(value="/apiSkpMzkRemoteService.do")
    public SkpMzkRemoteService skpMzkRemoteService;
    @Autowired(required=false)
    OrderTask orderTask;
    @SoaAnnotation(value="/apiDFRemoteService.do")
    public DFRemoteService dfRemoteService;
    @Autowired
    private OrdersPayModelService ordersPayMapper;
    @Autowired
    private DbTools dbTools;

    @Override
    public RespBase payConfirm(ServiceSession session, ResqVo vo) {
        try {
            JSONObject paramsObject = vo.getJsonObject();
            String splitCode = null;
            String netType = "";
            if (null != paramsObject.getString("netType")) {
                netType = paramsObject.getString("netType");
            }
            if (paramsObject.containsKey((Object)"splitCode")) {
                splitCode = paramsObject.getString("splitCode");
            }
            PayConfirmIn in = (PayConfirmIn)JSON.parseObject((String)paramsObject.toJSONString(), PayConfirmIn.class);
            PayConfirmOut out = new PayConfirmOut();
            CacheModel cacheModel = vo.getCacheModel();
            if (cacheModel == null) {
                return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
            }
            session.setEnt_id(cacheModel.getOrder().getEntId());
            if (!cacheModel.getOrder().getSendSuccess()) {
                List payments = cacheModel.getPayments();
                double thisTimeUsedPoint = 0.0;
                if (null != payments) {
                    for (Payment payment : payments) {
                        if (!"YJFHG".equals(payment.getPayMemo()) && !"YJFXF".equals(payment.getPayMemo())) continue;
                        thisTimeUsedPoint += payment.getAmount();
                    }
                }
                if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
                    thisTimeUsedPoint = -1.0 * thisTimeUsedPoint;
                }
                cacheModel.getOrder().setThisTimeUsedPoint(thisTimeUsedPoint);
                log.info("\u672c\u5730\u4f7f\u7528\u79ef\u5206:{}", (Object)thisTimeUsedPoint);
                if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType()) && StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginTerminalSno())) {
                    cacheModel = this.saveSaleReturnOrder(cacheModel, session, in.getNewTerminalSno(), splitCode, netType);
                    log.info("\u79ef\u5206==>{}", (Object)cacheModel.getOrder().getTotalPoint());
                    if (cacheModel.getCalcResult() == -1) {
                        if ("2002".equals(this.errCode)) {
                            return Code.CODE_60006.getRespBase(new Object[]{cacheModel.getErrMsg()});
                        }
                        if ("50052".equals(cacheModel.getErrCode())) {
                            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel);
                            return new RespBase(Code.CODE_50052, cacheModel.getErrMsg(), (Object)resqVo, "SALESCONFIRECERTIFY");
                        }
                        return Code.CODE_60028.getRespBase(new Object[]{cacheModel.getErrMsg()});
                    }
                } else if ((cacheModel = this.saveOrder(cacheModel, session, in.getNewTerminalSno(), splitCode, netType)).getCalcResult() == -1) {
                    String errCode = "100000";
                    if (StringUtils.isNotBlank((String)cacheModel.getErrCode())) {
                        errCode = cacheModel.getErrCode();
                    }
                    if ("2002".equals(errCode)) {
                        return Code.CODE_60006.getRespBase(new Object[]{cacheModel.getErrMsg()});
                    }
                    if ("50099".equals(errCode)) {
                        return Code.CODE_50099.getRespBase(new Object[]{cacheModel.getErrMsg()});
                    }
                    if ("60139".equals(errCode)) {
                        return Code.CODE_60139.getRespBase(new Object[]{cacheModel.getErrMsg()});
                    }
                    if ("60025".equals(errCode)) {
                        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel);
                        return new RespBase(Code.CODE_60025, cacheModel.getErrMsg(), (Object)resqVo, "SALESCONFIRECERTIFY");
                    }
                    return Code.CODE_60139.getRespBase(new Object[]{cacheModel.getErrMsg()});
                }
                double availablePoint = ManipulatePrecision.add((double)cacheModel.getOrder().getTotalPoint(), (double)cacheModel.getOrder().getThisTimePoint());
                cacheModel.getOrder().setAvailablePoint(ManipulatePrecision.getDetailOverFlow((double)availablePoint, (String)"4"));
                cacheModel.clearOrderlist();
                cacheModel.clearBakGoodsAndPayments();
                if (null != cacheModel.getReturnPayments()) {
                    cacheModel.getReturnPayments().clear();
                }
            }
            if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
                String type = WorkLogType.refund;
                if ("2".equals(cacheModel.getOrder().getOrderType())) {
                    type = WorkLogType.voidSale;
                }
                this.orderTask.sendWorkLog(session, cacheModel.getOrder(), type, cacheModel.getOrder().getQty(), cacheModel.getOrder().getOughtPay());
            }
            if ("U".equals(cacheModel.getOrder().getOrderType())) {
                this.orderTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.buLuVic, cacheModel.getOrder().getQty(), cacheModel.getOrder().getOughtPay());
            }
            cacheModel = this.addGoodsDiscount(cacheModel);
            OrderGains orderGain = new OrderGains();
            List couponDetails = cacheModel.getOrder().getCouponDetails();
            orderGain = this.orderTransfer.convertOrderGains(couponDetails);
            if (null != orderGain) {
                out.setCouponGain(orderGain.getOrderCouponGains());
                out.setAchievePoints(orderGain.getPoints());
                out.setExperience(orderGain.getExperience());
            }
            PrintInfo printInfo = new PrintInfo();
            printInfo = "5".equals(cacheModel.getOrder().getOrderType()) ? this.printTransfer.convertPrintInfo(cacheModel.getReturnGoodsList()) : this.printTransfer.convertPrintInfo(cacheModel.getGoodsList());
            out.setOrder(this.orderTransfer.toOrderForPosOrderSave(cacheModel, printInfo.getGoodsListForPrint()));
            out.setPopInfo(this.popdetailTransfer.transferPopForPos(printInfo.getMergedPopDetails()));
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            String obj = this.redisUtil.get(RedisKey.CACHEID + in.getShopCode() + in.getTerminalNo());
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            Syjmain syjMainData = modeDetailsVo.getSyjmain();
            if ("9".equals(syjMainData.getSyjmode())) {
                JSONObject ob = new JSONObject();
                ob.put("mkt", (Object)in.getShopCode());
                ob.put("erpCode", (Object)cacheModel.getOrder().getErpCode());
                ob.put("syjh", (Object)in.getTerminalNo());
                ob.put("syjcursyyh", (Object)in.getTerminalOperator());
                ob.put("syjcurinvbs", (Object)(syjMainData.getSyjcurinvbs() + 1L));
                ob.put("syjcurinvje", (Object)syjMainData.getSyjcurinvje().add(BigDecimal.valueOf(cacheModel.getOrder().getOughtPay())));
                ob.put("syjcurcashje", (Object)0);
                ob.put("syjcurpreje", (Object)0);
                ob.put("syjcurstatus", (Object)"6");
                ob.put("syjcurnum", (Object)(Integer.parseInt(cacheModel.getOrder().getTerminalSno()) + 1));
                try {
                    log.info("[{}]--[{}]\u5165\u53c2->{}", new Object[]{cacheModel.getFlowNo(), "\u81ea\u52a9\u66f4\u65b0\u6536\u94f6\u673a\u72b6\u6001", ob.toJSONString()});
                    RespBase resp = this.functionRemoteService.update(session, null, ob);
                    log.info("[{}]--[{}]\u51fa\u53c2->{}", new Object[]{cacheModel.getFlowNo(), "\u81ea\u52a9\u66f4\u65b0\u6536\u94f6\u673a\u72b6\u6001", JSONObject.toJSONString((Object)resp)});
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return new RespBase(Code.SUCCESS, (Object)resqVo, "SALESCONFIRECERTIFY");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8ba2\u5355\u4fdd\u5b58\u5f02\u5e38!", (Throwable)e);
            log.error("\u4fdd\u5b58\u8ba2\u5355\u5f02\u5e38\uff1a" + e);
            return Code.CODE_60007.getRespBase(new Object[]{e.getMessage()});
        }
    }

    @Override
    public RespBase saleReturnQuery(ServiceSession session, ResqVo vo) {
        try {
            String shardingCode;
            JSONObject paramsObject = vo.getJsonObject();
            ParamsValidateUtil paramsValidateUtil = new ParamsValidateUtil(session, paramsObject);
            if (!paramsValidateUtil.validate()) {
                return paramsValidateUtil.getRespBase();
            }
            SaleReturnQueryIn saleReturnQueryIn = (SaleReturnQueryIn)JSON.parseObject((String)paramsObject.toJSONString(), SaleReturnQueryIn.class);
            String obj = this.redisUtil.get(RedisKey.CACHEID + saleReturnQueryIn.getShopCode() + saleReturnQueryIn.getTerminalNo());
            obj = this.reCacheMode(obj, paramsObject);
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
            CacheModel cacheModel = vo.getCacheModel();
            if (null == cacheModel) {
                return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
            }
            Order order = cacheModel.getOrder();
            OrderQueryIn orderQueryIn = new OrderQueryIn();
            orderQueryIn.setTerminalNo(saleReturnQueryIn.getOldTerminalNo());
            orderQueryIn.setTerminalSno(saleReturnQueryIn.getOldTerminalSno());
            orderQueryIn.setBusiTakeMarketCode(saleReturnQueryIn.getOldShopCode());
            orderQueryIn.setCreateDate(saleReturnQueryIn.getBillDate());
            if ("2".equals(cacheModel.getOrder().getOrderType())) {
                if (!(saleReturnQueryIn.getShopCode().equals(saleReturnQueryIn.getOldShopCode()) && saleReturnQueryIn.getTerminalNo().equals(saleReturnQueryIn.getOldTerminalNo()) && DateUtils.isOrderToday((String)saleReturnQueryIn.getBillDate()))) {
                    return Code.CODE_60046.getRespBase(new Object[0]);
                }
                orderQueryIn.setSearchType(1);
            } else {
                orderQueryIn.setSearchType(2);
            }
            if (paramsObject.containsKey((Object)"splitCode") && StringUtils.isNotBlank((String)(shardingCode = paramsObject.getString("splitCode")))) {
                orderQueryIn.setShardingCode(shardingCode);
            }
            if (StringUtils.isBlank((String)cacheModel.getOrder().getRefundAuthzCardNo())) {
                String cardnoString = saleReturnQueryIn.getTerminalOperator();
                if (StringUtils.isNotBlank((String)saleReturnQueryIn.getAccreditNo())) {
                    cardnoString = saleReturnQueryIn.getAccreditNo();
                }
                OperUserIn posManagerOperUserIn = new OperUserIn();
                posManagerOperUserIn.setCardno(cardnoString);
                posManagerOperUserIn.setMkt(saleReturnQueryIn.getShopCode());
                posManagerOperUserIn.setErpCode(cacheModel.getOrder().getErpCode());
                posManagerOperUserIn.setFlag("N");
                posManagerOperUserIn.setSyjh(saleReturnQueryIn.getTerminalNo());
                OperUser op1 = new OperUser();
                cacheModel.setCurGrant(op1);
                Object response = null;
                if ("0".equals(response.getReturncode())) {
                    OperUserOut posManagerOperUserOut = (OperUserOut)response.getData();
                    if (!posManagerOperUserOut.getPosrole().getPrivth().equals("Y") && !posManagerOperUserOut.getPosrole().getPrivth().equals("T")) {
                        return new RespBase(Code.CODE_60048, vo.getCacheModel().getFlowNo());
                    }
                    OperUser operUser = new OperUser(posManagerOperUserOut);
                    cacheModel.setCurGrant(operUser);
                    order.setRefundAuthzCardNo(operUser.getGh());
                } else {
                    return new RespBase(Code.CODE_60048, vo.getCacheModel().getFlowNo());
                }
            }
            RespBase resp = this.orderPosOuterService.searchOrdersDetail(session, (JSONObject)JSONObject.toJSON((Object)orderQueryIn));
            if (Code.SUCCESS.getIndex() != resp.getRetflag()) {
                log.info("\u8bf7\u6c42\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u8ba2\u5355\u5931\u8d25:" + resp.getData());
                if (order.getOrderType().equals("4")) {
                    return Code.CODE_60010.getRespBase(new Object[0]);
                }
                if (order.getOrderType().equals("2")) {
                    return Code.CODE_60033.getRespBase(new Object[0]);
                }
                return resp;
            }
            JSONObject json = (JSONObject)JSON.toJSON((Object)resp.getData());
            SaleOrders orderInfo = (SaleOrders)JSONObject.toJavaObject((JSON)((JSONObject)json.get((Object)"orderInfo")), SaleOrders.class);
            GetOrdersDetailOut getOrdersDetailOut = new GetOrdersDetailOut();
            getOrdersDetailOut.setOrderInfo(orderInfo);
            SaleOrders orderQueryOut = getOrdersDetailOut.getOrderInfo();
            if (null == orderQueryOut) {
                return Code.CODE_60011.getRespBase(new Object[0]);
            }
            String thrq = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"QHRQ");
            if (null != thrq && thrq.trim().length() > 0) {
                DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
                DateTimeFormatter formater2 = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                LocalDate thDate = LocalDate.parse(thrq, formatter);
                LocalDate orderDate = LocalDate.parse(orderQueryOut.getSaleOrders().getSaleDate().toString(), formater2);
                if (orderDate.isBefore(thDate)) {
                    return Code.CODE_60030.getRespBase(new Object[]{thDate});
                }
            }
            double allowReturnCopies = 0.0;
            for (SaleOrderDetailModel detail : orderQueryOut.getSaleOrderDetail()) {
                if ("0".equals(detail.getGoodsFlag())) continue;
                if ("2".equals(cacheModel.getOrder().getOrderType()) && ManipulatePrecision.doubleCompare((double)detail.getAllowReturnCopies(), (double)detail.getQty(), (int)4) != 0) {
                    return Code.CODE_60019.getRespBase(new Object[]{"" + detail.getRowNo()});
                }
                allowReturnCopies += detail.getAllowReturnCopies().doubleValue();
            }
            if (allowReturnCopies <= 0.0) {
                return Code.CODE_60020.getRespBase(new Object[0]);
            }
            boolean isHc = false;
            if ("2".equals(cacheModel.getOrder().getOrderType())) {
                isHc = true;
            }
            if ("2".equals(cacheModel.getOrder().getOrderType())) {
                if (!this.isAllowHC(orderQueryOut.getSaleOrders())) {
                    return Code.CODE_60049.getRespBase(new Object[0]);
                }
            } else if (!this.isAllowBack(orderQueryOut.getSaleOrders())) {
                return Code.CODE_60051.getRespBase(new Object[0]);
            }
            if (!SellType.ISBACK((String)order.getOrderType())) {
                return Code.CODE_60052.getRespBase(new Object[0]);
            }
            String paraValue = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"XDFS");
            ArrayList<String> unDisOrderPayCodes = new ArrayList<String>();
            String payString = "";
            if (null != paraValue) {
                payString = paraValue;
            }
            if (StringUtils.isNotEmpty((String)payString)) {
                Collections.addAll(unDisOrderPayCodes, payString.split(","));
            }
            if ("2".equals(cacheModel.getOrder().getOrderType())) {
                JSONObject object3;
                String paravalue1 = "1";
                JSONArray array = new JSONArray();
                List sysParaList = modeDetailsVo.getSyspara();
                JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
                if (sysParaArray.size() != 0) {
                    for (int i = 0; i < sysParaArray.size(); ++i) {
                        JSONObject sys = sysParaArray.getJSONObject(i);
                        if (!sys.get((Object)"code").equals("XDFS")) continue;
                        array.add((Object)sys);
                    }
                }
                if (array.size() != 0 && (object3 = array.getJSONObject(0)).containsKey((Object)"paravalue")) {
                    paravalue1 = object3.getString("paravalue");
                }
                String[] temp = paravalue1.split(",");
                List payModeList = orderInfo.getSaleOrderPay();
                if (temp.length > 0) {
                    for (int j = 0; j < temp.length; ++j) {
                        for (SaleOrderPayModel payModel : payModeList) {
                            if (!payModel.getPayCode().equals(temp[j])) continue;
                            return Code.CODE_60032.getRespBase(new Object[0]);
                        }
                    }
                }
            }
            String authCardNo = cacheModel.getOrder().getTerminalOperatorAuthzCardNo();
            String thAuthCardNo = cacheModel.getOrder().getRefundAuthzCardNo();
            cacheModel = this.TransferCacheModelForReturn(orderInfo, saleReturnQueryIn, cacheModel, unDisOrderPayCodes, isHc);
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String nowDateTime = dateTime.format(df).toString();
            cacheModel.getOrder().setSaleDate(nowDateTime);
            cacheModel.getOrder().setTerminalOperatorAuthzCardNo(authCardNo);
            cacheModel.getOrder().setRefundAuthzCardNo(thAuthCardNo);
            return new RespBase(Code.SUCCESS, (Object)cacheModel, "GETRETURNMESSCERTIFY");
        }
        catch (Exception e) {
            e.printStackTrace();
            return Code.CODE_60007.getRespBase(new Object[]{e.getMessage()});
        }
    }

    @Override
    public RespBase copySno(ServiceSession session, ResqVo vo) {
        try {
            String shardingCode;
            JSONObject paramsObject = vo.getJsonObject();
            ParamsValidateUtil paramsValidateUtil = new ParamsValidateUtil(session, paramsObject);
            if (!paramsValidateUtil.validate()) {
                return paramsValidateUtil.getRespBase();
            }
            if (!paramsObject.containsKey((Object)"originShopCode") || "".equals(paramsObject.getString("originShopCode")) || !paramsObject.containsKey((Object)"originTerminalSno") || "".equals(paramsObject.getString("originTerminalSno")) || !paramsObject.containsKey((Object)"originTerminalNo") || "".equals(paramsObject.getString("originTerminalNo"))) {
                return Code.CODE_60061.getRespBase(new Object[0]);
            }
            CopySnoIn copySnoIn = (CopySnoIn)JSONObject.toJavaObject((JSON)paramsObject, CopySnoIn.class);
            CacheModel cacheModel = vo.getCacheModel();
            if (cacheModel == null) {
                return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
            }
            if (!cacheModel.getOrder().getAllowEditGoods()) {
                return Code.CODE_60008.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
            }
            if (StringUtils.isBlank((String)cacheModel.getOrder().getSeqNo())) {
                LocalDateTime dateTime = LocalDateTime.now();
                DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
                String nowDateTime = dateTime.format(df).toString();
                cacheModel.getOrder().setSaleDate(nowDateTime);
            }
            String obj = this.redisUtil.get(RedisKey.CACHEID + copySnoIn.getShopCode() + copySnoIn.getTerminalNo());
            obj = this.reCacheMode(obj, paramsObject);
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            OrderQueryIn in = new OrderQueryIn();
            in.setBusiTakeMarketCode(copySnoIn.getOriginShopCode());
            in.setTerminalNo(copySnoIn.getOriginTerminalNo());
            in.setTerminalSno(copySnoIn.getOriginTerminalSno());
            in.setCreateDate(copySnoIn.getBillDate());
            in.setSearchType(3);
            if (paramsObject.containsKey((Object)"splitCode") && StringUtils.isNotBlank((String)(shardingCode = paramsObject.getString("splitCode")))) {
                in.setShardingCode(shardingCode);
            }
            RespBase resp = this.orderPosOuterService.searchOrdersDetail(session, (JSONObject)JSONObject.toJSON((Object)in));
            log.info("\u67e5\u8ba2\u5355\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)resp.getData()));
            if (Code.SUCCESS.getIndex() != resp.getRetflag()) {
                if ("60003".equals(String.valueOf(resp.getRetflag()))) {
                    return Code.CODE_60021.getRespBase(new Object[]{resp.getData()});
                }
                if ("10001".equals(String.valueOf(resp.getRetflag()))) {
                    return Code.CODE_60021.getRespBase(new Object[]{resp.getData()});
                }
                log.info("\u83b7\u53d6\u8ba2\u5355\u5931\u8d25:" + resp.getData());
                return Code.CODE_60035.getRespBase(new Object[]{resp.getData()});
            }
            OrdersDetailOut getOrdersDetailOut = (OrdersDetailOut)JSONObject.toJavaObject((JSON)((JSONObject)JSONObject.toJSON((Object)resp.getData())), OrdersDetailOut.class);
            SaleOrders_WSLF saleOrders = getOrdersDetailOut.getOrderInfo();
            if (saleOrders.getOrders() == null) {
                return new RespBase(Code.CODE_50067, vo.getCacheModel().getFlowNo());
            }
            OrdersModel4Pos saleOrder = saleOrders.getOrders();
            String typeCode = saleOrder.getOrderType();
            if (SellType.ISBACK((String)typeCode)) {
                return new RespBase(Code.CODE_60110, (Object)typeCode, vo.getCacheModel().getFlowNo());
            }
            if ("Y10".equals(typeCode)) {
                return new RespBase(Code.CODE_60110, (Object)typeCode, vo.getCacheModel().getFlowNo());
            }
            if ("Y11".equals(typeCode)) {
                return new RespBase(Code.CODE_60110, (Object)typeCode, vo.getCacheModel().getFlowNo());
            }
            if ("Y9".equals(typeCode)) {
                return new RespBase(Code.CODE_60110, (Object)typeCode, vo.getCacheModel().getFlowNo());
            }
            if ("Y3".equals(typeCode)) {
                return new RespBase(Code.CODE_60110, (Object)typeCode, vo.getCacheModel().getFlowNo());
            }
            if ("Y4".equals(typeCode)) {
                return new RespBase(Code.CODE_60110, (Object)typeCode, vo.getCacheModel().getFlowNo());
            }
            if ("Y12".equals(typeCode)) {
                return new RespBase(Code.CODE_60110, (Object)typeCode, vo.getCacheModel().getFlowNo());
            }
            int barNoMode = 0;
            String discType = "0";
            if ("2".equals(cacheModel.getEleCodeMode())) {
                barNoMode = 3;
            }
            List elecCodeRules = modeDetailsVo.getElecscalecoderule();
            DzcGoodsDetail dzc = new DzcGoodsDetail();
            GoodsInfo goodsInfo = null;
            List saleOrderDetail = saleOrders.getOrdersDetail();
            RespBase res = new RespBase();
            ArrayList<Goods> goodsList = new ArrayList<Goods>();
            ArrayList<String> guidList = new ArrayList<String>();
            if (!saleOrderDetail.isEmpty()) {
                for (int i = 0; i < saleOrderDetail.size(); ++i) {
                    GetGoodsDetailOut goodsDetail;
                    if (((OrdersDetailModel)saleOrderDetail.get(i)).getGoodType().equals("98") || ((OrdersDetailModel)saleOrderDetail.get(i)).getGoodType().equals("99") || null != ((OrdersDetailModel)saleOrderDetail.get(i)).getGoodsFlag() && (((OrdersDetailModel)saleOrderDetail.get(i)).getGoodsFlag().equals("0") || ((OrdersDetailModel)saleOrderDetail.get(i)).getGoodsFlag().equals("7") || ((OrdersDetailModel)saleOrderDetail.get(i)).getGoodsFlag().equals("8") || ((OrdersDetailModel)saleOrderDetail.get(i)).getGoodsFlag().equals("9") || ((OrdersDetailModel)saleOrderDetail.get(i)).getGoodsFlag().equals("B"))) continue;
                    boolean isdzcm = false;
                    boolean isNeedFindDzc = true;
                    boolean isNeedFindMdm = true;
                    int priceMode = 0;
                    String originalBarNo = ((OrdersDetailModel)saleOrderDetail.get(i)).getScanCode();
                    int disMode = 0;
                    double disValue = 0.0;
                    AnalyzeBarcodeDef codeInfo = this.posLogicCompoment.analyzeCodeInfo(barNoMode, originalBarNo, "0");
                    if (!codeInfo.getValidate()) {
                        return new RespBase(Code.CODE_60111, vo.getCacheModel().getFlowNo());
                    }
                    isNeedFindDzc = codeInfo.getIsNeedFindDzc();
                    priceMode = codeInfo.getPriceMode();
                    disMode = codeInfo.getDisMode();
                    disValue = codeInfo.getDisValue();
                    barNoMode = codeInfo.getBarNoMode();
                    if (isNeedFindDzc && elecCodeRules.size() > 0) {
                        dzc = this.posLogicCompoment.analyzeBarcode(codeInfo.getBarNo(), elecCodeRules, ((Elecscalecoderule)elecCodeRules.get(0)).getExpModeMMDDDays(), ((Elecscalecoderule)elecCodeRules.get(0)).getExpModeDDHHDays(), cacheModel.getEleCodeMode());
                        if (!SellType.ISBACK((String)cacheModel.getOrder().getOrderType()) && dzc.getRetCode() == 2) {
                            return new RespBase(Code.CODE_60109, vo.getCacheModel().getFlowNo());
                        }
                        if (dzc.getRetCode() == 1) {
                            isdzcm = true;
                        }
                    }
                    GetGoodsDetailIn getGoodsDetailIn = new GetGoodsDetailIn();
                    if (isdzcm) {
                        getGoodsDetailIn.setEntId(session.getEnt_id());
                        getGoodsDetailIn.setShopCode(cacheModel.getOrder().getShopCode());
                        getGoodsDetailIn.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                        getGoodsDetailIn.setCode(dzc.getCode());
                        getGoodsDetailIn.setSearchType("1");
                        getGoodsDetailIn.setChannel(cacheModel.getOrder().getChannel());
                        getGoodsDetailIn.setErpCode(cacheModel.getOrder().getErpCode());
                        res = this.goodsRemoteService.getGoodsFromMDM(session, (JSONObject)JSON.toJSON((Object)getGoodsDetailIn));
                    } else {
                        getGoodsDetailIn.setEntId(session.getEnt_id());
                        getGoodsDetailIn.setShopCode(cacheModel.getOrder().getShopCode());
                        getGoodsDetailIn.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                        getGoodsDetailIn.setCode(codeInfo.getBarNo());
                        getGoodsDetailIn.setSearchType("1");
                        getGoodsDetailIn.setChannel(cacheModel.getOrder().getChannel());
                        getGoodsDetailIn.setErpCode(cacheModel.getOrder().getErpCode());
                        if (isNeedFindMdm) {
                            res = this.goodsRemoteService.getGoodsFromMDM(session, (JSONObject)JSON.toJSON((Object)getGoodsDetailIn));
                        }
                    }
                    if (0 != res.getRetflag()) {
                        if (!isdzcm && disValue == 0.0 && getGoodsDetailIn.getCode().length() < 13) {
                            getGoodsDetailIn.setCode(Convert.padLeft(getGoodsDetailIn.getCode(), '0', 13));
                        }
                        res = this.goodsRemoteService.getGoodsFromMDM(session, (JSONObject)JSON.toJSON((Object)getGoodsDetailIn));
                        if (!"0".equals(resp.getRetflag())) {
                            return new RespBase(Code.CODE_20074, vo.getCacheModel().getFlowNo());
                        }
                        goodsDetail = (GetGoodsDetailOut)JSONObject.toJavaObject((JSON)((JSONObject)JSONObject.toJSON((Object)res.getData())), GetGoodsDetailOut.class);
                        if (goodsDetail.getGoods().size() == 0) {
                            continue;
                        }
                    } else {
                        goodsDetail = (GetGoodsDetailOut)JSONObject.toJavaObject((JSON)((JSONObject)JSONObject.toJSON((Object)res.getData())), GetGoodsDetailOut.class);
                    }
                    goodsInfo = (GoodsInfo)goodsDetail.getGoods().get(0);
                    if (goodsDetail.getGoods().size() > 1) {
                        for (GoodsInfo g : goodsDetail.getGoods()) {
                            if (!g.getMainBarcodeFlag()) continue;
                            goodsInfo = g;
                            break;
                        }
                    }
                    if (goodsInfo.getSalePrice() == 0.0) {
                        goodsInfo.setSalePrice(CastUtil.castDouble((Object)((OrdersDetailModel)saleOrderDetail.get(i)).getSalePrice()));
                    }
                    if (isdzcm) {
                        goodsInfo.setEWCCodeAmount(dzc.getDzcmjg());
                        goodsInfo.setEWCCodeNum(dzc.getDzcmsl());
                        goodsInfo.setExpTime(dzc.getExpTime());
                        if (goodsInfo.getSalePrice() == 0.0) {
                            goodsInfo.setSalePrice(dzc.getDzcmjg());
                        }
                    } else if (goodsInfo.getEscaleFlag() == 1) {
                        goodsInfo.setEscaleFlag(0);
                        goodsInfo.setSalePrice(CastUtil.castDouble((Object)((OrdersDetailModel)saleOrderDetail.get(i)).getSalePrice()));
                    }
                    Goods goods = this.posLogicService.CalcGoodsAmountBeforeSingle(goodsInfo, cacheModel.getOrder().getTerminalOperator(), isdzcm, goodsInfo.getEWCCodeNum(), goodsInfo.getEWCCodeAmount(), cacheModel.getEleCodeMode(), ((OrdersDetailModel)saleOrderDetail.get(i)).getBarNo(), ((OrdersDetailModel)saleOrderDetail.get(i)).getQty().doubleValue(), true);
                    goods.setGoodsNo(originalBarNo);
                    goods.setCalcMode("0");
                    goods.setGuid(UUIDUtils.buildGuid());
                    goods.setFlowNo(cacheModel.getFlowNo());
                    goods.setFlowId(goodsList.size() + 1);
                    log.info("PRICEMODE=" + priceMode + ",DISVALUE=" + disValue + ",DISMODE=" + disMode + ",SALEAMOUNT=" + goods.getSaleAmount() + ",GOODSNO=" + goods.getGoodsNo());
                    if (priceMode == 2 && ManipulatePrecision.doubleCompare((double)disValue, (double)0.0, (int)2) > 0) {
                        goods = this.posLogicCompoment.calcGoodsBarcodeDiscBeforeSingle(goods, disMode, disValue, discType);
                    }
                    String guid = UUIDUtils.buildGuid();
                    goods.setGuid(guid);
                    goods.setAssistantId(((OrdersDetailModel)saleOrderDetail.get(i)).getAssistantId());
                    goodsList.add(goods);
                    if (!"Y".equals(goods.getEscaleFlag()) || goods.getQty() == ((OrdersDetailModel)saleOrderDetail.get(i)).getQty().doubleValue()) continue;
                    for (double m = ((OrdersDetailModel)saleOrderDetail.get(i)).getQty() - 1.0; m > 0.0; m -= 1.0) {
                        Goods g = goods.deepClone();
                        goods.setGuid(UUIDUtils.buildGuid());
                        g.setAssistantId(((OrdersDetailModel)saleOrderDetail.get(i)).getAssistantId());
                        g.setFlowId(goodsList.size() + 1);
                        goodsList.add(g);
                    }
                }
            }
            cacheModel.callMarketClear();
            cacheModel.setGoodsList(goodsList);
            cacheModel = this.posLogicService.clearPop(cacheModel);
            if (cacheModel == null || cacheModel.getGoodsList() == null || cacheModel.getOrder() == null) {
                return new RespBase(Code.CODE_60112, vo.getCacheModel().getFlowNo());
            }
            vo.setCacheModel(cacheModel);
            if (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 3) {
                RespBase respBase = this.calcPopRemoteService.calcSinglePopAfterVipService(session, vo, true);
                ResqVo resqVo = (ResqVo)respBase.getData();
                cacheModel = resqVo.getCacheModel();
            } else if (cacheModel.getPopMode() == 2) {
                String calcMode = "0";
                cacheModel = this.calcOrderPop(session, calcMode, cacheModel, vo, guidList);
            } else {
                this.posLogicCompoment.calcOrderAmount(cacheModel);
            }
            if (cacheModel.getCalcResult() == -1) {
                return new RespBase(-1, cacheModel.getErrMsg(), vo.getCacheModel().getFlowNo());
            }
            cacheModel.getOrder().setTerminalOperatorAuthzCardNo(cacheModel.getCurGrant().getGh());
            return new RespBase(Code.SUCCESS, (Object)cacheModel, "COPYSNO");
        }
        catch (Exception e) {
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return new RespBase(Code.CODE_60113, vo.getCacheModel().getFlowNo());
        }
    }

    @Override
    public RespBase getOrder(ServiceSession session, GetOrderIn getOrderIn) {
        try {
            OrderQueryIn in = new OrderQueryIn();
            in.setBusiTakeMarketCode(getOrderIn.getShopCode());
            in.setTerminalNo(getOrderIn.getTerminalNo());
            in.setTerminalSno(getOrderIn.getTerminalSno());
            in.setCreateDate(getOrderIn.getBillDate());
            in.setSearchType(getOrderIn.getSearchType());
            if (StringUtils.isNotBlank((String)getOrderIn.getShardingCode())) {
                in.setShardingCode(getOrderIn.getShardingCode());
            }
            RespBase resp = this.orderPosOuterService.searchOrdersDetail(session, (JSONObject)JSONObject.toJSON((Object)in));
            log.info("\u67e5\u8ba2\u5355\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)resp.getData()));
            if (Code.SUCCESS.getIndex() != resp.getRetflag()) {
                if ("60003".equals(String.valueOf(resp.getRetflag()))) {
                    return Code.CODE_60021.getRespBase(new Object[]{resp.getData()});
                }
                if ("10001".equals(String.valueOf(resp.getRetflag()))) {
                    return Code.CODE_60021.getRespBase(new Object[]{resp.getData()});
                }
                log.info("\u83b7\u53d6\u8ba2\u5355\u5931\u8d25:" + resp.getData());
                return Code.CODE_60035.getRespBase(new Object[]{resp.getData()});
            }
            GetOrdersDetailOut getOrdersDetailOut = (GetOrdersDetailOut)JSONObject.toJavaObject((JSON)((JSONObject)JSONObject.toJSON((Object)resp.getData())), GetOrdersDetailOut.class);
            SaleOrders saleOrder = new SaleOrders();
            SaleOrders oriOrder = null;
            if (in.getSearchType() == 3) {
                oriOrder = getOrdersDetailOut.getOriginInfo();
                saleOrder = getOrdersDetailOut.getOrderInfo();
            } else {
                saleOrder = in.getSearchType() == 4 ? getOrdersDetailOut.getOriginInfo() : getOrdersDetailOut.getOrderInfo();
            }
            if (saleOrder.getSaleOrders() == null) {
                return Code.CODE_60016.getRespBase(new Object[]{resp.getData()});
            }
            PayConfirmOut out = new PayConfirmOut();
            OrderForPos orderOut = this.orderTransfer.toOrderForPos(saleOrder);
            ArrayList<Payment> sellPayments = new ArrayList<Payment>();
            for (Object s : saleOrder.getSaleOrderPay()) {
                Payment p = new Payment();
                this.paymentTransfer.SaleOrderPayToPayment((SaleOrderPayModel)s, p);
                log.info("payment\u8f6c\u6362\u5b8c\u62101");
                sellPayments.add(p);
            }
            orderOut.setSalePayments(sellPayments);
            log.info("payment\u8f6c\u6362\u5b8c\u6210");
            ArrayList<Goods> goodsList = new ArrayList<Goods>();
            for (SaleOrderDetailModel s : saleOrder.getSaleOrderDetail()) {
                Goods goods = new Goods();
                this.goodsTransfer.SaleOrderDetailToGoods(goods, s);
                goodsList.add(goods);
            }
            log.info("goods\u8f6c\u6362\u5b8c\u6210");
            if (null != saleOrder.getSaleOrderDetailPop() && saleOrder.getSaleOrderDetailPop().size() > 0) {
                for (SaleOrderDetailPopModel orderPop : saleOrder.getSaleOrderDetailPop()) {
                    int rowNo = orderPop.getRowNo() - 1;
                    ((Goods)goodsList.get(rowNo)).getPopDetailsInfo().add(this.popdetailTransfer.transferPopDetail(orderPop));
                }
            }
            log.info("orderPop\u8f6c\u6362\u5b8c\u6210");
            PrintInfo printInfo = this.printTransfer.convertPrintInfo(goodsList);
            log.info("printInfo\u8f6c\u6362\u5b8c\u6210");
            out.setPopInfo(new ArrayList());
            out.getPopInfo().addAll(printInfo.getMergedPopDetails());
            List goodListPops = this.goodsTransfer.transferGoodsToPosGoodsListSingle(printInfo.getGoodsListForPrint());
            orderOut.getGoodsList().addAll(goodListPops);
            OrderGains orderGain = this.orderTransfer.convertOrderGains(this.couponTransfer.transferCoupon3(saleOrder.getSaleOrderGain()));
            log.info("orderGain\u8f6c\u6362\u5b8c\u6210");
            if (null != orderGain) {
                out.setAchievePoints(orderGain.getPoints());
                out.setExperience(orderGain.getExperience());
                out.setCouponGain(orderGain.getOrderCouponGains());
            }
            out.setOrder(orderOut);
            return new RespBase(Code.SUCCESS, (Object)out, "GETORDERMESSCERTIFY");
        }
        catch (Exception e) {
            e.printStackTrace();
            return new RespBase(Code.CODE_60007.getIndex(), e.getMessage());
        }
    }

    @Override
    public RespBase getOrders(ServiceSession session, JSONObject paramsObject) {
        String shardingCode;
        if (StringUtils.isBlank((String)paramsObject.getString("shopCode"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"shopCode"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("entId"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"entId"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("pageNo"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"pageNo"});
        }
        if (StringUtils.isBlank((String)paramsObject.getString("pageSize"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"pageSize"});
        }
        GetOrdersIn getOrdersIn = (GetOrdersIn)JSON.parseObject((String)paramsObject.toJSONString(), GetOrdersIn.class);
        if (getOrdersIn == null) {
            return Code.CODE_60015.getRespBase(new Object[]{"\u5165\u53c2\u8f6c\u6362\u5931\u8d25"});
        }
        session.setEnt_id(getOrdersIn.getEntId());
        OrderQueryIn orderQueryIn = OrderQueryIn.transferGetOrdersInToOrderQueryIn((GetOrdersIn)getOrdersIn);
        if (paramsObject.containsKey((Object)"splitCode") && StringUtils.isNotBlank((String)(shardingCode = paramsObject.getString("splitCode")))) {
            orderQueryIn.setShardingCode(shardingCode);
        }
        RespBase response = this.orderPosOuterService.searchOrders(session, (JSONObject)JSONObject.toJSON((Object)orderQueryIn));
        if (Code.SUCCESS.getIndex() == response.getRetflag()) {
            SaleOrdersQueryOut data = new SaleOrdersQueryOut();
            List ordersList = (List)response.getData();
            data.setSaleOrders(ordersList);
            data.setTotal_results(ordersList.size());
            return new RespBase(Code.SUCCESS, (Object)data, "ORDERLISTCERTIFY");
        }
        return response;
    }

    @Override
    public RespBase confirmSalesReturn(ServiceSession session, ResqVo vo) {
        JSONObject paramsObject = vo.getJsonObject();
        ParamsValidateUtil paramsValidateUtil = new ParamsValidateUtil(session, paramsObject);
        if (!paramsValidateUtil.validate()) {
            return paramsValidateUtil.getRespBase();
        }
        String obj = this.redisUtil.get(RedisKey.CACHEID + vo.getCacheModel().getOrder().getShopCode() + vo.getCacheModel().getOrder().getTerminalNo());
        obj = this.reCacheMode(obj, paramsObject);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        ConfirmSaleReturnIn confirmSalesReturnIn = (ConfirmSaleReturnIn)JSON.parseObject((String)paramsObject.toJSONString(), ConfirmSaleReturnIn.class);
        CacheModel cacheModel = vo.getCacheModel();
        List orderGoods = cacheModel.getReturnGoodsList();
        log.info("\u539f\u8ba2\u5355\u5546\u54c1==>{}", (Object)JSONArray.toJSONString((Object)orderGoods));
        List selectGoods = confirmSalesReturnIn.getGoodsList();
        ArrayList<Goods> returnGoods = new ArrayList<Goods>();
        int i = 0;
        if (cacheModel.getOrder().isDepositSale() && !cacheModel.getOrder().isTailMoneyPay() && orderGoods.size() != selectGoods.size()) {
            return Code.CODE_60062.getRespBase(new Object[0]);
        }
        if (cacheModel.getOrder().getOriginOrderState() == 7 && (cacheModel.getOrder().getOriginLogisticsState() == 16 || cacheModel.getOrder().getOriginLogisticsState() == 1) && orderGoods.size() != selectGoods.size()) {
            return Code.CODE_60063.getRespBase(new Object[0]);
        }
        double refundAmount = 0.0;
        block0: for (Goods goodsA : selectGoods) {
            for (Goods goodsB : orderGoods) {
                if (!goodsB.getGuid().equals(goodsA.getGuid())) continue;
                if (goodsB.getAllowReturnCopies() <= 0.0) {
                    return Code.CODE_60064.getRespBase(new Object[]{goodsB.getGoodsCode(), goodsB.getAllowReturnCopies()});
                }
                Goods goods = new Goods();
                String precisionMode = DataExchageUtils.exchangePrecisionMode((String)goodsB.getPrcutMode());
                if ("2".equals(cacheModel.getOrder().getOrderType())) {
                    goods = goodsB.deepClone();
                    goods.setTempZrDiscount(goods.getAdjustDiscountValue());
                } else {
                    goods = goodsB.deepCloneWithOutPopInfo();
                }
                String jyms = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"JYMS");
                String artCode = "";
                String serchType = "1";
                GetGoodsDetailIn getGoodsDetailIn = new GetGoodsDetailIn();
                getGoodsDetailIn.setEntId(cacheModel.getOrder().getEntId());
                getGoodsDetailIn.setShopCode(cacheModel.getOrder().getShopCode());
                getGoodsDetailIn.setTerminalNo(cacheModel.getOrder().getTerminalNo());
                getGoodsDetailIn.setCode(goods.getBarNo());
                getGoodsDetailIn.setSearchType(serchType);
                getGoodsDetailIn.setOrgCode(goods.getOrgCode());
                getGoodsDetailIn.setErpCode(cacheModel.getOrder().getErpCode());
                RespBase resp = this.goodsRemoteService.getGoodsFromMDM(session, (JSONObject)JSON.toJSON((Object)getGoodsDetailIn));
                if (Code.SUCCESS.getIndex() != resp.getRetflag()) {
                    return Code.CODE_20074.getRespBase(new Object[0]);
                }
                GetGoodsDetailOut goodsDetailOut = (GetGoodsDetailOut)resp.getData();
                if (goodsDetailOut.getGoods() != null && goodsDetailOut.getGoods().size() > 0) {
                    GoodsInfo goodsInfo = (GoodsInfo)goodsDetailOut.getGoods().get(0);
                    artCode = goodsInfo.getArtCode();
                }
                goods.setArtCode(artCode);
                if ("1".equals(jyms)) {
                    goods.setTempCategory(goods.getArtCode());
                } else {
                    goods.setTempCategory(goods.getCategoryCode());
                }
                goods.setOriginalFlowId(Integer.valueOf(goodsB.getFlowId()));
                goods.setFlowId(++i);
                if (cacheModel.getOrder().isDepositSale()) {
                    return Code.CODE_20129.getRespBase(new Object[0]);
                }
                if (goodsA.getQty() != goods.getAllowReturnCopies().doubleValue() && cacheModel.getOrder().getOriginOrderState() == 7 && (cacheModel.getOrder().getOriginLogisticsState() == 16 || cacheModel.getOrder().getOriginLogisticsState() == 1) && orderGoods.size() != selectGoods.size()) {
                    return Code.CODE_60063.getRespBase(new Object[0]);
                }
                if (goodsA.getQty() > goods.getAllowReturnCopies()) {
                    return Code.CODE_60065.getRespBase(new Object[]{goods.getGuid(), goodsA.getQty(), goods.getAllowReturnCopies()});
                }
                if (goods.getQty() != goodsA.getQty()) {
                    goods.setSaleValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getSaleValue() * goodsA.getQty() / goodsB.getQty()), (String)precisionMode));
                    goods.setCouponValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getCouponValue() * goodsA.getQty() / goodsB.getQty()), (String)precisionMode));
                    goods.setPopDiscountValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getPopDiscountValue() * goodsA.getQty() / goodsB.getQty()), (String)precisionMode));
                    goods.setAdjustDiscountValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getAdjustDiscountValue() * goodsA.getQty() / goodsB.getQty()), (String)precisionMode));
                    goods.setCustomDiscountValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getCustomDiscountValue() * goodsA.getQty() / goodsB.getQty()), (String)precisionMode));
                    goods.setMealDiscountValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getMealDiscountValue() * goodsA.getQty() / goodsB.getQty()), (String)precisionMode));
                    goods.setPayDiscountValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getPayDiscountValue() * goodsA.getQty() / goodsB.getQty()), (String)precisionMode));
                    goods.setStudentCardDiscountValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getStudentCardDiscountValue() * goodsA.getQty() / goodsB.getQty()), (String)precisionMode));
                    goods.setNoDisAmountValue(ManipulatePrecision.getDetailOverFlow((double)(goods.getNoDisAmountValue() * goodsA.getQty() / goodsB.getQty()), (String)precisionMode));
                    goods.setTotalDiscountValue(CountZZK.getZZK((Goods)goods));
                }
                goods.setSaleAmount(ManipulatePrecision.getDetailOverFlow((double)(goods.getSaleValue() - goods.getTotalDiscountValue()), (String)precisionMode));
                goods.setQty(goodsA.getQty());
                returnGoods.add(goods);
                refundAmount += goods.getSaleAmount();
                continue block0;
            }
        }
        if (cacheModel.getOrder().getOrderType() != null && !cacheModel.getOrder().getOrderType().equals("2") && refundAmount > cacheModel.getCurGrant().getPrivthje()) {
            return Code.CODE_20077.getRespBase(new Object[0]);
        }
        cacheModel.setGoodsList(returnGoods);
        if (cacheModel.getOrder().isDepositSale() && !cacheModel.getOrder().isTailMoneyPay()) {
            String wkPayCode = "";
            String paraValue = "";
            paraValue = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"WKFS");
            if (null == paraValue || "".equals(paraValue)) {
                return Code.CODE_20132.getRespBase(new Object[0]);
            }
            wkPayCode = paraValue.trim();
            if (cacheModel.getPayments().size() == 0) {
                for (Payment p : cacheModel.getReturnPayments()) {
                    if (!p.getPayCode().equals(wkPayCode)) continue;
                    Payment newp = (Payment)p.clone();
                    newp.setPuid(String.valueOf(UniqueID.getUniqueID()));
                    newp.setRowno(cacheModel.getPayments().size() + 1);
                    newp.setIsAutoDelOnly(true);
                    cacheModel.getPayments().add(newp);
                }
            }
        }
        this.posLogicCompoment.calcOrderAmount(cacheModel);
        this.posLogicCompoment.calcPayBalance(cacheModel);
        if (cacheModel.getCalcResult() == -1) {
            return Code.CODE_20078.getRespBase(new Object[]{cacheModel.getErrMsg()});
        }
        if (null != confirmSalesReturnIn.getOrderType() && SellType.ISBACK((String)confirmSalesReturnIn.getOrderType())) {
            cacheModel.getOrder().setOrderType(confirmSalesReturnIn.getOrderType());
        }
        return new RespBase(Code.SUCCESS, (Object)cacheModel, "FINISHBACKSALEGOODS");
    }

    @Override
    public RespBase<ResqVo> changeOrderSno(ServiceSession session, ResqVo vo) {
        JSONObject paramsObject = vo.getJsonObject();
        ChangeOrderSnoIn in = (ChangeOrderSnoIn)JSON.parseObject((String)paramsObject.toJSONString(), ChangeOrderSnoIn.class);
        ParamsValidateUtil paramsValidateUtil = new ParamsValidateUtil(session, paramsObject);
        if (!paramsValidateUtil.validate()) {
            return paramsValidateUtil.getRespBase();
        }
        if (StringUtils.isBlank((String)paramsObject.getString("terminalSno"))) {
            return Code.CODE_60001.getRespBase(new Object[]{"terminalSno"});
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (!cacheModel.getOrder().getAllowEditGoods()) {
            return Code.CODE_60008.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_60009.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        String terminalSno = in.getTerminalSno();
        if (cacheModel.getOrder().getSysPara().getFphmMode() == 1) {
            if (terminalSno.length() > 6) {
                terminalSno = StringUtils.substring((String)terminalSno, (int)6);
            }
            SimpleDateFormat format = new SimpleDateFormat("yyMMdd");
            Date date = new Date();
            cacheModel.getOrder().setTerminalSno(format.format(date) + terminalSno);
        } else if (StringUtils.isNotEmpty((String)terminalSno)) {
            cacheModel.getOrder().setTerminalSno(terminalSno);
        }
        LocalDateTime dateTime = LocalDateTime.now();
        DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
        String nowDateTime = dateTime.format(df).toString();
        cacheModel.getOrder().setSaleDate(nowDateTime);
        cacheModel.getOrder().setSaleExtractTime(nowDateTime);
        cacheModel.getOrder().setTerminalOperator(in.getTerminalOperator());
        if (StringUtils.isNotBlank((String)in.getAccreditNo())) {
            FindOperUserInVo posManagerOperUserIn = new FindOperUserInVo();
            posManagerOperUserIn.setErpCode(cacheModel.getOrder().getErpCode());
            posManagerOperUserIn.setCardNo(in.getAccreditNo());
            posManagerOperUserIn.setShopCode(in.getShopCode());
            RespBase response = this.functionRemoteService.getOperUser(session, posManagerOperUserIn);
            if ("0".equals(response.getRetflag())) {
                OperUserOut posManagerOperUserOut = (OperUserOut)response.getData();
                if (posManagerOperUserOut.getOperuser() == null || posManagerOperUserOut.getPosrole() == null) {
                    return Code.CODE_60066.getRespBase(new Object[0]);
                }
                OperUser operUser = new OperUser(posManagerOperUserOut);
                cacheModel.setCurGrant(operUser);
                if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
                    if (!posManagerOperUserOut.getPosrole().getPrivth().equals("Y") && !posManagerOperUserOut.getPosrole().getPrivth().equals("T")) {
                        return Code.CODE_60048.getRespBase(new Object[0]);
                    }
                    cacheModel.getOrder().setRefundAuthzCardNo(operUser.getGh());
                }
            } else {
                return Code.CODE_60067.getRespBase(new Object[0]);
            }
        }
        if (cacheModel.getPayments().size() > 0) {
            for (Payment p : cacheModel.getPayments()) {
                p.setTerminalSno(terminalSno);
            }
        }
        if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
            log.info("\u5355\u884c\u8ba1\u7b97\u524d\u8ba2\u5355==>{}", (Object)JSONObject.toJSONString((Object)cacheModel.getGoodsList()));
            double tempZZk = cacheModel.getOrder().getTempZzk();
            double tempZZr = cacheModel.getOrder().getTempZzr();
            double discAmount = cacheModel.getOrder().getDiscAmount();
            double temporaryDiscAmount = cacheModel.getOrder().getTemporaryDiscAmount();
            log.info("\u539f\u5355\u6298\u6263==\u300btempZZk:{},tempZZr:{},discAmount:{}", new Object[]{tempZZk, tempZZr, discAmount});
            cacheModel.getOrder().setTempZzk(0.0);
            cacheModel.getOrder().setTempZzr(0.0);
            cacheModel.getOrder().setDiscAmount(0.0);
            cacheModel.callMarketClear();
            cacheModel.getOrder().setSeqNo(null);
            vo.setCacheModel(cacheModel);
            if (cacheModel.getPopMode() == 1) {
                log.info("\u89e3\u6302\u540e\u5355\u884c\u8ba1\u7b97");
                RespBase respBase = null;
                try {
                    respBase = this.calcPopRemoteService.calcSinglePopAfterVipService(session, vo, true);
                    if (0 == respBase.getRetflag()) {
                        cacheModel = ((ResqVo)respBase.getData()).getCacheModel();
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                    log.info("\u4f1a\u5458\u8c03\u7528\u5355\u884c\u8ba1\u7b97\u5f02\u5e38:" + e);
                }
                log.info("\u5355\u884c\u8ba1\u7b97\u540e\u8ba2\u5355==>{}", (Object)JSONObject.toJSONString((Object)cacheModel.getGoodsList()));
            } else if (cacheModel.getPopMode() == 2) {
                log.info("\u89e3\u6302\u540e\u6574\u5355\u8ba1\u7b97");
                String calcMode = "0";
                cacheModel = this.calcOrderPop(session, calcMode, cacheModel, vo, cacheModel.getLimitedPayCodes());
            } else {
                this.posLogicCompoment.calcOrderAmount(cacheModel);
            }
            log.info("\u5355\u884c\u540eTempZZk:" + tempZZk + "\uff0cTempZZr:" + tempZZr + "\uff0cdiscAmount:" + discAmount);
            if (tempZZk != 0.0) {
                log.info("\u6574\u5355\u6298\u6263\u8ba1\u7b97");
                cacheModel = this.posLogicCompoment.calcOrderRebateByRate(cacheModel, cacheModel.getCurGrant().getGh(), tempZZk);
                if (discAmount != 0.0) {
                    cacheModel = this.posLogicCompoment.calcOrderRebateByAmountMode1(cacheModel, cacheModel.getCurGrant().getGh(), discAmount);
                } else {
                    if (2 == cacheModel.getOrder().getSysPara().getAdjustMode()) {
                        tempZZr = temporaryDiscAmount;
                    }
                    cacheModel = this.posLogicCompoment.calcOrderRebateByAmount(cacheModel, cacheModel.getCurGrant().getGh(), tempZZr);
                }
            } else if (tempZZr != 0.0) {
                log.info("\u6574\u5355\u6298\u8ba9\u8ba1\u7b97");
                cacheModel = discAmount != 0.0 ? this.posLogicCompoment.calcOrderRebateByAmountMode1(cacheModel, cacheModel.getCurGrant().getGh(), discAmount) : this.posLogicCompoment.calcOrderRebateByAmount(cacheModel, cacheModel.getCurGrant().getGh(), tempZZr);
            }
            log.info("\u8ba1\u7b97\u540e==tempZZk\uff1a{}\uff0ctempZZr\uff1a{}", (Object)cacheModel.getOrder().getTempZzk(), (Object)cacheModel.getOrder().getTempZzr());
        }
        vo.setCacheModel(cacheModel);
        return new RespBase(Code.SUCCESS, (Object)vo, "CHANGEORDERFPHM");
    }

    public CacheModel TransferCacheModelForReturn(SaleOrders orderQueryOut, SaleReturnQueryIn saleReturnQueryIn, CacheModel cacheModel, List<String> unDisOrderPayCodes, boolean isHc) {
        ArrayList<Goods> goodslist = new ArrayList<Goods>();
        for (SaleOrderDetailModel saleDetail : orderQueryOut.getSaleOrderDetail()) {
            if (!isHc && saleDetail.getGoodsFlag().equals("0")) continue;
            goodslist.add(this.goodsTransfer.transferGoods2(saleDetail));
        }
        cacheModel.setReturnPayments(this.paymentTransfer.transferPayment3(orderQueryOut.getSaleOrderPay()));
        String orderType = "4";
        Date saleDate = orderQueryOut.getSaleOrders().getSaleDate();
        Date nowDate = TimeZoneUtil.ConvertTimeByTimeZone((Date)new Date(), (String)cacheModel.getOrder().getTimeZone(), (Boolean)this.localcache);
        if (cacheModel.getOrder().getOrderType().equals("2")) {
            if (saleDate.before(nowDate)) {
                orderType = "4";
            } else {
                orderType = "2";
                List payments = cacheModel.getReturnPayments();
                boolean unDis = true;
                block1: for (Payment payment : payments) {
                    for (String paycode : unDisOrderPayCodes) {
                        if (!paycode.equals(payment.getPayCode())) continue;
                        unDis = false;
                        continue block1;
                    }
                }
                if (!unDis) {
                    orderType = "4";
                }
            }
        }
        if (orderQueryOut.getSaleOrders().getSheetTypeCode().equals("Y1")) {
            orderType = "Y2";
        } else if ("4".equals(orderType) && "Z1".equals(orderQueryOut.getSaleOrders().getSheetTypeCode())) {
            orderType = "Z2";
        }
        cacheModel.setOrder(this.orderTransfer.transferRetrunOrder(orderQueryOut, cacheModel.getOrder(), orderType));
        log.info("\u8f6c\u6362popDetail\u524d orderType=[{}]", (Object)orderType);
        if ("2".equals(orderType) && null != orderQueryOut.getSaleOrderDetailPop() && orderQueryOut.getSaleOrderDetailPop().size() > 0) {
            for (SaleOrderDetailPopModel orderPop : orderQueryOut.getSaleOrderDetailPop()) {
                int rowNo = orderPop.getRowNo() - 1;
                if (goodslist.size() < rowNo + 1) continue;
                ((Goods)goodslist.get(rowNo)).getPopDetailsInfo().add(this.popdetailTransfer.transferPopDetail(orderPop));
            }
        }
        cacheModel.setReturnGoodsList(goodslist);
        return cacheModel;
    }

    public CacheModel TransferCacheModelForReturn(SaleOrders_WSLF orderQueryOut, CacheModel cacheModel, boolean isHc) {
        Double totalQty = 0.0;
        ArrayList<Goods> goodslist = new ArrayList<Goods>();
        for (OrdersDetailModel saleDetail : orderQueryOut.getOrdersDetail()) {
            if (!isHc && "0".equals(saleDetail.getGoodsFlag()) || !isHc && "97".equals(saleDetail.getGoodType())) continue;
            totalQty = saleDetail.getWeighGood() != false && !this.posLogicCompoment.checkEscaleEditFlagForDetail((JSONObject)JSON.toJSON((Object)saleDetail)) ? Double.valueOf(totalQty + 1.0) : Double.valueOf(totalQty + saleDetail.getQty());
            goodslist.add(this.goodsTransfer.transferGoods2(saleDetail));
        }
        cacheModel.getOrder().setQty(totalQty.intValue());
        cacheModel.setReturnPayments(PaymentUtil.transferPayment((List)orderQueryOut.getOrdersPay()));
        String orderType = "4";
        try {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            Date saleDate = orderQueryOut.getOrders().getSaleDate();
            String billDate = this.computeBillDate(new Date());
            Date nowDate = TypeUtils.castToDate((Object)(billDate + BILL_END_TIME));
            if (cacheModel.getOrder().getOrderType().equals("2")) {
                if (saleDate.before(nowDate)) {
                    orderType = "4";
                } else {
                    orderType = "2";
                    List payments = cacheModel.getReturnPayments();
                    boolean unDis = true;
                    if (null != cacheModel.getOrder().getSysPara().getNoVoidPaymentCodes() && !cacheModel.getOrder().getSysPara().getNoVoidPaymentCodes().isEmpty()) {
                        for (Payment payment : payments) {
                            if (cacheModel.getOrder().getSysPara().getNoVoidPaymentCodes().indexOf(payment.getPayCode()) == -1) continue;
                            unDis = false;
                            break;
                        }
                    }
                    if (!unDis) {
                        orderType = "4";
                    }
                }
            }
            if (orderQueryOut.getOrders().getOrderType().equals("Y1")) {
                orderType = "Y2";
            }
            if (orderQueryOut.getOrders().getOrderType().equals("h")) {
                orderType = "i";
            } else if ("4".equals(orderType) && "Z1".equals(orderQueryOut.getOrders().getOrderType())) {
                orderType = "Z2";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        cacheModel.setOrder(this.orderTransfer.transferRetrunOrder(orderQueryOut, cacheModel.getOrder(), orderType));
        double gainPoints = 0.0;
        if ("2".equals(cacheModel.getOrder().getOrderType()) && orderQueryOut.getOrdersGainDetail() != null && !orderQueryOut.getOrdersGainDetail().isEmpty()) {
            List orderGainDetails = orderQueryOut.getOrdersGainDetail();
            for (int i = 0; i < orderGainDetails.size(); ++i) {
                OrdersGainDetailModel ordersGainDetailModel = (OrdersGainDetailModel)orderGainDetails.get(i);
                if ("01".equals(ordersGainDetailModel.getCouponGroup())) {
                    gainPoints = ManipulatePrecision.add((double)gainPoints, (double)ordersGainDetailModel.getAmount().doubleValue());
                }
                for (int j = 0; j < goodslist.size(); ++j) {
                    Goods goods = (Goods)goodslist.get(j);
                    if (goods.getFlowId() != ordersGainDetailModel.getRowNo().intValue()) continue;
                    if (goods.getCouponGains() == null) {
                        goods.setCouponGains(new ArrayList());
                    }
                    goods.getCouponGains().add(this.goodsTransfer.transferCouponGain(ordersGainDetailModel));
                }
            }
            if (null != orderQueryOut.getOrdersMember() && StringUtils.isNotBlank((String)orderQueryOut.getOrdersMember().getCid()) && null != orderQueryOut.getOrdersMember().getThisTimeGivePoint()) {
                cacheModel.getOrder().setThisTimePoint(-1.0 * orderQueryOut.getOrdersMember().getThisTimeGivePoint());
            }
        }
        if ("2".equals(orderType) && null != orderQueryOut.getOrdersDetailPop() && orderQueryOut.getOrdersDetailPop().size() > 0) {
            for (OrdersDetailPopModel orderPop : orderQueryOut.getOrdersDetailPop()) {
                int rowNo = orderPop.getRowNo() - 1;
                if (goodslist.size() < rowNo + 1) continue;
                ((Goods)goodslist.get(rowNo)).getPopDetailsInfo().add(this.popdetailTransfer.transferPopDetail(orderPop));
            }
            for (int i = 0; i < goodslist.size(); ++i) {
                Goods goods = (Goods)goodslist.get(i);
                if (!"97".equals(goods.getGoodsType())) continue;
                goodslist.remove(i);
                --i;
            }
        }
        log.info("popdetail\u884c\u6570\uff1a" + ((Goods)goodslist.get(0)).getPopDetailsInfo().size());
        if (null != orderQueryOut.getOrdersUseCoupon() && orderQueryOut.getOrdersUseCoupon().size() > 0) {
            for (OrdersDetailPopModel orderPop : orderQueryOut.getOrdersUseCoupon()) {
                int rowNo = orderPop.getRowNo() - 1;
                if (goodslist.size() < rowNo + 1) continue;
                ((Goods)goodslist.get(rowNo)).getCouponUses().add(this.couponTransfer.transferCouponUse3((OrdersUseCouponModel)orderPop, cacheModel.getOrder()));
            }
        }
        cacheModel.setReturnGoodsList(goodslist);
        return cacheModel;
    }

    protected CacheModel saveSaleReturnOrder(CacheModel cacheModel, ServiceSession session, String newTerminalSno, String splitCode, String netType) {
        com.product.model.ServiceResponse response = null;
        RespBase sp = null;
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        boolean trainingMode = modeDetailsVo.isTrainingMode();
        if (!(trainingMode || cacheModel.getPopMode() != 1 && cacheModel.getPopMode() != 2)) {
            if (!"2".equals(cacheModel.getOrder().getOrderType())) {
                RespBase respBase;
                if (cacheModel.getPayConfirmStatus() != 0 && (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2)) {
                    response = this.couponConsume(cacheModel, session, cacheModel.getPayConfirmStatus(), netType);
                    if (null == response.getData() || "".equals(response.getData().toString())) {
                        cacheModel.setCalcResult(-1);
                        cacheModel.setErrCode(response.getReturncode());
                        cacheModel.setErrMsg(response.getData().toString());
                        return cacheModel;
                    }
                    if (!"0".equals(response.getReturncode())) {
                        cacheModel.setCalcResult(-1);
                        cacheModel.setErrCode(response.getReturncode());
                        cacheModel.setErrMsg(response.getData().toString());
                        return cacheModel;
                    }
                }
                log.info("\u51b2\u6b63\u540e\u7684cacheResult{} ,errCode{} ,errmsg{} ,", new Object[]{cacheModel.getCalcResult(), cacheModel.getErrCode(), cacheModel.getErrMsg()});
                CouponuseConsumeIn couponuseConsumeIn = new CouponuseConsumeIn();
                couponuseConsumeIn.setBillno(cacheModel.getOrder().getFlowNo());
                couponuseConsumeIn.setCalcBillId(cacheModel.getOrder().getSeqNo());
                couponuseConsumeIn.setChannel(cacheModel.getOrder().getChannel());
                List couponPayments = this.posLogicCompoment.getCouponPayments(cacheModel.getPayments());
                if (couponPayments != null && couponPayments.size() != 0) {
                    couponuseConsumeIn.setSellPayments(this.paymentTransfer.transferSellPayment(couponPayments, SellType.ISBACK((String)cacheModel.getOrder().getOrderType())));
                    couponuseConsumeIn.setType("0");
                    cacheModel.callMarketClear();
                    respBase = this.couponRemoteService.couponAndPointsConsume(session, cacheModel, couponuseConsumeIn, netType);
                    if (0 != respBase.getRetflag()) {
                        List reversePayments = couponuseConsumeIn.getSellPayments();
                        cacheModel.setReversePayments(reversePayments);
                        response = this.couponConsume(cacheModel, session, 5, netType);
                        cacheModel.setCalcResult(-1);
                        cacheModel.setErrCode(response.getReturncode());
                        if (null == response.getData() || "".equals(response.getData().toString())) {
                            cacheModel.setErrMsg(response.getData().toString());
                        } else {
                            cacheModel.setErrMsg(response.getData().toString());
                        }
                        return cacheModel;
                    }
                }
                log.info("\u6838\u9500\u540e\u7684cacheResult{} ,errCode{} ,errmsg{} ,", new Object[]{cacheModel.getCalcResult(), cacheModel.getErrCode(), cacheModel.getErrMsg()});
                if (StringUtils.isNotBlank((String)cacheModel.getOrder().getOriginSeqNo()) && !SellType.isGroupbuy((String)cacheModel.getOrder().getOrderType(), (boolean)cacheModel.getOrder().getHasGroupBuy()) && (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3) && (cacheModel = (CacheModel)(respBase = this.calcPopRemoteService.calcCouponGain(session, cacheModel, netType, newTerminalSno)).getData()).getCalcResult() == -1) {
                    return cacheModel;
                }
            } else if ((cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2) && (cacheModel = this.cancelOrder(session, cacheModel, netType, newTerminalSno)).getCalcResult() == -1) {
                return cacheModel;
            }
        }
        String orgTerminalSno = cacheModel.getOrder().getTerminalSno();
        if (null != newTerminalSno && newTerminalSno.length() > 0) {
            cacheModel = this.posLogicService.RefreshTerminalSno(cacheModel, newTerminalSno);
        }
        SaleOrders order = this.orderTransfer.saleOrdersFromCacheModel(cacheModel);
        if (null != splitCode && !"".equals(splitCode)) {
            order.getSaleOrders().setShardingCode(splitCode);
        }
        order.getSaleOrders().setOrderState(Integer.valueOf(OrderStateEnum.T_YWC.getCode()));
        sp = this.orderPosUploadService.receiveOrderUpload(session, order, netType);
        SaveOrdersOut saveOrdersOut = null;
        String sheetNo = "";
        if (!"0".equals(String.valueOf(sp.getRetflag())) && !"1".equals(String.valueOf(sp.getRetflag()))) {
            if ("101".equals(String.valueOf(sp.getRetflag())) || "201".equals(String.valueOf(sp.getRetflag()))) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("2002");
                cacheModel.setErrMsg(cacheModel.getOrder().getTerminalSno());
                try {
                    saveOrdersOut = (SaveOrdersOut)JSON.parseObject((String)sp.getData().toString(), SaveOrdersOut.class);
                    String terminalSno = saveOrdersOut.getTerminalSno();
                    String serviceSno = "";
                    com.product.model.ServiceResponse sNoResponse = new com.product.model.ServiceResponse();
                    if (StringUtils.isNotBlank((String)terminalSno)) {
                        serviceSno = terminalSno;
                        sNoResponse.setReturncode("2002");
                        sNoResponse.setData((Object)serviceSno);
                        this.couponConsume(cacheModel, session, 8, netType);
                        cacheModel.setCalcResult(-1);
                        cacheModel.setErrCode("2002");
                        cacheModel.setErrMsg(serviceSno);
                    }
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
                return cacheModel;
            }
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("100000");
            cacheModel.setErrMsg(Code.CODE_60135.getMsg() + sp.getData().toString());
            return cacheModel;
        }
        saveOrdersOut = (SaveOrdersOut)JSON.parseObject((String)JSONObject.toJSONString((Object)sp.getData()), SaveOrdersOut.class);
        sheetNo = saveOrdersOut.getSheetNo();
        Order o = cacheModel.getOrder();
        if (this.excuteZuul(String.valueOf(sp.getRetflag()), sheetNo, o.getOrderType(), o.getTerminalSno(), o.getExistPay())) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode(String.valueOf(sp.getRetflag()));
            if (null == sp.getData() || "".equals(sp.getData().toString())) {
                cacheModel.setErrMsg(sp.getData().toString());
            } else {
                cacheModel.setErrMsg(sp.getData().toString());
            }
            return cacheModel;
        }
        cacheModel.getOrder().setSaveStatus(String.valueOf(sp.getRetflag()));
        cacheModel.getOrder().setSendSuccess(true);
        cacheModel.getOrder().setIdSheetNo(sheetNo);
        return cacheModel;
    }

    protected CacheModel saveOrder(CacheModel cacheModel, ServiceSession session, String newTerminalSno, String splitCode, String netType) {
        String obj;
        ModeDetailsVo modeDetailsVo;
        boolean trainingMode;
        RespBase respBase;
        com.product.model.ServiceResponse response = null;
        log.info("cacheModel.getPayConfirmStatus[{}],cacheModel.getPopMode[{}]", (Object)cacheModel.getPayConfirmStatus(), (Object)cacheModel.getPopMode());
        if (null != cacheModel.getPayConfirmStatus() && cacheModel.getPayConfirmStatus() != 0 && (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3)) {
            response = this.couponConsume(cacheModel, session, cacheModel.getPayConfirmStatus(), netType);
            if ("0".equals(response.getReturncode())) {
                cacheModel.setErrMsg(Code.CODE_60136.getMsg());
            } else {
                cacheModel.setErrMsg(Code.CODE_60137.getMsg());
            }
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode(String.valueOf(Code.CODE_60025.getIndex()));
            return cacheModel;
        }
        log.info("\u8c03\u7528\u5238\u51b2\u6b63\u5b8c\u6bd5");
        List couponPayments = this.posLogicCompoment.getCouponPayments(cacheModel.getPayments());
        if (couponPayments != null && couponPayments.size() != 0) {
            if (cacheModel.getPayConfirmStatus() == 0 && (cacheModel.getPopMode() == 1 || cacheModel.getPopMode() == 2 || cacheModel.getPopMode() == 3)) {
                respBase = new RespBase();
                try {
                    respBase = this.couponRemoteService.couponuseConsumeForPay(session, cacheModel, netType);
                    cacheModel = ((ResqVo)respBase.getData()).getCacheModel();
                }
                catch (Exception e) {
                    log.error("\u8425\u9500\u5238\u6838\u9500\u5931\u8d25\uff1a" + e.getMessage(), (Throwable)e);
                }
            }
            log.info("\u8425\u9500\u5238\u6838\u9500\u5b8c\u6bd5");
        }
        if (cacheModel.getCalcResult() == -1) {
            return cacheModel;
        }
        if (null != cacheModel.getOrder().getConsumersData() && "MOHO".equals(cacheModel.getOrder().getConsumersData().getConsumersType())) {
            if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType())) {
                log.info("\u6d77\u9f0e\u5238\u6838\u9500\u5f00\u59cb");
                RespBase resp = this.couponRemoteService.consumeOrderCoupon(session, cacheModel);
                if (0 != resp.getRetflag()) {
                    throw new EfutureException(resp);
                }
            }
            if (0 != (respBase = this.calcPopRemoteService.saveTrade(session, cacheModel)).getRetflag()) {
                log.info("\u6d77\u9f0e\u8ba2\u5355\u4e0a\u9001\u5931\u8d25==>{}", (Object)JSONObject.toJSONString((Object)respBase));
                throw new EfutureException(respBase);
            }
        }
        if (!((trainingMode = (modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)(obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo())), ModeDetailsVo.class)).isTrainingMode()) || SellType.NOPOP((String)cacheModel.getOrder().getOrderType()) || cacheModel.getPopMode() != 1 && cacheModel.getPopMode() != 2 && cacheModel.getPopMode() != 3)) {
            long popstart = System.currentTimeMillis();
            log.info("saveOrder\u8bf7\u6c42\u8425\u9500\u5f00\u59cb====");
            RespBase respBase2 = this.calcPopRemoteService.calcCouponGain(session, cacheModel, netType, newTerminalSno);
            if (0 != respBase2.getRetflag()) {
                cacheModel.setCalcResult(-1);
                cacheModel.setErrMsg("calcCouponGain\uff1a" + respBase2.getRetmsg());
                return cacheModel;
            }
            long popend = System.currentTimeMillis();
            log.info("saveOrder\u8bf7\u6c42\u8425\u9500\u8017\u65f6====" + (popend - popstart) + "\u6beb\u79d2");
            cacheModel = (CacheModel)respBase2.getData();
        }
        log.info("\u8425\u9500\u4fdd\u5b58\u5b8c\u6bd511111");
        RespBase respBaseBeforSaveSaleOrder = this.beforSaveSaleOrder(session, cacheModel, netType, newTerminalSno);
        if (Code.SUCCESS.getIndex() != respBaseBeforSaveSaleOrder.getRetflag()) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrMsg("beforSaveSaleOrder\uff1a" + respBaseBeforSaveSaleOrder.getRetmsg());
            return cacheModel;
        }
        if (StringUtils.isNotBlank((String)newTerminalSno)) {
            cacheModel = this.RefreshTerminalSno(cacheModel, newTerminalSno);
            log.info("\u8df3\u53f7\u5904\u7406\u5b8c\u6bd5");
        }
        if (null != cacheModel.getOrder().getConsumersData() && StringUtils.isNotBlank((String)cacheModel.getOrder().getConsumersData().getConsumersId())) {
            log.info("\u7d2f\u8ba1\u79ef\u5206\u8ba1\u7b97");
            cacheModel.getOrder().setTotalPoint(ManipulatePrecision.doubleConvert((double)(cacheModel.getOrder().getTotalPoint() - cacheModel.getOrder().getThisTimeUsedPoint() + cacheModel.getOrder().getThisTimePoint())));
        }
        if ((cacheModel = this.saveSaleOrder(cacheModel, session, splitCode, netType)).getCalcResult() == -1) {
            return cacheModel;
        }
        return cacheModel;
    }

    protected CacheModel addAdjustPopDetail(CacheModel cacheModel) {
        if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType()) || null == cacheModel.getOrder().getOriginIdSheetNo() || cacheModel.getOrder().getOriginIdSheetNo().equals("")) {
            for (Goods goods : cacheModel.getGoodsList()) {
                if (null == goods.getPopDetailsInfo()) {
                    goods.setPopDetailsInfo(new ArrayList());
                } else {
                    for (int i = 0; i < goods.getPopDetailsInfo().size(); ++i) {
                        PopDetail pop = (PopDetail)goods.getPopDetailsInfo().get(i);
                        if (!YPopStatusType.pop_policy_group_grant_order.equals(pop.getPopPolicyGroup()) && !YPopStatusType.pop_policy_group_grant_goods.equals(pop.getPopPolicyGroup()) && !YPopStatusType.pop_policy_group_aeoncoupon.equals(pop.getPopPolicyGroup())) continue;
                        goods.getPopDetailsInfo().remove(pop);
                        --i;
                    }
                }
                if (ManipulatePrecision.doubleCompare((double)goods.getTempZzkDiscount(), (double)0.0, (int)2) > 0) {
                    PopDetail popDetail = new PopDetail();
                    popDetail.setPopEventBillId("0");
                    popDetail.setDiscountAmount(ManipulatePrecision.doubleConvert((double)goods.getTempZzkDiscount(), (int)6, (int)1));
                    popDetail.setPopMode("0");
                    popDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_order);
                    popDetail.setPopDescribe("[" + cacheModel.getOrder().getSysPara().getZpRateDes() + cacheModel.getOrder().getTempZzk() + "%]");
                    popDetail.setPopMemo("PRE:0");
                    if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                        popDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdzkfd:" + goods.getFdzkfd());
                    }
                    popDetail.setPopPolicyType(YPopStatusType.pop_type_order);
                    popDetail.setGoodsRow((long)goods.getFlowId());
                    goods.getPopDetailsInfo().add(popDetail);
                }
                if (ManipulatePrecision.doubleCompare((double)goods.getTempZzrDiscount(), (double)0.0, (int)2) > 0) {
                    PopDetail popDetail = new PopDetail();
                    popDetail.setPopEventBillId("0");
                    popDetail.setDiscountAmount(ManipulatePrecision.doubleConvert((double)goods.getTempZzrDiscount(), (int)6, (int)1));
                    popDetail.setPopMode("0");
                    popDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_order);
                    popDetail.setPopDescribe("[" + cacheModel.getOrder().getSysPara().getZpAmountDes() + "]");
                    popDetail.setPopMemo("PRE:0");
                    if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                        popDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdzkfd:" + goods.getFdzkfd());
                    }
                    popDetail.setPopPolicyType(YPopStatusType.pop_type_order);
                    popDetail.setGoodsRow((long)goods.getFlowId());
                    goods.getPopDetailsInfo().add(popDetail);
                }
                if (ManipulatePrecision.doubleCompare((double)goods.getFixedDiscountValue(), (double)0.0, (int)2) > 0) {
                    PopDetail popDetail = new PopDetail();
                    popDetail.setPopEventBillId("0");
                    popDetail.setDiscountAmount(ManipulatePrecision.doubleConvert((double)goods.getFixedDiscountValue(), (int)6, (int)1));
                    popDetail.setPopMode("0");
                    popDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    popDetail.setPopPolicyType(YPopStatusType.pop_type_goods);
                    popDetail.setPopDescribe("[" + cacheModel.getOrder().getSysPara().getDpAmountDes() + "]");
                    popDetail.setPopMemo("PRE:0");
                    if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                        popDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdresult:" + goods.getFdresult() + ",popzkfd:" + goods.getPopzkfd());
                    }
                    popDetail.setGoodsRow((long)goods.getFlowId());
                    goods.getPopDetailsInfo().add(popDetail);
                }
                if (ManipulatePrecision.doubleCompare((double)goods.getDzcDiscountValue(), (double)0.0, (int)2) > 0) {
                    PopDetail popDetail = new PopDetail();
                    popDetail.setPopEventBillId("0");
                    popDetail.setDiscountAmount(ManipulatePrecision.doubleConvert((double)goods.getDzcDiscountValue(), (int)6, (int)1));
                    popDetail.setPopMode("0");
                    popDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    popDetail.setPopPolicyType(YPopStatusType.pop_type_goods);
                    popDetail.setPopDescribe("[" + cacheModel.getOrder().getSysPara().getDpAmountDes() + "]");
                    popDetail.setPopMemo("PRE:0");
                    if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                        popDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdresult:" + goods.getFdresult() + ",popzkfd:" + goods.getPopzkfd());
                    }
                    popDetail.setGoodsRow((long)goods.getFlowId());
                    goods.getPopDetailsInfo().add(popDetail);
                }
                if (ManipulatePrecision.doubleCompare((double)goods.getTempZkDiscount(), (double)0.0, (int)2) > 0) {
                    PopDetail popDetail = new PopDetail();
                    popDetail.setPopEventBillId("0");
                    popDetail.setDiscountAmount(ManipulatePrecision.doubleConvert((double)goods.getTempZkDiscount(), (int)6, (int)1));
                    popDetail.setPopMode("0");
                    popDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    popDetail.setPopDescribe("[" + cacheModel.getOrder().getSysPara().getDpRateDes() + goods.getTempZkl() + "%]");
                    popDetail.setPopMemo("PRE:0");
                    if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                        popDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdzkfd:" + goods.getFdzkfd());
                    }
                    popDetail.setPopPolicyType(YPopStatusType.pop_type_goods);
                    popDetail.setGoodsRow((long)goods.getFlowId());
                    goods.getPopDetailsInfo().add(popDetail);
                }
                if (ManipulatePrecision.doubleCompare((double)goods.getTempZrDiscount(), (double)0.0, (int)2) > 0) {
                    PopDetail popDetail = new PopDetail();
                    popDetail.setPopEventBillId("0");
                    popDetail.setDiscountAmount(ManipulatePrecision.doubleConvert((double)goods.getTempZrDiscount(), (int)6, (int)1));
                    popDetail.setPopMode("0");
                    popDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    popDetail.setPopDescribe("[" + cacheModel.getOrder().getSysPara().getDpAmountDes() + "]");
                    popDetail.setPopMemo("PRE:0");
                    if (StringUtils.isNotBlank((String)goods.getFdmode())) {
                        popDetail.setPopMemo("fdmode:" + goods.getFdmode() + ",fdzkfd:" + goods.getFdzkfd());
                    }
                    popDetail.setPopPolicyType(YPopStatusType.pop_type_goods);
                    popDetail.setGoodsRow((long)goods.getFlowId());
                    goods.getPopDetailsInfo().add(popDetail);
                }
                if (goods.getCustomDiscountValue() > 0.0) {
                    PopDetail popDetail = new PopDetail();
                    popDetail.setPopEventBillId("0");
                    popDetail.setDiscountAmount(ManipulatePrecision.doubleConvert((double)goods.getCustomDiscountValue(), (int)6, (int)1));
                    popDetail.setPopMode("0");
                    popDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    popDetail.setPopPolicyType(YPopStatusType.pop_ghcard_goods);
                    popDetail.setPopMemo("PRE:0");
                    popDetail.setGoodsRow((long)goods.getFlowId());
                    popDetail.setPopDescribe("\u5de5\u4f1a\u6298\u6263");
                    goods.getPopDetailsInfo().add(popDetail);
                }
                if (goods.getMealDiscountValue() > 0.0) {
                    PopDetail popDetail = new PopDetail();
                    popDetail.setPopEventBillId("0");
                    popDetail.setDiscountAmount(ManipulatePrecision.doubleConvert((double)goods.getMealDiscountValue(), (int)6, (int)1));
                    popDetail.setPopMode("0");
                    popDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_grant_goods);
                    popDetail.setPopMemo("PRE:1");
                    popDetail.setGoodsRow((long)goods.getFlowId());
                    goods.getPopDetailsInfo().add(popDetail);
                }
                if (!(goods.getStudentCardDiscountValue() > 0.0)) continue;
                PopDetail popDetail = new PopDetail();
                popDetail.setPopEventBillId("0");
                popDetail.setDiscountAmount(ManipulatePrecision.doubleConvert((double)goods.getStudentCardDiscountValue(), (int)6, (int)1));
                popDetail.setPopMode("0");
                popDetail.setPopPolicyGroup(YPopStatusType.pop_policy_group_aeoncoupon);
                popDetail.setPopDescribe("[" + cacheModel.getOrder().getSysPara().getXzkDes() + goods.getStudentCardDiscountValue() + "$]");
                popDetail.setPopMemo("PRE:1");
                popDetail.setGoodsRow((long)goods.getFlowId());
                goods.getPopDetailsInfo().add(popDetail);
            }
        }
        return cacheModel;
    }

    protected CacheModel saveSaleOrder(CacheModel cacheModel, ServiceSession session, String splitCode, String netType) {
        log.info("saveSaleOrder");
        RespBase response = new RespBase();
        cacheModel.getOrder().setPayState(2);
        cacheModel.getOrder().setOrderState(7);
        SaleOrders order = this.orderTransfer.saleOrdersFromCacheModel(cacheModel);
        if (null != splitCode && !"".equals(splitCode)) {
            order.getSaleOrders().setShardingCode(splitCode);
        }
        CouponuseConsumeIn couponuseConsumeIn = new CouponuseConsumeIn();
        couponuseConsumeIn.setBillno(cacheModel.getOrder().getFlowNo());
        couponuseConsumeIn.setCalcBillId(cacheModel.getOrder().getSeqNo());
        couponuseConsumeIn.setType("0");
        couponuseConsumeIn.setSaveorder("N");
        couponuseConsumeIn.setChannel(cacheModel.getOrder().getChannel());
        if (SellType.ISEXERCISE((String)cacheModel.getOrder().getOrderType())) {
            order.getSaleOrders().setSheetTypeCode("1");
        }
        if (!SellType.ISEXERCISE((String)cacheModel.getOrder().getOrderType())) {
            this.allVpayRemoteService.saleSubmit(cacheModel, null, session);
        }
        response = this.orderPosUploadService.receiveOrderUpload(session, order, netType);
        SaveOrdersOut saveOrdersOut = null;
        String sheetNo = "";
        if (!"0".equals(String.valueOf(response.getRetflag())) && !"1".equals(String.valueOf(response.getRetflag()))) {
            if ("101".equals(String.valueOf(response.getRetflag())) || "201".equals(String.valueOf(response.getRetflag()))) {
                saveOrdersOut = (SaveOrdersOut)JSON.parseObject((String)response.getData().toString(), SaveOrdersOut.class);
                String terminalSno = saveOrdersOut.getTerminalSno();
                log.info("\u5c0f\u7968\u53f7terminalSno\uff1a" + terminalSno);
                String serviceSno = "";
                com.product.model.ServiceResponse sNoResponse = new com.product.model.ServiceResponse();
                sNoResponse.setReturncode("2002");
                sNoResponse.setData((Object)cacheModel.getOrder().getTerminalSno());
                cacheModel.setErrMsg(cacheModel.getOrder().getTerminalSno());
                if (StringUtils.isNotBlank((String)terminalSno)) {
                    serviceSno = terminalSno;
                    sNoResponse.setData((Object)serviceSno);
                    cacheModel.setErrMsg(serviceSno);
                }
                cacheModel.setCalcResult(-1);
                cacheModel.setErrCode("2002");
                return cacheModel;
            }
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode("60139");
            cacheModel.setErrMsg(String.valueOf(response.getData()));
            return cacheModel;
        }
        saveOrdersOut = (SaveOrdersOut)JSON.parseObject((String)JSONObject.toJSONString((Object)response.getData()), SaveOrdersOut.class);
        sheetNo = saveOrdersOut.getSheetNo();
        Order o = cacheModel.getOrder();
        if (this.excuteZuul(String.valueOf(response.getRetflag()), sheetNo, o.getOrderType(), o.getTerminalSno(), o.getExistPay())) {
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode(String.valueOf(response.getRetflag()));
            if (null == response.getData() || "".equals(response.getData().toString())) {
                cacheModel.setErrMsg(response.getData().toString());
            } else {
                cacheModel.setErrMsg(response.getData().toString());
            }
            return cacheModel;
        }
        cacheModel.getOrder().setSaveStatus(String.valueOf(response.getRetflag()));
        cacheModel.getOrder().setSendSuccess(true);
        cacheModel.getOrder().setIdSheetNo(sheetNo);
        return cacheModel;
    }

    public List<Payment> getCouponPayments(List<Payment> payments) {
        if (null == payments || payments.size() == 0) {
            return null;
        }
        ArrayList<Payment> list = new ArrayList<Payment>();
        for (Payment payment : payments) {
            if (!"Y".equalsIgnoreCase(payment.getIsCoupon())) continue;
            list.add(payment);
        }
        return list;
    }

    protected com.product.model.ServiceResponse couponConsume(CacheModel cacheModel, ServiceSession session, int payConfirmStatus, String netType) {
        RespBase respBase = new RespBase();
        try {
            respBase = this.couponRemoteService.couponConsume(session, cacheModel, payConfirmStatus, netType);
            log.info("\u5238\u51b2\u6b63\u8fd4\u56de" + JSON.toJSONString((Object)respBase));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        if (respBase.getRetflag() != 0) {
            return com.product.model.ServiceResponse.buildFailure((ServiceSession)session, (String)"10003", (String)"\u60e0go\u5238\u51b2\u6b63\u6570\u636e\u5f02\u5e38");
        }
        com.product.model.ServiceResponse response = (com.product.model.ServiceResponse)JSONObject.parseObject((String)((ResqVo)respBase.getData()).getJsonObject().toJSONString(), com.product.model.ServiceResponse.class);
        log.info("\u5238\u51b2\u6b63\u8fd4\u56de1  response\uff1a" + JSON.toJSONString((Object)response));
        return response;
    }

    protected double getRevenuePoint(CouponGainCalcOut couponGainCalcOut, Order order) {
        double memberPoints = 0.0;
        List sellCoupons = null;
        sellCoupons = SellType.ISBACK((String)order.getOrderType()) ? couponGainCalcOut.getBillDetail().getCouponGains() : couponGainCalcOut.getCoupons();
        if (CollectionUtils.isNotEmpty((Collection)sellCoupons)) {
            for (SellCoupon sellCoupon : sellCoupons) {
                if (!"01".equals(sellCoupon.getCouponGroup())) continue;
                memberPoints = ManipulatePrecision.add((double)memberPoints, (double)sellCoupon.getAmount());
            }
        }
        return ManipulatePrecision.getDetailOverFlow((double)memberPoints, (String)"4");
    }

    public CacheModel RefreshTerminalSno(CacheModel cacheModel, String newTerminalSno) {
        return this.refreshTerminalSno(cacheModel, newTerminalSno);
    }

    public CacheModel refreshTerminalSno(CacheModel cacheModel, String newTerminalSno) {
        cacheModel.getOrder().setTerminalSno(newTerminalSno);
        if (cacheModel.getPayments().size() > 0) {
            for (Payment p : cacheModel.getPayments()) {
                p.setTerminalSno(newTerminalSno);
            }
        }
        return cacheModel;
    }

    public boolean excuteZuul(String returnCode, String orderNo, String type, String terminalSno, double existPay) {
        boolean reverseStata = false;
        switch (returnCode) {
            case "0": {
                break;
            }
            case "1": {
                String billDate = "";
                try {
                    SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                    billDate = sdf.format(new Date());
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.syncTradeService.addSyncTrade(orderNo, type, billDate, terminalSno, String.valueOf(existPay));
                break;
            }
            case "2": {
                reverseStata = true;
                break;
            }
            default: {
                reverseStata = true;
            }
        }
        return reverseStata;
    }

    public boolean checkOrder(CacheModel cacheModel) {
        Order saleOrder = cacheModel.getOrder();
        List payments = cacheModel.getPayments();
        if (saleOrder.getSaleValue() == 0.0) {
            saleOrder.setSaleValue(ManipulatePrecision.doubleConvert((double)(saleOrder.getOughtPay() + saleOrder.getTotalDiscountValue()), (int)2, (int)1));
        }
        if (payments.size() > 0 && ManipulatePrecision.doubleCompare((double)(saleOrder.getExistPay() - saleOrder.getChangeValue()), (double)(saleOrder.getOughtPay() + saleOrder.getOverageValue()), (int)2) != 0) {
            cacheModel.setErrMsg("\u4ea4\u6613\u4e3b\u5355\u6570\u636e\u76f8\u4e92\u4e0d\u5e73!\n\n\u5b9e\u9645\u4ed8\u6b3e - \u627e\u96f6  = " + ManipulatePrecision.doubleToString((double)(saleOrder.getExistPay() - saleOrder.getChangeValue())) + "\n\u5e94\u6536\u91d1\u989d + \u635f\u6ea2   = " + ManipulatePrecision.doubleToString((double)(saleOrder.getOughtPay() - saleOrder.getRoundUpOverageValue() + saleOrder.getOverageValue())));
            return false;
        }
        double amount = 0.0;
        double changeValue = 0.0;
        for (int i = 0; i < payments.size(); ++i) {
            Payment payment = (Payment)payments.get(i);
            if ("2".equals(payment.getFlag())) {
                changeValue += payment.getMoney();
                continue;
            }
            if ("3".equals(payment.getFlag())) continue;
            amount += payment.getMoney();
        }
        if (ManipulatePrecision.doubleCompare((double)this.calcOrderOughtPay(saleOrder.getExistPay(), saleOrder.getPrecisionMode()), (double)this.calcOrderOughtPay(amount, saleOrder.getPrecisionMode()), (int)2) != 0) {
            cacheModel.setErrMsg("\u4ea4\u6613\u4e3b\u5355\u548c\u4ed8\u6b3e\u660e\u7ec6\u4e0d\u5e73!\n\n\u4e3b\u5355\u5b9e\u9645\u4ed8\u6b3e = " + ManipulatePrecision.doubleToString((double)this.calcOrderOughtPay(saleOrder.getExistPay(), saleOrder.getPrecisionMode())) + "\n\u4ed8\u6b3e\u5408\u8ba1\u91d1\u989d  = " + ManipulatePrecision.doubleToString((double)this.calcOrderOughtPay(amount, saleOrder.getPrecisionMode())));
            return false;
        }
        return true;
    }

    public double calcOrderOughtPay(double OughtPay, String precisionMode) {
        double saleyfje = ManipulatePrecision.getDetailOverFlow((double)OughtPay, (String)precisionMode);
        return saleyfje;
    }

    @Override
    public RespBase changeOrderType(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        ChangeOrderTypeIn in = (ChangeOrderTypeIn)JSON.parseObject((String)paramsObject.toJSONString(), ChangeOrderTypeIn.class);
        ParamsValidateUtil paramsValidateUtil = new ParamsValidateUtil(session, paramsObject);
        if (!paramsValidateUtil.validate()) {
            return paramsValidateUtil.getRespBase();
        }
        if (StringUtils.isBlank((String)paramsObject.getString("orderType"))) {
            return new RespBase(-1, "\u4fee\u6539\u8ba2\u5355\u7c7b\u578b\u5fc5\u987b\u5305\u542b\u53c2\u6570[{0}]", "\u8ba2\u5355\u7c7b\u578b");
        }
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (!cacheModel.getOrder().getAllowEditGoods()) {
            return Code.CODE_60008.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return Code.CODE_60009.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getGoodsList().size() > 0) {
            return Code.CODE_60068.getRespBase(new Object[0]);
        }
        cacheModel.getOrder().setOrderType(in.getOrderType());
        OrderForPos ofp = this.orderTransfer.toOrderForPos(cacheModel);
        this.posLogicCompoment.calcOrderAmount(cacheModel);
        vo.setCacheModel(cacheModel);
        ofp.setSaleValue(0.0);
        ofp.setTotalDiscountValue(0.0);
        ofp.setOughtPay(0.0);
        BaseOutModel out = new BaseOutModel();
        out.setOrder(ofp);
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "PAYCERTIFY");
    }

    @Override
    public RespBase saveOrderInfoForCloud(ServiceSession session, JSONObject jsonObject) {
        log.info("saveOrderInfoForCloud:" + jsonObject.toJSONString());
        if (this.localcache.booleanValue() || this.hazelcast.booleanValue()) {
            return Code.CODE_60069.getRespBase(new Object[0]);
        }
        JSONObject result = new JSONObject();
        try {
            String obj;
            ModeDetailsVo modeDetailsVo;
            boolean trainingMode;
            SaleOrdersModel order = (SaleOrdersModel)JSON.parseObject((String)jsonObject.getJSONObject("saleOrders").toJSONString(), SaleOrdersModel.class);
            if (order == null) {
                return Code.CODE_60070.getRespBase(new Object[0]);
            }
            SaleOrders orders = (SaleOrders)JSONObject.parseObject((String)JSON.toJSONString((Object)jsonObject), SaleOrders.class);
            SaleOrdersModel saleOrders = orders.getSaleOrders();
            String timeZone = saleOrders.getTimeZone();
            saleOrders.setPayDate(TimeZoneUtil.ConvertTimeByTimeZone((Date)saleOrders.getPayDate(), (String)timeZone));
            saleOrders.setCreateDate(TimeZoneUtil.ConvertTimeByTimeZone((Date)saleOrders.getCreateDate(), (String)timeZone));
            orders.getSaleOrdersExt().setCreateDate(TimeZoneUtil.ConvertTimeByTimeZone((Date)orders.getSaleOrdersExt().getCreateDate(), (String)timeZone));
            String splitodevalue = null;
            log.info("order.getShardingCode()=============>" + order.getShardingCode());
            if (null == order.getShardingCode() || "".equals(order.getShardingCode())) {
                Iterator splitcode = "posshop:log:" + order.getSaleMarketCode();
                log.info("redis\u5206\u5e93\u7801key\u503c\uff1a" + (String)((Object)splitcode));
                if (this.redisUtil.hasKey((String)((Object)splitcode))) {
                    splitodevalue = (String)this.redisUtil.hget((String)((Object)splitcode), "splitCode");
                }
            }
            if (null != splitodevalue || StringUtils.isNotBlank((String)timeZone)) {
                if (null != orders.getSaleOrdersMember()) {
                    if (null != splitodevalue) {
                        orders.getSaleOrdersMember().setShardingCode(splitodevalue);
                    }
                    if (StringUtils.isNotBlank((String)timeZone)) {
                        orders.getSaleOrdersMember().setCreateDate(TimeZoneUtil.ConvertTimeByTimeZone((Date)orders.getSaleOrdersMember().getCreateDate(), (String)timeZone));
                    }
                }
                if (null != orders.getSaleOrderDetail()) {
                    for (SaleOrderDetailModel saleOrderDetailModel : orders.getSaleOrderDetail()) {
                        if (null != splitodevalue) {
                            saleOrderDetailModel.setShardingCode(splitodevalue);
                        }
                        if (!StringUtils.isNotBlank((String)timeZone)) continue;
                        saleOrderDetailModel.setCreateDate(TimeZoneUtil.ConvertTimeByTimeZone((Date)saleOrderDetailModel.getCreateDate(), (String)timeZone));
                    }
                }
                if (null != orders.getSaleOrderPay()) {
                    for (SaleOrderPayModel saleOrderPayModel : orders.getSaleOrderPay()) {
                        if (null != splitodevalue) {
                            saleOrderPayModel.setShardingCode(splitodevalue);
                        }
                        if (!StringUtils.isNotBlank((String)timeZone)) continue;
                        saleOrderPayModel.setCreateDate(TimeZoneUtil.ConvertTimeByTimeZone((Date)saleOrderPayModel.getCreateDate(), (String)timeZone));
                    }
                }
                if (null != splitodevalue) {
                    orders.getSaleOrders().setShardingCode(splitodevalue);
                    orders.getSaleOrdersExt().setShardingCode(splitodevalue);
                    if (null != orders.getMatchOriginDetail()) {
                        for (SaleOrderDetailModel saleOrderDetailModel : orders.getMatchOriginDetail()) {
                            saleOrderDetailModel.setShardingCode(splitodevalue);
                        }
                    }
                    if (null != orders.getSaleOrderDetailPop()) {
                        for (SaleOrderDetailPopModel saleOrderDetailPopModel : orders.getSaleOrderDetailPop()) {
                            saleOrderDetailPopModel.setShardingCode(splitodevalue);
                        }
                    }
                    if (null != orders.getSaleOrderUseCoupon()) {
                        for (SaleOrderUseCouponModel saleOrderUseCouponModel : orders.getSaleOrderUseCoupon()) {
                            saleOrderUseCouponModel.setShardingCode(splitodevalue);
                        }
                    }
                    if (null != orders.getSaleOrderGainDetail()) {
                        for (SaleOrderGainDetailModel saleOrderGainDetailModel : orders.getSaleOrderGainDetail()) {
                            saleOrderGainDetailModel.setShardingCode(splitodevalue);
                        }
                    }
                    if (null != orders.getSaleOrderGain()) {
                        for (SaleOrderGainModel saleOrderGainModel : orders.getSaleOrderGain()) {
                            saleOrderGainModel.setShardingCode(splitodevalue);
                        }
                    }
                }
            }
            if (trainingMode = (modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)(obj = this.redisUtil.get(RedisKey.CACHEID + order.getSaleMarketCode() + order.getTerminalNo())), ModeDetailsVo.class)).isTrainingMode()) {
                MultipleDataSource.setDataSourceKey((String)"dataSource10");
            } else {
                MultipleDataSource.setDataSourceKey((String)"dataSource01");
            }
            RespBase uploadSr = this.orderPosCommonService.saveOrderInfoForCloud(session, orders, (Map<String, Object>)jsonObject, order, modeDetailsVo);
            if (!"0".equals(String.valueOf(uploadSr.getRetflag()))) {
                if ("10001".equals(String.valueOf(uploadSr.getRetflag()))) {
                    result.clear();
                    result.put("oid", (Object)order.getOid());
                    result.put("sheetNo", (Object)order.getOrderNo());
                    result.put("terminalSno", (Object)order.getTerminalSno());
                    result.put("isAllReturn", (Object)true);
                    if (!this.localcache.booleanValue()) {
                        JSONObject rightPushValue = new JSONObject();
                        rightPushValue.put("entId", (Object)order.getEntId());
                        rightPushValue.put("erpCode", (Object)order.getBusCompany());
                        rightPushValue.put("oid", (Object)order.getOid());
                        rightPushValue.put("shopCode", (Object)order.getSaleMarketCode());
                        long var = this.redisUtil.rightPush("ORDER_SYSN_ERP_QUEUE", rightPushValue.toJSONString());
                        log.info("\u5b58\u5165redis\u8ba2\u5355\u5e8f\u5217\uff1a" + var + rightPushValue.toString());
                    }
                    return new RespBase(Code.SUCCESS, (Object)result, "SYNCLOCALORDER");
                }
                return Code.CODE_60017.getRespBase(new Object[]{order.getTerminalSno()});
            }
            if (!this.localcache.booleanValue()) {
                JSONObject rightPushValue = new JSONObject();
                rightPushValue.put("entId", (Object)order.getEntId());
                rightPushValue.put("erpCode", (Object)order.getBusCompany());
                rightPushValue.put("oid", (Object)order.getOid());
                rightPushValue.put("shopCode", (Object)order.getSaleMarketCode());
                long var = this.redisUtil.rightPush("ORDER_SYSN_ERP_QUEUE", rightPushValue.toJSONString());
                log.info("\u5b58\u5165redis\u8ba2\u5355\u5e8f\u5217\uff1a" + var + rightPushValue.toString());
            }
            result.clear();
            result.put("oid", (Object)order.getOid());
            result.put("sheetNo", (Object)order.getOrderNo());
            result.put("terminalSno", (Object)order.getTerminalSno());
            result.put("isAllReturn", (Object)true);
            return new RespBase(Code.SUCCESS, (Object)result, "SYNCLOCALORDER");
        }
        catch (Exception e) {
            log.error("\u4e0a\u4f20\u8ba2\u5355\u9519\u8bef: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return new RespBase(Code.CODE_60017.getIndex(), e.getMessage());
        }
    }

    @Override
    public RespBase receiveOrderSync(ServiceSession session, JSONObject paramsObject) {
        log.info("\u540c\u6b65\u8ba2\u5355\u5165\u53c2\uff1a" + paramsObject.toJSONString());
        try {
            Iterator orderArray = paramsObject.getJSONArray("orders").iterator();
            ArrayList<String> succList = new ArrayList<String>();
            ArrayList<String> failList = new ArrayList<String>();
            String splitcode = "posshop:log:" + paramsObject.get((Object)"shopCode");
            String splitodevalue = "";
            log.info("redis\u5206\u5e93\u7801key\u503c\uff1a" + splitcode);
            if (this.redisUtil.hasKey(splitcode)) {
                splitodevalue = (String)this.redisUtil.hget(splitcode, "splitCode");
                log.info("shardingcode Value : " + splitodevalue);
                if (null == splitodevalue) {
                    splitodevalue = "";
                }
            }
            while (orderArray.hasNext()) {
                String obj;
                ModeDetailsVo modeDetailsVo;
                boolean trainingMode;
                JSONObject orderJson = (JSONObject)orderArray.next();
                log.info("orderJson:" + orderJson.toJSONString());
                SaleOrders orders = (SaleOrders)JSONObject.parseObject((String)JSON.toJSONString((Object)orderJson), SaleOrders.class);
                orders.getSaleOrders().setShardingCode(splitodevalue);
                orders.getSaleOrders().setCreateDate(orders.getSaleOrders().getSaleDate());
                orders.getSaleOrdersExt().setShardingCode(splitodevalue);
                orders.getSaleOrdersMember().setShardingCode(splitodevalue);
                if (null != orders.getSaleOrderDetail()) {
                    for (SaleOrderDetailModel saleOrderDetailModel : orders.getSaleOrderDetail()) {
                        saleOrderDetailModel.setShardingCode(splitodevalue);
                    }
                }
                if (null != orders.getMatchOriginDetail()) {
                    for (SaleOrderDetailModel saleOrderDetailModel : orders.getMatchOriginDetail()) {
                        saleOrderDetailModel.setShardingCode(splitodevalue);
                    }
                } else {
                    orders.setMatchOriginDetail(new ArrayList());
                }
                if (null != orders.getSaleOrderDetailPop()) {
                    for (SaleOrderDetailPopModel saleOrderDetailPopModel : orders.getSaleOrderDetailPop()) {
                        saleOrderDetailPopModel.setShardingCode(splitodevalue);
                    }
                }
                if (null != orders.getSaleOrderUseCoupon()) {
                    for (SaleOrderUseCouponModel saleOrderUseCouponModel : orders.getSaleOrderUseCoupon()) {
                        saleOrderUseCouponModel.setShardingCode(splitodevalue);
                    }
                }
                if (null != orders.getSaleOrderGainDetail()) {
                    for (SaleOrderGainDetailModel saleOrderGainDetailModel : orders.getSaleOrderGainDetail()) {
                        saleOrderGainDetailModel.setShardingCode(splitodevalue);
                    }
                }
                if (null != orders.getSaleOrderGain()) {
                    for (SaleOrderGainModel saleOrderGainModel : orders.getSaleOrderGain()) {
                        saleOrderGainModel.setShardingCode(splitodevalue);
                    }
                }
                if (null != orders.getSaleOrderPay()) {
                    for (SaleOrderPayModel saleOrderPayModel : orders.getSaleOrderPay()) {
                        saleOrderPayModel.setShardingCode(splitodevalue);
                    }
                }
                if (trainingMode = (modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)(obj = this.redisUtil.get(RedisKey.CACHEID + orders.getSaleOrders().getSaleMarketCode() + orders.getSaleOrders().getTerminalNo())), ModeDetailsVo.class)).isTrainingMode()) {
                    MultipleDataSource.setDataSourceKey((String)"dataSource10");
                } else {
                    MultipleDataSource.setDataSourceKey((String)"dataSource01");
                }
                RespBase uploadSr = this.orderPosCommonService.saveOrderInfoForCloud(session, orders, (Map<String, Object>)orderJson, orders.getSaleOrders(), modeDetailsVo);
                if ("0".equals(String.valueOf(uploadSr.getRetflag()))) {
                    if (!this.localcache.booleanValue()) {
                        JSONObject rightPushValue = new JSONObject();
                        rightPushValue.put("entId", (Object)orders.getSaleOrders().getEntId());
                        rightPushValue.put("erpCode", (Object)orders.getSaleOrders().getBusCompany());
                        rightPushValue.put("oid", (Object)orders.getSaleOrders().getOid());
                        rightPushValue.put("shopCode", (Object)orders.getSaleOrders().getSaleMarketCode());
                        long var = this.redisUtil.rightPush("ORDER_SYSN_ERP_QUEUE", rightPushValue.toJSONString());
                        log.info("\u5b58\u5165redis\u8ba2\u5355\u5e8f\u5217\uff1a" + var + rightPushValue.toString());
                    }
                    succList.add(orders.getSaleOrders().getOrderNo());
                    continue;
                }
                failList.add(orders.getSaleOrders().getOrderNo());
            }
            JSONObject result = new JSONObject();
            result.put("success", succList);
            result.put("fail", failList);
            return new RespBase(Code.SUCCESS, (Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new RespBase(-1, e.getMessage());
        }
    }

    @Override
    public RespBase getSyncList(ServiceSession session) {
        if (this.localcache.booleanValue() || this.hazelcast.booleanValue()) {
            List<SyncTradeModel> tradeList = this.syncTradeService.getSyncTradeList();
            if (tradeList.size() > 0) {
                JSONObject json = new JSONObject();
                json.put("total_results", (Object)tradeList.size());
                json.put("tradeList", tradeList);
                return new RespBase(Code.SUCCESS, (Object)json);
            }
            return Code.CODE_60071.getRespBase(new Object[0]);
        }
        return Code.CODE_60072.getRespBase(new Object[0]);
    }

    @Override
    public RespBase synLocalOrder(ServiceSession session, List<SyncTradeModel> synTradeList) {
        try {
            if (this.localcache.booleanValue() || this.hazelcast.booleanValue()) {
                log.info("\u5f00\u59cb\u68c0\u6d4b\u672c\u5730\u5e93\u662f\u5426\u5b58\u5728!!");
                LocalUtil.checkTodayDatabase();
                Date endDate = new Date();
                JSONObject request = new JSONObject();
                request.put("endTime", (Object)endDate);
                RespBase respBase = this.syjMainLogRemoteService.uploadData(request);
                log.info("\u4e0a\u4f20syjmainlog\u8fd4\u56de==>{}", JSONObject.toJSON((Object)respBase));
                RespBase respBasePosworklog = this.posWorkLogRemoteService.uploadData(request);
                log.info("\u4e0a\u4f20Posworklog\u8fd4\u56de==>{}", JSONObject.toJSON((Object)respBasePosworklog));
                RespBase respPrintLog = this.uploadPrintLogData(null, request);
                log.info("\u4e0a\u4f20PrintLog\u8fd4\u56de==>{}", JSONObject.toJSON((Object)respPrintLog));
                List<SyncTradeModel> tradeList = null != synTradeList && synTradeList.size() > 0 ? synTradeList : this.syncTradeService.getSyncTradeList();
                if (tradeList.isEmpty()) {
                    JSONObject res = new JSONObject();
                    res.put("toalSyn", (Object)0);
                    res.put("isSyn", (Object)"0");
                    res.put("unSyn", (Object)0);
                    res.put("failList", (Object)new JSONObject());
                    return new RespBase(Code.SUCCESS, (Object)res);
                }
                ArrayList<String> delList = new ArrayList<String>();
                ArrayList<SyncTradeModel> failList = new ArrayList<SyncTradeModel>();
                int count = 0;
                JSONObject in = new JSONObject();
                if (tradeList.size() <= 20) {
                    in.put("syncOrder", tradeList);
                } else {
                    count = tradeList.size() - 20;
                    in.put("syncOrder", tradeList.subList(0, 20));
                }
                RespBase synSalesResp = this.orderPosOuterService.syncLocalData(session, in);
                if ("0".equals(String.valueOf(synSalesResp.getRetflag()))) {
                    log.info("synSalesResp:" + JSON.toJSONString((Object)synSalesResp));
                    this.doResult((JSONObject)synSalesResp.getData(), delList, failList, tradeList);
                }
                if (count > 0) {
                    failList.addAll(tradeList.subList(20, tradeList.size()));
                }
                if (!delList.isEmpty()) {
                    this.syncTradeService.deleteSyncTrade(delList);
                }
                JSONObject res = new JSONObject();
                res.put("toalSyn", (Object)delList.size());
                if (failList.isEmpty()) {
                    res.put("isSyn", (Object)"0");
                    res.put("unSyn", (Object)0);
                    res.put("failList", (Object)new JSONObject());
                } else {
                    res.put("isSyn", (Object)"1");
                    res.put("unSyn", (Object)failList.size());
                    res.put("failList", failList);
                }
                return new RespBase(Code.SUCCESS, (Object)res);
            }
            return Code.CODE_10043.getRespBase(new Object[0]);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return Code.CODE_60017.getRespBase(new Object[]{e.getMessage()});
        }
    }

    private void doResult(JSONObject resultData, List<String> delList, List<SyncTradeModel> failList, List<SyncTradeModel> tradeList) {
        String obj;
        int m;
        JSONArray success = resultData.getJSONArray("success");
        JSONArray fail = resultData.getJSONArray("fail");
        if (success != null && success.size() > 0) {
            for (m = 0; m < success.size(); ++m) {
                obj = (String)success.get(m);
                delList.add(obj);
            }
        }
        if (fail != null && fail.size() > 0) {
            for (m = 0; m < fail.size(); ++m) {
                obj = (String)fail.get(m);
                for (SyncTradeModel trade : tradeList) {
                    if (!obj.equals(trade.getTradeNo())) continue;
                    failList.add(trade);
                }
            }
        }
    }

    public SysParaInfo initSysParaInfo(List<Syspara> sysParaList) {
        SysParaInfo sysParaInfo = new SysParaInfo();
        block43: for (Syspara s : sysParaList) {
            block18 : switch (s.getCode()) {
                case "CMFT": {
                    sysParaInfo.setCmft(CastUtil.castInt((Object)s.getParavalue()));
                    break;
                }
                case "HYQZ": {
                    sysParaInfo.setHyqz(s.getParavalue());
                    break;
                }
                case "BBFS": {
                    sysParaInfo.setBasePaymentCode(s.getParavalue());
                    break;
                }
                case "OZ": {
                    if (!StringUtils.isNotBlank((String)s.getParavalue())) break;
                    String[] values = s.getParavalue().split(",");
                    sysParaInfo.setMaxSaleGoodsCount(Integer.getInteger(values[0]).intValue());
                    sysParaInfo.setMaxSalePayCount(Integer.getInteger(values[1]).intValue());
                    sysParaInfo.setMaxSaleGoodsQuantity(Double.valueOf(values[2]));
                    sysParaInfo.setMaxSaleGoodsMoney(Double.valueOf(values[3]));
                    sysParaInfo.setMaxSaleMoney(Double.valueOf(values[4]));
                    break;
                }
                case "4J": {
                    sysParaInfo.setMaxChangeValue(CastUtil.castDouble((Object)s.getParavalue()));
                    break;
                }
                case "XDFS": {
                    String[] values;
                    if (!StringUtils.isNotBlank((String)s.getParavalue())) break;
                    sysParaInfo.setNoVoidPaymentCodes(new ArrayList());
                    for (String code : values = s.getParavalue().split(",")) {
                        sysParaInfo.getNoVoidPaymentCodes().add(code);
                    }
                    continue block43;
                }
                case "JYMS": {
                    if (!"1".equals(s.getParavalue()) || sysParaInfo.getBarCodeMode() >= 2) break;
                    sysParaInfo.setBarCodeMode(2);
                    break;
                }
                case "ZKSX": {
                    if (!StringUtils.isNotBlank((String)s.getParavalue())) break;
                    sysParaInfo.setOrderDiscSeq(s.getParavalue());
                    break;
                }
                case "PRTSEQ": {
                    String[] values;
                    if (!StringUtils.isNotBlank((String)s.getParavalue())) break;
                    sysParaInfo.setPopPrtSeq(new ArrayList());
                    for (String code : values = s.getParavalue().split(",")) {
                        sysParaInfo.getPopPrtSeq().add(code);
                    }
                    continue block43;
                }
                case "SYMS": {
                    sysParaInfo.setOverageMode(s.getParavalue());
                    break;
                }
                case "YGGW": {
                    sysParaInfo.setStaffMode(s.getParavalue());
                    break;
                }
                case "SCHS": {
                    if (!StringUtils.isNotBlank((String)s.getParavalue())) break;
                    String[] values = s.getParavalue().split(",");
                    if (values.length >= 1) {
                        sysParaInfo.setMaxDelNum(CastUtil.castInt((Object)values[0]));
                    }
                    if (values.length < 2) continue block43;
                    sysParaInfo.setMinRemainNum(CastUtil.castInt((Object)values[1]));
                    break;
                }
                case "SLXS": {
                    if (!"Y".equals(s.getParavalue())) break;
                    sysParaInfo.setDecimalNum(true);
                    break;
                }
                case "CMJY": {
                    if ("1".equals(s.getParavalue()) && sysParaInfo.getBarCodeMode() != 2) {
                        sysParaInfo.setBarCodeMode(1);
                        break;
                    }
                    if ("2".equals(s.getParavalue())) {
                        sysParaInfo.setBarCodeMode(3);
                        break;
                    }
                    sysParaInfo.setBarCodeMode(CastUtil.castInt((Object)s.getParavalue()));
                    break;
                }
                case "DISCNAME": {
                    if (!StringUtils.isNotBlank((String)s.getParavalue())) break;
                    String[] names = s.getParavalue().split("\\|");
                    block46: for (int i = 0; i < names.length; ++i) {
                        if (i > 4) break block18;
                        String name = names[i];
                        if (!StringUtils.isNotBlank((String)name)) continue;
                        switch (i) {
                            case 0: {
                                sysParaInfo.setDpRateDes(name);
                                continue block46;
                            }
                            case 1: {
                                sysParaInfo.setDpAmountDes(name);
                                continue block46;
                            }
                            case 2: {
                                sysParaInfo.setZpRateDes(name);
                                continue block46;
                            }
                            case 3: {
                                sysParaInfo.setZpAmountDes(name);
                                continue block46;
                            }
                            case 4: {
                                sysParaInfo.setBarCodeDes(name);
                            }
                        }
                    }
                    continue block43;
                }
                case "CWYH": {
                    String[] values;
                    if (!StringUtils.isNotBlank((String)s.getParavalue())) break;
                    sysParaInfo.setCalcPriceType(new ArrayList());
                    for (String code : values = s.getParavalue().split(",")) {
                        sysParaInfo.getCalcPriceType().add(code);
                    }
                    continue block43;
                }
            }
        }
        return sysParaInfo;
    }

    @Override
    public RespBase searchTerminalReport(ServiceSession session, JSONObject paramsObject) {
        log.info("\u67e5\u8be2\u8ba2\u5355\u62a5\u8868\u5165\u53c2\uff1a" + paramsObject.toJSONString());
        RespBase resp = this.orderStatisticsService.searchTerminalReport(session, paramsObject);
        log.info("\u67e5\u8be2\u8ba2\u5355\u62a5\u8868\u51fa\u53c2\uff1a" + JSON.toJSONString((Object)resp));
        return resp;
    }

    @Override
    public RespBase searchIntegralReport(ServiceSession session, JSONObject paramsObject) {
        return this.orderStatisticsService.searchIntegralReport(session, paramsObject);
    }

    @Override
    public RespBase searchGroupReport(ServiceSession session, JSONObject paramsObject) {
        return this.orderStatisticsService.searchGroupReport(session, paramsObject);
    }

    @Override
    public RespBase searchElectronicReport(ServiceSession session, JSONObject paramsObject) {
        return this.orderStatisticsService.searchElectronicReport(session, paramsObject);
    }

    @Override
    public RespBase getPrintCount(ServiceSession session, JSONObject paramsObject) {
        com.product.model.ServiceResponse sr = ParamValidateUtil.checkParam((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"sheetNo", "terminalNo", "terminalOperator", "shopCode"});
        if (!sr.getReturncode().equals("0")) {
            return new RespBase(Code.SUCCESS, (Object)sr);
        }
        try {
            QueryWrapper queryWrapper = new QueryWrapper();
            queryWrapper.eq((Object)"marketCode", (Object)paramsObject.getString("shopCode"));
            queryWrapper.eq((Object)"terminalNo", (Object)paramsObject.getString("terminalNo"));
            queryWrapper.eq((Object)"terminalOperator", (Object)paramsObject.getString("terminalOperator"));
            queryWrapper.eq((Object)"sheetNo", (Object)paramsObject.getString("sheetNo"));
            List printLogInfo = this.ordersPrintLogInfoModelService.selectList(queryWrapper, "ordersprintloginfo");
            JSONObject outobj = new JSONObject();
            int printCnt = 1;
            if (null != printLogInfo && printLogInfo.size() > 0) {
                printCnt = printLogInfo.size() + 1;
            }
            outobj.put("printCnt", (Object)printCnt);
            return new RespBase(Code.SUCCESS, (Object)outobj);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new RespBase(-1, "10000", e.getMessage());
        }
    }

    @Override
    public boolean savePrintLogBatch(ServiceSession session, JSONObject param) {
        JSONArray jsonList = param.getJSONArray("list");
        List list = JSONArray.parseArray((String)jsonList.toJSONString(), OrdersPrintLogInfoModel.class);
        return this.ordersPrintLogInfoModelService.saveBatch(list, "ordersprintloginfo");
    }

    @Override
    public RespBase uploadPrintLogData(ServiceSession session, JSONObject param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        if (StringUtils.isNotBlank((String)param.getString("mkt"))) {
            queryWrapper.eq((Object)"marketCode", (Object)param.getString("mkt"));
        }
        if (StringUtils.isNotBlank((String)param.getString("syjh"))) {
            queryWrapper.eq((Object)"terminalNo", (Object)param.getString("syjh"));
        }
        if (StringUtils.isNotBlank((String)param.getString("endTime"))) {
            queryWrapper.le((Object)"printTime", (Object)param.getString("endTime"));
        }
        List printLogInfoList = this.ordersPrintLogInfoModelService.selectList(queryWrapper, "ordersprintloginfo");
        log.info("\u67e5\u8be2\u5230printLog\u65e5\u5fd7\u4e3a{}\u6761", (Object)printLogInfoList.size());
        if (ArrayUtils.isNotEmpty(printLogInfoList)) {
            try {
                log.info("\u4e0a\u4f20\u672c\u5730printLog\u65e5\u5fd7!");
                JSONObject request = new JSONObject();
                request.put("list", printLogInfoList);
                request.put("command_id", (Object)"UPLOADPRINTLOG");
                String response = HttpClientUtils.postJson((String)GlobalInfo.cloudUrl, (String)"UTF-8", (String)JSONObject.toJSONString((Object)request), (int)5000, (int)15000);
                log.info("\u4e0a\u4f20\u672c\u5730printLog\u65e5\u5fd7\u8fd4\u56de==>{}", (Object)response);
                if (StringUtils.isNotBlank((String)response)) {
                    RespBase respBase = (RespBase)JSONObject.parseObject((String)response, RespBase.class);
                    JSONObject jsonResponse = JSONObject.parseObject((String)response);
                    int retFlag = jsonResponse.getInteger("returncode");
                    respBase.setRetflag(retFlag);
                    if (0 != retFlag) {
                        respBase.setRetmsg(jsonResponse.getString("data"));
                        return respBase;
                    }
                }
                ArrayList<Long> ids = new ArrayList<Long>();
                for (int i = 0; i < printLogInfoList.size(); ++i) {
                    ids.add(((OrdersPrintLogInfoModel)printLogInfoList.get(i)).getOpgId());
                }
                boolean b = true;
                List sprateList = ListUtils.partition(ids, (int)500);
                for (int p = 0; p < sprateList.size(); ++p) {
                    b = this.ordersPrintLogInfoModelService.removeByIds((Collection)sprateList.get(p));
                    if (b) continue;
                    log.info("\u672c\u5730printLog\u65e5\u5fd7\u5220\u9664\u5931\u8d25,\u7b2c{}\u9875", (Object)p);
                    return Code.FAIL.getRespBase(new Object[0]);
                }
                if (b) {
                    log.info("\u672c\u5730printLog\u65e5\u5fd7\u5220\u9664\u6210\u529f{}\u6761", (Object)printLogInfoList.size());
                } else {
                    log.info("\u672c\u5730printLog\u65e5\u5fd7\u5220\u9664\u5931\u8d25");
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                log.info("\u7cfb\u7edf\u521d\u59cb\u5316\u8fde\u63a5\u7ebf\u4e0a\u5f02\u5e38:", (Throwable)e);
                return Code.FAIL.getRespBase(new Object[0]);
            }
        }
        return new RespBase(Code.SUCCESS, "");
    }

    @Override
    public RespBase checkPay(ServiceSession session, JSONObject body) {
        return null;
    }

    @Override
    public RespBase r10BackRebate(ServiceSession session, CacheModel cacheModel) {
        return null;
    }

    @Override
    public RespBase appliancesOrderCheck(ServiceSession session, ResqVo vo) {
        return null;
    }

    @Override
    public RespBase appliancesOrderList(ServiceSession session, JSONObject vo) {
        return null;
    }

    @Override
    public RespBase appliancesSaveTemp(ServiceSession session, ResqVo vo) {
        return null;
    }

    @Override
    public RespBase checkPayCode(ServiceSession session, JSONObject paramsObject) {
        try {
            QueryWrapper cwrapper = new QueryWrapper();
            cwrapper.eq((Object)"payNo", (Object)paramsObject.getString("payNo"));
            if (this.localcache.booleanValue()) {
                MultipleDataSource.setLocDataSourceKey((String)new SimpleDateFormat("yyyyMMdd").format(new Date()));
            }
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("orders"));
            int i = this.ordersPayMapper.selectCount(cwrapper, "");
            if (i > 0) {
                return new RespBase(-1, "\u67e5\u8be2\u5230\u5df2\u5b58\u5728\u8ba2\u5355\uff1a" + paramsObject.getString("payNo") + " " + paramsObject.getString("flowNo"));
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new RespBase(-1, "\u67e5\u8be2\u5f02\u5e38\uff1a" + e.getMessage() + " " + paramsObject.getString("flowNo"));
        }
        return new RespBase(Code.SUCCESS, paramsObject.getString("flowNo"));
    }

    @Override
    public RespBase appliancessaleReturnQuery(ServiceSession session, ResqVo vo) {
        return null;
    }

    @Override
    public RespBase recordPrintLog(ServiceSession session, JSONObject paramsObject) {
        try {
            log.info("recordPrintLog\u5165\u53c2\uff1a" + paramsObject.toJSONString());
            RecordPrintLogIn in = (RecordPrintLogIn)JSONObject.toJavaObject((JSON)paramsObject, RecordPrintLogIn.class);
            PrintLogIn appLogIn = new PrintLogIn();
            appLogIn.setMarketCode(in.getShopCode());
            appLogIn.setTerminalNo(in.getTerminalNo());
            appLogIn.setTerminalOperator(in.getTerminalOperator());
            appLogIn.setOriginMarketCode(in.getPShopCode());
            appLogIn.setOriginTerminalNo(in.getPTerminalNo());
            appLogIn.setOriginTerminalSno(in.getPTerminalSno());
            RespBase resp = this.postBackPrintLog(session, (JSONObject)JSON.toJSON((Object)appLogIn));
            String opgId = "";
            if (resp.getRetflag() != 0 && resp.getRetflag() != 1) {
                return Code.CODE_60074.getRespBase(new Object[0]);
            }
            opgId = resp.getData().toString();
            String back = "success";
            return new RespBase(Code.SUCCESS, back);
        }
        catch (Exception e) {
            log.error(e.getMessage());
            e.printStackTrace();
            StringWriter stringWriter = new StringWriter();
            e.printStackTrace(new PrintWriter(stringWriter));
            return Code.CODE_60073.getRespBase(new Object[0]);
        }
    }

    public RespBase postBackPrintLog(ServiceSession session, JSONObject paramsObject) {
        com.product.model.ServiceResponse sr = ParamValidateUtil.checkParam((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"marketCode", "terminalNo", "terminalOperator", "originMarketCode", "originTerminalNo", "originTerminalSno"});
        if (!sr.getReturncode().equals("0")) {
            return new RespBase(Code.SUCCESS, (Object)sr);
        }
        try {
            String obj = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("marketCode") + paramsObject.getString("terminalNo"));
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
            boolean trainingMode = modeDetailsVo.isTrainingMode();
            QueryWrapper orderqueryWrapper = new QueryWrapper();
            ((QueryWrapper)((QueryWrapper)orderqueryWrapper.eq((Object)"busiTakeMarketCode", (Object)paramsObject.getString("originMarketCode"))).eq((Object)"terminalNo", (Object)paramsObject.getString("originTerminalNo"))).eq((Object)"terminalSno", (Object)paramsObject.getString("originTerminalSno"));
            SaleOrdersModel order = (SaleOrdersModel)this.ordersModelService.selectOne(orderqueryWrapper, "orders", trainingMode);
            if (order == null) {
                return new RespBase(-1, "\u8ba2\u5355\u4e0d\u5b58\u5728");
            }
            OrdersPrintLogInfoModel model = new OrdersPrintLogInfoModel();
            Long opgId = paramsObject.containsKey((Object)"opgId") && !StringUtils.isEmpty((String)((String)paramsObject.get((Object)"opgId"))) ? paramsObject.getLong("opgId") : Long.valueOf(UniqueID.getUniqueID());
            model.setOpgId(opgId);
            model.setOid(order.getOid());
            model.setSheetNo(order.getOrderNo());
            model.setMarketCode(paramsObject.getString("marketCode"));
            model.setTerminalNo(paramsObject.getString("terminalNo"));
            model.setTerminalOperator(paramsObject.getString("terminalOperator"));
            model.setPrintCnt(Integer.valueOf(1));
            model.setPrintTime(new Date());
            this.ordersPrintLogInfoModelService.insert(model, "ordersprintloginfo");
            return new RespBase(Code.SUCCESS, (Object)opgId);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            return new RespBase(-1, "10000", e.getMessage());
        }
    }

    public SysParaInfo toSyspara(String shopCode, String terminalNo) {
        String obj = this.redisUtil.get(RedisKey.CACHEID + shopCode + terminalNo);
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
        List sysparaOut = modeDetailsVo.getSyspara();
        return this.initSysParaInfo(sysparaOut);
    }

    private CacheModel calcOrderPop(ServiceSession session, String calcMode, CacheModel cacheModel, ResqVo vo, List<String> guidList) {
        RespBase resp = new RespBase();
        CountAllIn countAllIn = new CountAllIn();
        countAllIn.setGuidList(guidList);
        countAllIn.setCount(guidList.size());
        double qty = 0.0;
        for (Goods g : cacheModel.getGoodsList()) {
            for (String guid : countAllIn.getGuidList()) {
                if (!guid.equals(g.getGuid())) continue;
                qty += g.getQty();
            }
        }
        countAllIn.setQty(qty);
        countAllIn.setNoPriceGiftList(cacheModel.getChoiceGiftsHaveNoPrice());
        countAllIn.setCalcMode(calcMode);
        List limitedPayCodes = CountAllIn.gainLimitedPayCodes((CacheModel)cacheModel, (CountAllIn)countAllIn);
        countAllIn.setLimitedPayCodes(limitedPayCodes);
        RespBase respBase = new RespBase();
        try {
            respBase = this.calcPopRemoteService.calcAllPop(session, vo, countAllIn);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        ResqVo resqVo = (ResqVo)respBase.getData();
        cacheModel = resqVo.getCacheModel();
        return cacheModel;
    }

    public List<BankCardInfoDef> getBankCardInfo(ServiceSession session) {
        try {
            GetBankCardInfoIn getIn = new GetBankCardInfoIn();
            getIn.setPageNo(1);
            getIn.setPageSize(1000);
            Object response = null;
            if (!"0".equals(response.getReturncode())) {
                return null;
            }
            GetBankCardInfoOut getBankCardInfoOut = (GetBankCardInfoOut)response.getData();
            if (null == getBankCardInfoOut.getBankCardInfo() || getBankCardInfoOut.getBankCardInfo().size() == 0) {
                return null;
            }
            return getBankCardInfoOut.getBankCardInfo();
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    @Override
    public RespBase checkOrderBalance(ServiceSession session, ResqVo vo) {
        RespBase check3 = this.mzkConfirm(session, vo);
        if (Code.SUCCESS.getIndex() != check3.getRetflag()) {
            return check3;
        }
        JSONObject paramsObject = vo.getJsonObject();
        ParamsValidateUtil paramsValidateUtil = new ParamsValidateUtil(session, paramsObject);
        if (!paramsValidateUtil.validate()) {
            return paramsValidateUtil.getRespBase();
        }
        if (!JsonUtils.checkJsonArray(paramsObject, "guidList", true, new String[0])) {
            return Code.CODE_60001.getRespBase(new Object[]{"guidList"});
        }
        if (!JsonUtils.checkJsonArray(paramsObject, "puidList", true, new String[0])) {
            return Code.CODE_60001.getRespBase(new Object[]{"puidList"});
        }
        PayConfirmIn in = (PayConfirmIn)JSON.parseObject((String)paramsObject.toJSONString(), PayConfirmIn.class);
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        session.setEnt_id(cacheModel.getOrder().getEntId());
        if (!cacheModel.getOrder().getSendSuccess()) {
            for (Object p : cacheModel.getPayments()) {
                if (p.getIsSuccess()) continue;
                return Code.CODE_60075.getRespBase(new Object[0]);
            }
            int m = 0;
            for (Goods g : cacheModel.getGoodsList()) {
                if (!g.getIsNoBackGift()) continue;
                ++m;
            }
            List guidList = in.getGuidList();
            if (guidList.size() != cacheModel.getGoodsList().size() - m) {
                return Code.CODE_60004.getRespBase(new Object[0]);
            }
            int num = 0;
            for (Goods g : cacheModel.getGoodsList()) {
                if (g.getIsNoBackGift()) continue;
                boolean flag = false;
                for (String guid : guidList) {
                    if (!guid.equals(g.getGuid())) continue;
                    ++num;
                    flag = true;
                }
                if (flag) continue;
                return Code.CODE_60004.getRespBase(new Object[0]);
            }
            if (num != guidList.size()) {
                return Code.CODE_60004.getRespBase(new Object[0]);
            }
            List puidList = in.getPuidList();
            if (puidList.size() != cacheModel.getPayments().size()) {
                return Code.CODE_60005.getRespBase(new Object[0]);
            }
            int num2 = 0;
            for (Payment p : cacheModel.getPayments()) {
                boolean flag = false;
                for (String puid : puidList) {
                    if (!puid.equals(p.getPuid())) continue;
                    ++num2;
                    flag = true;
                }
                if (flag) continue;
                return Code.CODE_60005.getRespBase(new Object[0]);
            }
            if (num2 != puidList.size()) {
                return Code.CODE_60005.getRespBase(new Object[0]);
            }
        } else {
            return new RespBase(Code.SUCCESS, (Object)cacheModel);
        }
        if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType())) {
            if (!this.checkOrder(cacheModel)) {
                return Code.CODE_60031.getRespBase(new Object[]{cacheModel.getErrMsg()});
            }
            cacheModel.getOrder().setPayState(2);
            cacheModel.getOrder().setOrderState(7);
        }
        if (SellType.NOPOP((String)cacheModel.getOrder().getOrderType()) || SellType.isGroupbuy((String)cacheModel.getOrder().getOrderType(), (boolean)cacheModel.getOrder().getHasGroupBuy()) || cacheModel.getPopMode() != 1 && cacheModel.getPopMode() != 2 && cacheModel.getPopMode() != 3) {
            cacheModel = this.addAdjustPopDetail(cacheModel);
        }
        log.info("\u8ba2\u5355\u5934\u4fc3\u9500\uff1a" + cacheModel.getOrder().getTotalDiscountValue() + "\u660e\u7ec6\u884c\u6570" + cacheModel.getOrder().getQty());
        RespBase check2 = this.orderCheckService.checkSaleBalance(session, in, cacheModel);
        if (null == check2) {
            return Code.CODE_60031.getRespBase(null);
        }
        if (Code.SUCCESS.getIndex() != check2.getRetflag()) {
            return check2;
        }
        vo.setCacheModel(cacheModel);
        return this.afterCheckOrderBalance(session, vo);
    }

    @Override
    public RespBase checkOrderState(CacheModel cacheModel) {
        return this.orderCheckService.checkOrderState(cacheModel);
    }

    private RespBase mzkConfirm(ServiceSession session, ResqVo vo) {
        CacheModel cacheModel = vo.getCacheModel();
        boolean isUseMzk = false;
        List paymentList = cacheModel.getPayments();
        for (int i = 0; i < paymentList.size(); ++i) {
            Payment p = (Payment)paymentList.get(i);
            if (!StringUtils.isNotBlank((String)p.getPayMemo()) || !"SKPMZK".equals(p.getPayMemo()) || p.getIsSuccess()) continue;
            isUseMzk = true;
            break;
        }
        if (isUseMzk) {
            try {
                RespBase respBase = this.skpMzkRemoteService.skpMzkFreeze(session, vo);
                if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
                    return Code.CODE_60038.getRespBase(new Object[0]);
                }
                cacheModel = (CacheModel)respBase.getData();
                vo.setCacheModel(cacheModel);
            }
            catch (Exception e) {
                return Code.CODE_60076.getRespBase(new Object[]{e.getMessage()});
            }
        }
        return new RespBase(Code.SUCCESS, (Object)vo.getCacheModel());
    }

    @Override
    public RespBase afterCheckOrderBalance(ServiceSession session, ResqVo vo) {
        return new RespBase(Code.SUCCESS, (Object)vo.getCacheModel());
    }

    @Override
    public RespBase recalc(ServiceSession session) {
        RespBase respBase = this.syncTradeService.recalc(session);
        return respBase;
    }

    @Override
    public RespBase tempSave(ServiceSession session, CacheModel cacheModel) {
        if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
            JSONObject in = new JSONObject();
            in.put("shopCode", (Object)cacheModel.getOrder().getShopCode());
            in.put("originFlowNo", (Object)cacheModel.getOrder().getOriginFlowNo());
            com.product.model.ServiceResponse rs = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, TEMPORDERLIST, session, JSON.toJSONString((Object)in), OrdersTemp.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u67e5\u8be2\u672a\u4ed8\u6b3e\u9000\u8d27\u5f00\u7968\u5217\u8868");
            if (!"0".equals(rs.getReturncode())) {
                return Code.CODE_60028.getRespBase(new Object[]{"\u67e5\u8be2\u672a\u4ed8\u6b3e\u9000\u8d27\u5f00\u7968\u5217\u8868\u5931\u8d25\uff01"});
            }
            OrdersTemp out = (OrdersTemp)rs.getData();
            if (null != out.getOrdersTemp() && out.getOrdersTemp().size() > 0 && null != cacheModel.getReturnGoodsList() && cacheModel.getReturnGoodsList().size() > 0) {
                for (Goods g : cacheModel.getReturnGoodsList()) {
                    double allowReturnCopies = g.getAllowReturnCopies();
                    block1: for (TempDetailOut tempDetailOut : out.getOrdersTemp()) {
                        if (tempDetailOut.getOrderstempdetail().size() <= 0) continue;
                        for (TempDetails tempDetail : tempDetailOut.getOrderstempdetail()) {
                            if (!tempDetail.getExtendFt1().equals(String.valueOf(g.getFlowId()))) continue;
                            allowReturnCopies = ManipulatePrecision.sub((double)allowReturnCopies, (double)tempDetail.getQty());
                            continue block1;
                        }
                    }
                    for (Goods goods : cacheModel.getGoodsList()) {
                        if (!goods.getGuid().equals(g.getGuid())) continue;
                        allowReturnCopies = ManipulatePrecision.sub((double)allowReturnCopies, (double)goods.getQty());
                        break;
                    }
                    if (!(allowReturnCopies < 0.0)) continue;
                    return Code.CODE_60028.getRespBase(new Object[]{"\u5546\u54c1\u53ef\u9000\u6570\u91cf\u4e0d\u8db3\uff0c\u4e0d\u5141\u8bb8\u518d\u6b21\u9000\u8d27\u5f00\u7968"});
                }
            }
        }
        log.info("cacheModel.getOrder().getPayState()==>" + cacheModel.getOrder().getPayState());
        if (SellType.ISSALE((String)cacheModel.getOrder().getOrderType()) && 0 != cacheModel.getOrder().getPayState()) {
            return new RespBase(Code.CODE_60039.getIndex(), "\u8ba2\u5355\u5df2\u652f\u4ed8\uff0c\u4e0d\u8fdb\u5165\u7535\u5b50\u5f00\u7968\uff01", cacheModel.getFlowNo());
        }
        JSONObject temp = new JSONObject();
        TempHead tempHead = new TempHead(cacheModel);
        ArrayList<TempDetails> tempDetails = new ArrayList<TempDetails>();
        for (Goods goods : cacheModel.getGoodsList()) {
            TempDetails detail = new TempDetails(goods);
            detail.setOrderState("1");
            tempDetails.add(detail);
            if (!SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) continue;
            detail.setFlowNo(cacheModel.getOrder().getFlowNo());
            if (null == cacheModel.getReturnGoodsList() || cacheModel.getReturnGoodsList().size() <= 0) continue;
            for (Goods g : cacheModel.getReturnGoodsList()) {
                if (!goods.getGuid().equals(g.getGuid())) continue;
                detail.setExtendFt1(String.valueOf(g.getFlowId()));
            }
        }
        temp.put("tempHead", (Object)tempHead);
        temp.put("tempDetails", tempDetails);
        JSONObject data = new JSONObject();
        data.put("data", (Object)temp);
        log.info("\u8ba2\u5355\u4e2d\u5fc3-\u7535\u5b50\u8ba2\u5355\u4e0a\u4f20start");
        com.product.model.ServiceResponse rs = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, EXECUTEONLINE, session, JSON.toJSONString((Object)data), SaveTempOut.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u7535\u5b50\u8ba2\u5355-\u4e0a\u4f20");
        log.info("\u8ba2\u5355\u4e2d\u5fc3-\u7535\u5b50\u8ba2\u5355\u4e0a\u4f20-end ,{}", (Object)rs);
        if (!"0".equals(rs.getReturncode())) {
            return new RespBase(Code.CODE_60040.getIndex(), "\u7535\u5b50\u5c0f\u7968\u4e0a\u4f20\u5931\u8d25\uff01" + rs.getData(), cacheModel.getFlowNo());
        }
        this.orderTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.saveTemp, cacheModel.getOrder().getQty(), cacheModel.getOrder().getOughtPay());
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)rs.getData())));
        return new RespBase(Code.SUCCESS, (Object)resqVo, "SAVETEMP");
    }

    @Override
    public RespBase searchTempInfo(ServiceSession session, JSONObject paramsObject) {
        log.info("searchTempInfo\u5165\u53c2{}", (Object)paramsObject.toJSONString());
        if (!paramsObject.containsKey((Object)"shopCode") || paramsObject.getString("shopCode").isEmpty()) {
            return Code.CODE_60001.getRespBase(new Object[]{"[shopCode]"});
        }
        if (!paramsObject.containsKey((Object)"page_no") || paramsObject.getString("page_no").isEmpty()) {
            return Code.CODE_60001.getRespBase(new Object[]{"[page_no]"});
        }
        if (!paramsObject.containsKey((Object)"page_size") || paramsObject.getString("page_size").isEmpty()) {
            return Code.CODE_60001.getRespBase(new Object[]{"[page_size]"});
        }
        if (!paramsObject.containsKey((Object)"endStartDate") || paramsObject.getString("endStartDate").isEmpty()) {
            return Code.CODE_60001.getRespBase(new Object[]{"[endStartDate]"});
        }
        SearchTempDef in = (SearchTempDef)JSONObject.toJavaObject((JSON)paramsObject, SearchTempDef.class);
        log.info("\u7535\u5b50\u8ba2\u5355-\u67e5\u8be2\u5217\u8868start");
        com.product.model.ServiceResponse rs = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, TEMPORDERINFO, session, JSON.toJSONString((Object)in), null, "\u8ba2\u5355\u4e2d\u5fc3", "\u7535\u5b50\u8ba2\u5355-\u67e5\u8be2\u5217\u8868");
        log.info("\u7535\u5b50\u8ba2\u5355-\u67e5\u8be2\u5217\u8868-end ,{}", (Object)JSON.toJSONString((Object)rs));
        if (!"0".equals(rs.getReturncode())) {
            return Code.CODE_60041.getRespBase(new Object[]{rs.getData()});
        }
        log.info("\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, rs.getData(), "TEMPORDERINFO")));
        return new RespBase(Code.SUCCESS, rs.getData(), "TEMPORDERINFO");
    }

    @Override
    public RespBase searchTempDetail(ServiceSession session, CacheModel cacheModel, JSONObject paramsObject) {
        RespBase respBase;
        log.info("searchTempDetail{}", (Object)paramsObject.toJSONString());
        if (!paramsObject.containsKey((Object)"searchType") || paramsObject.getString("searchType").isEmpty()) {
            return Code.CODE_60001.getRespBase(new Object[]{"[searchType]"});
        }
        if (!paramsObject.containsKey((Object)"orgFlowNo") || paramsObject.getString("orgFlowNo").isEmpty()) {
            return Code.CODE_60001.getRespBase(new Object[]{"[orgFlowNo]"});
        }
        String orgFlowNo = paramsObject.getString("orgFlowNo");
        if (cacheModel.getGoodsList().size() > 0) {
            for (Goods sg : cacheModel.getGoodsList()) {
                if (!orgFlowNo.equals(sg.getEBillFlowNo())) continue;
                return Code.CODE_60047.getRespBase(new Object[0]);
            }
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flowNo", paramsObject.getString("orgFlowNo"));
        map.put("shopCode", paramsObject.getString("shopCode"));
        log.info("\u7535\u5b50\u8ba2\u5355-\u67e5\u8be2\u8be6\u60c5start");
        com.product.model.ServiceResponse rs = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, TEMPORDERDETAIL, session, JSON.toJSONString(map), null, "\u8ba2\u5355\u4e2d\u5fc3", "\u7535\u5b50\u8ba2\u5355-\u67e5\u8be2\u8be6\u60c5");
        log.info("\u8ba2\u5355\u4e2d\u5fc3-\u7535\u5b50\u8ba2\u5355\u67e5\u8be2\u8be6\u60c5-end ,{}", (Object)JSON.toJSONString((Object)rs));
        if (!"0".equals(rs.getReturncode())) {
            return Code.CODE_60042.getRespBase(new Object[0]);
        }
        if ("1".equals(paramsObject.getString("searchType"))) {
            return new RespBase(Code.SUCCESS, (Object)ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)rs.getData()))), paramsObject.getString("flowNo"));
        }
        TempDetailOut tempDetailOut = (TempDetailOut)JSON.parseObject((String)JSONObject.toJSONString((Object)rs.getData()), TempDetailOut.class);
        if (tempDetailOut.getOrderstempdetail() == null || tempDetailOut.getOrderstempdetail().size() == 0) {
            return Code.CODE_60079.getRespBase(new Object[0]);
        }
        if (tempDetailOut.getOrderstemphead() == null) {
            return Code.CODE_60080.getRespBase(new Object[0]);
        }
        if (tempDetailOut.getOrderstemphead().getOrderState() != 1) {
            return Code.CODE_60081.getRespBase(new Object[0]);
        }
        if (SellType.ISBACK((String)cacheModel.getOrder().getOrderType())) {
            return this.searchTHTempDetail(session, cacheModel, tempDetailOut, paramsObject);
        }
        log.info("\u8bbe\u7f6e\u7535\u5b50\u5f00\u7968\u72b6\u6001");
        cacheModel.getOrder().setHasEbill(Integer.valueOf(1));
        ResqVo respVos = ResqVo.buildReqVo((CacheModel)cacheModel);
        if (null != cacheModel.getOrder().getConsumersData() && null != cacheModel.getOrder().getConsumersData().getConsumersCard() && !cacheModel.getOrder().getConsumersData().getConsumersId().equals(tempDetailOut.getOrderstemphead().getConsumersId()) && !"3".equals(paramsObject.getString("searchType"))) {
            return Code.CODE_60044.getRespBase(new Object[0]);
        }
        if (null != tempDetailOut.getOrderstemphead().getConsumersId() && !"3".equals(paramsObject.getString("searchType"))) {
            respBase = this.setTempOrderDetailConsumer(session, cacheModel, paramsObject, tempDetailOut, respVos);
            if (null != respBase && Code.SUCCESS.getIndex() == respBase.getRetflag()) {
                cacheModel = (CacheModel)respBase.getData();
            } else {
                return Code.CODE_60082.getRespBase(new Object[]{respBase.getRetmsg()});
            }
        }
        log.info("\u590d\u5236\u6dfb\u52a0\u5546\u54c1-start");
        respBase = this.goodsRemoteService.getTempDetail(session, ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)tempDetailOut))));
        if (respBase.getRetflag() != Code.SUCCESS.getIndex()) {
            log.info("\u8c03\u51fa\u5f02\u5e38\uff1a{}", (Object)respBase.getRetmsg());
            return Code.CODE_60083.getRespBase(new Object[]{respBase.getRetmsg()});
        }
        respVos = (ResqVo)respBase.getData();
        cacheModel = respVos.getCacheModel();
        log.info("\u590d\u5236\u6dfb\u52a0\u5546\u54c1-end");
        this.orderTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.tempDetail, cacheModel.getOrder().getQty(), cacheModel.getOrder().getOughtPay());
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        log.info("\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, cacheModel.getFlowNo())));
        return new RespBase(Code.SUCCESS, (Object)resqVo, cacheModel.getFlowNo());
    }

    public RespBase searchTHTempDetail(ServiceSession session, CacheModel cacheModel, TempDetailOut tempDetailOut, JSONObject j) {
        if (StringUtils.isBlank((String)tempDetailOut.getOrderstemphead().getOriginFlowNo())) {
            return Code.CODE_60016.getRespBase(new Object[]{"\u539f\u5c0f\u7968\u8ba2\u5355\u53f7\u4e0d\u5b58\u5728"});
        }
        JSONObject jsonObject = new JSONObject();
        jsonObject.put("posId", (Object)tempDetailOut.getOrderstemphead().getOriginFlowNo());
        SaleOrders_WSLF saleOrder = null;
        RespBase resp = this.orderPosOuterService.searchOrdersDetailFromCloud(session, jsonObject);
        log.info("\u9000\u8d27\u7535\u5b50\u5f00\u7968\u67e5\u8be2\u539f\u5355\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)resp.getData()));
        if (Code.SUCCESS.getIndex() == resp.getRetflag()) {
            OrdersDetailOut getOrdersDetailOut = (OrdersDetailOut)JSONObject.toJavaObject((JSON)((JSONObject)JSONObject.toJSON((Object)resp.getData())), OrdersDetailOut.class);
            saleOrder = getOrdersDetailOut.getOrderInfo();
            if (saleOrder.getOrders() == null) {
                return Code.CODE_60016.getRespBase(new Object[]{resp.getData()});
            }
        } else {
            return Code.CODE_60016.getRespBase(new Object[]{resp.getData()});
        }
        cacheModel = this.TransferCacheModelForReturn(saleOrder, cacheModel, false);
        Order order = cacheModel.getOrder();
        JSONObject paramsObject = new JSONObject();
        paramsObject.put("erpCode", (Object)order.getErpCode());
        paramsObject.put("flowNo", (Object)order.getFlowNo());
        paramsObject.put("oldShopCode", (Object)order.getErpCode());
        paramsObject.put("orderType", (Object)order.getOrderType());
        paramsObject.put("shopCode", (Object)order.getErpCode());
        paramsObject.put("terminalNo", (Object)j.getString("terminalNo"));
        paramsObject.put("terminalOperator", (Object)j.getString("terminalOperator"));
        ArrayList<JSONObject> goodslist = new ArrayList<JSONObject>();
        for (TempDetails t : tempDetailOut.getOrderstempdetail()) {
            for (Goods g : cacheModel.getReturnGoodsList()) {
                if (CastUtil.castInt((Object)t.getExtendFt1()) != g.getFlowId()) continue;
                JSONObject jo = new JSONObject();
                jo.put("guid", (Object)g.getGuid());
                jo.put("qty", (Object)t.getQty());
                goodslist.add(jo);
            }
        }
        paramsObject.put("goodslist", goodslist);
        cacheModel.getOrder().setHasEbill(Integer.valueOf(1));
        cacheModel.getOrder().setEBillFlowNo(tempDetailOut.getOrderstemphead().getFlowNo());
        return this.goodsRemoteService.confirmSalesReturn(session, ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)paramsObject));
    }

    @Override
    public RespBase updateTempOrderState(ServiceSession session, JSONObject paramsObject) {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("orderState", paramsObject.getString("orderState"));
        map.put("shopCode", paramsObject.getString("shopCode"));
        map.put("flowNo", paramsObject.getString("flowNo"));
        log.info("\u7535\u5b50\u8ba2\u5355-\u4fee\u6539\u72b6\u6001start");
        com.product.model.ServiceResponse rs = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, UPDATETEMPORDERSTATE, session, JSON.toJSONString(map), null, "\u8ba2\u5355\u4e2d\u5fc3", "\u7535\u5b50\u8ba2\u5355-\u4fee\u6539\u72b6\u6001");
        log.info("\u7535\u5b50\u8ba2\u5355-\u4fee\u6539\u72b6\u6001-end ,{}", (Object)rs);
        if (!"0".equals(rs.getReturncode())) {
            return new RespBase(Code.CODE_60043.getIndex(), "\u7535\u5b50\u8ba2\u5355\u4fee\u6539\u72b6\u6001\u5931\u8d25\uff01" + rs.getData(), "UPDATETEMPORDERSTATE");
        }
        log.info("\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, rs.getData(), "UPDATETEMPORDERSTATE")));
        return new RespBase(Code.SUCCESS, rs.getData(), "UPDATETEMPORDERSTATE");
    }

    @Override
    public RespBase copyTempOrder(ServiceSession session, CacheModel cacheModel, JSONObject paramsObject) {
        log.info("copyTempOrder{}", (Object)paramsObject.toJSONString());
        if (!paramsObject.containsKey((Object)"orgFlowNo") || paramsObject.getString("orgFlowNo").isEmpty()) {
            return Code.CODE_60001.getRespBase(new Object[]{"[orgFlowNo]"});
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flowNo", paramsObject.getString("orgFlowNo"));
        map.put("shopCode", paramsObject.getString("shopCode"));
        log.info("\u7535\u5b50\u8ba2\u5355-\u67e5\u8be2\u8be6\u60c5start");
        com.product.model.ServiceResponse rs = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, TEMPORDERDETAIL, session, JSON.toJSONString(map), null, "\u8ba2\u5355\u4e2d\u5fc3", "\u7535\u5b50\u8ba2\u5355-\u67e5\u8be2\u8be6\u60c5");
        log.info("\u8ba2\u5355\u4e2d\u5fc3-\u7535\u5b50\u8ba2\u5355\u67e5\u8be2\u8be6\u60c5-end ,{}", (Object)JSON.toJSONString((Object)rs));
        if (!"0".equals(rs.getReturncode())) {
            return new RespBase(Code.CODE_60042.getIndex(), "\u7535\u5b50\u8ba2\u5355\u67e5\u8be2\u5217\u8868\u8be6\u60c5\u5931\u8d25\uff01" + rs.getData(), cacheModel.getFlowNo());
        }
        TempDetailOut tempDetailOut = (TempDetailOut)JSON.parseObject((String)JSONObject.toJSONString((Object)rs.getData()), TempDetailOut.class);
        if (tempDetailOut.getOrderstempdetail() == null || tempDetailOut.getOrderstempdetail().size() == 0) {
            return Code.CODE_60079.getRespBase(new Object[0]);
        }
        if (tempDetailOut.getOrderstemphead() == null) {
            return Code.CODE_60080.getRespBase(new Object[0]);
        }
        RespBase respBase = null;
        if (cacheModel.getGoodsList() != null && cacheModel.getGoodsList().size() > 0) {
            cacheModel.getGoodsList().clear();
        }
        cacheModel.getOrder().setConsumersData(new ConsumersData());
        ResqVo respVos = ResqVo.buildReqVo((CacheModel)cacheModel);
        if (null != tempDetailOut.getOrderstemphead().getConsumersId()) {
            respBase = this.setTempOrderDetailConsumer(session, cacheModel, paramsObject, tempDetailOut, respVos);
            log.info("\u590d\u5236\u4f1a\u5458return,{}", (Object)respBase.getRetflag());
            if (null != respBase && Code.SUCCESS.getIndex() == respBase.getRetflag()) {
                cacheModel = (CacheModel)respBase.getData();
            } else {
                log.info("\u590d\u5236\u4f1a\u5458\u5f02\u5e38:{}", (Object)respBase.getRetmsg());
                return Code.CODE_60082.getRespBase(new Object[]{respBase.getRetmsg()});
            }
        }
        log.info("copy\u6dfb\u52a0\u5546\u54c1-start");
        respBase = this.goodsRemoteService.getTempDetail(session, ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)tempDetailOut))));
        if (respBase.getRetflag() != Code.SUCCESS.getIndex()) {
            log.info("\u8ba2\u5355\u8c03\u51fa\u5355\u636e\u5f02\u5e38:{}", (Object)respBase.getRetmsg());
            return Code.CODE_60083.getRespBase(new Object[]{respBase.getRetmsg()});
        }
        respVos = (ResqVo)respBase.getData();
        cacheModel = respVos.getCacheModel();
        log.info("copy\u6dfb\u52a0\u5546\u54c1-end");
        HashMap<String, Object> res = new HashMap<String, Object>();
        res.put("orderState", 8);
        res.put("shopCode", paramsObject.getString("shopCode"));
        res.put("flowNo", paramsObject.getString("orgFlowNo"));
        log.info("\u7535\u5b50\u8ba2\u5355-\u4fee\u6539\u72b6\u6001start");
        com.product.model.ServiceResponse sr = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, UPDATETEMPORDERSTATE, session, JSON.toJSONString(res), null, "\u8ba2\u5355\u4e2d\u5fc3", "\u7535\u5b50\u8ba2\u5355-\u4fee\u6539\u72b6\u6001");
        log.info("\u7535\u5b50\u8ba2\u5355-\u590d\u5236\u540e\u4fee\u6539\u72b6\u6001-end ,{}", (Object)sr);
        if (!"0".equals(sr.getReturncode())) {
            return Code.CODE_60043.getRespBase(new Object[]{sr.getData()});
        }
        this.orderTask.sendWorkLog(session, cacheModel.getOrder(), WorkLogType.tempCopy, cacheModel.getOrder().getQty(), cacheModel.getOrder().getOughtPay());
        BaseOutModel out = new BaseOutModel();
        out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
        ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
        log.info("\u590d\u5236\u7535\u5b50\u8ba2\u5355\u51fa\u53c2\u8f93\u51fa" + JSON.toJSON((Object)new RespBase(Code.SUCCESS, (Object)resqVo, cacheModel.getFlowNo())));
        return new RespBase(Code.SUCCESS, (Object)resqVo, cacheModel.getFlowNo());
    }

    public com.product.model.ServiceResponse reversePromotion(ServiceSession session, CacheModel cacheModel, CouponuseConsumeIn couponuseConsumeIn, String netType) {
        com.product.model.ServiceResponse response = new com.product.model.ServiceResponse();
        List reversePayments = couponuseConsumeIn.getSellPayments();
        cacheModel.setReversePayments(reversePayments);
        response.setReturncode(this.couponConsume(cacheModel, session, 4, netType).getReturncode());
        return response;
    }

    public CacheModel cancelOrder(ServiceSession session, CacheModel cacheModel, String netType, String newTerminalSno) {
        log.info("cancelOrder begin");
        if (StringUtils.isNotBlank((String)newTerminalSno)) {
            return cacheModel;
        }
        CalcCancelOrderIn cancelOrderIn = new CalcCancelOrderIn();
        cancelOrderIn.setBillno(cacheModel.getOrder().getOriginFlowNo());
        cancelOrderIn.setChannel(cacheModel.getOrder().getChannel());
        cancelOrderIn.setType("0");
        double discountAmount = this.posLogicService.CalcPopDetail(cacheModel);
        com.product.model.ServiceResponse response = this.cancelOrder(null, session, cancelOrderIn, netType, cacheModel, newTerminalSno);
        log.info("returncode = " + response.getReturncode());
        Object responseNew = null;
        if (!response.getReturncode().equals("0") && !SellType.ISEXERCISE((String)cacheModel.getOrder().getOrderType())) {
            if (!"60003".equals(response.getReturncode())) {
                cancelOrderIn.setType("1");
                response.setReturncode(this.cancelOrder(null, session, cancelOrderIn, netType, cacheModel, newTerminalSno).getReturncode());
            }
            cacheModel.setCalcResult(-1);
            cacheModel.setErrCode(response.getReturncode());
            cacheModel.setErrMsg("\u4fc3\u9500\u4e2d\u5fc3\u53d6\u6d88\u8ba2\u5355\u5931\u8d25");
            if (null != response.getData()) {
                cacheModel.setErrMsg(response.getData().toString());
            }
            return cacheModel;
        }
        log.info("\u8425\u9500\u53d6\u6d88\u5b8c\u6bd5");
        return cacheModel;
    }

    public com.product.model.ServiceResponse cancelOrder(RestTemplate restTemplate, ServiceSession session, CalcCancelOrderIn in, String NetType, CacheModel cacheModel, String newTerminalSno) {
        String calcurl = YPopStatusType.cmdtype_ordercancel;
        String inParams = JSON.toJSONString((Object)in);
        log.info("cancelOrder====>" + inParams);
        log.info("cancelOrder NetType====>" + NetType);
        com.product.model.ServiceResponse resp = null;
        if ("1".equals(GlobalInfo.mssLocalIsOpen)) {
            if ("2".equals(NetType)) {
                resp = this.httpUtils.doPost(restTemplate, HttpUtils.RemoteService.PROMOTION, calcurl, session, inParams, Object.class, "\u8425\u9500\u4e2d\u5fc3", "\u53d6\u6d88\u8ba2\u5355");
                if ("60003".equals(resp.getReturncode())) {
                    log.info("cancelOrder loc====>" + inParams);
                    inParams = JSON.toJSONString((Object)in);
                    com.efuture.ocp.common.entity.ServiceSession sessionobj = new com.efuture.ocp.common.entity.ServiceSession();
                    sessionobj.setRemoteaddr("localhost");
                    sessionobj.setMethod(calcurl);
                    sessionobj.setEnt_id(session.getEnt_id());
                    sessionobj.setUser_code(String.valueOf(session.getUser_id()));
                    sessionobj.setUser_name(session.getUser_name());
                    sessionobj.setLogkey("");
                    sessionobj.setRootkey("");
                    sessionobj.setParentkey("");
                    ServiceResponse ocpresp = null;
                    try {
                        ocpresp = (ServiceResponse)this.rcm.executeClassMethod(calcurl, sessionobj, inParams);
                        log.info("cancelOrder2.5====>" + ocpresp.getReturncode() + "-----" + ocpresp.getData());
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        e.printStackTrace();
                    }
                    resp = new com.product.model.ServiceResponse();
                    resp.setReturncode(ocpresp.getReturncode());
                }
            } else {
                com.efuture.ocp.common.entity.ServiceSession sessionobj = new com.efuture.ocp.common.entity.ServiceSession();
                sessionobj.setRemoteaddr("localhost");
                sessionobj.setMethod(calcurl);
                sessionobj.setEnt_id(session.getEnt_id());
                sessionobj.setUser_code(String.valueOf(session.getUser_id()));
                sessionobj.setUser_name(session.getUser_name());
                sessionobj.setLogkey("");
                sessionobj.setRootkey("");
                sessionobj.setParentkey("");
                ServiceResponse ocpresp = null;
                try {
                    log.info("cancelOrder3 ====>" + ocpresp.getReturncode() + "-----" + ocpresp.getData());
                    ocpresp = (ServiceResponse)this.rcm.executeClassMethod(calcurl, sessionobj, inParams);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    e.printStackTrace();
                }
                resp = new com.product.model.ServiceResponse();
                resp.setReturncode(ocpresp.getReturncode());
            }
        } else {
            inParams = JSON.toJSONString((Object)in);
            resp = this.httpUtils.doPost(restTemplate, HttpUtils.RemoteService.PROMOTION, calcurl, session, inParams, Object.class, "\u8425\u9500\u4e2d\u5fc3", "\u53d6\u6d88\u8ba2\u5355");
        }
        log.info("cancelOrder====>" + JSONObject.toJSON((Object)resp).toString());
        return resp;
    }

    public boolean isAllowHC(SaleOrdersModel order) {
        String saleType = order.getSheetTypeCode();
        if (SellType.ISBACK((String)saleType)) {
            return false;
        }
        if ("5".equals(saleType)) {
            return false;
        }
        if ("Y19".equals(saleType)) {
            return false;
        }
        if ("Y12".equals(saleType)) {
            return false;
        }
        if ("Y12".equals(saleType)) {
            return false;
        }
        if ("U".equals(saleType)) {
            return false;
        }
        return !"Z1".equals(saleType);
    }

    public boolean isAllowHC(OrdersModel4Pos order) {
        String saleType = order.getOrderType();
        if (SellType.ISBACK((String)saleType)) {
            return false;
        }
        if ("5".equals(saleType)) {
            return false;
        }
        if ("Y19".equals(saleType)) {
            return false;
        }
        if ("Y12".equals(saleType)) {
            return false;
        }
        if ("Y12".equals(saleType)) {
            return false;
        }
        if ("U".equals(saleType)) {
            return false;
        }
        return !"Z1".equals(saleType);
    }

    public boolean isAllowBack(SaleOrdersModel order) {
        String saleType = order.getSheetTypeCode();
        if (SellType.ISBACK((String)saleType)) {
            return false;
        }
        if ("5".equals(saleType)) {
            return false;
        }
        if ("Y19".equals(saleType)) {
            return false;
        }
        if ("Y12".equals(saleType)) {
            return false;
        }
        if ("Y12".equals(saleType)) {
            return false;
        }
        return !"U".equals(saleType);
    }

    public boolean isAllowBack(OrdersModel4Pos order) {
        String saleType = order.getOrderType();
        if (SellType.ISBACK((String)saleType)) {
            return false;
        }
        if ("5".equals(saleType)) {
            return false;
        }
        if ("Y19".equals(saleType)) {
            return false;
        }
        if ("Y12".equals(saleType)) {
            return false;
        }
        if ("Y12".equals(saleType)) {
            return false;
        }
        return !"U".equals(saleType);
    }

    private String getPointPayCode(CacheModel cacheModel) {
        JSONObject object3;
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String paravalue = "";
        JSONArray array = new JSONArray();
        List sysParaList = modeDetailsVo.getSyspara();
        JSONArray sysParaArray = JSONArray.parseArray((String)JSON.toJSONString((Object)sysParaList));
        if (sysParaArray.size() != 0) {
            for (int i = 0; i < sysParaArray.size(); ++i) {
                JSONObject sys = sysParaArray.getJSONObject(i);
                if (!sys.get((Object)"code").equals("OC")) continue;
                array.add((Object)sys);
            }
        }
        if (array.size() != 0 && (object3 = array.getJSONObject(0)).containsKey((Object)"paravalue")) {
            paravalue = object3.getString("paravalue");
        }
        if (paravalue.length() > 0) {
            for (String string : paravalue.split("\\|")) {
                if (string.length() <= 0 || !string.contains("RewardPoints") || string.split(",").length <= 0) continue;
                return string.split(",")[1];
            }
        }
        return "";
    }

    private String reCacheMode(String obj, JSONObject jsonObject) {
        if ("".equals(obj) || null == obj) {
            this.initRemoteService.reSaveCacheModel(null, jsonObject);
            obj = this.redisUtil.get(RedisKey.CACHEID + jsonObject.getString("shopCode") + jsonObject.getString("terminalNo"));
        }
        return obj;
    }

    @Override
    public RespBase cancelReturnQuery(ServiceSession session, ResqVo vo) {
        try {
            String shardingCode;
            JSONObject paramsObject = vo.getJsonObject();
            ParamsValidateUtil paramsValidateUtil = new ParamsValidateUtil(session, paramsObject);
            if (!paramsValidateUtil.validate()) {
                return paramsValidateUtil.getRespBase();
            }
            SaleReturnQueryIn saleReturnQueryIn = (SaleReturnQueryIn)JSON.parseObject((String)paramsObject.toJSONString(), SaleReturnQueryIn.class);
            String obj = this.redisUtil.get(RedisKey.CACHEID + saleReturnQueryIn.getShopCode() + saleReturnQueryIn.getTerminalNo());
            obj = this.reCacheMode(obj, paramsObject);
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
            CacheModel cacheModel = vo.getCacheModel();
            if (null == cacheModel) {
                return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
            }
            cacheModel.getOrder().setSeqNo("");
            OrderQueryIn orderQueryIn = new OrderQueryIn();
            orderQueryIn.setTerminalNo(saleReturnQueryIn.getOldTerminalNo());
            orderQueryIn.setTerminalSno(saleReturnQueryIn.getOldTerminalSno());
            orderQueryIn.setBusiTakeMarketCode(saleReturnQueryIn.getOldShopCode());
            orderQueryIn.setCreateDate(saleReturnQueryIn.getBillDate());
            orderQueryIn.setSearchType(2);
            if (paramsObject.containsKey((Object)"splitCode") && StringUtils.isNotBlank((String)(shardingCode = paramsObject.getString("splitCode")))) {
                orderQueryIn.setShardingCode(shardingCode);
            }
            log.info("\u8bf7\u6c42\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u8ba2\u5355\u5165\u53c2:" + JSON.toJSONString((Object)orderQueryIn));
            RespBase resp = this.orderPosOuterService.searchOrdersDetail(session, (JSONObject)JSONObject.toJSON((Object)orderQueryIn));
            if (Code.SUCCESS.getIndex() != resp.getRetflag()) {
                log.info("\u8bf7\u6c42\u8ba2\u5355\u4e2d\u5fc3\u83b7\u53d6\u8ba2\u5355\u5931\u8d25:" + JSON.toJSONString((Object)resp));
                if ("60003".equals(String.valueOf(resp.getRetflag()))) {
                    return Code.CODE_60021.getRespBase(new Object[]{resp.getData()});
                }
                return resp;
            }
            OrdersDetailOut getOrdersDetailOut = (OrdersDetailOut)JSONObject.toJavaObject((JSON)((JSONObject)JSONObject.toJSON((Object)resp.getData())), OrdersDetailOut.class);
            SaleOrders_WSLF orderQueryOut = getOrdersDetailOut.getOrderInfo();
            if (null == orderQueryOut) {
                return Code.CODE_60011.getRespBase(new Object[0]);
            }
            log.info("\u67e5\u8be2\u539f\u5355\u6570\u636e\uff1a{}", (Object)JSONObject.toJSONString((Object)orderQueryOut));
            if (null != orderQueryOut.getOrders().getOriginSheetNo()) {
                return Code.CODE_60084.getRespBase(new Object[0]);
            }
            if (!orderQueryOut.getOrders().getOrderType().equals("4")) {
                return Code.CODE_60085.getRespBase(new Object[0]);
            }
            String authCardNo = cacheModel.getOrder().getTerminalOperatorAuthzCardNo();
            String thAuthCardNo = cacheModel.getOrder().getRefundAuthzCardNo();
            cacheModel = this.TransferCacheModelForReturn(orderQueryOut, cacheModel);
            for (Goods goods : cacheModel.getGoodsList()) {
                goods.setPopFlag("Z");
            }
            LocalDateTime dateTime = LocalDateTime.now();
            DateTimeFormatter df = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
            String nowDateTime = dateTime.format(df);
            cacheModel.getOrder().setSaleDate(nowDateTime);
            cacheModel.getOrder().setTerminalOperatorAuthzCardNo(authCardNo);
            cacheModel.getOrder().setRefundAuthzCardNo(thAuthCardNo);
            cacheModel.getOrder().setExtendFt1("\u53d6\u6d88\u9000\u8d27");
            this.posLogicCompoment.calcOrderAmount(cacheModel);
            GetSaleGoodsInfoOut out = new GetSaleGoodsInfoOut();
            out.setOrder(this.orderTransfer.toOrderForPos(cacheModel));
            ResqVo resqVo = ResqVo.buildReqVo((CacheModel)cacheModel, (JSONObject)((JSONObject)JSON.toJSON((Object)out)));
            return new RespBase(Code.SUCCESS, (Object)resqVo, "CANCELRETURNQUERY");
        }
        catch (EfutureException e) {
            throw e;
        }
        catch (Exception e) {
            log.info("\u8c03\u7528\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            return Code.CODE_60007.getRespBase(new Object[]{e.getMessage()});
        }
    }

    public String computeBillDate(Date createDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd");
        try {
            String searchDate = dateFormat.format(createDate);
            Date whenDate = TypeUtils.castToDate((Object)(searchDate + BILL_END_TIME));
            if (createDate.after(whenDate)) {
                return searchDate;
            }
            if (createDate.equals(whenDate)) {
                return searchDate;
            }
            return DateHelpUtil.getYestoryDate((String)searchDate);
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u4e2d\u5fc3\u8ba1\u7b97\u8bb0\u8d26\u65e5\u671f\u5931\u8d25: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public CacheModel TransferCacheModelForReturn(SaleOrders_WSLF orderQueryOut, CacheModel cacheModel) {
        Double totalQty = 0.0;
        ArrayList<Goods> goodslist = new ArrayList<Goods>();
        for (OrdersDetailModel saleDetail : orderQueryOut.getOrdersDetail()) {
            totalQty = saleDetail.getWeighGood() != false && !this.posLogicCompoment.checkEscaleEditFlagForDetail((JSONObject)JSON.toJSON((Object)saleDetail)) ? Double.valueOf(totalQty + 1.0) : Double.valueOf(totalQty + saleDetail.getQty());
            Goods goods = this.goodsTransfer.transferGoods2(saleDetail);
            goods.setTempZrDiscount(goods.getAdjustDiscountValue());
            goodslist.add(goods);
        }
        cacheModel.getOrder().setQty(totalQty.intValue());
        if (null != orderQueryOut.getOrdersDetailPop() && orderQueryOut.getOrdersDetailPop().size() > 0) {
            for (OrdersDetailPopModel orderPop : orderQueryOut.getOrdersDetailPop()) {
                int rowNo = orderPop.getRowNo() - 1;
                if (goodslist.size() < rowNo + 1) continue;
                ((Goods)goodslist.get(rowNo)).getPopDetails().add(this.popdetailTransfer.transferPopDetail(orderPop));
            }
            for (int i = 0; i < goodslist.size(); ++i) {
                Goods goods = (Goods)goodslist.get(i);
                for (int y = 0; y < goods.getPopDetails().size(); ++y) {
                    PopDetail popDetails = (PopDetail)goods.getPopDetails().get(y);
                    popDetails.setDiscountShare(ManipulatePrecision.div((double)popDetails.getDiscountAmount(), (double)goods.getSaleValue()));
                }
                if (!"97".equals(goods.getGoodsType())) continue;
                goodslist.remove(i);
                --i;
            }
        }
        log.info("popdetail\u884c\u6570\uff1a" + ((Goods)goodslist.get(0)).getPopDetailsInfo().size());
        cacheModel.setGoodsList(goodslist);
        return cacheModel;
    }

    @Override
    public RespBase queryTailPay(ServiceSession session, CacheModel cacheModel, GetOrderIn getOrderIn) {
        try {
            OrderQueryIn in = new OrderQueryIn();
            in.setBusiTakeMarketCode(getOrderIn.getShopCode());
            in.setTerminalNo(getOrderIn.getTerminalNo());
            in.setTerminalSno(getOrderIn.getTerminalSno());
            in.setCreateDate(getOrderIn.getBillDate());
            in.setSearchType(getOrderIn.getSearchType());
            if (StringUtils.isNotBlank((String)getOrderIn.getShardingCode())) {
                in.setShardingCode(getOrderIn.getShardingCode());
            }
            if (!"5".equals(cacheModel.getOrder().getOrderType())) {
                return Code.CODE_60086.getRespBase(new Object[0]);
            }
            log.info("\u8ba2\u5355\u660e\u7ec6\u67e5\u8be2\u5165\u53c2\uff1a{}", (Object)JSONObject.toJSONString((Object)in));
            RespBase resp = this.orderPosOuterService.searchOrdersDetail(session, (JSONObject)JSONObject.toJSON((Object)in));
            log.info("\u67e5\u8ba2\u5355\u8fd4\u56de\uff1a" + JSON.toJSONString((Object)resp.getData()));
            if (Code.SUCCESS.getIndex() != resp.getRetflag()) {
                if ("60003".equals(String.valueOf(resp.getRetflag()))) {
                    return Code.CODE_60021.getRespBase(new Object[]{resp.getData()});
                }
                if ("10001".equals(String.valueOf(resp.getRetflag()))) {
                    return Code.CODE_60021.getRespBase(new Object[]{resp.getData()});
                }
                log.info("\u83b7\u53d6\u8ba2\u5355\u5931\u8d25:" + resp.getData());
                return Code.CODE_60035.getRespBase(new Object[]{resp.getData()});
            }
            OrdersDetailOut getOrdersDetailOut = (OrdersDetailOut)JSONObject.toJavaObject((JSON)((JSONObject)JSONObject.toJSON((Object)resp.getData())), OrdersDetailOut.class);
            SaleOrders_WSLF saleOrder = new SaleOrders_WSLF();
            saleOrder = getOrdersDetailOut.getOrderInfo();
            if (null == saleOrder.getOrders()) {
                return Code.CODE_60016.getRespBase(new Object[]{resp.getData()});
            }
            if (SaleOrderStateEnum.YQX.getCode() == saleOrder.getOrders().getOrderState().intValue()) {
                return Code.CODE_60087.getRespBase(new Object[0]);
            }
            if (!saleOrder.getOrders().isDepositSale()) {
                return Code.CODE_60088.getRespBase(new Object[0]);
            }
            if (!SellType.ISSALE((String)saleOrder.getOrders().getOrderType())) {
                return Code.CODE_60089.getRespBase(new Object[0]);
            }
            if (saleOrder.getOrders().isTailMoneyPay()) {
                return Code.CODE_60090.getRespBase(new Object[0]);
            }
            ArrayList<Goods> cachedGoodsList = cacheModel.getReturnGoodsList();
            if (cachedGoodsList == null) {
                cachedGoodsList = new ArrayList<Goods>();
            }
            cachedGoodsList.clear();
            for (OrdersDetailModel saleOrderDetail : saleOrder.getOrdersDetail()) {
                cachedGoodsList.add(this.goodsTransfer.transferGoods2(saleOrderDetail));
            }
            if (null != saleOrder.getOrdersDetailPop() && saleOrder.getOrdersDetailPop().size() > 0) {
                for (int i = 0; i < cachedGoodsList.size(); ++i) {
                    Goods goods = (Goods)cachedGoodsList.get(i);
                    for (OrdersDetailPopModel orderPop : saleOrder.getOrdersDetailPop()) {
                        if (goods.getFlowId() != orderPop.getRowNo().intValue()) continue;
                        goods.getPopDetailsInfo().add(this.popdetailTransfer.transferPopDetail(orderPop));
                    }
                }
            }
            cacheModel.setReturnGoodsList(cachedGoodsList);
            String wkPayCode = "";
            String obj = this.redisUtil.get("business:initialize:cacheid:" + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj.toString(), ModeDetailsVo.class);
            List sysparaOut = modeDetailsVo.getSyspara();
            String paraValue = "";
            paraValue = ModeDetailsVo.getSysParaValue((List)sysparaOut, (String)"WKFS");
            if (null == paraValue || "".equals(paraValue)) {
                return Code.CODE_20132.getRespBase(new Object[0]);
            }
            wkPayCode = paraValue.trim();
            cacheModel.getOrder().setOriginShopCode(saleOrder.getOrders().getBusiTakeMarketCode());
            cacheModel.getOrder().setOriginTerminalNo(saleOrder.getOrders().getOriginTerminalNo());
            cacheModel.getOrder().setOriginTerminalSno(saleOrder.getOrders().getOriginTerminalSno());
            cacheModel.getOrder().setOriginIdSheetNo(saleOrder.getOrders().getSheetNo());
            cacheModel.getOrder().setSeqNo(saleOrder.getOrders().getCalcBillId());
            SimpleDateFormat s = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            cacheModel.getOrder().setSaleDate(s.format(new Date()));
            log.info("\u8f6c\u6362sellpayment");
            ArrayList<Payment> paymentList = new ArrayList<Payment>();
            int i = 0;
            double wkAmout = 0.0;
            for (OrdersPayModel ordersPayModel : saleOrder.getOrdersPay()) {
                if (!wkPayCode.equals(ordersPayModel.getPayCode())) {
                    Payment p = new Payment();
                    this.paymentTransfer.SaleOrderPayToPayment(ordersPayModel, p);
                    p.setIsAutoDelOnly(true);
                    p.setPuid(String.valueOf(UniqueID.getUniqueID()));
                    p.setIsSuccess(true);
                    p.setOriginSheetNo(cacheModel.getOrder().getOriginIdSheetNo());
                    p.setRowno(i++);
                    paymentList.add(p);
                    continue;
                }
                wkAmout = CastUtil.castDouble((Object)ordersPayModel.getMoney());
            }
            cacheModel.setReturnPayments(paymentList);
            Goods goods = new Goods();
            goods.setFlowNo(cacheModel.getFlowNo());
            goods.setFlowId(cacheModel.getGoodsList().size() + 1);
            goods.setGuid(UUIDUtils.buildGuid());
            goods.setGoodsCode(saleOrder.getOrders().getSheetNo());
            goods.setGoodsName("\u5c3e\u6b3e\u5546\u54c1");
            goods.setSalePrice(wkAmout);
            goods.setRealSalePrice(wkAmout);
            goods.setGoodsType("0");
            goods.setGoodsNo(saleOrder.getOrders().getSheetNo());
            goods.setBarNo(saleOrder.getOrders().getSheetNo());
            goods.setPrcutMode("A");
            goods.setQty(1.0);
            goods.setLicense(2);
            goods.setSaleValue(wkAmout);
            goods.setCategoryCode("00");
            goods.setSaleSpec(" ");
            goods.setAssistantId("");
            cacheModel.getGoodsList().add(goods);
            this.posLogicCompoment.calcOrderAmount(cacheModel);
            this.posLogicCompoment.calcPayBalance(cacheModel);
            return new RespBase(Code.SUCCESS, (Object)cacheModel, "QUERYTAILPAY");
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8c03\u7528\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            return new RespBase(Code.CODE_60007.getIndex(), e.getMessage());
        }
    }

    @Override
    public RespBase pickUp(ServiceSession session, JSONObject jsonObject) {
        PickUpIn pickUpIn = (PickUpIn)JSONObject.toJavaObject((JSON)jsonObject, PickUpIn.class);
        JSONObject temp = new JSONObject();
        temp.put("marketCode", (Object)pickUpIn.getShopCode());
        temp.put("terminalNo", (Object)pickUpIn.getTerminalNo());
        temp.put("terminalOperator", (Object)pickUpIn.getTerminalOperator());
        temp.put("originMarketCode", (Object)pickUpIn.getOriginShopCode());
        temp.put("originTerminalNo", (Object)pickUpIn.getOriginTerminalNo());
        temp.put("originTerminalSno", (Object)pickUpIn.getOriginTerminalSno());
        log.info("\u8ba2\u5355\u4e2d\u5fc3-\u63d0\u8d27start");
        com.product.model.ServiceResponse rs = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, PICKUPORDER, session, temp.toJSONString(), null, "\u8ba2\u5355\u4e2d\u5fc3", "\u63d0\u8d27");
        log.info("\u8ba2\u5355\u4e2d\u5fc3-\u63d0\u8d27-end ,{}", (Object)rs);
        if (!"0".equals(rs.getReturncode())) {
            return Code.CODE_60091.getRespBase(new Object[]{rs.getData()});
        }
        return new RespBase(Code.SUCCESS, rs.getData(), "PICKUP");
    }

    @Override
    public RespBase searchTemp(ServiceSession session, JSONObject paramsObject) {
        log.info("searchTemp{}", (Object)paramsObject.toJSONString());
        if (!paramsObject.containsKey((Object)"shopCode") || paramsObject.getString("shopCode").isEmpty()) {
            return Code.CODE_60001.getRespBase(new Object[]{"[shopCode]"});
        }
        if (!paramsObject.containsKey((Object)"flowNo") || paramsObject.getString("flowNo").isEmpty()) {
            return Code.CODE_60001.getRespBase(new Object[]{"[flowNo]"});
        }
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("flowNo", paramsObject.getString("flowNo"));
        map.put("shopCode", paramsObject.getString("shopCode"));
        log.info("\u7535\u5b50\u8ba2\u5355-\u67e5\u8be2\u8be6\u60c5start");
        com.product.model.ServiceResponse rs = this.httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, TEMPORDERDETAIL, session, JSON.toJSONString(map), null, "\u8ba2\u5355\u4e2d\u5fc3", "\u7535\u5b50\u8ba2\u5355-\u67e5\u8be2\u8be6\u60c5");
        log.info("\u8ba2\u5355\u4e2d\u5fc3-\u7535\u5b50\u8ba2\u5355\u67e5\u8be2\u8be6\u60c5-end ,{}", (Object)JSON.toJSONString((Object)rs));
        if (!"0".equals(rs.getReturncode())) {
            return new RespBase(Code.CODE_60042, "");
        }
        TempDetailOut tempDetailOut = (TempDetailOut)JSON.parseObject((String)JSONObject.toJSONString((Object)rs.getData()), TempDetailOut.class);
        if (tempDetailOut.getOrderstempdetail() == null || tempDetailOut.getOrderstempdetail().size() == 0) {
            return Code.CODE_60079.getRespBase(new Object[0]);
        }
        if (tempDetailOut.getOrderstemphead() == null) {
            return Code.CODE_60080.getRespBase(new Object[0]);
        }
        return new RespBase(Code.SUCCESS, (Object)tempDetailOut, "TEMPOUTORDER");
    }

    public RespBase setTempOrderDetailConsumer(ServiceSession session, CacheModel cacheModel, JSONObject paramsObject, TempDetailOut tempDetailOut, ResqVo respVos) {
        log.info("\u590d\u5236\u4f1a\u5458");
        paramsObject.put("testType", (Object)"C");
        paramsObject.put("channel", (Object)cacheModel.getOrder().getChannel());
        paramsObject.put("custNo", (Object)tempDetailOut.getOrderstemphead().getConsumersId());
        paramsObject.put("erpCode", (Object)cacheModel.getOrder().getErpCode());
        RespBase respBase = this.vipRemoteService.promotionVipLogin(session, respVos, paramsObject);
        return respBase;
    }

    @Override
    public RespBase getBinCardInfo(ServiceSession session, JSONObject paramsObject) {
        return null;
    }

    @Override
    public RespBase getBankInfo(ServiceSession session, JSONObject paramsObject) {
        return null;
    }

    public RespBase beforSaveSaleOrder(ServiceSession session, CacheModel cacheModel, String netType, String newTerminalSno) {
        return Code.SUCCESS.getRespBase(new Object[0]);
    }

    public CacheModel addGoodsDiscount(CacheModel cacheModel) {
        return cacheModel;
    }

    @Override
    public RespBase isExistPayInOrder(ServiceSession session, JSONObject paramsObject) {
        return null;
    }
}

