/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.dao.SaleOrdersDetailModelService;
import com.efuture.business.dao.SaleOrdersDetailPopModelService;
import com.efuture.business.dao.SaleOrdersExtModelService;
import com.efuture.business.dao.SaleOrdersGainDetailModelService;
import com.efuture.business.dao.SaleOrdersGainModelService;
import com.efuture.business.dao.SaleOrdersMemberModelService;
import com.efuture.business.dao.SaleOrdersModelService;
import com.efuture.business.dao.SaleOrdersPayModelService;
import com.efuture.business.dao.SaleOrdersUseCouponModelService;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderDetailPopModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderGainDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderGainModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderPayModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderUseCouponModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrdersExtModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrdersMemberModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrdersModel;
import com.efuture.business.service.OrderDataLocalService;
import com.efuture.business.util.DateHelpUtil;
import com.product.model.ServiceSession;
import java.util.ArrayList;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

public class SaleOrderDataLocalServiceImpl
implements OrderDataLocalService {
    private Logger log = LoggerFactory.getLogger(SaleOrderDataLocalServiceImpl.class);
    @Autowired
    private SaleOrdersModelService orderMapper;
    @Autowired
    private SaleOrdersMemberModelService ordersMemberMapper;
    @Autowired
    private SaleOrdersDetailModelService ordersDetailMapper;
    @Autowired
    private SaleOrdersDetailPopModelService ordersDetailPopMapper;
    @Autowired
    private SaleOrdersGainModelService ordersGainMapper;
    @Autowired
    private SaleOrdersGainDetailModelService ordersGainDetail;
    @Autowired
    private SaleOrdersUseCouponModelService ordersUseCouponMapper;
    @Autowired
    private SaleOrdersPayModelService ordersPayMapper;
    @Autowired
    private SaleOrdersExtModelService ordersExtMapper;

    @Override
    public RespBase selectOrderAll(ServiceSession session, String billDate, List<String> sheetNoList) {
        long t1 = System.currentTimeMillis();
        try {
            List<SaleOrdersModel> orders = this.orderMapper.selectByList(sheetNoList, "orders");
            if (orders.size() == 0) {
                return Code.CODE_60098.getRespBase(new Object[0]);
            }
            ArrayList<String> oids = new ArrayList<String>();
            for (SaleOrdersModel order : orders) {
                oids.add("" + order.getOid());
            }
            List<SaleOrderDetailModel> ordersDetails = this.ordersDetailMapper.selectByList(oids, "ordersdetail");
            List<SaleOrdersExtModel> ordersExts = this.ordersExtMapper.selectByList(oids, "ordersext");
            List<SaleOrdersMemberModel> ordersMembers = this.ordersMemberMapper.selectByList(oids, "ordersmember");
            List<SaleOrderPayModel> ordersPays = this.ordersPayMapper.selectByList(oids, "orderspay");
            List<SaleOrderDetailPopModel> ordersDetailPops = this.ordersDetailPopMapper.selectByList(oids, "ordersdetailpop");
            List<SaleOrderGainModel> ordersGains = this.ordersGainMapper.selectByList(oids, "ordersgain");
            List<SaleOrderGainDetailModel> ordersGainDetails = this.ordersGainDetail.selectByList(oids, "ordersgaindetail");
            List<SaleOrderUseCouponModel> ordersUseCoupons = this.ordersUseCouponMapper.selectByList(oids, "ordersusecoupon");
            long t2 = System.currentTimeMillis();
            this.log.info("\u672c\u5730\u8ba2\u5355\u6570\u636e\u5e93[" + billDate + "],\u67e5\u8be2\u8017\u65f6[ms]: " + (t2 - t1));
            JSONArray ordersJson = JSON.parseArray((String)JSON.toJSONString(orders));
            for (Object obj : ordersJson) {
                JSONObject json = (JSONObject)obj;
                json.put("rePrintCnt", (Object)0);
            }
            JSONArray osJson = this.parseOrderResult(ordersDetails, ordersExts, ordersMembers, ordersPays, ordersDetailPops, ordersGains, ordersGainDetails, ordersUseCoupons, ordersJson);
            long t3 = System.currentTimeMillis();
            this.log.info("\u672c\u5730\u8ba2\u5355\u6570\u636e\u5e93[" + billDate + "],\u7ec4\u88c5\u7ed3\u679c\u8017\u65f6[ms]: " + (t3 - t2));
            return new RespBase(Code.SUCCESS, (Object)osJson);
        }
        catch (Exception e) {
            this.log.error(e.getMessage(), (Throwable)e);
            this.log.error("\u67e5\u8be2\u672c\u5730\u8ba2\u5355\u5e93 ERROR:" + e.getMessage());
            return Code.CODE_60028.getRespBase(new Object[]{"ERROR:" + e.getMessage()});
        }
    }

    @Override
    public RespBase selectOrderPay(ServiceSession session, JSONObject param) {
        QueryWrapper queryWrapper = new QueryWrapper();
        queryWrapper.eq((Object)"payNo", (Object)param.getString("payNo"));
        List orderspay = this.ordersPayMapper.selectList(queryWrapper, "orderspay");
        if (orderspay != null && orderspay.size() > 0) {
            return Code.CODE_50103.getRespBase(new Object[0]);
        }
        return new RespBase(Code.SUCCESS);
    }

    public JSONArray parseOrderResult(List<SaleOrderDetailModel> ordersDetails, List<SaleOrdersExtModel> ordersExts, List<SaleOrdersMemberModel> ordersMembers, List<SaleOrderPayModel> ordersPays, List<SaleOrderDetailPopModel> ordersDetailPops, List<SaleOrderGainModel> ordersGains, List<SaleOrderGainDetailModel> ordersGainDetails, List<SaleOrderUseCouponModel> ordersUseCoupons, JSONArray ordersJson) {
        JSONArray saleorders = new JSONArray();
        for (Object obj : ordersJson) {
            JSONArray array;
            JSONObject osJson = new JSONObject();
            JSONObject order = (JSONObject)obj;
            long oid = order.getLong("oid");
            if (!StringUtils.isEmpty((Object)order.get((Object)"createDate"))) {
                order.put("createDate", (Object)DateHelpUtil.getDateStringFromMillisecond((Long)osJson.getLongValue("createDate")));
            }
            if (!StringUtils.isEmpty((Object)osJson.get((Object)"receiveDate"))) {
                order.put("receiveDate", (Object)DateHelpUtil.getDateStringFromMillisecond((Long)osJson.getLongValue("receiveDate")));
            }
            if (!StringUtils.isEmpty((Object)osJson.get((Object)"lastDate"))) {
                order.put("lastDate", (Object)DateHelpUtil.getDateStringFromMillisecond((Long)osJson.getLongValue("lastDate")));
            }
            if (!StringUtils.isEmpty((Object)osJson.get((Object)"saleDate"))) {
                order.put("saleDate", (Object)DateHelpUtil.getDateStringFromMillisecond((Long)osJson.getLongValue("saleDate")));
            }
            if (!StringUtils.isEmpty((Object)osJson.get((Object)"billDate"))) {
                order.put("billDate", (Object)DateHelpUtil.getDateStringFromMillisecond((Long)osJson.getLongValue("billDate")));
            }
            osJson.put("saleOrders", (Object)order);
            if (ordersDetails.size() > 0) {
                array = new JSONArray();
                for (SaleOrderDetailModel saleOrderDetailModel : ordersDetails) {
                    if (oid != saleOrderDetailModel.getOid()) continue;
                    array.add((Object)saleOrderDetailModel);
                }
                osJson.put("saleOrderDetail", (Object)array);
            }
            if (ordersExts.size() > 0) {
                for (SaleOrdersExtModel saleOrdersExtModel : ordersExts) {
                    if (oid != saleOrdersExtModel.getOid()) continue;
                    osJson.put("saleOrdersExt", (Object)saleOrdersExtModel);
                    break;
                }
            }
            if (ordersMembers.size() > 0) {
                for (SaleOrdersMemberModel saleOrdersMemberModel : ordersMembers) {
                    if (oid != saleOrdersMemberModel.getOid()) continue;
                    osJson.put("saleOrdersMember", (Object)saleOrdersMemberModel);
                    break;
                }
            }
            if (ordersPays.size() > 0) {
                array = new JSONArray();
                for (SaleOrderPayModel saleOrderPayModel : ordersPays) {
                    if (oid != saleOrderPayModel.getOid()) continue;
                    array.add((Object)saleOrderPayModel);
                }
                osJson.put("saleOrderPay", (Object)array);
            }
            if (ordersDetailPops.size() > 0) {
                array = new JSONArray();
                for (SaleOrderDetailPopModel saleOrderDetailPopModel : ordersDetailPops) {
                    if (oid != saleOrderDetailPopModel.getOid()) continue;
                    array.add((Object)saleOrderDetailPopModel);
                }
                osJson.put("saleOrderDetailPop", (Object)array);
            }
            if (ordersGains.size() > 0) {
                array = new JSONArray();
                for (SaleOrderGainModel saleOrderGainModel : ordersGains) {
                    if (oid != saleOrderGainModel.getOid()) continue;
                    array.add((Object)saleOrderGainModel);
                }
                osJson.put("saleOrderGain", (Object)array);
            }
            if (ordersGainDetails.size() > 0) {
                array = new JSONArray();
                for (SaleOrderGainDetailModel saleOrderGainDetailModel : ordersGainDetails) {
                    if (oid != saleOrderGainDetailModel.getOid()) continue;
                    array.add((Object)saleOrderGainDetailModel);
                }
                osJson.put("saleOrderGainDetail", (Object)array);
            }
            if (ordersUseCoupons.size() > 0) {
                array = new JSONArray();
                for (SaleOrderUseCouponModel saleOrderUseCouponModel : ordersUseCoupons) {
                    if (oid != saleOrderUseCouponModel.getOid()) continue;
                    array.add((Object)saleOrderUseCouponModel);
                }
                osJson.put("saleOrderUseCoupon", (Object)array);
            }
            saleorders.add((Object)osJson);
        }
        return saleorders;
    }
}

