/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.struct.LogisticsModeEnum;
import com.efuture.business.mapper.zbcs.SaleOrderIndexModelMapper;
import com.efuture.business.mapper.zbcs.SaleOrderStatisticsMapper;
import com.efuture.business.model.PayModeCache;
import com.efuture.business.service.OrderStatisticsService;
import com.efuture.business.util.DateHelpUtil;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.db.DbTools;
import com.efuture.business.util.db.MultipleDataSource;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import com.product.util.ParamValidateUtil;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;

public class SaleOrderStatisticsServiceImpl
implements OrderStatisticsService {
    private static final Logger log = LoggerFactory.getLogger(SaleOrderStatisticsServiceImpl.class);
    @Autowired
    private DbTools dbTools;
    @Autowired
    SaleOrderStatisticsMapper saleOrderStatisticsMapper;
    @Autowired
    SaleOrderIndexModelMapper saleOrderIndexModelMapper;
    @Value(value="${localcache.enabled}")
    private Boolean localcache;
    @Value(value="${hazelcast.enabled:false}")
    private Boolean hazelcast;
    @Autowired
    private RedisUtil redisUtil;
    private static final String BUSINESS_CLOSE_TIME = " 05:00:00";

    @Override
    public RespBase searchTerminalReport(ServiceSession session, JSONObject paramsObject) {
        ParamValidateUtil.paramCheck((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"createDate", "busiTakeMarketCode", "terminalOperator", "erpCode", "searchType"});
        session.setShop_code(paramsObject.getString("busiTakeMarketCode"));
        int searchType = paramsObject.getIntValue("searchType");
        if (searchType == 3) {
            ParamValidateUtil.paramCheck((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"terminalNo"});
        }
        JSONObject result = new JSONObject();
        try {
            List<Map<String, Object>> report1;
            long t1 = System.currentTimeMillis();
            MultipleDataSource.setDataSourceKey((String)this.dbTools.FilterDatesrc("orders"));
            if (this.localcache.booleanValue() || this.hazelcast.booleanValue()) {
                String s = this.formatBillDate(paramsObject.getDate("createDate"));
                if (StringUtils.isEmpty((Object)s)) {
                    return Code.CODE_60123.getRespBase(new Object[0]);
                }
                log.info("\u8131\u673a\u67e5\u5bfb\u8ba2\u5355\u5217\u8868\u65e5\u671f:" + s);
                MultipleDataSource.setLocDataSourceKey((String)s);
            }
            if ((report1 = this.saleOrderStatisticsMapper.searchTerminalReport1(paramsObject)) != null && report1.size() > 0 && report1.get(0) != null) {
                if (!StringUtils.isEmpty((Object)report1.get(0).get("lsxsCount"))) {
                    result.put("totalSaleCnt", (Object)Integer.parseInt(report1.get(0).get("lsxsCount").toString()));
                } else {
                    result.put("totalSaleCnt", (Object)0);
                }
                if (!StringUtils.isEmpty((Object)report1.get(0).get("lsxsMoneySum"))) {
                    result.put("totalSaleAmt", (Object)new BigDecimal(report1.get(0).get("lsxsMoneySum").toString()));
                } else {
                    result.put("totalSaleAmt", (Object)BigDecimal.ZERO);
                }
                if (!StringUtils.isEmpty((Object)report1.get(0).get("lsthCount"))) {
                    result.put("totalReturnCnt", (Object)Integer.parseInt(report1.get(0).get("lsthCount").toString()));
                } else {
                    result.put("totalReturnCnt", (Object)0);
                }
                if (!StringUtils.isEmpty((Object)report1.get(0).get("lsthMoneySum")) && new BigDecimal(report1.get(0).get("lsthMoneySum").toString()).compareTo(new BigDecimal("0")) > 0) {
                    result.put("totalReturnAmt", (Object)new BigDecimal("-" + report1.get(0).get("lsthMoneySum")));
                } else {
                    result.put("totalReturnAmt", (Object)BigDecimal.ZERO);
                }
                if (!StringUtils.isEmpty((Object)report1.get(0).get("hcxsCount"))) {
                    result.put("totalHcSaleCnt", (Object)Integer.parseInt(report1.get(0).get("hcxsCount").toString()));
                } else {
                    result.put("totalHcSaleCnt", (Object)0);
                }
                if (!StringUtils.isEmpty((Object)report1.get(0).get("hcxsMoneySum")) && new BigDecimal(report1.get(0).get("hcxsMoneySum").toString()).compareTo(new BigDecimal("0")) > 0) {
                    result.put("totalHcSaleAmt", (Object)new BigDecimal("-" + report1.get(0).get("hcxsMoneySum")));
                } else {
                    result.put("totalHcSaleAmt", (Object)BigDecimal.ZERO);
                }
            } else {
                result.put("totalSaleCnt", (Object)0);
                result.put("totalSaleAmt", (Object)0);
                result.put("totalReturnCnt", (Object)0);
                result.put("totalReturnAmt", (Object)0);
                result.put("totalHcSaleCnt", (Object)0);
                result.put("totalHcSaleAmt", (Object)0);
            }
            List<Map<String, Object>> report2 = this.saleOrderStatisticsMapper.searchTerminalReport2(paramsObject);
            if (report2 != null && report2.size() > 0 && report2.get(0) != null && !StringUtils.isEmpty((Object)report2.get(0).get("erpCode"))) {
                int ovgCount = 0;
                BigDecimal ovgMoney = new BigDecimal(0);
                if (!StringUtils.isEmpty((Object)report2.get(0).get("lsxsOvgCount"))) {
                    ovgCount += Integer.parseInt(report2.get(0).get("lsxsOvgCount").toString());
                }
                if (!StringUtils.isEmpty((Object)report2.get(0).get("hcxsOvgCount"))) {
                    ovgCount += Integer.parseInt(report2.get(0).get("hcxsOvgCount").toString());
                }
                if (!StringUtils.isEmpty((Object)report2.get(0).get("lsthOvgCount"))) {
                    ovgCount += Integer.parseInt(report2.get(0).get("lsthOvgCount").toString());
                }
                if (!StringUtils.isEmpty((Object)report2.get(0).get("lsxsOvgMoney"))) {
                    ovgMoney = ovgMoney.add(new BigDecimal(report2.get(0).get("lsxsOvgMoney").toString()));
                }
                if (!StringUtils.isEmpty((Object)report2.get(0).get("hcxsOvgMoney"))) {
                    ovgMoney = ovgMoney.subtract(new BigDecimal(report2.get(0).get("hcxsOvgMoney").toString()));
                }
                if (!StringUtils.isEmpty((Object)report2.get(0).get("lsthOvgMoney"))) {
                    ovgMoney = ovgMoney.subtract(new BigDecimal(report2.get(0).get("lsthOvgMoney").toString()));
                }
                result.put("overageCnt", (Object)ovgCount);
                result.put("overageAmt", (Object)ovgMoney.multiply(BigDecimal.valueOf(-1L)));
            } else {
                result.put("overageCnt", (Object)0);
                result.put("overageAmt", (Object)0);
            }
            JSONArray payReportFinal = new JSONArray();
            List<Map<String, Object>> report3 = this.saleOrderStatisticsMapper.searchTerminalReport3(paramsObject);
            JSONArray cashPayFinal = new JSONArray();
            if (report3 != null && report3.size() > 0 && report3.get(0) != null) {
                JSONObject payDe;
                JSONArray payReport = JSON.parseArray((String)JSON.toJSONString(report3));
                JSONArray payReportByPaying = new JSONArray();
                JSONArray payReportByChange = new JSONArray();
                for (Object payObj : payReport) {
                    payDe = (JSONObject)payObj;
                    if (payDe.getIntValue("flag") == 1) {
                        payReportByPaying.add((Object)payDe);
                        continue;
                    }
                    payReportByChange.add((Object)payDe);
                }
                HashMap<String, JSONObject> payReportByChangeMap = new HashMap<String, JSONObject>();
                if (payReportByChange.size() > 0) {
                    for (Object payObj : payReportByChange) {
                        payDe = (JSONObject)payObj;
                        payReportByChangeMap.put(payDe.getString("payCode"), payDe);
                    }
                }
                if (payReportByPaying.size() > 0) {
                    for (Object payObj : payReportByPaying) {
                        payDe = (JSONObject)payObj;
                        if (!payReportByChangeMap.containsKey(payDe.getString("payCode"))) continue;
                        JSONObject payChange = (JSONObject)payReportByChangeMap.get(payDe.getString("payCode"));
                        payDe.put("lsxsMoneySum", (Object)payDe.getBigDecimal("lsxsMoneySum").subtract(payChange.getBigDecimal("lsxsMoneySum")));
                        payDe.put("hcxsMoneySum", (Object)payDe.getBigDecimal("hcxsMoneySum").subtract(payChange.getBigDecimal("hcxsMoneySum")));
                        payDe.put("lsthMoneySum", (Object)payDe.getBigDecimal("lsthMoneySum").subtract(payChange.getBigDecimal("lsthMoneySum")));
                    }
                }
                if (payReportByPaying.size() > 0) {
                    for (Object payObj : payReportByPaying) {
                        JSONObject payFinal = new JSONObject();
                        payDe = (JSONObject)payObj;
                        if (payDe.getString("payType").equals("0")) {
                            cashPayFinal.add((Object)payDe);
                        }
                        BigDecimal totalAmt = new BigDecimal(0);
                        int totalCnt = payDe.getIntValue("lsxsCount") + payDe.getIntValue("hcxsCount") + payDe.getIntValue("lsthCount");
                        totalAmt = totalAmt.add(payDe.getBigDecimal("lsxsMoneySum")).subtract(payDe.getBigDecimal("hcxsMoneySum")).subtract(payDe.getBigDecimal("lsthMoneySum"));
                        payFinal.put("payType", (Object)payDe.getString("payType"));
                        payFinal.put("payCode", (Object)payDe.getString("payCode"));
                        payFinal.put("payName", (Object)payDe.getString("payName"));
                        payFinal.put("totalCnt", (Object)totalCnt);
                        payFinal.put("totalAmt", (Object)totalAmt);
                        payReportFinal.add((Object)payFinal);
                    }
                }
            }
            JSONObject overagePay = new JSONObject();
            overagePay.put("payName", (Object)"\u820d\u5165\u8c03\u6574");
            overagePay.put("totalCnt", result.get((Object)"overageCnt"));
            overagePay.put("totalAmt", result.get((Object)"overageAmt"));
            result.remove((Object)"overageCnt");
            result.remove((Object)"overageAmt");
            payReportFinal.add((Object)overagePay);
            result.put("payReport", (Object)payReportFinal);
            if (cashPayFinal.size() > 0) {
                result.put("cashTotalSaleCnt", (Object)0);
                result.put("cashTotalSaleAmt", (Object)0);
                result.put("cashTotalReturnCnt", (Object)0);
                result.put("cashTotalReturnAmt", (Object)0);
                result.put("cashTotalHcSaleCnt", (Object)0);
                result.put("cashTotalHcSaleAmt", (Object)0);
                for (Object payObj : cashPayFinal) {
                    JSONObject payDe = (JSONObject)payObj;
                    result.put("cashTotalSaleCnt", (Object)(result.getIntValue("cashTotalSaleCnt") + payDe.getIntValue("lsxsCount")));
                    result.put("cashTotalSaleAmt", (Object)result.getBigDecimal("cashTotalSaleAmt").add(payDe.getBigDecimal("lsxsMoneySum")));
                    result.put("cashTotalReturnCnt", (Object)(result.getIntValue("cashTotalReturnCnt") + payDe.getIntValue("lsthCount")));
                    result.put("cashTotalReturnAmt", (Object)result.getBigDecimal("cashTotalReturnAmt").add(payDe.getBigDecimal("lsthMoneySum")));
                    result.put("cashTotalHcSaleCnt", (Object)(result.getIntValue("cashTotalHcSaleCnt") + payDe.getIntValue("hcxsCount")));
                    result.put("cashTotalHcSaleAmt", (Object)result.getBigDecimal("cashTotalHcSaleAmt").add(payDe.getBigDecimal("hcxsMoneySum")));
                }
                if (result.getBigDecimal("cashTotalReturnAmt").compareTo(BigDecimal.valueOf(0L)) != 0) {
                    result.put("cashTotalReturnAmt", (Object)result.getBigDecimal("cashTotalReturnAmt").multiply(BigDecimal.valueOf(-1L)));
                }
                if (result.getBigDecimal("cashTotalHcSaleAmt").compareTo(BigDecimal.valueOf(0L)) != 0) {
                    result.put("cashTotalHcSaleAmt", (Object)result.getBigDecimal("cashTotalHcSaleAmt").multiply(BigDecimal.valueOf(-1L)));
                }
            }
            result.put("scanOperationTime", (Object)"00:00");
            result.put("cashierOperationTime", (Object)"00:00");
            log.info("POS\u603b\u90e8\u67e5\u8be2\u7ec8\u7aef\u65e5\u62a5,\u67e5\u8be2\u7c7b\u578b\uff1a" + searchType + ", \u8fd4\u56de\u6570\u636e: " + result.toJSONString());
            log.error("POS\u603b\u90e8\u67e5\u8be2\u7ec8\u7aef\u65e5\u62a5,\u8017\u65f6[ms]: " + (System.currentTimeMillis() - t1));
            return new RespBase(Code.SUCCESS, (Object)result);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            log.error("POS\u603b\u90e8\u67e5\u8be2\u7ec8\u7aef\u65e5\u62a5\u9519\u8bef: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return Code.CODE_60028.getRespBase(new Object[]{e.getMessage()});
        }
    }

    @Override
    public RespBase searchIntegralReport(ServiceSession session, JSONObject paramsObject) {
        return null;
    }

    @Override
    public RespBase searchGroupReport(ServiceSession session, JSONObject paramsObject) {
        return null;
    }

    @Override
    public RespBase searchElectronicReport(ServiceSession session, JSONObject paramsObject) {
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ServiceResponse getClearingMachineInfo(ServiceSession session, JSONObject paramsObject) {
        Map<String, String> dateParam;
        JSONObject param;
        ArrayList<String> ocPays;
        JSONObject result;
        long t1;
        block76: {
            t1 = System.currentTimeMillis();
            ServiceResponse check = ParamValidateUtil.checkParam((ServiceSession)session, (JSONObject)paramsObject, (String[])new String[]{"terminalNo", "terminalOperator", "saleMarket", "shopCode", "loan", "middleCollection", "searchType", "payCode", "mkt"});
            if (!check.getReturncode().equals("0")) {
                return check;
            }
            result = new JSONObject();
            ocPays = new ArrayList<String>();
            ocPays.add("0306");
            ocPays.add("0303");
            ocPays.add("0307");
            result.put("saleMarket", (Object)paramsObject.getString("saleMarket"));
            result.put("terminalNo", (Object)paramsObject.getString("terminalNo"));
            result.put("terminalOperator", (Object)paramsObject.getString("terminalOperator"));
            result.put("shopCode", (Object)paramsObject.getString("shopCode"));
            param = new JSONObject();
            param.put("terminalNo", (Object)paramsObject.getString("terminalNo"));
            dateParam = this.computesClearTime();
            if (dateParam != null) break block76;
            ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)"\u8ba1\u7b97 \u6e05\u673a\u5f00\u59cb/\u7ed3\u675f\u65f6\u95f4 \u5931\u8d25");
            return serviceResponse;
        }
        try {
            List<Map<String, Object>> ra16;
            param.put("billStartDate", (Object)dateParam.get("startTime"));
            param.put("billEndDate", (Object)dateParam.get("endTime"));
            param.put("terminalOperator", (Object)paramsObject.getString("terminalOperator"));
            param.put("searchType", (Object)paramsObject.getString("searchType"));
            param.put("marketCode", (Object)paramsObject.getString("mkt"));
            ArrayList<String> exOrderTypeList = new ArrayList<String>();
            exOrderTypeList.add("Y3");
            exOrderTypeList.add("Y9");
            param.put("exOrderTypeList", exOrderTypeList);
            List<Map<String, Object>> ra1 = this.saleOrderIndexModelMapper.clearMachine01(param);
            result.put("saleOrderCount", ra1.get(0).get("totalCount"));
            if (ra1 != null && ra1.size() > 0 && !StringUtils.isEmpty((Object)ra1.get(0).get("totalMoney"))) {
                result.put("saleOrderMoney", ra1.get(0).get("totalMoney"));
            } else {
                result.put("saleOrderMoney", (Object)0);
            }
            exOrderTypeList.clear();
            param.remove((Object)"exOrderTypeList");
            List<Map<String, Object>> ra2 = this.saleOrderIndexModelMapper.clearMachine02(param);
            result.put("returnOrderCount", ra2.get(0).get("totalCount"));
            if (ra2 != null && ra2.size() > 0 && !StringUtils.isEmpty((Object)ra2.get(0).get("totalMoney"))) {
                result.put("returnOrderMoney", ra2.get(0).get("totalMoney"));
            } else {
                result.put("returnOrderMoney", (Object)0);
            }
            HashMap<String, Object> stampListInfo = new HashMap<String, Object>();
            exOrderTypeList.add("Y12");
            param.put("exOrderTypeList", exOrderTypeList);
            List<Map<String, Object>> ra12 = this.saleOrderIndexModelMapper.clearMachine01(param);
            if (ra12 != null && ra12.size() > 0 && !StringUtils.isEmpty((Object)ra12.get(0).get("totalElectronicStamp")) && !StringUtils.isEmpty((Object)ra12.get(0).get("totalPhysicalStamp"))) {
                stampListInfo.put("stampPayoutESale", ra12.get(0).get("totalElectronicStamp"));
                stampListInfo.put("stampPayoutPSale", ra12.get(0).get("totalPhysicalStamp"));
            } else {
                stampListInfo.put("stampPayoutESale", 0);
                stampListInfo.put("stampPayoutPSale", 0);
            }
            List<Map<String, Object>> ra13 = this.saleOrderIndexModelMapper.clearMachine02(param);
            if (ra13 != null && ra13.size() > 0 && !StringUtils.isEmpty((Object)ra13.get(0).get("totalElectronicStamp")) && !StringUtils.isEmpty((Object)ra13.get(0).get("totalPhysicalStamp"))) {
                stampListInfo.put("stampPayoutEReturn", ra13.get(0).get("totalElectronicStamp"));
                stampListInfo.put("stampPayoutPReturn", ra13.get(0).get("totalPhysicalStamp"));
            } else {
                stampListInfo.put("stampPayoutEReturn", 0);
                stampListInfo.put("stampPayoutPReturn", 0);
            }
            exOrderTypeList.clear();
            param.remove((Object)"exOrderTypeList");
            result.put("stampPayoutE", (Object)new BigDecimal(stampListInfo.get("stampPayoutESale").toString()).subtract(new BigDecimal(stampListInfo.get("stampPayoutEReturn").toString())));
            result.put("stampPayoutP", (Object)new BigDecimal(stampListInfo.get("stampPayoutPSale").toString()).subtract(new BigDecimal(stampListInfo.get("stampPayoutPReturn").toString())));
            param.remove((Object)"exOrderType");
            param.put("orderType", (Object)"Y12");
            List<Map<String, Object>> ra14 = this.saleOrderIndexModelMapper.clearMachine01(param);
            if (ra14 != null && ra14.size() > 0 && !StringUtils.isEmpty((Object)ra14.get(0).get("totalElectronicStamp")) && !StringUtils.isEmpty((Object)ra14.get(0).get("totalPhysicalStamp"))) {
                result.put("stampRedeemE", ra14.get(0).get("totalElectronicStamp"));
                result.put("stampRedeemP", ra14.get(0).get("totalPhysicalStamp"));
            } else {
                result.put("stampRedeemE", (Object)0);
                result.put("stampRedeemP", (Object)0);
            }
            param.remove((Object)"orderType");
            ArrayList<Integer> modeList = new ArrayList<Integer>();
            modeList.add(LogisticsModeEnum.DCSH.getCode());
            param.put("modeList", modeList);
            List<Map<String, Object>> ra3 = this.saleOrderIndexModelMapper.clearMachine01(param);
            List<Map<String, Object>> ra9 = this.saleOrderIndexModelMapper.clearMachine06(param);
            result.put("dcOrderCount", ra3.get(0).get("totalCount"));
            if (ra3 != null && ra3.size() > 0 && !StringUtils.isEmpty((Object)ra3.get(0).get("totalMoney"))) {
                result.put("dcOrderMoney", ra3.get(0).get("totalMoney"));
            } else {
                result.put("dcOrderMoney", (Object)0);
            }
            if (ra9 != null && ra9.size() > 0 && !StringUtils.isEmpty((Object)ra9.get(0).get("totalMoney"))) {
                result.put("dcOrderCount", (Object)new BigDecimal(ra3.get(0).get("totalCount").toString()).subtract(new BigDecimal(ra9.get(0).get("totalCount").toString())));
                BigDecimal dcOrderMoney = new BigDecimal(result.getString("dcOrderMoney"));
                result.put("dcOrderMoney", (Object)dcOrderMoney.subtract(new BigDecimal("" + ra9.get(0).get("totalMoney"))));
            }
            if (ocPays != null && ocPays.size() > 0) {
                param.put("ocList", ocPays);
            }
            List<Map<String, Object>> ra10 = this.saleOrderIndexModelMapper.clearMachine07(param);
            List<Map<String, Object>> ra11 = this.saleOrderIndexModelMapper.clearMachine08(param);
            if (ra10 != null && ra10.size() > 0 && !StringUtils.isEmpty((Object)ra10.get(0).get("totalMoney"))) {
                result.put("hpBalance", ra10.get(0).get("totalMoney"));
            } else {
                result.put("hpBalance", (Object)0);
            }
            if (ra11 != null && ra11.size() > 0 && !StringUtils.isEmpty((Object)ra11.get(0).get("totalMoney"))) {
                BigDecimal hpBalance = new BigDecimal(result.getString("hpBalance"));
                result.put("hpBalance", (Object)hpBalance.subtract(new BigDecimal("" + ra10.get(0).get("totalMoney"))));
            }
            param.remove((Object)"modeList");
            param.remove((Object)"ocList");
            BigDecimal neAmount = new BigDecimal(0);
            if (!StringUtils.isEmpty((Object)result.getString("saleOrderMoney"))) {
                neAmount = neAmount.add(new BigDecimal(result.getString("saleOrderMoney"))).subtract(new BigDecimal(result.getString("returnOrderMoney"))).subtract(new BigDecimal(result.getString("dcOrderMoney")));
            }
            result.put("netSales", (Object)neAmount);
            BigDecimal totalAmountByPay = new BigDecimal(0);
            String hc = this.redisUtil.get(RedisKey.CACHEID + paramsObject.getString("shopCode") + paramsObject.getString("terminalNo"));
            ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)hc, ModeDetailsVo.class);
            List payInfos = modeDetailsVo.getPaymode();
            ArrayList<String> payTicketList = new ArrayList<String>();
            if (payInfos != null && payInfos.size() > 0) {
                Map<String, Integer> payOthers;
                Map<String, Object> map3;
                List<Map<String, Object>> ra4 = this.saleOrderIndexModelMapper.clearMachine03(param);
                List<Map<String, Object>> ra15 = this.saleOrderIndexModelMapper.clearMachine09(param);
                ra16 = this.saleOrderIndexModelMapper.clearMachine10(param);
                if (ra15 != null && ra15.size() > 0) {
                    for (Map<String, Object> map2 : ra15) {
                        double i = Double.parseDouble(map2.get("factMoney").toString());
                        map2.put("factMoney", -i);
                    }
                    ra4.addAll(ra15);
                }
                if (ra16 != null && ra16.size() > 0) {
                    ra4.addAll(ra16);
                }
                ArrayList<String> payCodes = new ArrayList<String>();
                Iterator<Map<String, Object>> payCodesOther = new ArrayList();
                ArrayList<String> payCreditsList = new ArrayList<String>();
                payCreditsList.add("0301");
                payCreditsList.add("0310");
                payCreditsList.add("0309");
                payCreditsList.add("0308");
                ArrayList<String> payAgingList = new ArrayList<String>();
                payAgingList.add("0303");
                payAgingList.add("0306");
                ArrayList<String> payMicroList = new ArrayList<String>();
                payMicroList.add("0901");
                payMicroList.add("0903");
                for (PayModeCache obj : payInfos) {
                    if (obj.getCode().equals("1")) {
                        payCodes.add(obj.getCode());
                    } else {
                        payCodesOther.add((Map<String, Object>)((Object)obj.getCode()));
                    }
                    if (!obj.getVirtualPayType().equals("1")) continue;
                    payTicketList.add(obj.getCode());
                }
                payCodesOther.removeAll(payCreditsList);
                payCodesOther.removeAll(payAgingList);
                payCodesOther.removeAll(payMicroList);
                BigDecimal cashAmountByPay = new BigDecimal(0);
                BigDecimal tailPayTotalAmount = new BigDecimal(0);
                HashMap<String, Map<String, Integer>> amountByPay = new HashMap<String, Map<String, Integer>>();
                HashMap<Object, Map<String, Integer>> creditByPay = new HashMap<Object, Map<String, Integer>>();
                HashMap<Object, Map<String, Integer>> agingByPay = new HashMap<Object, Map<String, Integer>>();
                HashMap<Object, Map<String, Integer>> microByPay = new HashMap<Object, Map<String, Integer>>();
                if (ra4 != null && ra4.size() > 0) {
                    for (Map<String, Object> map3 : ra4) {
                        if (StringUtils.isEmpty(map3.get("factMoney"))) continue;
                        BigDecimal money = new BigDecimal(map3.get("factMoney").toString());
                        if (payCodes.contains(map3.get("payCode").toString())) {
                            if (map3.get("flag").toString().equals("1")) {
                                cashAmountByPay = cashAmountByPay.add(money);
                            } else if (map3.get("flag").toString().equals("2")) {
                                cashAmountByPay = cashAmountByPay.subtract(money);
                            }
                        } else if (payCreditsList.contains(map3.get("payCode").toString())) {
                            payName = map3.get("payName").toString();
                            if (creditByPay.containsKey(payName)) {
                                payCredit = (Map)creditByPay.get(payName);
                                payCredit.put("amount", (Integer)((Object)money.add(new BigDecimal(payCredit.get("amount").toString()))));
                                payCredit.put("num", Integer.parseInt(payCredit.get("num").toString()) + 1);
                            } else {
                                payCredit = new HashMap();
                                payCredit.put("amount", (Integer)((Object)money));
                                payCredit.put("num", 1);
                                creditByPay.put(payName, payCredit);
                            }
                        } else if (payAgingList.contains(map3.get("payCode").toString())) {
                            payName = "";
                            if (map3.get("refCode").toString().equals("0")) {
                                payName = map3.get("payName") + " HP";
                            } else {
                                Object refCode = map3.get("refCode").toString();
                                if (((String)refCode).length() == 1) {
                                    refCode = "0" + (String)refCode;
                                }
                                payName = map3.get("payName") + " HP " + (String)refCode;
                            }
                            if (agingByPay.containsKey(payName)) {
                                payAging = (Map)agingByPay.get(payName);
                                payAging.put("amount", (Integer)((Object)money.add(new BigDecimal(payAging.get("amount").toString()))));
                                payAging.put("num", Integer.parseInt(payAging.get("num").toString()) + 1);
                            } else {
                                payAging = new HashMap();
                                payAging.put("amount", (Integer)((Object)money));
                                payAging.put("num", 1);
                                agingByPay.put(payName, payAging);
                            }
                        } else if (payMicroList.contains(map3.get("payCode").toString())) {
                            payName = map3.get("payName").toString();
                            if (microByPay.containsKey(payName)) {
                                payMicro = (Map)microByPay.get(payName);
                                payMicro.put("amount", (Integer)((Object)money.add(new BigDecimal(payMicro.get("amount").toString()))));
                                payMicro.put("num", Integer.parseInt(payMicro.get("num").toString()) + 1);
                            } else {
                                payMicro = new HashMap();
                                payMicro.put("amount", (Integer)((Object)money));
                                payMicro.put("num", 1);
                                microByPay.put(payName, payMicro);
                            }
                        } else if (amountByPay.containsKey(map3.get("payCode").toString())) {
                            payOthers = (Map)amountByPay.get(map3.get("payCode").toString());
                            payOthers.put("amount", (Integer)((Object)money.add(new BigDecimal(payOthers.get("amount").toString()))));
                            payOthers.put("num", Integer.parseInt(payOthers.get("num").toString()) + 1);
                        } else {
                            payOthers = new HashMap();
                            payOthers.put("amount", (Integer)((Object)money));
                            payOthers.put("num", 1);
                            amountByPay.put(map3.get("payCode").toString(), payOthers);
                        }
                        if (map3.get("payCode").toString().equals(paramsObject.getString("payCode"))) {
                            tailPayTotalAmount = tailPayTotalAmount.add(money);
                        }
                        if (map3.get("flag").toString().equals("1")) {
                            totalAmountByPay = totalAmountByPay.add(money);
                            continue;
                        }
                        totalAmountByPay = totalAmountByPay.subtract(money);
                    }
                }
                HashMap<String, Map> amountByPayAll = new HashMap<String, Map>();
                map3 = payCodesOther.iterator();
                while (map3.hasNext()) {
                    String payName = (String)map3.next();
                    if (amountByPay.containsKey(payName)) {
                        amountByPayAll.put(payName, (Map)amountByPay.get(payName));
                        continue;
                    }
                    payOthers = new HashMap<String, Number>();
                    payOthers.put("amount", 0);
                    payOthers.put("num", 0);
                    amountByPayAll.put(payName, payOthers);
                }
                HashMap creditByPayNew = new HashMap();
                creditByPayNew = creditByPay;
                for (String key : creditByPayNew.keySet()) {
                    amountByPayAll.put(key, (Map)creditByPayNew.get(key));
                }
                for (String key : agingByPay.keySet()) {
                    amountByPayAll.put(key, (Map)agingByPay.get(key));
                }
                for (String key : microByPay.keySet()) {
                    amountByPayAll.put(key, (Map)microByPay.get(key));
                }
                result.put("netCash", (Object)cashAmountByPay);
                result.put("amountByPayAll", amountByPayAll);
                result.put("actualMedia", (Object)totalAmountByPay);
                result.put("salesOnCredit", (Object)tailPayTotalAmount);
            } else {
                result.put("netCash", (Object)0);
                result.put("amountByPayAll", (Object)new JSONObject());
                result.put("actualMedia", (Object)0);
                result.put("salesOnCredit", (Object)0);
            }
            List<Map<String, Object>> ra5 = this.saleOrderIndexModelMapper.clearMachine04(param);
            if (ra5.get(0) != null && ra5.get(0).toString() != "") {
                result.put("accountPayment", ra5.get(0).get("totalMoney"));
            } else {
                result.put("accountPayment", (Object)0);
            }
            param.put("mode", (Object)"1");
            List<Map<String, Object>> ra8 = this.saleOrderIndexModelMapper.clearMachine03(param);
            ra16 = this.saleOrderIndexModelMapper.clearMachine09(param);
            BigDecimal depositsAmount = new BigDecimal(0);
            if (ra8 != null && ra8.size() > 0) {
                for (Map<String, Object> map : ra8) {
                    if (map.get("payCode").toString().equals(paramsObject.getString("payCode"))) continue;
                    depositsAmount = depositsAmount.add(new BigDecimal(map.get("money").toString()));
                }
            }
            if (ra16 != null && ra16.size() > 0) {
                for (Map<String, Object> map : ra16) {
                    if (map.get("payCode").toString().equals(paramsObject.getString("payCode"))) continue;
                    depositsAmount = depositsAmount.subtract(new BigDecimal(map.get("money").toString()));
                }
            }
            param.remove((Object)"mode");
            result.put("depositsAmount", (Object)depositsAmount);
            param.put("orderType", (Object)"Y3");
            List<Map<String, Object>> ra6 = this.saleOrderIndexModelMapper.clearMachine01(param);
            if (ra6 != null && ra6.size() > 0 && !StringUtils.isEmpty((Object)ra6.get(0).get("totalMoney"))) {
                result.put("octopusAddValue", (Object)ra6.get(0).get("totalMoney").toString());
            } else {
                result.put("octopusAddValue", (Object)0);
            }
            param.put("orderType", (Object)"Y9");
            List<Map<String, Object>> ra7 = this.saleOrderIndexModelMapper.clearMachine01(param);
            if (ra7 != null && ra7.size() > 0 && !StringUtils.isEmpty((Object)ra7.get(0).get("totalMoney"))) {
                result.put("octopusTopUp", (Object)ra7.get(0).get("totalMoney").toString());
            } else {
                result.put("octopusTopUp", (Object)0);
            }
            result.put("aeonWalletAddValue", (Object)0);
            BigDecimal mediaTotal = new BigDecimal(0);
            mediaTotal = mediaTotal.add(totalAmountByPay).subtract(new BigDecimal(result.getString("accountPayment"))).subtract(depositsAmount).subtract(new BigDecimal(result.getString("hpBalance"))).subtract(new BigDecimal(result.getString("octopusAddValue"))).subtract(new BigDecimal(result.getString("octopusTopUp")));
            result.put("mediaTotal", (Object)mediaTotal);
            result.put("loan", paramsObject.get((Object)"loan"));
            result.put("middleCollection", paramsObject.get((Object)"middleCollection"));
            result.put("cashOnBook", (Object)new BigDecimal(result.getString("netCash")).add(new BigDecimal(paramsObject.getString("loan"))).subtract(new BigDecimal(paramsObject.getString("middleCollection"))));
            result.put("preCommit", (Object)0);
            result.put("difference", result.get((Object)"cashOnBook"));
            if (paramsObject.getString("searchType").equals("2") && payTicketList.size() > 0) {
                param.put("ticketList", payTicketList);
                List<Map<String, Object>> ra15 = this.saleOrderIndexModelMapper.clearMachine05(param);
                if (ra15 != null && ra15.size() > 0 && !StringUtils.isEmpty((Object)ra15.get(0).get("totalMoney"))) {
                    result.put("couponTotalMoney", ra15.get(0).get("totalMoney"));
                } else {
                    result.put("couponTotalMoney", (Object)0);
                }
            }
            log.info("\u6e05\u673a\u8fd4\u56de\u7ed3\u679c : " + result);
            log.info("\u6e05\u673a\u8017\u65f6\uff1a " + (System.currentTimeMillis() - t1));
            ServiceResponse serviceResponse = ServiceResponse.buildSuccess((Object)result);
            return serviceResponse;
        }
        catch (Exception e) {
            e.printStackTrace();
            ServiceResponse serviceResponse = ServiceResponse.buildFailure((ServiceSession)session, (String)"10000", (String)e.getMessage());
            return serviceResponse;
        }
    }

    public String secondToTime(int count) {
        if (count > 0) {
            int minute = 0;
            int second = 0;
            if (count > 60) {
                minute = count / 60;
                second = count % 60;
            } else {
                second = count;
            }
            String minuteStr = minute < 10 ? "0" + minute : "" + minute;
            String secondStr = second < 10 ? "0" + second : "" + second;
            return minuteStr + ":" + secondStr;
        }
        return "00:00";
    }

    public String formatBillDate(Date createDate) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMdd");
        try {
            return dateFormat.format(createDate);
        }
        catch (Exception e) {
            log.error("\u65e5\u671f\u8f6c\u6362\u5f02\u5e38: " + e.getMessage());
            return null;
        }
    }

    private Map<String, String> computesClearTime() {
        HashMap<String, String> param = new HashMap<String, String>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        try {
            String todayDate = DateHelpUtil.getTodayDate();
            String businessCloseDate = todayDate + BUSINESS_CLOSE_TIME;
            String nowTime = DateHelpUtil.nowToString((String)"yyyy-MM-dd HH:mm:ss");
            if (sdf.parse(nowTime).after(sdf.parse(businessCloseDate))) {
                param.put("startTime", todayDate + BUSINESS_CLOSE_TIME);
            } else {
                param.put("startTime", DateHelpUtil.getYestoryDate() + BUSINESS_CLOSE_TIME);
            }
            param.put("endTime", nowTime);
            System.out.println(param);
            return param;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

