/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.impl.wslf;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.dao.wslf.OrdersDetailModelService;
import com.efuture.business.dao.wslf.OrdersDetailPopModelService;
import com.efuture.business.dao.wslf.OrdersExtModelService;
import com.efuture.business.dao.wslf.OrdersGainDetailModelService;
import com.efuture.business.dao.wslf.OrdersGainModelService;
import com.efuture.business.dao.wslf.OrdersMemberModelService;
import com.efuture.business.dao.wslf.OrdersModelService;
import com.efuture.business.dao.wslf.OrdersPayModelService;
import com.efuture.business.dao.wslf.OrdersUploadInfoModelService;
import com.efuture.business.dao.wslf.OrdersUseCouponModelService;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersExtModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersMemberModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersModel;
import com.efuture.business.javaPos.struct.orderCentre.OrdersModel4Pos;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrderDetailModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrders;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrdersModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrders_WSLF;
import com.efuture.business.javaPos.struct.orderCentre.response.SyncOutData;
import com.efuture.business.model.Syjmain;
import com.efuture.business.service.OrderPosCommonService;
import com.efuture.business.service.SyjMainRemoteService;
import com.efuture.business.util.ArrayUtils;
import com.efuture.business.util.HttpUtils;
import com.efuture.business.util.RedisUtil;
import com.efuture.business.util.TransformationUtils;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.dao.DuplicateKeyException;
import org.springframework.transaction.annotation.Propagation;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.client.RestTemplate;

public class OrderPosCommonServiceImpl
implements OrderPosCommonService {
    private static final Logger log = LoggerFactory.getLogger(OrderPosCommonServiceImpl.class);
    private final String BILL_END_TIME = " 05:00:00";
    @Autowired
    private OrdersModelService orderMapper;
    @Autowired
    private OrdersMemberModelService ordersMember;
    @Autowired
    private OrdersDetailModelService ordersDetailMapper;
    @Autowired
    private OrdersDetailPopModelService ordersDetailPopMapper;
    @Autowired
    private OrdersGainModelService ordersGainMapper;
    @Autowired
    private OrdersGainDetailModelService ordersGainDetail;
    @Autowired
    private OrdersUseCouponModelService ordersUseCouponMapper;
    @Autowired
    private OrdersPayModelService ordersPayMapper;
    @Autowired
    private OrdersExtModelService ordersExtMapper;
    @Autowired
    private OrdersUploadInfoModelService ordersUploadInfoMapper;
    @Value(value="${localcache.enabled}")
    private Boolean localcache;
    @Value(value="${hazelcast.enabled:false}")
    private Boolean hazelcast;
    RestTemplate restTemplate;
    @Autowired
    protected RedisUtil redisUtil;
    private static String SYNC = "order.online.sync.execute";
    private static String ORDERPATH = "/storage/emulated/0/androidserver/server/sqlites/";
    @SoaAnnotation(value="/syjMainRemoteService.do")
    private SyjMainRemoteService syjmainRemoteService;

    public LocalDate computeBillDate(LocalDateTime nowDate) {
        try {
            String billCloseDateDf = DateTimeFormatter.ofPattern("yyyy-MM-dd").format(nowDate) + " 05:00:00";
            LocalDateTime whenDate = LocalDateTime.parse(billCloseDateDf, DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss"));
            String dateText = nowDate.isAfter(whenDate) || nowDate.isEqual(whenDate) ? nowDate.format(DateTimeFormatter.ofPattern("yyyy-MM-dd")) : nowDate.minusDays(1L).format(DateTimeFormatter.ofPattern("yyyy-MM-dd"));
            return LocalDate.parse(dateText, DateTimeFormatter.ofPattern("yyyy-MM-dd"));
        }
        catch (Exception e) {
            log.error("\u8ba2\u5355\u4e2d\u5fc3\u8ba1\u7b97\u8bb0\u8d26\u65e5\u671f\u5931\u8d25: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public RespBase checkOriginGoodQty(ServiceSession session, List<SaleOrderDetailModel> ordersDetails, String originSheetNo) {
        try {
            HashMap<String, Object> param = new HashMap<String, Object>();
            param.put("sheetNo", originSheetNo);
            OrdersModel originOrder = (OrdersModel)this.orderMapper.selectByMap(param, "orders").get(0);
            if (originOrder == null) {
                return Code.CODE_60095.getRespBase(new Object[0]);
            }
            param.clear();
            param.put("oid", originOrder.getOid());
            List originOrderDetails = this.ordersDetailMapper.selectByMap(param, "ordersdetail");
            if (originOrderDetails == null || originOrderDetails.size() == 0) {
                return Code.CODE_60096.getRespBase(new Object[0]);
            }
            boolean isAllReturn = true;
            ArrayList<OrdersDetailModel> matchModels = new ArrayList<OrdersDetailModel>();
            for (OrdersDetailModel od : originOrderDetails) {
                for (SaleOrderDetailModel or : ordersDetails) {
                    if (!or.getItemCode().equals(od.getGoodsCode()) || !or.getOldRowNo().equals(od.getRowNo())) continue;
                    log.info("\u5141\u8bb8\u9000\u8d27\u6570\u91cf\uff1a" + od.getAllowReturnCopies());
                    log.info("\u5f53\u524d\u6570\u91cf\uff1a" + or.getQty());
                    double allow = ManipulatePrecision.sub((double)od.getAllowReturnCopies(), (double)or.getQty());
                    log.info("\u68c0\u67e5\u539f\u4ea4\u6613\u5546\u54c1\u6570\u91cf:\u68c0\u67e5\u53ef\u9000\u5546\u54c1\u6570\u91cf[" + od.getGoodsCode() + "]: " + allow);
                    if (allow < 0.0) {
                        return Code.CODE_60097.getRespBase(new Object[]{allow});
                    }
                    if (allow > 0.0) {
                        isAllReturn = false;
                    }
                    od.setAllowReturnCopies(Double.valueOf(allow));
                    od.setLastDate(new Date());
                    matchModels.add(od);
                }
            }
            JSONObject result = new JSONObject();
            result.put("isAllReturn", (Object)isAllReturn);
            result.put("matchModels", matchModels);
            return new RespBase(Code.SUCCESS, (Object)result);
        }
        catch (Exception e) {
            log.error("\u68c0\u67e5\u539f\u4ea4\u6613\u5546\u54c1\u6570\u91cf,\u9519\u8bef: " + e.getMessage());
            log.error(e.getMessage(), (Throwable)e);
            return Code.CODE_60097.getRespBase(new Object[]{e.getMessage()});
        }
    }

    @Override
    @Transactional(rollbackFor={Exception.class}, propagation=Propagation.REQUIRES_NEW)
    public RespBase saveOrderInfoForCloud(ServiceSession session, SaleOrders saleOrder, Map<String, Object> preSaveParamInfo, SaleOrdersModel order, ModeDetailsVo modeDetailsVo) throws Exception {
        List list;
        long tX = System.currentTimeMillis();
        TransformationUtils util = new TransformationUtils();
        SaleOrders_WSLF saleOrders = util.saleOrdersToSaleOrders_WSLF(saleOrder);
        long tY = System.currentTimeMillis();
        long tZ = tY - tX;
        log.info("\u8ba2\u5355\u8f6c\u6362\u8017\u65f6ms\uff1a" + tZ);
        ArrayList<SaleOrders_WSLF> data = new ArrayList<SaleOrders_WSLF>();
        data.add(saleOrders);
        JSONObject result = new JSONObject();
        OrdersModel4Pos ordersModel = saleOrders.getOrders();
        boolean trainingMode = false;
        if (null != modeDetailsVo) {
            trainingMode = modeDetailsVo.isTrainingMode();
        }
        log.info("\u6821\u9a8c\u8ba2\u5355\u662f\u5426\u5df2\u63d0\u4ea4!");
        HashMap<String, Object> param = new HashMap<String, Object>();
        param.put("posId", ordersModel.getPosId());
        param.put("terminalNo", ordersModel.getTerminalNo());
        param.put("busiTakeMarketCode", ordersModel.getBusiTakeMarketCode());
        if (null != ordersModel.getEntId()) {
            param.put("entId", ordersModel.getEntId());
        }
        if (ArrayUtils.isNotEmpty(list = this.orderMapper.selectByMap(param, "orders", trainingMode))) {
            log.info("\u8ba2\u5355\u5df2\u4e0a\u4f20!");
            result.clear();
            result.put("oid", (Object)order.getOid());
            result.put("sheetNo", (Object)order.getOrderNo());
            result.put("terminalSno", (Object)order.getTerminalSno());
            result.put("isAllReturn", (Object)true);
            return new RespBase(Code.SUCCESS, (Object)result);
        }
        log.info("\u6821\u9a8c\u8ba2\u5355\u5c0f\u7968\u53f7\u662f\u5426\u5df2\u5b58\u5728\u662f\u5426\u5df2\u63d0\u4ea4!");
        param = new HashMap();
        param.put("terminalSno", ordersModel.getTerminalSno());
        param.put("terminalNo", ordersModel.getTerminalNo());
        param.put("busiTakeMarketCode", ordersModel.getBusiTakeMarketCode());
        List terminalSnoList = this.orderMapper.selectByMap(param, "orders", trainingMode);
        if (ArrayUtils.isNotEmpty(terminalSnoList)) {
            if (ordersModel.getPosId().equals(((OrdersModel)terminalSnoList.get(0)).getPosId())) {
                log.info("\u8ba2\u5355\u5df2\u4e0a\u4f20!");
                result.clear();
                result.put("oid", (Object)order.getOid());
                result.put("sheetNo", (Object)order.getOrderNo());
                result.put("terminalSno", (Object)order.getTerminalSno());
                result.put("isAllReturn", (Object)true);
                return new RespBase(Code.SUCCESS, (Object)result);
            }
            Syjmain syjmain = new Syjmain();
            syjmain.setMkt(order.getSaleMarketCode());
            syjmain.setErpCode(saleOrders.getOrders().getErpCode());
            syjmain.setSyjh(order.getTerminalNo());
            String maxterminalSno = "";
            try {
                Syjmain syjObj = this.syjmainRemoteService.selectOneByMKTAndSYJ(syjmain);
                if (null != syjObj) {
                    maxterminalSno = String.valueOf(syjObj.getSyjcurnum());
                    log.info("\u5f53\u524d\u6536\u94f6\u673a\u5c0f\u7968\u53f7:" + maxterminalSno);
                }
            }
            catch (Exception syjObj) {
                // empty catch block
            }
            if (StringUtils.isNotBlank((String)maxterminalSno)) {
                if (maxterminalSno.equals(order.getTerminalSno())) {
                    maxterminalSno = String.valueOf(Long.parseLong(maxterminalSno) + 1L);
                }
            } else {
                maxterminalSno = String.valueOf(Long.parseLong(order.getTerminalSno()) + 1L);
            }
            log.info("\u66f4\u65b0\u6700\u5927\u5c0f\u7968\u53f7:==>{}", (Object)maxterminalSno);
            ordersModel.setTerminalSno(maxterminalSno);
        }
        if (!this.localcache.booleanValue() && !trainingMode) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("data", data);
            HttpUtils httpUtils = new HttpUtils();
            String timeZone = "";
            if (null != modeDetailsVo) {
                timeZone = modeDetailsVo.getSysparainfo().getTimeZone();
            }
            if (StringUtils.isNotBlank((String)timeZone) && timeZone.contains(",")) {
                timeZone = timeZone.split(",")[0];
            } else {
                log.info("\u65f6\u533a\u672a\u914d\u7f6e\u6216\u8005\u683c\u5f0f\u9519\u8bef:{}", (Object)timeZone);
            }
            map.put("timeZone", timeZone);
            ServiceResponse resp = httpUtils.doPost(this.restTemplate, HttpUtils.RemoteService.ORDER, SYNC, session, JSON.toJSONString(map), SyncOutData.class, "\u8ba2\u5355\u4e2d\u5fc3", "\u540c\u6b65\u8ba2\u5355");
            if ("0".equals(resp.getReturncode())) {
                SyncOutData re = (SyncOutData)resp.getData();
                if (null != re.getFail() && re.getFail().size() > 0) {
                    return new RespBase(Code.CODE_60017, re.getFail().get(0), null);
                }
                return new RespBase(Code.SUCCESS, resp.getData(), null);
            }
            return new RespBase(Code.CODE_60017, resp.getData(), null);
        }
        try {
            long t1 = System.currentTimeMillis();
            log.info("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f,start ...... ");
            if (null != saleOrders.getOrders()) {
                log.info("Ready to insert OrdersModel...");
                this.orderMapper.insert(ordersModel, "orders");
                log.info("OrdersModel insert success!");
            }
            if (null != saleOrders.getOrdersExt()) {
                OrdersExtModel ordersExt = saleOrders.getOrdersExt();
                this.ordersExtMapper.insert(ordersExt, "ordersext");
                log.info("OrdersExtModel insert success!");
            }
            if (null != saleOrders.getOrdersMember()) {
                OrdersMemberModel ordersMembers = saleOrders.getOrdersMember();
                this.ordersMember.insert(ordersMembers, "ordersmember");
                log.info("OrdersMemberModel insert success!");
            }
            if (null != saleOrders.getOrdersDetail() && saleOrders.getOrdersDetail().size() > 0) {
                List ordersDetailList = saleOrders.getOrdersDetail();
                this.ordersDetailMapper.saveBatch(ordersDetailList, "ordersdetail");
                log.info("OrdersDetailModel insert success!");
            }
            if (null != saleOrders.getOrdersDetailPop() && saleOrders.getOrdersDetailPop().size() > 0) {
                List ordersDetailPopList = saleOrders.getOrdersDetailPop();
                this.ordersDetailPopMapper.saveBatch(ordersDetailPopList, "ordersdetailpop");
                log.info("OrdersDetailPopModel insert success!");
            }
            if (null != saleOrders.getOrdersUseCoupon() && saleOrders.getOrdersUseCoupon().size() > 0) {
                List ordersUseCouponList = saleOrders.getOrdersUseCoupon();
                this.ordersUseCouponMapper.saveBatch(ordersUseCouponList, "ordersUseCoupon");
                log.info("OrdersUseCouponModelConvertor insert success!");
            }
            if (null != saleOrders.getOrdersGainDetail() && saleOrders.getOrdersGainDetail().size() > 0) {
                List ordersGainDetailList = saleOrders.getOrdersGainDetail();
                this.ordersGainDetail.saveBatch(ordersGainDetailList, "ordersgaindetail");
                log.info("OrdersGainDetailModel insert success!");
            }
            if (null != saleOrders.getOrdersGain() && saleOrders.getOrdersGain().size() > 0) {
                List ordersGainList = saleOrders.getOrdersGain();
                this.ordersGainMapper.saveBatch(ordersGainList, "ordersgainmapper");
                log.info("OrdersGainModelConvertor insert success!");
            }
            if (null != saleOrders.getOrdersPay() && saleOrders.getOrdersPay().size() > 0) {
                List ordersPayList = saleOrders.getOrdersPay();
                this.ordersPayMapper.saveBatch(ordersPayList, "orderspay");
                log.info("OrdersPayModel insert success!");
            }
            long t2 = System.currentTimeMillis();
            log.info("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f,\u6279\u91cf\u4fdd\u5b58,\u8017\u65f6[ms]: " + (t2 - t1));
            long t3 = System.currentTimeMillis();
            if (preSaveParamInfo.containsKey("matchOriginDetail")) {
                List martchDetails = JSON.parseArray((String)JSON.toJSONString((Object)preSaveParamInfo.get("matchOriginDetail")), SaleOrderDetailModel.class);
                for (int i = 0; i < martchDetails.size(); ++i) {
                    ((SaleOrderDetailModel)martchDetails.get(i)).setShardingCode(null);
                    ((SaleOrderDetailModel)martchDetails.get(i)).setShopCode(null);
                    OrdersDetailModel ordersDetail = util.toOrdersDetailModel((SaleOrderDetailModel)martchDetails.get(i));
                    this.ordersDetailMapper.updateById(ordersDetail, "ordersdetail");
                }
            }
            long t4 = System.currentTimeMillis();
            log.info("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f,\u66f4\u65b0\u539f\u4ea4\u6613\u5546\u54c1\u6570\u91cf,\u8017\u65f6[ms]: " + (t4 - t3));
            result.clear();
            result.put("oid", (Object)order.getOid());
            result.put("sheetNo", (Object)order.getOrderNo());
            result.put("terminalSno", (Object)order.getTerminalSno());
            result.put("isAllReturn", (Object)true);
            return new RespBase(Code.SUCCESS, (Object)result);
        }
        catch (DuplicateKeyException e1) {
            if (order == null) {
                throw new Exception("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f:\u8ba2\u5355\u4e3b\u4f53\u6570\u636e\u7a7a");
            }
            log.error(e1.getMessage(), (Throwable)e1);
            if (e1.getMessage().contains("idx_orders_searchByPos")) {
                log.info("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f-\u5c0f\u7968\u53f7\u5df2\u5b58\u5728,\u5f53\u524d\u5c0f\u7968\u53f7:" + order.getTerminalSno());
                return new RespBase(Code.CODE_60034, (Object)order.getTerminalSno(), null);
            }
            if (e1.getMessage().contains("idx_orders_sheetNo")) {
                log.info("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f-\u8ba2\u5355\u53f7\u5df2\u5b58\u5728,\u5f53\u524d\u8ba2\u5355\u53f7:" + order.getOrderNo());
                return new RespBase(10001, "idx_orders_sheetNo");
            }
            if (e1.getMessage().contains("idx_orders_posId")) {
                log.info("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f-POS\u552f\u4e00\u952e\u5df2\u5b58\u5728,\u5f53\u524d\u552f\u4e00\u952e:" + order.getPosId());
                return Code.CODE_60028.getRespBase(new Object[]{"posId is exist"});
            }
            this.deleteOrdersInfoForCloud(session, order.getOid(), trainingMode);
            throw new Exception("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f-\u5176\u4ed6\u9519\u8bef:" + e1.getMessage());
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            if (e instanceof NullPointerException) {
                throw new Exception("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f:\u5fc5\u586b\u5b57\u6bb5\u7a7a," + e.getMessage());
            }
            this.deleteOrdersInfoForCloud(session, order.getOid(), trainingMode);
            throw new Exception("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f:" + e.getMessage());
        }
    }

    public RespBase deleteOrdersInfoForCloud(ServiceSession session, long oid, boolean trainingMode) {
        int i = 0;
        HashMap<String, Long> map = new HashMap<String, Long>();
        map.put("oid", oid);
        i += this.orderMapper.deleteByMap(map, "orders", trainingMode);
        i += this.ordersExtMapper.deleteByMap(map, "ordersext", trainingMode);
        i += this.ordersMember.deleteByMap(map, "ordersmember", trainingMode);
        i += this.ordersDetailMapper.deleteByMap(map, "ordersdetail", trainingMode);
        i += this.ordersDetailPopMapper.deleteByMap(map, "ordersdetailpop", trainingMode);
        i += this.ordersGainMapper.deleteByMap(map, "ordersgainmapper", trainingMode);
        i += this.ordersGainDetail.deleteByMap(map, "ordersgaindetail", trainingMode);
        i += this.ordersPayMapper.deleteByMap(map, "orderspay", trainingMode);
        log.info("\u6279\u91cf\u4fdd\u5b58\u8ba2\u5355\u4fe1\u606f,\u8ba2\u5355\u51b2\u6b63,\u5f71\u54cd\u884c\u6570: " + (i += this.ordersUseCouponMapper.deleteByMap(map, "ordersUseCoupon", trainingMode)));
        return new RespBase(Code.SUCCESS);
    }
}

