/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.ModeDetailsVo;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.SellType;
import com.efuture.business.constant.RedisKey;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.global.GlobalInfo;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Order;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.klxy.BillGoods;
import com.efuture.business.javaPos.struct.klxy.BillPay;
import com.efuture.business.javaPos.struct.klxy.KlxyRespVo;
import com.efuture.business.javaPos.struct.klxy.PosTradeIn;
import com.efuture.business.service.localize.OrderSaleBSImpl_WSLF;
import com.product.model.ServiceResponse;
import com.product.model.ServiceSession;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OrderSaleBSImpl_KLXY
extends OrderSaleBSImpl_WSLF {
    private static final Logger log = LoggerFactory.getLogger(OrderSaleBSImpl_KLXY.class);

    @Override
    public RespBase payConfirm(ServiceSession session, ResqVo vo) {
        CacheModel cacheModel = vo.getCacheModel();
        if (cacheModel == null) {
            return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
        }
        if (cacheModel.getOrder().getSendSuccess()) {
            return super.payConfirm(session, vo);
        }
        RespBase respBase = super.payConfirm(session, vo);
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        ResqVo respVo = (ResqVo)respBase.getData();
        cacheModel = respVo.getCacheModel();
        JSONObject jsonObject = respVo.getJsonObject();
        JSONObject paramsObject = vo.getJsonObject();
        String obj = this.redisUtil.get(RedisKey.CACHEID + cacheModel.getOrder().getShopCode() + cacheModel.getOrder().getTerminalNo());
        ModeDetailsVo modeDetailsVo = (ModeDetailsVo)JSONObject.parseObject((String)obj, ModeDetailsVo.class);
        String mbkey = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBKEY");
        String mallId = ModeDetailsVo.getSysParaValue((List)modeDetailsVo.getSyspara(), (String)"MBSTORE");
        if (StringUtils.isBlank((String)mbkey)) {
            return Code.CODE_1013.getRespBase(new Object[]{"appKey\u672a\u8bbe\u7f6e"});
        }
        if (StringUtils.isBlank((String)mallId)) {
            return Code.CODE_1009.getRespBase(new Object[]{"mallId\u672a\u8bbe\u7f6e"});
        }
        String rnd = paramsObject.getString("shopCode") + paramsObject.getString("terminalNo") + System.currentTimeMillis();
        String token = "";
        RespBase res = this.initRemoteService.getToken(session, paramsObject);
        if (Code.SUCCESS.getIndex() == res.getRetflag()) {
            JSONObject resp = (JSONObject)res.getData();
            token = resp.getString("token");
        }
        if (StringUtils.isBlank((String)token)) {
            respBase.setRetflag(1);
            return respBase;
        }
        PosTradeIn paraIn = this.loadRequestPara(cacheModel);
        paraIn.setStoreId(mallId);
        boolean isUpload = false;
        ServiceResponse resp = this.httpUtils.doKlxyPost(mbkey, GlobalInfo.mburl, "/api/v3/external/posTrade", session, JSON.toJSONString((Object)paraIn), KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u9500\u552e\u4e0a\u62a5", token, rnd);
        if ("0".equals(resp.getReturncode())) {
            KlxyRespVo res1 = (KlxyRespVo)resp.getData();
            if ("PUB-00000".equals(res1.getErrorCode())) {
                Double nowPoint = res1.getBody().getDouble("nowPoint");
                Double point = res1.getBody().getDouble("point");
                if (null != nowPoint) {
                    cacheModel.getOrder().setTotalPoint(nowPoint.doubleValue());
                    jsonObject.getJSONObject("order").put("totalPoint", (Object)nowPoint);
                }
                if (null != point) {
                    cacheModel.getOrder().setThisTimePoint(point.doubleValue());
                    jsonObject.getJSONObject("order").put("thisTimePoint", (Object)point);
                }
                isUpload = true;
            } else {
                log.info("\u9500\u552e\u4e0a\u62a5\u5931\u8d25\uff1a" + res1.getErrorMessage());
            }
        } else {
            for (int i = 0; i < 3; ++i) {
                resp = this.httpUtils.doKlxyPost(mbkey, GlobalInfo.mburl, "/api/v3/external/posTrade", session, JSON.toJSONString((Object)paraIn), KlxyRespVo.class, "\u58a8\u535a\u4e91\u821f", "\u9500\u552e\u4e0a\u62a5", token, rnd);
                if (!"0".equals(resp.getReturncode())) continue;
                KlxyRespVo res1 = (KlxyRespVo)resp.getData();
                if ("PUB-00000".equals(res1.getErrorCode())) {
                    Double nowPoint = res1.getBody().getDouble("nowPoint");
                    Double point = res1.getBody().getDouble("point");
                    if (null != nowPoint) {
                        cacheModel.getOrder().setTotalPoint(nowPoint.doubleValue());
                        jsonObject.getJSONObject("order").put("totalPoint", (Object)nowPoint);
                    }
                    if (null != point) {
                        cacheModel.getOrder().setThisTimePoint(point.doubleValue());
                        jsonObject.getJSONObject("order").put("thisTimePoint", (Object)point);
                    }
                    isUpload = true;
                    break;
                }
                log.info("\u9500\u552e\u4e0a\u62a5\u5931\u8d25\uff1a" + res1.getErrorMessage());
                break;
            }
        }
        if (!isUpload) {
            respBase.setRetflag(1);
        }
        return respBase;
    }

    private PosTradeIn loadRequestPara(CacheModel cacheModel) {
        PosTradeIn in = new PosTradeIn();
        Order order = cacheModel.getOrder();
        in.setFlowNo(order.getFlowNo());
        if (SellType.ISBACK((String)order.getOrderType())) {
            if (StringUtils.isNotBlank((String)order.getOriginTerminalSno())) {
                in.setOriFlowNo(order.getOriginFlowNo());
                in.setOriPosNo(order.getOriginTerminalNo());
                in.setTranMode("-2");
            } else {
                in.setTranMode("-1");
            }
        } else {
            in.setTranMode("1");
        }
        in.setSrcAmt(String.valueOf(order.getSaleValue()));
        in.setFavAmt(String.valueOf(order.getTotalDiscountValue()));
        in.setRealAmt(String.valueOf(order.getOughtPay()));
        if (null != order.getConsumersData() && StringUtils.isNotBlank((String)order.getConsumersData().getConsumersCard())) {
            in.setCardId(order.getConsumersData().getConsumersCard());
        }
        in.setUserAccount(order.getTerminalOperator());
        in.setPosNo(order.getTerminalNo());
        in.setFilDate(order.getSaleDate());
        if (null != cacheModel.getGoodsList() && cacheModel.getGoodsList().size() > 0) {
            for (int i = 0; i < cacheModel.getGoodsList().size(); ++i) {
                Goods goods = (Goods)cacheModel.getGoodsList().get(i);
                BillGoods billGoodsList = new BillGoods();
                billGoodsList.setGoodsCode(goods.getGoodsCode());
                billGoodsList.setGoodsCount((int)goods.getQty());
                billGoodsList.setGoodsName(goods.getGoodsName());
                billGoodsList.setPrice(String.valueOf(goods.getSaleAmount()));
                in.getBillGoodsList().add(billGoodsList);
            }
        }
        if (null != cacheModel.getPayments() && cacheModel.getPayments().size() > 0) {
            HashMap<String, BillPay> jo = new HashMap<String, BillPay>();
            for (Payment p : cacheModel.getPayments()) {
                if (jo.containsKey(p.getPayCode())) {
                    double amount;
                    String payName = "";
                    if ("2".equals(p.getFlag())) {
                        amount = ManipulatePrecision.sub((double)Double.valueOf(((BillPay)jo.get(p.getPayCode())).getPaymentAmount()), (double)p.getAmount());
                    } else {
                        amount = ManipulatePrecision.add((double)Double.valueOf(((BillPay)jo.get(p.getPayCode())).getPaymentAmount()), (double)p.getAmount());
                        payName = p.getPayName();
                    }
                    ((BillPay)jo.get(p.getPayCode())).setPaymentAmount(String.valueOf(amount));
                    if (!StringUtils.isNotBlank((String)payName)) continue;
                    ((BillPay)jo.get(p.getPayCode())).setPaymentTypeName(payName);
                    continue;
                }
                BillPay billPay = new BillPay();
                billPay.setPaymentId(p.getPayNo());
                billPay.setPaymentTypeCode(p.getPayCode());
                billPay.setPaymentTypeName(p.getPayName());
                billPay.setPaymentNo(String.valueOf(p.getRowno()));
                if ("2".equals(p.getFlag())) {
                    billPay.setPaymentAmount(String.valueOf(p.getAmount() * -1.0));
                } else {
                    billPay.setPaymentAmount(String.valueOf(p.getAmount()));
                }
                billPay.setReferenceNo(p.getRefCode());
                jo.put(p.getPayCode(), billPay);
            }
            Set entries = jo.entrySet();
            for (Map.Entry o : entries) {
                log.info("entries==>" + JSONObject.toJSONString(entries));
                in.getBillPayList().add((BillPay)o.getValue());
            }
        }
        return in;
    }
}

