/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.exception.EfutureException;
import com.efuture.business.javaPos.commonkit.ManipulatePrecision;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.GoodsForPos;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.PopDetail;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrders_WSLF;
import com.efuture.business.javaPos.struct.orderCentre.request.OrderQueryIn;
import com.efuture.business.javaPos.struct.request.GetOrderIn;
import com.efuture.business.javaPos.struct.request.SaleReturnQueryIn;
import com.efuture.business.javaPos.struct.response.PayConfirmOut;
import com.efuture.business.service.localize.OrderSaleBSImpl_WSLF;
import com.efuture.business.task.OrderTask;
import com.efuture.business.util.DateUtils;
import com.efuture.business.util.ParamsValidateUtil;
import com.product.model.ServiceSession;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OrderSaleBSImpl_SJGW
extends OrderSaleBSImpl_WSLF {
    private static final Logger log = LoggerFactory.getLogger(OrderSaleBSImpl_SJGW.class);
    @Autowired
    private OrderTask orderTask;

    @Override
    public RespBase payConfirm(ServiceSession session, ResqVo vo) {
        RespBase respBase = super.payConfirm(session, vo);
        if (0 != respBase.getRetflag()) {
            return respBase;
        }
        ResqVo vo1 = (ResqVo)respBase.getData();
        this.orderTask.uploadIntegral(vo1.getCacheModel());
        return respBase;
    }

    @Override
    public RespBase saleReturnQuery(ServiceSession session, ResqVo vo) {
        RespBase respBase = this.returnQuery(session, vo);
        if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
            return respBase;
        }
        CacheModel cacheModel = vo.getCacheModel();
        boolean yxth = false;
        for (Payment p : cacheModel.getReturnPayments()) {
            if (!StringUtils.isNotBlank((String)p.getPayMemo()) || !p.getPayMemo().startsWith("\u94f6\u8054")) continue;
            yxth = true;
        }
        if (!yxth) {
            return Code.CODE_60028.getRespBase(new Object[]{"\u975e\u94f6\u8054\u4ea4\u6613\u4e0d\u5141\u8bb8\u6d88\u5355"});
        }
        return respBase;
    }

    public RespBase returnQuery(ServiceSession session, ResqVo vo) {
        try {
            JSONObject paramsObject = vo.getJsonObject();
            ParamsValidateUtil paramsValidateUtil = new ParamsValidateUtil(session, paramsObject);
            if (!paramsValidateUtil.validate()) {
                return paramsValidateUtil.getRespBase();
            }
            SaleReturnQueryIn saleReturnQueryIn = (SaleReturnQueryIn)JSON.parseObject((String)paramsObject.toJSONString(), SaleReturnQueryIn.class);
            CacheModel cacheModel = vo.getCacheModel();
            if (null == cacheModel) {
                return Code.CODE_60003.getRespBase(new Object[]{vo.getCacheModel().getFlowNo()});
            }
            OrderQueryIn orderQueryIn = new OrderQueryIn();
            if ("2".equals(cacheModel.getOrder().getOrderType())) {
                if (!(saleReturnQueryIn.getShopCode().equals(saleReturnQueryIn.getOldShopCode()) && saleReturnQueryIn.getTerminalNo().equals(saleReturnQueryIn.getOldTerminalNo()) && DateUtils.isOrderToday((String)saleReturnQueryIn.getBillDate()))) {
                    return Code.CODE_60046.getRespBase(new Object[0]);
                }
            } else {
                return Code.CODE_60028.getRespBase(new Object[]{"\u8ba2\u5355\u4e0d\u5141\u8bb8\u9000\u8d27\uff0c\u8bf7\u8d70\u6d88\u5355\u901a\u9053"});
            }
            orderQueryIn.setSearchType(1);
            if (StringUtils.isBlank((String)saleReturnQueryIn.getPosId())) {
                return Code.CODE_60001.getRespBase(new Object[]{"posId"});
            }
            orderQueryIn.setTerminalNo(saleReturnQueryIn.getOldTerminalNo());
            orderQueryIn.setBusiTakeMarketCode(saleReturnQueryIn.getOldShopCode());
            orderQueryIn.setCreateDate(saleReturnQueryIn.getBillDate());
            orderQueryIn.setPosId(saleReturnQueryIn.getPosId());
            return this.getReturnOrder(session, paramsObject, saleReturnQueryIn, cacheModel, orderQueryIn);
        }
        catch (EfutureException e) {
            throw e;
        }
        catch (Exception e) {
            log.info("\u8c03\u7528\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            return Code.CODE_60007.getRespBase(new Object[]{e.getMessage()});
        }
    }

    @Override
    public RespBase getOrder(ServiceSession session, GetOrderIn getOrderIn) {
        try {
            if (StringUtils.isBlank((String)getOrderIn.getPosId())) {
                return Code.CODE_60001.getRespBase(new Object[]{"posId"});
            }
            OrderQueryIn in = new OrderQueryIn();
            in.setBusiTakeMarketCode(getOrderIn.getShopCode());
            in.setTerminalNo(getOrderIn.getTerminalNo());
            if (1 == getOrderIn.getType()) {
                in.setTerminalSno(getOrderIn.getTerminalSno());
            } else {
                in.setPosId(getOrderIn.getPosId());
            }
            in.setCreateDate(getOrderIn.getBillDate());
            in.setSearchType(getOrderIn.getSearchType());
            if (StringUtils.isNotBlank((String)getOrderIn.getShardingCode())) {
                in.setShardingCode(getOrderIn.getShardingCode());
            }
            return this.getOrder(session, getOrderIn, in);
        }
        catch (Exception e) {
            e.printStackTrace();
            log.info("\u8c03\u7528\u8ba2\u5355\u5f02\u5e38", (Throwable)e);
            return new RespBase(Code.CODE_60007.getIndex(), e.getMessage());
        }
    }

    @Override
    public PayConfirmOut toPayConfirmOut(ServiceSession session, SaleOrders_WSLF saleOrder, SaleOrders_WSLF oriOrder, List<String> calcPriceType, boolean isReprint) {
        PayConfirmOut out = super.toPayConfirmOut(session, saleOrder, oriOrder, calcPriceType, isReprint);
        return this.addGoodsDiscount(out);
    }

    @Override
    public CacheModel addGoodsDiscount(CacheModel cacheModel) {
        double hyDiscountAmount = 0.0;
        double zkDiscountAmount = 0.0;
        double tmDiscountAmount = 0.0;
        double qtDiscountAmount = 0.0;
        for (Goods goods : cacheModel.getGoodsList()) {
            double totalHyDiscountAmount = 0.0;
            for (int i = 0; i < goods.getPopDetailsInfo().size(); ++i) {
                boolean dygl = false;
                PopDetail pop = (PopDetail)goods.getPopDetailsInfo().get(i);
                if (ManipulatePrecision.doubleCompare((double)pop.getDiscountAmount(), (double)0.0, (int)2) <= 0) continue;
                if ("9999".equals(pop.getPopPolicyType()) || "96111".equals(pop.getPopPolicyType())) {
                    zkDiscountAmount = ManipulatePrecision.add((double)zkDiscountAmount, (double)pop.getDiscountAmount());
                    totalHyDiscountAmount = ManipulatePrecision.add((double)totalHyDiscountAmount, (double)pop.getDiscountAmount());
                    dygl = true;
                } else if ("9998".equals(pop.getPopPolicyType()) || "96112".equals(pop.getPopPolicyType())) {
                    hyDiscountAmount = ManipulatePrecision.add((double)hyDiscountAmount, (double)pop.getDiscountAmount());
                    totalHyDiscountAmount = ManipulatePrecision.add((double)totalHyDiscountAmount, (double)pop.getDiscountAmount());
                    dygl = true;
                } else if ("96110".equals(pop.getPopPolicyType())) {
                    tmDiscountAmount = ManipulatePrecision.add((double)tmDiscountAmount, (double)pop.getDiscountAmount());
                    totalHyDiscountAmount = ManipulatePrecision.add((double)totalHyDiscountAmount, (double)pop.getDiscountAmount());
                    dygl = true;
                } else {
                    qtDiscountAmount = ManipulatePrecision.add((double)qtDiscountAmount, (double)pop.getDiscountAmount());
                }
                if (!dygl) continue;
                goods.getPopDetailsInfo().remove(i);
                --i;
            }
            goods.setPayDiscountValue(totalHyDiscountAmount);
        }
        cacheModel.getOrder().setHyDiscountAmount(hyDiscountAmount);
        cacheModel.getOrder().setZkDiscountAmount(zkDiscountAmount);
        cacheModel.getOrder().setTmDiscountAmount(tmDiscountAmount);
        cacheModel.getOrder().setQtDiscountAmount(qtDiscountAmount);
        return cacheModel;
    }

    public PayConfirmOut addGoodsDiscount(PayConfirmOut out) {
        double hyDiscountAmount = 0.0;
        double zkDiscountAmount = 0.0;
        double tmDiscountAmount = 0.0;
        double qtDiscountAmount = 0.0;
        for (GoodsForPos goods : out.getOrder().getGoodsList()) {
            double totalHyDiscountAmount = 0.0;
            for (int i = 0; i < goods.getPopDetails().size(); ++i) {
                boolean dygl = false;
                PopDetail pop = (PopDetail)goods.getPopDetails().get(i);
                if (ManipulatePrecision.doubleCompare((double)pop.getDiscountAmount(), (double)0.0, (int)2) <= 0) continue;
                if ("9999".equals(pop.getPopPolicyType()) || "96111".equals(pop.getPopPolicyType())) {
                    zkDiscountAmount = ManipulatePrecision.add((double)zkDiscountAmount, (double)pop.getDiscountAmount());
                    totalHyDiscountAmount = ManipulatePrecision.add((double)totalHyDiscountAmount, (double)pop.getDiscountAmount());
                    dygl = true;
                } else if ("9998".equals(pop.getPopPolicyType()) || "96112".equals(pop.getPopPolicyType())) {
                    hyDiscountAmount = ManipulatePrecision.add((double)hyDiscountAmount, (double)pop.getDiscountAmount());
                    totalHyDiscountAmount = ManipulatePrecision.add((double)totalHyDiscountAmount, (double)pop.getDiscountAmount());
                    dygl = true;
                } else if ("96110".equals(pop.getPopPolicyType())) {
                    tmDiscountAmount = ManipulatePrecision.add((double)tmDiscountAmount, (double)pop.getDiscountAmount());
                    totalHyDiscountAmount = ManipulatePrecision.add((double)totalHyDiscountAmount, (double)pop.getDiscountAmount());
                    dygl = true;
                } else {
                    qtDiscountAmount = ManipulatePrecision.add((double)qtDiscountAmount, (double)pop.getDiscountAmount());
                }
                if (!dygl) continue;
                goods.getPopDetails().remove(i);
                --i;
            }
            goods.setPayDiscountValue(totalHyDiscountAmount);
        }
        out.getOrder().setHyDiscountAmount(hyDiscountAmount);
        out.getOrder().setZkDiscountAmount(zkDiscountAmount);
        out.getOrder().setTmDiscountAmount(tmDiscountAmount);
        out.getOrder().setQtDiscountAmount(qtDiscountAmount);
        return out;
    }
}

