/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.localize;

import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.SoaAnnotation;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.bean.YPopStatusType;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.Goods;
import com.efuture.business.javaPos.struct.Payment;
import com.efuture.business.javaPos.struct.orderCentre.OrdersDetailPopModel;
import com.efuture.business.javaPos.struct.orderCentre.SaleOrders_WSLF;
import com.efuture.business.javaPos.struct.response.PayConfirmOut;
import com.efuture.business.service.CrmFlCouponRemoteService;
import com.efuture.business.service.GoodsRemoteService;
import com.efuture.business.service.OrderDataLocalService;
import com.efuture.business.service.V3PointRemoteService;
import com.efuture.business.service.localize.OrderSaleBSImpl_WSLF;
import com.efuture.business.util.RandomNum;
import com.product.model.ServiceSession;
import java.util.HashMap;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class OrderSaleBSImpl_XHD
extends OrderSaleBSImpl_WSLF {
    private static final Logger log = LoggerFactory.getLogger(OrderSaleBSImpl_XHD.class);
    @SoaAnnotation(value="/apiCrmFlCouponRemoteService.do")
    private CrmFlCouponRemoteService crmFlCouponRemoteService;
    @SoaAnnotation(value="/apiV3PointRemoteService.do")
    private V3PointRemoteService v3PointRemoteService;
    @SoaAnnotation(value="/apiGoodsRemoteService.do")
    private GoodsRemoteService goodsRemoteService;
    @Autowired
    private OrderDataLocalService orderDataLocalActionUtil;

    @Override
    public PayConfirmOut toPayConfirmOut(ServiceSession session, SaleOrders_WSLF saleOrder, SaleOrders_WSLF oriOrder, List<String> calcPriceType, boolean isReprint) {
        return super.toPayConfirmOut(session, saleOrder, oriOrder, calcPriceType, false);
    }

    @Override
    public Goods transExtendForOrderPop(OrdersDetailPopModel orderPop, Goods goods) {
        if (YPopStatusType.pop_policy_group_barcode_discA.equals(orderPop.getPopPolicyGroup())) {
            goods.setBarcodeDiscount(orderPop.getDiscountAmount().doubleValue());
        }
        return goods;
    }

    @Override
    public boolean thirdVoidPayment(ServiceSession session, CacheModel cacheModel) {
        List paymentList = cacheModel.getPayments();
        List returnPayments = cacheModel.getReturnPayments();
        HashMap<String, Payment> paymap = new HashMap<String, Payment>();
        for (Payment repayment : returnPayments) {
            if (!"FLQ".equals(repayment.getPayMemo()) && !"JFXF".equals(repayment.getPayMemo())) continue;
            paymap.put(repayment.getPayCode(), repayment);
        }
        boolean flag = true;
        JSONObject jsonObject = new JSONObject();
        for (Payment payment : paymentList) {
            RespBase respBase;
            if (!paymap.containsKey(payment.getPayCode()) || "true".equals(payment.getExtMemo())) continue;
            jsonObject.put("amount", (Object)payment.getMoney());
            jsonObject.put("balance", (Object)payment.getCouponBalance());
            jsonObject.put("cardNo", (Object)payment.getPayNo());
            jsonObject.put("description", (Object)((Payment)paymap.get(payment.getPayCode())).getDescription());
            jsonObject.put("flowNo", (Object)cacheModel.getFlowNo());
            jsonObject.put("payCode", (Object)payment.getPayCode());
            jsonObject.put("shopCode", (Object)cacheModel.getOrder().getShopCode());
            jsonObject.put("terminalNo", (Object)cacheModel.getOrder().getTerminalNo());
            jsonObject.put("terminalOperator", (Object)cacheModel.getOrder().getTerminalOperator());
            jsonObject.put("terminalSno", (Object)cacheModel.getOrder().getTerminalSno());
            jsonObject.put("orderNo", (Object)(cacheModel.getOrder().getTerminalSno() + RandomNum.generateString((int)4)));
            ResqVo vo = new ResqVo();
            vo.setCacheModel(cacheModel);
            vo.setJsonObject(jsonObject);
            if ("FLQ".equals(((Payment)paymap.get(payment.getPayCode())).getPayMemo())) {
                log.info("\u83b7\u53d6\u5230\u8fd4\u5229\u5238");
                respBase = this.crmFlCouponRemoteService.saleRefund(session, vo, jsonObject);
                if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
                    flag = false;
                } else {
                    payment.setExtMemo("true");
                    payment.setCouponBalance(0.0);
                }
            }
            if (!"JFXF".equals(((Payment)paymap.get(payment.getPayCode())).getPayMemo())) continue;
            log.info("\u83b7\u53d6\u5230\u79ef\u5206\u6d88\u8d39");
            respBase = this.v3PointRemoteService.saleRefund(session, vo, jsonObject);
            if (Code.SUCCESS.getIndex() != respBase.getRetflag()) {
                flag = false;
                continue;
            }
            payment.setExtMemo("true");
            payment.setCouponBalance(0.0);
        }
        return flag;
    }

    @Override
    public boolean cardIsSameWithGh() {
        return false;
    }

    @Override
    public boolean eqOperator() {
        return false;
    }

    @Override
    public RespBase payConfirm(ServiceSession session, ResqVo vo) {
        RespBase respBase = super.payConfirm(session, vo);
        if (vo.getCacheModel().getOrder().isHasGroupBuy()) {
            JSONObject paramsObject = new JSONObject();
            this.goodsRemoteService.setGroupBuyBillStatus(session, vo, paramsObject);
        }
        return respBase;
    }

    @Override
    public RespBase isExistPayInOrder(ServiceSession session, JSONObject paramsObject) {
        return this.orderDataLocalActionUtil.selectOrderPay(session, paramsObject);
    }
}

