/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.service.remote;

import com.alibaba.fastjson.JSONObject;
import com.efuture.business.annotation.HessianService;
import com.efuture.business.bean.Code;
import com.efuture.business.bean.RespBase;
import com.efuture.business.bean.ResqVo;
import com.efuture.business.javaPos.struct.CacheModel;
import com.efuture.business.javaPos.struct.SyncTradeModel;
import com.efuture.business.javaPos.struct.request.GetOrderIn;
import com.efuture.business.service.OrderRemoteService;
import com.efuture.business.service.OrderSaleBS;
import com.efuture.business.util.ThreadContextUtils;
import com.efuture.business.version.OrderServerVersion;
import com.product.model.ServiceSession;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@HessianService(value="/apiOrderRemoteService.do", interf=OrderRemoteService.class)
@Service
public class OrderRemoteServiceImpl
implements OrderRemoteService {
    private static final Logger log = LoggerFactory.getLogger(OrderRemoteServiceImpl.class);
    @Autowired
    private OrderSaleBS orderSaleBS;
    @Autowired
    private ThreadContextUtils threadContextUtils;
    @Value(value="${localcache.enabled}")
    protected Boolean localcache;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase payConfirm(ServiceSession session, ResqVo vo) {
        try {
            this.threadContextUtils.setLogFlag(vo);
            RespBase respBase = this.orderSaleBS.payConfirm(session, vo);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase saleReturnQuery(ServiceSession session, ResqVo vo) {
        try {
            this.threadContextUtils.setLogFlag(vo);
            RespBase respBase = this.orderSaleBS.saleReturnQuery(session, vo);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase copySno(ServiceSession session, ResqVo vo) {
        try {
            this.threadContextUtils.setLogFlag(vo);
            RespBase respBase = this.orderSaleBS.copySno(session, vo);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public RespBase getOrder(ServiceSession session, GetOrderIn getOrderIn) {
        return this.orderSaleBS.getOrder(session, getOrderIn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase getOrders(ServiceSession session, JSONObject paramsObject) {
        try {
            this.threadContextUtils.setLogFlag(paramsObject);
            RespBase respBase = this.orderSaleBS.getOrders(session, paramsObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase confirmSalesReturn(ServiceSession session, ResqVo vo) {
        try {
            this.threadContextUtils.setLogFlag(vo);
            RespBase respBase = this.orderSaleBS.confirmSalesReturn(session, vo);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase<ResqVo> changeOrderSno(ServiceSession session, ResqVo vo) {
        try {
            this.threadContextUtils.setLogFlag(vo);
            RespBase<ResqVo> respBase = this.orderSaleBS.changeOrderSno(session, vo);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase changeOrderType(ServiceSession session, ResqVo vo, JSONObject paramsObject) {
        try {
            this.threadContextUtils.setLogFlag(vo);
            RespBase respBase = this.orderSaleBS.changeOrderType(session, vo, paramsObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase saveOrderInfoForCloud(ServiceSession session, JSONObject jsonObject) {
        try {
            this.threadContextUtils.setLogFlag(jsonObject);
            RespBase respBase = this.orderSaleBS.saveOrderInfoForCloud(session, jsonObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase receiveOrderSync(ServiceSession session, JSONObject paramsObject) {
        try {
            this.threadContextUtils.setLogFlag(paramsObject);
            RespBase respBase = this.orderSaleBS.receiveOrderSync(session, paramsObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public RespBase getSyncList(ServiceSession session) {
        return this.orderSaleBS.getSyncList(session);
    }

    public RespBase synLocalOrder(ServiceSession session, List<SyncTradeModel> synTradeList) {
        return this.orderSaleBS.synLocalOrder(session, synTradeList);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase searchTerminalReport(ServiceSession session, JSONObject paramsObject) {
        try {
            this.threadContextUtils.setLogFlag(paramsObject);
            RespBase respBase = this.orderSaleBS.searchTerminalReport(session, paramsObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase searchIntegralReport(ServiceSession session, JSONObject paramsObject) {
        try {
            this.threadContextUtils.setLogFlag(paramsObject);
            RespBase respBase = this.orderSaleBS.searchIntegralReport(session, paramsObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase searchGroupReport(ServiceSession session, JSONObject paramsObject) {
        try {
            this.threadContextUtils.setLogFlag(paramsObject);
            RespBase respBase = this.orderSaleBS.searchGroupReport(session, paramsObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase searchElectronicReport(ServiceSession session, JSONObject paramsObject) {
        try {
            this.threadContextUtils.setLogFlag(paramsObject);
            RespBase respBase = this.orderSaleBS.searchElectronicReport(session, paramsObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean savePrintLogBatch(ServiceSession session, JSONObject paramsObject) {
        try {
            this.threadContextUtils.setLogFlag(paramsObject);
            boolean bl = this.orderSaleBS.savePrintLogBatch(session, paramsObject);
            return bl;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase uploadPrintLogData(ServiceSession session, JSONObject paramsObject) {
        try {
            this.threadContextUtils.setLogFlag(paramsObject);
            RespBase respBase = this.orderSaleBS.uploadPrintLogData(session, paramsObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase checkPay(ServiceSession session, JSONObject body) {
        try {
            this.threadContextUtils.setLogFlag(body);
            RespBase respBase = this.orderSaleBS.checkPay(session, body);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase appliancesOrderCheck(ServiceSession session, ResqVo vo) {
        try {
            this.threadContextUtils.setLogFlag(vo);
            RespBase respBase = this.orderSaleBS.appliancesOrderCheck(session, vo);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase appliancesOrderList(ServiceSession session, JSONObject body) {
        try {
            this.threadContextUtils.setLogFlag(body);
            RespBase respBase = this.orderSaleBS.appliancesOrderList(session, body);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase appliancesSaveTemp(ServiceSession session, ResqVo vo) {
        try {
            this.threadContextUtils.setLogFlag(vo);
            RespBase respBase = this.orderSaleBS.appliancesSaveTemp(session, vo);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase appliancessaleReturnQuery(ServiceSession session, ResqVo vo) {
        try {
            this.threadContextUtils.setLogFlag(vo);
            RespBase respBase = this.orderSaleBS.appliancessaleReturnQuery(session, vo);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase recordPrintLog(ServiceSession session, JSONObject paramsObject) {
        try {
            this.threadContextUtils.setLogFlag(paramsObject);
            RespBase respBase = this.orderSaleBS.recordPrintLog(session, paramsObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase getPrintCount(ServiceSession session, JSONObject paramsObject) {
        try {
            this.threadContextUtils.setLogFlag(paramsObject);
            RespBase respBase = this.orderSaleBS.getPrintCount(session, paramsObject);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase checkOrderBalance(ServiceSession session, ResqVo vo) {
        try {
            this.threadContextUtils.setLogFlag(vo);
            RespBase respBase = this.orderSaleBS.checkOrderBalance(session, vo);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public RespBase checkOrderState(CacheModel cacheModel) {
        return this.orderSaleBS.checkOrderState(cacheModel);
    }

    public RespBase recalc(ServiceSession session) {
        RespBase respBase = this.orderSaleBS.recalc(session);
        return respBase;
    }

    public RespBase tempSave(ServiceSession session, CacheModel cacheModel) {
        return this.orderSaleBS.tempSave(session, cacheModel);
    }

    public RespBase searchTempInfo(ServiceSession session, JSONObject paramsObject) {
        return this.orderSaleBS.searchTempInfo(session, paramsObject);
    }

    public RespBase searchTempDetail(ServiceSession session, CacheModel cacheModel, JSONObject paramsObject) {
        return this.orderSaleBS.searchTempDetail(session, cacheModel, paramsObject);
    }

    public RespBase searchTemp(ServiceSession session, JSONObject paramsObject) {
        return null;
    }

    public RespBase updateTempOrderState(ServiceSession session, JSONObject paramsObject) {
        return this.orderSaleBS.updateTempOrderState(session, paramsObject);
    }

    public RespBase copyTempOrder(ServiceSession session, CacheModel cacheModel, JSONObject paramsObject) {
        return this.orderSaleBS.copyTempOrder(session, cacheModel, paramsObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase cancelReturnQuery(ServiceSession session, ResqVo vo) {
        try {
            this.threadContextUtils.setLogFlag(vo);
            RespBase respBase = this.orderSaleBS.cancelReturnQuery(session, vo);
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public RespBase queryTailPay(ServiceSession session, CacheModel cacheModel, GetOrderIn getOrderIn) {
        return this.orderSaleBS.queryTailPay(session, cacheModel, getOrderIn);
    }

    public RespBase pickUp(ServiceSession session, JSONObject paramsObject) {
        return this.orderSaleBS.pickUp(session, paramsObject);
    }

    public RespBase r10BackRebate(ServiceSession session, CacheModel cacheModel) {
        return this.orderSaleBS.r10BackRebate(session, cacheModel);
    }

    public RespBase checkPayCode(ServiceSession session, JSONObject paramsObject) {
        return this.orderSaleBS.checkPayCode(session, paramsObject);
    }

    public RespBase getBinCardInfo(ServiceSession session, JSONObject paramsObject) {
        return this.orderSaleBS.getBinCardInfo(session, paramsObject);
    }

    public RespBase getBankInfo(ServiceSession session, JSONObject paramsObject) {
        return this.orderSaleBS.getBankInfo(session, paramsObject);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RespBase<JSONObject> getVersion(ServiceSession session, JSONObject paramsObject) {
        try {
            this.threadContextUtils.setLogFlag(paramsObject);
            JSONObject json = new JSONObject();
            json.put("serverName", (Object)OrderServerVersion.serverName);
            if (this.localcache.booleanValue()) {
                json.put("offlineServerVersion", (Object)OrderServerVersion.offLineServerVersion);
            } else {
                json.put("onlineServerVersion", (Object)OrderServerVersion.onlineServerVersion);
            }
            RespBase respBase = new RespBase(Code.SUCCESS, (Object)json, "GETVERSION");
            return respBase;
        }
        finally {
            this.threadContextUtils.clear();
        }
    }

    public RespBase isExistPayInOrder(ServiceSession session, JSONObject paramsObject) {
        return this.orderSaleBS.isExistPayInOrder(session, paramsObject);
    }
}

