/*
 * Decompiled with CFR 0.152.
 */
package com.efuture.business.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LocalUtil {
    private static final Logger log = LoggerFactory.getLogger(LocalUtil.class);
    private static String downloadTempPath = "../../downloadtemp";
    private static String orderDb3 = "order.db3";

    public static void main(String[] args) throws IOException {
        LocalUtil.checkTodayDatabase();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean checkTodayDatabase() throws IOException {
        String relativePaths = "../../";
        String osName = System.getProperty("os.name");
        String OSname = null;
        if (Pattern.matches("Linux.*", osName)) {
            OSname = "Linux";
            log.info("\u5b89\u5353\u8bbe\u5907");
            relativePaths = "./";
        } else if (Pattern.matches("Windows.*", osName)) {
            log.info("win\u8bbe\u5907");
            OSname = "Windows";
            relativePaths = "../../server/";
        } else if (Pattern.matches("Mac.*", osName)) {
            OSname = "Mac";
        }
        log.info(OSname);
        String today = new SimpleDateFormat("yyyyMMdd").format(new Date());
        String orderPath = relativePaths + "sqlites/" + today;
        String orderFilePath = relativePaths + "sqlites/" + today + File.separator + orderDb3;
        File file = new File(orderPath);
        File orderFile = new File(orderFilePath);
        log.info("file:{}", (Object)file.getCanonicalPath());
        log.info("currentFile:{}", (Object)new File("./").getCanonicalPath());
        if (!orderFile.exists()) {
            boolean b;
            if (!file.exists()) {
                file.mkdirs();
            }
            File temp = new File(downloadTempPath + File.separator + "sqlites" + File.separator + "order.db3");
            log.info(">>>file:{}", (Object)temp.getCanonicalPath());
            if (!temp.exists()) {
                log.info("order.db3\u5907\u4efd\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            if (!(b = LocalUtil.copyFile(downloadTempPath + File.separator + "sqlites" + File.separator + "order.db3", relativePaths + "sqlites/" + today, "order.db3"))) return false;
            log.info("\u751f\u6210\u672c\u5730\u5e93{}\u6210\u529f!", (Object)orderPath);
            return true;
        } else {
            log.info("\u672c\u5730\u5e93order.db3\u5df2\u5b58\u5728!");
        }
        return true;
    }

    public static final boolean copyFile(String inPach, String outPath, String outFileName) throws IOException {
        File in = new File(inPach);
        log.info("inPach ==>{}", (Object)in.getCanonicalPath());
        File out = new File(outPath);
        log.info("outPath ==>{}", (Object)out.getCanonicalPath());
        if (!in.exists()) {
            return false;
        }
        if (!out.exists()) {
            out.mkdirs();
        }
        File out2 = new File(outPath + File.separator + outFileName);
        return LocalUtil.copyFile(in, out2);
    }

    public static final boolean copyFile(File in, File out) {
        try {
            FileInputStream fis = new FileInputStream(in);
            FileOutputStream fos = new FileOutputStream(out);
            byte[] buf = new byte[1024];
            int i = 0;
            while ((i = fis.read(buf)) != -1) {
                fos.write(buf, 0, i);
            }
            fis.close();
            fos.close();
            return true;
        }
        catch (IOException ie) {
            ie.printStackTrace();
            return false;
        }
    }
}

